package netfu.selectors;

import netfu.*;

import java.util.*;
import java.awt.*;
import netfu.types.*;
import java.net.*;
import java.io.*;
import java.applet.*;

public class ArgumentsListSelector extends Panel implements Selector
{
private static final String serverHost = "zarathustra";
private static String groupLabel;

  Panel thisPanel = new Panel ();
  Applet applet;
  AppletContext appletContext;
  Script script;
  Panel gbox;
  ParametersList params = null;
  Panel buttonPanel;
  Vector argumentSelectors = new Vector ();
  GButton runButton;

  /*
   * Initialize a script's arguments selector.
   */
public ArgumentsListSelector (Script _script, Applet _applet)
  {
    super ();
    applet = _applet;
    appletContext = _applet.getAppletContext();
    script = _script;
    params = script.params ();
    initSelector ();
  }

public void initSelector ()
  {
    thisPanel.setLayout (new BorderLayout ());
    setLayout (new BorderLayout ());
    gbox = new Panel ();

    Insets insets = new Insets (5, 5, 5, 5);
    GridBagConstraints labelConstraints = new GridBagConstraints ();
    GridBagConstraints widgetConstraints = new GridBagConstraints ();

    labelConstraints.weightx = 1.0;
    labelConstraints.anchor = GridBagConstraints.WEST;
    labelConstraints.gridwidth = GridBagConstraints.RELATIVE;
    labelConstraints.insets = insets;

    widgetConstraints.fill = GridBagConstraints.NONE;
    widgetConstraints.gridwidth = GridBagConstraints.REMAINDER;
    widgetConstraints.anchor = GridBagConstraints.WEST;
    widgetConstraints.insets =  insets;

    GridBagLayout gridbag = new GridBagLayout ();
    gbox.setLayout (gridbag);
    Enumeration paramIterator = params.elements ();
    int i = 0;

    while (paramIterator.hasMoreElements ())
      {
	Parameter p = (Parameter) paramIterator.nextElement ();
	System.out.println ("Adding " + p.name());

	Label label = new Label (p.name ());
	gridbag.setConstraints (label, labelConstraints);
	gbox.add ( label );

	Selector s = (Selector) ((Type) p.type()).select ();
	argumentSelectors.addElement (s);
	Component widget = s.component ();
	if (s instanceof GLimitedInteger)
	  widgetConstraints.fill = GridBagConstraints.HORIZONTAL;
	gridbag.setConstraints (widget, widgetConstraints);
	widgetConstraints.fill = GridBagConstraints.NONE;
	gbox.add (widget);
      }

    thisPanel.add ("Center", gbox);
    gbox.show ();

    buttonPanel = new Panel ();
    buttonPanel.setLayout (new GridLayout (1, 1));
    runButton = new GButton (this, "Run");
    buttonPanel.add (runButton);
    thisPanel.add ("South", buttonPanel);
    buttonPanel.show();

    add ("Center", thisPanel);
    show ();
  }

public Component component () { return this; }

public void selectValue (Object o)
  {
    if ( o instanceof GButton)
      if ( ((GButton)o).getLabel().equals ("Run") )
	{
	  runScript ((String) selectedValue ());
	}
    return;
  }

  /** Return an ArgumentsList object */
public Object selectedValue ()
  {
    StringBuffer sb = new StringBuffer ("");

    Enumeration args = argumentSelectors.elements ();

    if (argumentSelectors.size() > 0)
      sb.append ((String)((Selector)args.nextElement()).selectedValue());

    while (args.hasMoreElements ())
      {
	sb.append (" ");
	sb.append ((String)((Selector)args.nextElement()).selectedValue());
      }

    sb.append ("");

    System.out.println (sb.toString ());

    return sb.toString ();
  }

private void runScript (String args)
  {
    String request = "(" + script.name() + " " + args + ")";
    URL netfu_URL = null;

    try
      {
        System.out.println ("Making request: " + request);
        netfu_URL = new URL ("http://" + serverHost + "/cgi-bin/proxy.cgi?" + spaceToStar (request));
        System.out.println ("URL: " + netfu_URL.getRef ());
      }
    catch (MalformedURLException e)
      {
	System.out.println ("Bad URL!");
        return;
      }

    appletContext.showDocument(netfu_URL, "_self");
  }

public void enable (boolean f)
  {
    runButton.enable (f);
  }

public String spaceToStar (String s)
  {
      StringBuffer sb = new StringBuffer ();

      for (int i = 0; i < s.length (); i++) {
	  if (s.charAt (i) == ' ')
	      sb.append ('*');
	  else
	      sb.append (s.charAt (i));
      }

      return sb.toString ();
  }

}
