package netfu;

import java.awt.*;
import java.util.*;
import netfu.types.*;

public class Parameter {

    private String name;
    private Class typeClass;
    private Type type = null;

    public Parameter (String _name, String typeName) {
    	this(_name, typeName, null);
    }

    public Parameter (String _name, String typeName, String defaultsStr) {
	boolean isAType = false;
	int i;
	Class __type = null;
	String[] defaults = null;

	if (defaultsStr!=null) {
		System.out.println ("\tGoing to extract defaults");
		defaults = extractDefaults (defaultsStr);
	} else {
		System.out.println ("\tdefaults are null");
	}

	try {
	    __type = Class.forName ("netfu.types." + typeName);
	} catch (ClassNotFoundException e) {
	    System.out.println ("Unknown type: " + typeName);
	    return;
	}

	Class superclass = __type.getSuperclass();

	/* make sure that the type is a proper subclass of netfu.Type */
	try {
	    if (superclass == Class.forName ("netfu.types.Type"))
		isAType = true;
	} catch (ClassNotFoundException e) {
	    System.out.println ("netfu.types.Type isn't present.");
	    System.exit (0);
	}


	/* if it's not, throw an exception. otherwise do the rightthing. */
	if (!isAType) {
	    System.out.println ("" + typeName + "is not a proper type.");
	    return;
	} else {
	    System.out.println ("Type: " + _name);
	    name = _name;
	    typeClass = __type;
	    try {
		type = (Type)(typeClass.newInstance());
		if (defaults!=null) type.setDefaults (defaults);
	    } catch (InstantiationException e) {
		System.out.println ("Can't instantiate.");
	    } catch (IllegalAccessException e1) {
		System.out.println ("Constructor not public.");
	    }
	}
    }


    public String name () {
	return name;
    }

    public Type type () {
	return type;
    }


    public Panel view () {
	Panel p = new Panel ();
	p.add (new Label (name ()) );
	return p;
    }


    private String[] extractDefaults (String defaults) {
	StringTokenizer st = new StringTokenizer (defaults, ",");

	System.out.println ("\t- " + defaults + " has " + st.countTokens() + "tokens.");
	if (st.countTokens()==0) return null;

	String[] defaultsArr = new String[st.countTokens()];
	int i = 0;

	while (st.hasMoreTokens()) {
		defaultsArr [i] = new String(st.nextToken ());
		System.out.println ("\t- Adding token " + i);
		System.out.println ("\t- " + defaultsArr [i]);
		i++;
	}

	System.out.println ("\t- Returning: " + defaultsArr[0]);
	return defaultsArr;
    }
}
