;;;; 	Copyright (C) 1998 Lauri Alanko <la@iki.fi>
;;;; 
;;;; This program is free software; you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation; either version 2, or (at your option)
;;;; any later version.
;;;; 
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License
;;;; along with this software; see the file COPYING.  If not, write to
;;;; the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
;;;; Boston, MA 02111-1307 USA
;;;; 
;;;; The GPL is also available at http://www.gnu.org/copyleft/gpl.html


; gimple-init.scm


(define (enumlist-iter rest idx accum)
  (if
   (null? rest)
   (reverse accum)
   (enumlist-iter (cdr rest)
		  (+ idx 1)
		  (cons (list 'define (car rest) idx)
			accum))))

(defmacro enum enums (cons begin (enumlist-iter enums 0 '())))

;This stuff should prolly be snarfed from the headers..

(enum 
 NORMAL
 DISSOLVE
 BEHIND
 MULTIPLY
 SCREEN
 OVERLAY
 DIFFERENCE
 ADDITION
 SUBTRACTION
 DARKEN-ONLY
 LIGHTEN-ONLY
 HUE
 SATURATION
 COLOR
 VALUE)

(enum
 FG-BG-RGB
 FG-BG-HSV
 FG-TRANS
 CUSTOM)

(enum
 LINEAR
 BILINEAR
 RADIAL
 SQUARE
 CONICAL-SYMMETRIC
 CONICAL-ASYMMETRIC
 SHAPEBURST-ANGULAR
 SHAPEBURST-SPHERICAL
 SHAPEBURST-DIMPLED)

(enum
 REPEAT-NONE
 REPEAT-SAWTOOTH
 REPEAT-TRIANGULAR)

(enum
 FG-BUCKET-FILL
 BG-BUCKET-FILL
 PATTERN-BUCKET-FILL)

(enum
 BG-IMAGE-FILL
 WHITE-IMAGE-FILL
 TRANS-IMAGE-FILL
 NO-IMAGE-FILL)


(enum
 RGB
 GRAY
 INDEXED)

(enum
 RGB-IMAGE
 RGBA-IMAGE
 GRAY-IMAGE
 GRAYA-IMAGE
 INDEXED-IMAGE
 INDEXEDA-IMAGE)

(enum
 RED-CHANNEL
 GREEN-CHANNEL
 BLUE-CHANNEL
 GRAY-CHANNEL
 INDEXED-CHANNEL)

(enum
 WHITE-MASK
 BLACK-MASK
 ALPHA-MASK)

(enum
 APPLY
 DISCARD)

(enum
 EXPAND-AS-NECESSARY
 CLIP-TO-IMAGE
 CLIP-TO-BOTTOM-LAYER)

(enum
 ADD
 SUB
 REPLACE
 INTERSECT)

(enum
 PIXELS
 POINTS)

(enum
 IMAGE-CLONE
 PATTERN-CLONE)

(enum
 BLUR
 SHARPEN)

(enum
 FALSE
 TRUE)

(enum
 PARAM-INT32
 PARAM-INT16
 PARAM-INT8
 PARAM-FLOAT
 PARAM-STRING
 PARAM-INT32ARRAY
 PARAM-INT16ARRAY
 PARAM-INT8ARRAY
 PARAM-FLOATARRAY
 PARAM-STRINGARRAY
 PARAM-COLOR
 PARAM-REGION
 PARAM-DISPLAY
 PARAM-IMAGE
 PARAM-LAYER
 PARAM-CHANNEL
 PARAM-DRAWABLE
 PARAM-SELECTION
 PARAM-BOUNDARY
 PARAM-PATH
 PARAM-STATUS
 PARAM-END)

(enum
 RUN-INTERACTIVE
 RUN-NONINTERACTIVE
 RUN-WITH-LAST-VALS)

(enum
 STATUS-EXECUTION-ERROR
 STATUS-CALLING_ERROR
 STATUS-PASS_THROUGH
 STATUS-SUCCESS)

(primitive-load-path "script-fu-compat.scm")

