/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimpproceduraldb_pdb.h
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#ifndef __GIMP_PROCEDURAL_DB_PDB_H__
#define __GIMP_PROCEDURAL_DB_PDB_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* For information look into the C source or the html documentation */


void           gimp_procedural_db_dump          (gchar            *filename);
void           gimp_procedural_db_query         (gchar            *name,
						 gchar            *blurb,
						 gchar            *help,
						 gchar            *author,
						 gchar            *copyright,
						 gchar            *date,
						 gchar            *proc_type,
						 gint             *num_matches,
						 gchar          ***proc_names);
gboolean       _gimp_procedural_db_proc_info    (gchar            *procedure,
						 gchar           **blurb,
						 gchar           **help,
						 gchar           **author,
						 gchar           **copyright,
						 gchar           **date,
						 GimpPDBProcType  *proc_type,
						 gint             *num_args,
						 gint             *num_values);
gboolean       gimp_procedural_db_proc_arg      (gchar            *procedure,
						 gint              arg_num,
						 GimpPDBArgType   *arg_type,
						 gchar           **arg_name,
						 gchar           **arg_desc);
gboolean       gimp_procedural_db_proc_val      (gchar            *procedure,
						 gint              val_num,
						 GimpPDBArgType   *val_type,
						 gchar           **val_name,
						 gchar           **val_desc);
void           _gimp_procedural_db_get_data     (gchar            *identifier,
						 gint             *bytes,
						 guint8          **data);
gint           gimp_procedural_db_get_data_size (gchar            *identifier);
void           _gimp_procedural_db_set_data     (gchar            *identifier,
						 gint              bytes,
						 guint8           *data);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GIMP_PROCEDURAL_DB_PDB_H__ */
