/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-1999 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "procedural_db.h"

#include "config.h"

#include <string.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "fileops.h"
#include "gimprc.h"
#include "plug_in.h"

#include "libgimp/gimpintl.h"

static ProcRecord file_load_proc;
static ProcRecord file_save_proc;
static ProcRecord temp_name_proc;
static ProcRecord register_magic_load_handler_proc;
static ProcRecord register_load_handler_proc;
static ProcRecord register_save_handler_proc;

void
register_fileops_procs (void)
{
  procedural_db_register (&file_load_proc);
  procedural_db_register (&file_save_proc);
  procedural_db_register (&temp_name_proc);
  procedural_db_register (&register_magic_load_handler_proc);
  procedural_db_register (&register_load_handler_proc);
  procedural_db_register (&register_save_handler_proc);
}

static Argument *
file_load_invoker (Argument *args)
{
  PlugInProcDef *file_proc;
  ProcRecord *proc;

  file_proc = file_proc_find (load_procs, (gchar *) args[2].value.pdb_pointer);
  if (!file_proc)
    return procedural_db_return_args (&file_load_proc, FALSE);

  proc = &file_proc->db_info;

  return procedural_db_execute (proc->name, args);
}

static ProcArg file_load_inargs[] =
{
  {
    PDB_INT32,
    "run_mode",
    "The run mode: RUN_INTERACTIVE (0) or RUN_NONINTERACTIVE (1)"
  },
  {
    PDB_STRING,
    "filename",
    "The name of the file to load"
  },
  {
    PDB_STRING,
    "raw_filename",
    "The name entered"
  }
};

static ProcArg file_load_outargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The output image"
  }
};

static ProcRecord file_load_proc =
{
  "gimp_file_load",
  "Loads a file by extension.",
  "This procedure invokes the correct file load handler according to the file's extension and/or prefix. The name of the file to load is typically a full pathname, and the name entered is what the user actually typed before prepending a directory path. The reason for this is that if the user types http://www.xcf/~gimp/ he wants to fetch a URL, and the full pathname will not look like a URL.",
  "Josh MacDonald",
  "Josh MacDonald",
  "1997",
  PDB_INTERNAL,
  3,
  file_load_inargs,
  1,
  file_load_outargs,
  { { file_load_invoker } }
};

static Argument *
file_save_invoker (Argument *args)
{
  Argument *new_args;
  Argument *return_vals;
  PlugInProcDef *file_proc;
  ProcRecord *proc;

  file_proc = file_proc_find (save_procs, (gchar *) args[4].value.pdb_pointer);
  if (!file_proc) 
    return procedural_db_return_args (&file_save_proc, FALSE);

  proc = &file_proc->db_info;

  new_args = g_new (Argument, proc->num_args);
  memset (new_args, 0, sizeof (Argument) * proc->num_args);
  memcpy (new_args, args, sizeof (Argument) * 5);

  return_vals = procedural_db_execute (proc->name, new_args);
  g_free (new_args);

  return return_vals;
}

static ProcArg file_save_inargs[] =
{
  {
    PDB_INT32,
    "run_mode",
    "The run mode: RUN_INTERACTIVE (0) or RUN_NONINTERACTIVE (1)"
  },
  {
    PDB_IMAGE,
    "image",
    "Input image"
  },
  {
    PDB_DRAWABLE,
    "drawable",
    "Drawable to save"
  },
  {
    PDB_STRING,
    "filename",
    "The name of the file to save the image in"
  },
  {
    PDB_STRING,
    "raw_filename",
    "The name of the file to save the image in"
  }
};

static ProcRecord file_save_proc =
{
  "gimp_file_save",
  "Saves a file by extension.",
  "This procedure invokes the correct file save handler according to the file's extension and/or prefix. The name of the file to save is typically a full pathname, and the name entered is what the user actually typed before prepending a directory path. The reason for this is that if the user types http://www.xcf/~gimp/ she wants to fetch a URL, and the full pathname will not look like a URL.",
  "Josh MacDonald",
  "Josh MacDonald",
  "1997",
  PDB_INTERNAL,
  5,
  file_save_inargs,
  0,
  NULL,
  { { file_save_invoker } }
};

static Argument *
temp_name_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *extension;
  gchar *name = NULL;
  static gint id = 0;
  static gint pid;

  extension = (gchar *) args[0].value.pdb_pointer;
  if (extension == NULL)
    success = FALSE;

  if (success)
    {
      if (id == 0)
	pid = getpid();
    
      name = g_strdup_printf ("%s" G_DIR_SEPARATOR_S "gimp_temp.%d%d.%s",
			      temp_path, pid, id++, extension);
    }

  return_args = procedural_db_return_args (&temp_name_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = name;

  return return_args;
}

static ProcArg temp_name_inargs[] =
{
  {
    PDB_STRING,
    "extension",
    "The extension the file will have"
  }
};

static ProcArg temp_name_outargs[] =
{
  {
    PDB_STRING,
    "name",
    "The new temp filename"
  }
};

static ProcRecord temp_name_proc =
{
  "gimp_temp_name",
  "Generates a unique filename.",
  "Generates a unique filename using the temp path supplied in the user's gimprc.",
  "Josh MacDonald",
  "Josh MacDonald",
  "1997",
  PDB_INTERNAL,
  1,
  temp_name_inargs,
  1,
  temp_name_outargs,
  { { temp_name_invoker } }
};

static Argument *
register_magic_load_handler_invoker (Argument *args)
{
  gboolean success = TRUE;
  gchar *name;
  gchar *extensions;
  gchar *prefixes;
  gchar *magics;
  ProcRecord *proc;
  PlugInProcDef *file_proc;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL)
    success = FALSE;

  extensions = (gchar *) args[1].value.pdb_pointer;

  prefixes = (gchar *) args[2].value.pdb_pointer;

  magics = (gchar *) args[3].value.pdb_pointer;

  if (success)
    {
      success = FALSE;
    
      proc = procedural_db_lookup (name);
    
      if (proc && ((proc->num_args < 3) ||
		   (proc->num_values < 1) ||
		   (proc->args[0].arg_type != PDB_INT32) ||
		   (proc->args[1].arg_type != PDB_STRING) ||
		   (proc->args[2].arg_type != PDB_STRING) ||
		   (proc->values[0].arg_type != PDB_IMAGE)))
	{
	  g_message (_("load handler \"%s\" does not take the standard load handler args"),
		     name);
	  goto done;
	}
    
      file_proc = plug_in_file_handler (name, extensions, prefixes, magics);
    
      if (!file_proc)
	{
	  g_message (_("attempt to register non-existant load handler \"%s\""),
		     name);
	  goto done;
	}
    
      load_procs = g_slist_prepend (load_procs, file_proc);
    
      success = TRUE;
    
    done: ;
    }

  return procedural_db_return_args (&register_magic_load_handler_proc, success);
}

static ProcArg register_magic_load_handler_inargs[] =
{
  {
    PDB_STRING,
    "procedure_name",
    "The name of the procedure to be used for loading"
  },
  {
    PDB_STRING,
    "extensions",
    "comma separated list of extensions this handler can load (i.e. \"jpg,jpeg\")"
  },
  {
    PDB_STRING,
    "prefixes",
    "comma separated list of prefixes this handler can load (i.e. \"http:,ftp:\")"
  },
  {
    PDB_STRING,
    "magics",
    "comma separated list of magic file information this handler can load (i.e. \"0,string,GIF\")"
  }
};

static ProcRecord register_magic_load_handler_proc =
{
  "gimp_register_magic_load_handler",
  "Registers a file load handler procedure.",
  "Registers a procedural database procedure to be called to load files of a particular file format using magic file information.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  4,
  register_magic_load_handler_inargs,
  0,
  NULL,
  { { register_magic_load_handler_invoker } }
};

static Argument *
register_load_handler_invoker (Argument *args)
{
  int i;
  Argument argv[4];

  for (i = 0; i < 3; i++)
    argv[i] = args[i];

  argv[3].arg_type = PDB_STRING;
  argv[3].value.pdb_pointer = NULL;

  return register_magic_load_handler_invoker (argv);
}

static ProcArg register_load_handler_inargs[] =
{
  {
    PDB_STRING,
    "procedure_name",
    "The name of the procedure to be used for loading"
  },
  {
    PDB_STRING,
    "extensions",
    "comma separated list of extensions this handler can load (i.e. \"jpg,jpeg\")"
  },
  {
    PDB_STRING,
    "prefixes",
    "comma separated list of prefixes this handler can load (i.e. \"http:,ftp:\")"
  }
};

static ProcRecord register_load_handler_proc =
{
  "gimp_register_load_handler",
  "Registers a file load handler procedure.",
  "Registers a procedural database procedure to be called to load files of a particular file format.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  3,
  register_load_handler_inargs,
  0,
  NULL,
  { { register_load_handler_invoker } }
};

static Argument *
register_save_handler_invoker (Argument *args)
{
  gboolean success = TRUE;
  gchar *name;
  gchar *extensions;
  gchar *prefixes;
  ProcRecord *proc;
  PlugInProcDef *file_proc;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL)
    success = FALSE;

  extensions = (gchar *) args[1].value.pdb_pointer;

  prefixes = (gchar *) args[2].value.pdb_pointer;

  if (success)
    {
      success = FALSE;
    
      proc = procedural_db_lookup (name);
    
      if (proc && ((proc->num_args < 5) ||
		   (proc->args[0].arg_type != PDB_INT32) ||
		   (proc->args[1].arg_type != PDB_IMAGE) ||
		   (proc->args[2].arg_type != PDB_DRAWABLE) ||
		   (proc->args[3].arg_type != PDB_STRING) ||
		   (proc->args[4].arg_type != PDB_STRING)))
	{
	  g_message (_("save handler \"%s\" does not take the standard save handler args"),
		     name);
	  goto done;
	}
    
      file_proc = plug_in_file_handler (name, extensions, prefixes, NULL);
    
      if (!file_proc)
	{
	  g_message (_("attempt to register non-existant save handler \"%s\""),
		     name);
	  goto done;
	}
    
      save_procs = g_slist_prepend (save_procs, file_proc);
    
      success = TRUE;
    
    done: ;
    }

  return procedural_db_return_args (&register_save_handler_proc, success);
}

static ProcArg register_save_handler_inargs[] =
{
  {
    PDB_STRING,
    "procedure_name",
    "The name of the procedure to be used for saving"
  },
  {
    PDB_STRING,
    "extensions",
    "comma separated list of extensions this handler can save (i.e. \"jpg,jpeg\")"
  },
  {
    PDB_STRING,
    "prefixes",
    "comma separated list of prefixes this handler can save (i.e. \"http:,ftp:\")"
  }
};

static ProcRecord register_save_handler_proc =
{
  "gimp_register_save_handler",
  "Registers a file save handler procedure.",
  "Registers a procedural database procedure to be called to save files in a particular file format.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  PDB_INTERNAL,
  3,
  register_save_handler_inargs,
  0,
  NULL,
  { { register_save_handler_invoker } }
};
