/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2000 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"

#include <string.h>

#include <glib-object.h>

#include "libgimpbase/gimpbasetypes.h"

#include "pdb-types.h"
#include "procedural_db.h"

#include "core/gimp.h"
#include "core/gimpcontext.h"
#include "core/gimpdatafactory.h"
#include "core/gimplist.h"
#include "core/gimppalette.h"

#include "libgimpcolor/gimpcolor.h"

static ProcRecord palette_get_foreground_proc;
static ProcRecord palette_get_background_proc;
static ProcRecord palette_set_foreground_proc;
static ProcRecord palette_set_background_proc;
static ProcRecord palette_set_default_colors_proc;
static ProcRecord palette_swap_colors_proc;
static ProcRecord palette_refresh_proc;
static ProcRecord palette_list_proc;
static ProcRecord palette_get_palette_proc;
static ProcRecord palette_set_palette_proc;
static ProcRecord palette_get_entry_proc;

void
register_palette_procs (Gimp *gimp)
{
  procedural_db_register (gimp, &palette_get_foreground_proc);
  procedural_db_register (gimp, &palette_get_background_proc);
  procedural_db_register (gimp, &palette_set_foreground_proc);
  procedural_db_register (gimp, &palette_set_background_proc);
  procedural_db_register (gimp, &palette_set_default_colors_proc);
  procedural_db_register (gimp, &palette_swap_colors_proc);
  procedural_db_register (gimp, &palette_refresh_proc);
  procedural_db_register (gimp, &palette_list_proc);
  procedural_db_register (gimp, &palette_get_palette_proc);
  procedural_db_register (gimp, &palette_set_palette_proc);
  procedural_db_register (gimp, &palette_get_entry_proc);
}

static Argument *
palette_get_foreground_invoker (Gimp     *gimp,
                                Argument *args)
{
  Argument *return_args;
  GimpRGB color;

  gimp_context_get_foreground (gimp_get_current_context (gimp), &color);

  return_args = procedural_db_return_args (&palette_get_foreground_proc, TRUE);
  return_args[1].value.pdb_color = color;

  return return_args;
}

static ProcArg palette_get_foreground_outargs[] =
{
  {
    GIMP_PDB_COLOR,
    "foreground",
    "The foreground color"
  }
};

static ProcRecord palette_get_foreground_proc =
{
  "gimp_palette_get_foreground",
  "Get the current GIMP foreground color.",
  "This procedure retrieves the current GIMP foreground color. The foreground color is used in a variety of tools such as paint tools, blending, and bucket fill.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  0,
  NULL,
  1,
  palette_get_foreground_outargs,
  { { palette_get_foreground_invoker } }
};

static Argument *
palette_get_background_invoker (Gimp     *gimp,
                                Argument *args)
{
  Argument *return_args;
  GimpRGB color;

  gimp_context_get_background (gimp_get_current_context (gimp), &color);

  return_args = procedural_db_return_args (&palette_get_background_proc, TRUE);
  return_args[1].value.pdb_color = color;

  return return_args;
}

static ProcArg palette_get_background_outargs[] =
{
  {
    GIMP_PDB_COLOR,
    "background",
    "The background color"
  }
};

static ProcRecord palette_get_background_proc =
{
  "gimp_palette_get_background",
  "Get the current GIMP background color.",
  "This procedure retrieves the current GIMP background color. The background color is used in a variety of tools such as blending, erasing (with non-alpha images), and image filling.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  0,
  NULL,
  1,
  palette_get_background_outargs,
  { { palette_get_background_invoker } }
};

static Argument *
palette_set_foreground_invoker (Gimp     *gimp,
                                Argument *args)
{
  GimpRGB color;

  color = args[0].value.pdb_color;

  gimp_rgb_set_alpha (&color, 1.0);
  gimp_context_set_foreground (gimp_get_current_context (gimp), &color);

  return procedural_db_return_args (&palette_set_foreground_proc, TRUE);
}

static ProcArg palette_set_foreground_inargs[] =
{
  {
    GIMP_PDB_COLOR,
    "foreground",
    "The foreground color"
  }
};

static ProcRecord palette_set_foreground_proc =
{
  "gimp_palette_set_foreground",
  "Set the current GIMP foreground color.",
  "This procedure sets the current GIMP foreground color. After this is set, operations which use foreground such as paint tools, blending, and bucket fill will use the new value.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  1,
  palette_set_foreground_inargs,
  0,
  NULL,
  { { palette_set_foreground_invoker } }
};

static Argument *
palette_set_background_invoker (Gimp     *gimp,
                                Argument *args)
{
  GimpRGB color;

  color = args[0].value.pdb_color;

  gimp_rgb_set_alpha (&color, 1.0);
  gimp_context_set_background (gimp_get_current_context (gimp), &color);

  return procedural_db_return_args (&palette_set_background_proc, TRUE);
}

static ProcArg palette_set_background_inargs[] =
{
  {
    GIMP_PDB_COLOR,
    "background",
    "The background color"
  }
};

static ProcRecord palette_set_background_proc =
{
  "gimp_palette_set_background",
  "Set the current GIMP background color.",
  "This procedure sets the current GIMP background color. After this is set, operations which use background such as blending, filling images, clearing, and erasing (in non-alpha images) will use the new value.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  1,
  palette_set_background_inargs,
  0,
  NULL,
  { { palette_set_background_invoker } }
};

static Argument *
palette_set_default_colors_invoker (Gimp     *gimp,
                                    Argument *args)
{
  gimp_context_set_default_colors (gimp_get_current_context (gimp));
  return procedural_db_return_args (&palette_set_default_colors_proc, TRUE);
}

static ProcRecord palette_set_default_colors_proc =
{
  "gimp_palette_set_default_colors",
  "Set the current GIMP foreground and background colors to black and white.",
  "This procedure sets the current GIMP foreground and background colors to their initial default values, black and white.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  0,
  NULL,
  0,
  NULL,
  { { palette_set_default_colors_invoker } }
};

static Argument *
palette_swap_colors_invoker (Gimp     *gimp,
                             Argument *args)
{
  gimp_context_swap_colors (gimp_get_current_context (gimp));
  return procedural_db_return_args (&palette_swap_colors_proc, TRUE);
}

static ProcRecord palette_swap_colors_proc =
{
  "gimp_palette_swap_colors",
  "Swap the current GIMP foreground and background colors.",
  "This procedure swaps the current GIMP foreground and background colors, so that the new foreground color becomes the old background color and vice versa.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  GIMP_INTERNAL,
  0,
  NULL,
  0,
  NULL,
  { { palette_swap_colors_invoker } }
};

static Argument *
palette_refresh_invoker (Gimp     *gimp,
                         Argument *args)
{
  /* FIXME: I've hardcoded success to be TRUE, because brushes_init() is a 
   *        void function right now.  It'd be nice if it returned a value at 
   *        some future date, so we could tell if things blew up when reparsing
   *        the list (for whatever reason). 
   *                       - Seth "Yes, this is a kludge" Burgess
   *                         <sjburges@ou.edu>
   *   -and shamelessly stolen by Adrian Likins for use here...
   */

  gimp_data_factory_data_init (gimp->palette_factory, FALSE);

  return procedural_db_return_args (&palette_refresh_proc, TRUE);
}

static ProcRecord palette_refresh_proc =
{
  "gimp_palette_refresh",
  "Refreshes current palettes.",
  "This procedure incorporates all palettes currently in the users palette path.",
  "Adrian Likins <adrian@gimp.org>",
  "Adrian Likins",
  "1998",
  GIMP_INTERNAL,
  0,
  NULL,
  0,
  NULL,
  { { palette_refresh_invoker } }
};

static Argument *
palette_list_invoker (Gimp     *gimp,
                      Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar **palettes;
  GList *list = NULL;
  gint i = 0;

  palettes = g_new (gchar *, gimp->palette_factory->container->num_children);

  success = ((list = GIMP_LIST (gimp->palette_factory->container)->list) != NULL);

  while (list)
    {
      palettes[i++] = g_strdup (GIMP_OBJECT (list->data)->name);
      list = list->next;
    }

  return_args = procedural_db_return_args (&palette_list_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = gimp->palette_factory->container->num_children;
      return_args[2].value.pdb_pointer = palettes;
    }

  return return_args;
}

static ProcArg palette_list_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "num_palettes",
    "The number of palettes in the list"
  },
  {
    GIMP_PDB_STRINGARRAY,
    "palette_list",
    "The list of palette names"
  }
};

static ProcRecord palette_list_proc =
{
  "gimp_palette_list",
  "Retrieves a list of all of the available palettes",
  "This procedure returns a complete listing of available palettes. Each name returned can be used as input to the command 'gimp_palette_set_palette'.",
  "Nathan Summers <rock@gimp.org>",
  "Nathan Summers",
  "2001",
  GIMP_INTERNAL,
  0,
  NULL,
  2,
  palette_list_outargs,
  { { palette_list_invoker } }
};

static Argument *
palette_get_palette_invoker (Gimp     *gimp,
                             Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpPalette *palette;

  success = (palette = gimp_context_get_palette (gimp_get_current_context (gimp))) != NULL;

  return_args = procedural_db_return_args (&palette_get_palette_proc, success);

  if (success)
    {
      return_args[1].value.pdb_pointer = g_strdup (GIMP_OBJECT (palette)->name);
      return_args[2].value.pdb_int = palette->n_colors;
    }

  return return_args;
}

static ProcArg palette_get_palette_outargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The palette name"
  },
  {
    GIMP_PDB_INT32,
    "num_colors",
    "The palette num_colors"
  }
};

static ProcRecord palette_get_palette_proc =
{
  "gimp_palette_get_palette",
  "Retrieve information about the currently active palette.",
  "This procedure retrieves information about the currently active palette. This includes the name, and the number of colors.",
  "Nathan Summers <rock@gimp.org>",
  "Nathan Summers",
  "2001",
  GIMP_INTERNAL,
  0,
  NULL,
  2,
  palette_get_palette_outargs,
  { { palette_get_palette_invoker } }
};

static Argument *
palette_set_palette_invoker (Gimp     *gimp,
                             Argument *args)
{
  gboolean success = TRUE;
  gchar *name;
  GimpPalette *palette;
  GList *list;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL)
    success = FALSE;

  if (success)
    {
      success = FALSE;
    
      for (list = GIMP_LIST (gimp->palette_factory->container)->list;
	   list;
	   list = g_list_next (list))
	{
	  palette = (GimpPalette *) list->data;
    
	  if (! strcmp (GIMP_OBJECT (palette)->name, name))
	    {
	      gimp_context_set_palette (gimp_get_current_context (gimp), palette);
	      success = TRUE;
	      break;
	    }
	}
    }

  return procedural_db_return_args (&palette_set_palette_proc, success);
}

static ProcArg palette_set_palette_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The palette name"
  }
};

static ProcRecord palette_set_palette_proc =
{
  "gimp_palette_set_palette",
  "Set the specified palette as the active palette.",
  "This procedure allows the active palette to be set by specifying its name. The name is simply a string which corresponds to one of the names of the installed palettes. If no matching palette is found, this procedure will return an error. Otherwise, the specified palette becomes active and will be used in all subsequent palette operations.",
  "Nathan Summers <rock@gimp.org>",
  "Nathan Summers",
  "2001",
  GIMP_INTERNAL,
  1,
  palette_set_palette_inargs,
  0,
  NULL,
  { { palette_set_palette_invoker } }
};

static Argument *
palette_get_entry_invoker (Gimp     *gimp,
                           Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gint32 entry;
  GimpRGB color;
  GimpPalette *palette;

  entry = args[0].value.pdb_int;

  success = TRUE;

  palette = gimp_context_get_palette (gimp_get_current_context(gimp));

  if (entry < 0 || entry >= palette->n_colors) 
    {
      success = FALSE;
    }
  else
    {
      color=*(GimpRGB *) g_list_nth(palette->colors, entry)->data;
    }

  return_args = procedural_db_return_args (&palette_get_entry_proc, success);

  if (success)
    return_args[1].value.pdb_color = color;

  return return_args;
}

static ProcArg palette_get_entry_inargs[] =
{
  {
    GIMP_PDB_INT32,
    "entry_num",
    "The entry to retrieve"
  }
};

static ProcArg palette_get_entry_outargs[] =
{
  {
    GIMP_PDB_COLOR,
    "color",
    "The color requested"
  }
};

static ProcRecord palette_get_entry_proc =
{
  "gimp_palette_get_entry",
  "Gets the specified palette entry from the currently active palette.",
  "This procedure retrieves the color of the zero-based entry specifed for the current palette. It returns an error if the entry does not exist.",
  "Nathan Summers <rock@gimp.org>",
  "Nathan Summers",
  "2001",
  GIMP_INTERNAL,
  1,
  palette_get_entry_inargs,
  1,
  palette_get_entry_outargs,
  { { palette_get_entry_invoker } }
};
