/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"

#include <string.h>

#include <glib-object.h>

#include "pdb-types.h"
#include "procedural_db.h"

#include "core/gimp.h"
#include "core/gimplist.h"
#include "gimp-intl.h"
#include "vectors/gimpanchor.h"
#include "vectors/gimpbezierstroke.h"
#include "vectors/gimpvectors-compat.h"
#include "vectors/gimpvectors.h"

static ProcRecord vectors_get_strokes_proc;

void
register_vectors_procs (Gimp *gimp)
{
  procedural_db_register (gimp, &vectors_get_strokes_proc);
}

static Argument *
vectors_get_strokes_invoker (Gimp         *gimp,
                             GimpContext  *context,
                             GimpProgress *progress,
                             Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpVectors *vectors;
  gint32 num_strokes = 0;
  gint32 *stroke_list = NULL;

  vectors = (GimpVectors *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_VECTORS (vectors) && ! gimp_item_is_removed (GIMP_ITEM (vectors))))
    success = FALSE;

  if (success)
    {
      /* nothing yet */
    }

  return_args = procedural_db_return_args (&vectors_get_strokes_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = num_strokes;
      return_args[2].value.pdb_pointer = stroke_list;
    }

  return return_args;
}

static ProcArg vectors_get_strokes_inargs[] =
{
  {
    GIMP_PDB_PATH,
    "vectors",
    "The vectors object"
  }
};

static ProcArg vectors_get_strokes_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "num_strokes",
    "The number of strokes returned."
  },
  {
    GIMP_PDB_INT32ARRAY,
    "stroke_list",
    "List of the paths belonging to this image."
  }
};

static ProcRecord vectors_get_strokes_proc =
{
  "gimp_vectors_get_strokes",
  "List the strokes associated with the passed path.",
  "Returns an Array with the stroke-IDs associated with the passed path.",
  "Simon Budig",
  "Simon Budig",
  "2005",
  NULL,
  GIMP_INTERNAL,
  1,
  vectors_get_strokes_inargs,
  2,
  vectors_get_strokes_outargs,
  { { vectors_get_strokes_invoker } }
};
