/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"

#include <string.h>

#include <glib-object.h>

#include "libgimpcolor/gimpcolor.h"

#include "pdb-types.h"
#include "gimppdb.h"
#include "gimpprocedure.h"
#include "core/gimpparamspecs.h"

#include "core/gimp.h"
#include "core/gimpcontext.h"
#include "core/gimpdatafactory.h"
#include "core/gimplist.h"
#include "core/gimppalette.h"


static GValueArray *
palette_new_invoker (GimpProcedure     *procedure,
                     Gimp              *gimp,
                     GimpContext       *context,
                     GimpProgress      *progress,
                     const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  const gchar *name;
  gchar *actual_name = NULL;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      if (strlen (name))
        {
          GimpData *data = gimp_data_factory_data_new (gimp->palette_factory, name);

          if (data)
            actual_name = g_strdup (gimp_object_get_name (GIMP_OBJECT (data)));
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_take_string (&return_vals->values[1], actual_name);

  return return_vals;
}

static GValueArray *
palette_duplicate_invoker (GimpProcedure     *procedure,
                           Gimp              *gimp,
                           GimpContext       *context,
                           GimpProgress      *progress,
                           const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  const gchar *name;
  gchar *copy_name = NULL;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpPalette *palette = (GimpPalette *)
        gimp_container_get_child_by_name (gimp->palette_factory->container, name);

      if (palette)
        {
          GimpPalette *palette_copy = (GimpPalette *)
            gimp_data_factory_data_duplicate (gimp->palette_factory,
                                              GIMP_DATA (palette));

          if (palette_copy)
            copy_name = g_strdup (gimp_object_get_name (GIMP_OBJECT (palette_copy)));
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_take_string (&return_vals->values[1], copy_name);

  return return_vals;
}

static GValueArray *
palette_rename_invoker (GimpProcedure     *procedure,
                        Gimp              *gimp,
                        GimpContext       *context,
                        GimpProgress      *progress,
                        const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  const gchar *name;
  const gchar *new_name;
  gchar *actual_name = NULL;

  name = g_value_get_string (&args->values[0]);
  new_name = g_value_get_string (&args->values[1]);

  if (success)
    {
      GimpPalette *palette = (GimpPalette *)
        gimp_container_get_child_by_name (gimp->palette_factory->container, name);

      if (palette && GIMP_DATA (palette)->writable)
        {
          gimp_object_set_name (GIMP_OBJECT (palette), new_name);
          actual_name = g_strdup (gimp_object_get_name (GIMP_OBJECT (palette)));
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_take_string (&return_vals->values[1], actual_name);

  return return_vals;
}

static GValueArray *
palette_delete_invoker (GimpProcedure     *procedure,
                        Gimp              *gimp,
                        GimpContext       *context,
                        GimpProgress      *progress,
                        const GValueArray *args)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpPalette *palette = (GimpPalette *)
        gimp_container_get_child_by_name (gimp->palette_factory->container, name);

      if (palette && GIMP_DATA (palette)->deletable)
        {
          GError *error = NULL;

          success = gimp_data_factory_data_delete (gimp->palette_factory,
                                                   GIMP_DATA (palette),
                                                   TRUE, &error);

          if (! success)
            {
              gimp_message (gimp, progress, error->message);
              g_clear_error (&error);
            }
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
palette_is_editable_invoker (GimpProcedure     *procedure,
                             Gimp              *gimp,
                             GimpContext       *context,
                             GimpProgress      *progress,
                             const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  const gchar *name;
  gboolean editable = FALSE;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpPalette *palette = (GimpPalette *)
        gimp_container_get_child_by_name (gimp->palette_factory->container, name);

      if (palette)
        editable = GIMP_DATA (palette)->writable;
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_set_boolean (&return_vals->values[1], editable);

  return return_vals;
}

static GValueArray *
palette_get_info_invoker (GimpProcedure     *procedure,
                          Gimp              *gimp,
                          GimpContext       *context,
                          GimpProgress      *progress,
                          const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  const gchar *name;
  gint32 num_colors = 0;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpPalette *palette = (GimpPalette *)
        gimp_container_get_child_by_name (gimp->palette_factory->container, name);

      if (palette)
        num_colors = palette->n_colors;
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_set_int (&return_vals->values[1], num_colors);

  return return_vals;
}

static GValueArray *
palette_get_columns_invoker (GimpProcedure     *procedure,
                             Gimp              *gimp,
                             GimpContext       *context,
                             GimpProgress      *progress,
                             const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  const gchar *name;
  gint32 num_columns = 0;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpPalette *palette = (GimpPalette *)
        gimp_container_get_child_by_name (gimp->palette_factory->container, name);

      if (palette)
        num_columns = palette->n_columns;
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_set_int (&return_vals->values[1], num_columns);

  return return_vals;
}

static GValueArray *
palette_set_columns_invoker (GimpProcedure     *procedure,
                             Gimp              *gimp,
                             GimpContext       *context,
                             GimpProgress      *progress,
                             const GValueArray *args)
{
  gboolean success = TRUE;
  const gchar *name;
  gint32 columns;

  name = g_value_get_string (&args->values[0]);
  columns = g_value_get_int (&args->values[1]);

  if (success)
    {
      GimpPalette *palette = (GimpPalette *)
        gimp_container_get_child_by_name (gimp->palette_factory->container, name);

      if (palette && GIMP_DATA (palette)->writable)
        gimp_palette_set_columns (palette, columns);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
palette_add_entry_invoker (GimpProcedure     *procedure,
                           Gimp              *gimp,
                           GimpContext       *context,
                           GimpProgress      *progress,
                           const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  const gchar *name;
  const gchar *entry_name;
  GimpRGB color;
  gint32 entry_num = 0;

  name = g_value_get_string (&args->values[0]);
  entry_name = g_value_get_string (&args->values[1]);
  gimp_value_get_rgb (&args->values[2], &color);

  if (success)
    {
      GimpPalette *palette = (GimpPalette *)
        gimp_container_get_child_by_name (gimp->palette_factory->container, name);

      if (palette && GIMP_DATA (palette)->writable)
        {
          GimpPaletteEntry *entry =
            gimp_palette_add_entry (palette, -1, entry_name, &color);

          entry_num = entry->position;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_set_int (&return_vals->values[1], entry_num);

  return return_vals;
}

static GValueArray *
palette_delete_entry_invoker (GimpProcedure     *procedure,
                              Gimp              *gimp,
                              GimpContext       *context,
                              GimpProgress      *progress,
                              const GValueArray *args)
{
  gboolean success = TRUE;
  const gchar *name;
  gint32 entry_num;

  name = g_value_get_string (&args->values[0]);
  entry_num = g_value_get_int (&args->values[1]);

  if (success)
    {
      GimpPalette *palette = (GimpPalette *)
        gimp_container_get_child_by_name (gimp->palette_factory->container, name);

      if (palette && GIMP_DATA (palette)->writable)
        {
          if (entry_num >= 0 && entry_num < palette->n_colors)
            {
              GimpPaletteEntry *entry = g_list_nth_data (palette->colors, entry_num);

              gimp_palette_delete_entry (palette, entry);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
palette_entry_get_color_invoker (GimpProcedure     *procedure,
                                 Gimp              *gimp,
                                 GimpContext       *context,
                                 GimpProgress      *progress,
                                 const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  const gchar *name;
  gint32 entry_num;
  GimpRGB color = { 0.0, 0.0, 0.0, 1.0 };

  name = g_value_get_string (&args->values[0]);
  entry_num = g_value_get_int (&args->values[1]);

  if (success)
    {
      GimpPalette *palette = (GimpPalette *)
        gimp_container_get_child_by_name (gimp->palette_factory->container, name);

      if (palette)
        {
          if (entry_num >= 0 && entry_num < palette->n_colors)
            {
              GimpPaletteEntry *entry = g_list_nth_data (palette->colors, entry_num);

              color = entry->color;
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_rgb (&return_vals->values[1], &color);

  return return_vals;
}

static GValueArray *
palette_entry_set_color_invoker (GimpProcedure     *procedure,
                                 Gimp              *gimp,
                                 GimpContext       *context,
                                 GimpProgress      *progress,
                                 const GValueArray *args)
{
  gboolean success = TRUE;
  const gchar *name;
  gint32 entry_num;
  GimpRGB color;

  name = g_value_get_string (&args->values[0]);
  entry_num = g_value_get_int (&args->values[1]);
  gimp_value_get_rgb (&args->values[2], &color);

  if (success)
    {
      GimpPalette *palette = (GimpPalette *)
        gimp_container_get_child_by_name (gimp->palette_factory->container, name);

      if (palette && GIMP_DATA (palette)->writable)
        {
          if (entry_num >= 0 && entry_num < palette->n_colors)
            {
              GimpPaletteEntry *entry = g_list_nth_data (palette->colors, entry_num);

              entry->color = color;

              gimp_data_dirty (GIMP_DATA (palette));
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
palette_entry_get_name_invoker (GimpProcedure     *procedure,
                                Gimp              *gimp,
                                GimpContext       *context,
                                GimpProgress      *progress,
                                const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  const gchar *name;
  gint32 entry_num;
  gchar *entry_name = NULL;

  name = g_value_get_string (&args->values[0]);
  entry_num = g_value_get_int (&args->values[1]);

  if (success)
    {
      GimpPalette *palette = (GimpPalette *)
        gimp_container_get_child_by_name (gimp->palette_factory->container, name);

      if (palette)
        {
          if (entry_num >= 0 && entry_num < palette->n_colors)
            {
              GimpPaletteEntry *entry = g_list_nth_data (palette->colors, entry_num);

              entry_name = g_strdup (entry->name);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_take_string (&return_vals->values[1], entry_name);

  return return_vals;
}

static GValueArray *
palette_entry_set_name_invoker (GimpProcedure     *procedure,
                                Gimp              *gimp,
                                GimpContext       *context,
                                GimpProgress      *progress,
                                const GValueArray *args)
{
  gboolean success = TRUE;
  const gchar *name;
  gint32 entry_num;
  const gchar *entry_name;

  name = g_value_get_string (&args->values[0]);
  entry_num = g_value_get_int (&args->values[1]);
  entry_name = g_value_get_string (&args->values[2]);

  if (success)
    {
      GimpPalette *palette = (GimpPalette *)
        gimp_container_get_child_by_name (gimp->palette_factory->container, name);

      if (palette && GIMP_DATA (palette)->writable)
        {
          if (entry_num >= 0 && entry_num < palette->n_colors)
            {
              GimpPaletteEntry *entry = g_list_nth_data (palette->colors, entry_num);

              g_free (entry->name);
              entry->name = g_strdup (entry_name);

              gimp_data_dirty (GIMP_DATA (palette));
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

void
register_palette_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-palette-new
   */
  procedure = gimp_procedure_new (palette_new_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-palette-new");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-palette-new",
                                     "Creates a new palette",
                                     "This procedure creates a new, uninitialized palette",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The requested name of the new palette",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("actual-name",
                                                           "actual name",
                                                           "The actual new palette name",
                                                           FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-duplicate
   */
  procedure = gimp_procedure_new (palette_duplicate_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-palette-duplicate");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-palette-duplicate",
                                     "Duplicates a palette",
                                     "This procedure creates an identical palette by a different name",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("copy-name",
                                                           "copy name",
                                                           "The name of the palette's copy",
                                                           FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-rename
   */
  procedure = gimp_procedure_new (palette_rename_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-palette-rename");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-palette-rename",
                                     "Rename a palette",
                                     "This procedure renames a palette",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("new-name",
                                                       "new name",
                                                       "The new name of the palette",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("actual-name",
                                                           "actual name",
                                                           "The actual new name of the palette",
                                                           FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-delete
   */
  procedure = gimp_procedure_new (palette_delete_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-palette-delete");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-palette-delete",
                                     "Deletes a palette",
                                     "This procedure deletes a palette",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-is-editable
   */
  procedure = gimp_procedure_new (palette_is_editable_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-palette-is-editable");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-palette-is-editable",
                                     "Tests if palette can be edited",
                                     "Returns TRUE if you have permission to change the palette",
                                     "Bill Skaggs <weskaggs@primate.ucdavis.edu>",
                                     "Bill Skaggs",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("editable",
                                                         "editable",
                                                         "TRUE if the palette can be edited",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-get-info
   */
  procedure = gimp_procedure_new (palette_get_info_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-palette-get-info");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-palette-get-info",
                                     "Retrieve information about the specified palette.",
                                     "This procedure retrieves information about the specified palette. This includes the name, and the number of colors.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("num-colors",
                                                          "num colors",
                                                          "The number of colors in the palette",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-get-columns
   */
  procedure = gimp_procedure_new (palette_get_columns_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-palette-get-columns");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-palette-get-columns",
                                     "Retrieves the number of columns to use to display this palette",
                                     "This procedures retrieves the prefered number of columns to use when the palette is being displayed.",
                                     "Sven Neumann <sven@gimp.org>",
                                     "Sven Neumann",
                                     "2005",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("num-columns",
                                                          "num columns",
                                                          "The number of columns used to display this palette",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-set-columns
   */
  procedure = gimp_procedure_new (palette_set_columns_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-palette-set-columns");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-palette-set-columns",
                                     "Sets the number of columns to use when displaying the palette",
                                     "This procedures allows to control how many colors are shown per row when the palette is being displayed. This value can only be changed if the palette is writable. The maximum allowed value is 64.",
                                     "Sven Neumann <sven@gimp.org>",
                                     "Sven Neumann",
                                     "2005",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("columns",
                                                      "columns",
                                                      "The new number of columns",
                                                      0, 64, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-add-entry
   */
  procedure = gimp_procedure_new (palette_add_entry_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-palette-add-entry");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-palette-add-entry",
                                     "Adds a palette entry to the specified palette.",
                                     "This procedure adds an entry to the specifed palette. It returns an error if the entry palette does not exist.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("entry-name",
                                                       "entry name",
                                                       "The name of the entry",
                                                       FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_rgb ("color",
                                                    "color",
                                                    "The new entry's color color",
                                                    FALSE,
                                                    NULL,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("entry-num",
                                                          "entry num",
                                                          "The index of the added entry",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-delete-entry
   */
  procedure = gimp_procedure_new (palette_delete_entry_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-palette-delete-entry");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-palette-delete-entry",
                                     "Deletes a palette entry from the specified palette.",
                                     "This procedure deletes an entry from the specifed palette. It returns an error if the entry palette does not exist.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("entry-num",
                                                      "entry num",
                                                      "The index of the added entry",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-entry-get-color
   */
  procedure = gimp_procedure_new (palette_entry_get_color_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-palette-entry-get-color");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-palette-entry-get-color",
                                     "Gets the specified palette entry from the specified palette.",
                                     "This procedure retrieves the color of the zero-based entry specifed for the specified palette. It returns an error if the entry does not exist.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("entry-num",
                                                      "entry num",
                                                      "The entry to retrieve",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_rgb ("color",
                                                        "color",
                                                        "The color requested",
                                                        FALSE,
                                                        NULL,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-entry-set-color
   */
  procedure = gimp_procedure_new (palette_entry_set_color_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-palette-entry-set-color");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-palette-entry-set-color",
                                     "Sets the specified palette entry in the specified palette.",
                                     "This procedure sets the color of the zero-based entry specifed for the specified palette. It returns an error if the entry does not exist.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("entry-num",
                                                      "entry num",
                                                      "The entry to retrieve",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_rgb ("color",
                                                    "color",
                                                    "The new color",
                                                    FALSE,
                                                    NULL,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-entry-get-name
   */
  procedure = gimp_procedure_new (palette_entry_get_name_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-palette-entry-get-name");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-palette-entry-get-name",
                                     "Gets the specified palette entry from the specified palette.",
                                     "This procedure retrieves the name of the zero-based entry specifed for the specified palette. It returns an error if the entry does not exist.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("entry-num",
                                                      "entry num",
                                                      "The entry to retrieve",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("entry-name",
                                                           "entry name",
                                                           "The name requested",
                                                           FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-palette-entry-set-name
   */
  procedure = gimp_procedure_new (palette_entry_set_name_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-palette-entry-set-name");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-palette-entry-set-name",
                                     "Sets the specified palette entry in the specified palette.",
                                     "This procedure sets the name of the zero-based entry specifed for the specified palette. It returns an error if the entry does not exist.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The palette name",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("entry-num",
                                                      "entry num",
                                                      "The entry to retrieve",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("entry-name",
                                                       "entry name",
                                                       "The new name",
                                                       FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
