/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpbuffer_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "config.h"

#include "gimp.h"

/**
 * gimp_buffers_get_list:
 * @filter: An optional regular expression used to filter the list.
 * @num_buffers: The number of buffers.
 *
 * Retrieve a complete listing of the available buffers.
 *
 * This procedure returns a complete listing of available named
 * buffers.
 *
 * Returns: The list of buffer names.
 *
 * Since: GIMP 2.4
 */
gchar **
gimp_buffers_get_list (const gchar *filter,
                       gint        *num_buffers)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar **buffer_list = NULL;
  gint i;

  return_vals = gimp_run_procedure ("gimp-buffers-get-list",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, filter,
                                    GIMP_PDB_END);

  *num_buffers = 0;

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      *num_buffers = return_vals[1].data.d_int32;
      buffer_list = g_new (gchar *, *num_buffers);
      for (i = 0; i < *num_buffers; i++)
        buffer_list[i] = g_strdup (return_vals[2].data.d_stringarray[i]);
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return buffer_list;
}

/**
 * gimp_buffer_rename:
 * @buffer_name: The buffer name.
 * @new_name: The buffer's new name.
 *
 * Renames a named buffer.
 *
 * This procedure renames a named buffer.
 *
 * Returns: The real name given to the buffer.
 *
 * Since: GIMP 2.4
 */
gchar *
gimp_buffer_rename (const gchar *buffer_name,
                    const gchar *new_name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *real_name = NULL;

  return_vals = gimp_run_procedure ("gimp-buffer-rename",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, buffer_name,
                                    GIMP_PDB_STRING, new_name,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    real_name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return real_name;
}

/**
 * gimp_buffer_delete:
 * @buffer_name: The buffer name.
 *
 * Deletes a named buffer.
 *
 * This procedure deletes a named buffer.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.4
 */
gboolean
gimp_buffer_delete (const gchar *buffer_name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-buffer-delete",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, buffer_name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_buffer_get_width:
 * @buffer_name: The buffer name.
 *
 * Retrieves the specified buffer's width.
 *
 * This procedure retrieves the specified named buffer's width.
 *
 * Returns: The buffer width.
 *
 * Since: GIMP 2.4
 */
gint
gimp_buffer_get_width (const gchar *buffer_name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint width = 0;

  return_vals = gimp_run_procedure ("gimp-buffer-get-width",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, buffer_name,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    width = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return width;
}

/**
 * gimp_buffer_get_height:
 * @buffer_name: The buffer name.
 *
 * Retrieves the specified buffer's height.
 *
 * This procedure retrieves the specified named buffer's height.
 *
 * Returns: The buffer height.
 *
 * Since: GIMP 2.4
 */
gint
gimp_buffer_get_height (const gchar *buffer_name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint height = 0;

  return_vals = gimp_run_procedure ("gimp-buffer-get-height",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, buffer_name,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    height = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return height;
}

/**
 * gimp_buffer_get_bytes:
 * @buffer_name: The buffer name.
 *
 * Retrieves the specified buffer's bytes.
 *
 * This procedure retrieves the specified named buffer's bytes.
 *
 * Returns: The buffer bpp.
 *
 * Since: GIMP 2.4
 */
gint
gimp_buffer_get_bytes (const gchar *buffer_name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint bytes = 0;

  return_vals = gimp_run_procedure ("gimp-buffer-get-bytes",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, buffer_name,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    bytes = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return bytes;
}

/**
 * gimp_buffer_get_image_type:
 * @buffer_name: The buffer name.
 *
 * Retrieves the specified buffer's image type.
 *
 * This procedure retrieves the specified named buffer's image type.
 *
 * Returns: The buffer image type.
 *
 * Since: GIMP 2.4
 */
GimpImageBaseType
gimp_buffer_get_image_type (const gchar *buffer_name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpImageBaseType image_type = 0;

  return_vals = gimp_run_procedure ("gimp-buffer-get-image-type",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, buffer_name,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    image_type = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return image_type;
}
