/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpunit_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"

/**
 * _gimp_unit_get_number_of_units:
 *
 * Returns the number of units.
 *
 * This procedure returns the number of defined units.
 *
 * Returns: The number of units.
 */
gint
_gimp_unit_get_number_of_units (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint num_units = GIMP_UNIT_END;

  return_vals = gimp_run_procedure ("gimp-unit-get-number-of-units",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    num_units = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return num_units;
}

/**
 * _gimp_unit_get_number_of_built_in_units:
 *
 * Returns the number of built-in units.
 *
 * This procedure returns the number of defined units built-in to the
 * GIMP.
 *
 * Returns: The number of built-in units.
 */
gint
_gimp_unit_get_number_of_built_in_units (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint num_units = GIMP_UNIT_END;

  return_vals = gimp_run_procedure ("gimp-unit-get-number-of-built-in-units",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    num_units = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return num_units;
}

/**
 * _gimp_unit_new:
 * @identifier: The new unit's identifier.
 * @factor: The new unit's factor.
 * @digits: The new unit's digits.
 * @symbol: The new unit's symbol.
 * @abbreviation: The new unit's abbreviation.
 * @singular: The new unit's singular form.
 * @plural: The new unit's plural form.
 *
 * Creates a new unit and returns it's integer ID.
 *
 * This procedure creates a new unit and returns it's integer ID. Note
 * that the new unit will have it's deletion flag set to TRUE, so you
 * will have to set it to FALSE with gimp_unit_set_deletion_flag() to
 * make it persistent.
 *
 * Returns: The new unit's ID.
 */
GimpUnit
_gimp_unit_new (const gchar *identifier,
                gdouble      factor,
                gint         digits,
                const gchar *symbol,
                const gchar *abbreviation,
                const gchar *singular,
                const gchar *plural)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  GimpUnit unit_id = GIMP_UNIT_INCH;

  return_vals = gimp_run_procedure ("gimp-unit-new",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, identifier,
                                    GIMP_PDB_FLOAT, factor,
                                    GIMP_PDB_INT32, digits,
                                    GIMP_PDB_STRING, symbol,
                                    GIMP_PDB_STRING, abbreviation,
                                    GIMP_PDB_STRING, singular,
                                    GIMP_PDB_STRING, plural,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    unit_id = return_vals[1].data.d_unit;

  gimp_destroy_params (return_vals, nreturn_vals);

  return unit_id;
}

/**
 * _gimp_unit_get_deletion_flag:
 * @unit_id: The unit's integer ID.
 *
 * Returns the deletion flag of the unit.
 *
 * This procedure returns the deletion flag of the unit. If this value
 * is TRUE the unit's definition will not be saved in the user's unitrc
 * file on gimp exit.
 *
 * Returns: The unit's deletion flag.
 */
gboolean
_gimp_unit_get_deletion_flag (GimpUnit unit_id)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean deletion_flag = FALSE;

  return_vals = gimp_run_procedure ("gimp-unit-get-deletion-flag",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, unit_id,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    deletion_flag = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return deletion_flag;
}

/**
 * _gimp_unit_set_deletion_flag:
 * @unit_id: The unit's integer ID.
 * @deletion_flag: The new deletion flag of the unit.
 *
 * Sets the deletion flag of a unit.
 *
 * This procedure sets the unit's deletion flag. If the deletion flag
 * of a unit is TRUE on gimp exit, this unit's definition will not be
 * saved in the user's unitrc.
 *
 * Returns: TRUE on success.
 */
gboolean
_gimp_unit_set_deletion_flag (GimpUnit unit_id,
                              gboolean deletion_flag)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-unit-set-deletion-flag",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, unit_id,
                                    GIMP_PDB_INT32, deletion_flag,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * _gimp_unit_get_identifier:
 * @unit_id: The unit's integer ID.
 *
 * Returns the textual identifier of the unit.
 *
 * This procedure returns the textual identifier of the unit. For
 * built-in units it will be the english singular form of the unit's
 * name. For user-defined units this should equal to the singular form.
 *
 * Returns: The unit's textual identifier.
 */
gchar *
_gimp_unit_get_identifier (GimpUnit unit_id)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *identifier = NULL;

  return_vals = gimp_run_procedure ("gimp-unit-get-identifier",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, unit_id,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    identifier = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return identifier;
}

/**
 * _gimp_unit_get_factor:
 * @unit_id: The unit's integer ID.
 *
 * Returns the factor of the unit.
 *
 * This procedure returns the unit's factor which indicates how many
 * units make up an inch. Note that asking for the factor of \"pixels\"
 * will produce an error.
 *
 * Returns: The unit's factor.
 */
gdouble
_gimp_unit_get_factor (GimpUnit unit_id)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble factor = 0.0;

  return_vals = gimp_run_procedure ("gimp-unit-get-factor",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, unit_id,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    factor = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return factor;
}

/**
 * _gimp_unit_get_digits:
 * @unit_id: The unit's integer ID.
 *
 * Returns the number of digits of the unit.
 *
 * This procedure returns the number of digits you should provide in
 * input or output functions to get approximately the same accuracy as
 * with two digits and inches. Note that asking for the digits of
 * \"pixels\" will produce an error.
 *
 * Returns: The unit's number of digits.
 */
gint
_gimp_unit_get_digits (GimpUnit unit_id)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint digits = 0;

  return_vals = gimp_run_procedure ("gimp-unit-get-digits",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, unit_id,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    digits = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return digits;
}

/**
 * _gimp_unit_get_symbol:
 * @unit_id: The unit's integer ID.
 *
 * Returns the symbol of the unit.
 *
 * This procedure returns the symbol of the unit (\"''\" for inches).
 *
 * Returns: The unit's symbol.
 */
gchar *
_gimp_unit_get_symbol (GimpUnit unit_id)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *symbol = NULL;

  return_vals = gimp_run_procedure ("gimp-unit-get-symbol",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, unit_id,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    symbol = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return symbol;
}

/**
 * _gimp_unit_get_abbreviation:
 * @unit_id: The unit's integer ID.
 *
 * Returns the abbreviation of the unit.
 *
 * This procedure returns the abbreviation of the unit (\"in\" for
 * inches).
 *
 * Returns: The unit's abbreviation.
 */
gchar *
_gimp_unit_get_abbreviation (GimpUnit unit_id)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *abbreviation = NULL;

  return_vals = gimp_run_procedure ("gimp-unit-get-abbreviation",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, unit_id,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    abbreviation = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return abbreviation;
}

/**
 * _gimp_unit_get_singular:
 * @unit_id: The unit's integer ID.
 *
 * Returns the singular form of the unit.
 *
 * This procedure returns the singular form of the unit.
 *
 * Returns: The unit's singular form.
 */
gchar *
_gimp_unit_get_singular (GimpUnit unit_id)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *singular = NULL;

  return_vals = gimp_run_procedure ("gimp-unit-get-singular",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, unit_id,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    singular = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return singular;
}

/**
 * _gimp_unit_get_plural:
 * @unit_id: The unit's integer ID.
 *
 * Returns the plural form of the unit.
 *
 * This procedure returns the plural form of the unit.
 *
 * Returns: The unit's plural form.
 */
gchar *
_gimp_unit_get_plural (GimpUnit unit_id)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *plural = NULL;

  return_vals = gimp_run_procedure ("gimp-unit-get-plural",
                                    &nreturn_vals,
                                    GIMP_PDB_INT32, unit_id,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    plural = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return plural;
}
