/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"

#include <string.h>

#include <glib-object.h>

#include "pdb-types.h"
#include "procedural_db.h"

#include "base/temp-buf.h"
#include "core/gimp.h"
#include "core/gimpbrush.h"
#include "core/gimpbrushgenerated.h"
#include "core/gimpcontext.h"
#include "core/gimpdatafactory.h"
#include "core/gimplist.h"

static ProcRecord brush_new_proc;
static ProcRecord brush_duplicate_proc;
static ProcRecord brush_is_generated_proc;
static ProcRecord brush_rename_proc;
static ProcRecord brush_delete_proc;
static ProcRecord brush_is_editable_proc;
static ProcRecord brush_get_info_proc;
static ProcRecord brush_get_pixels_proc;
static ProcRecord brush_get_spacing_proc;
static ProcRecord brush_set_spacing_proc;
static ProcRecord brush_get_shape_proc;
static ProcRecord brush_get_radius_proc;
static ProcRecord brush_get_spikes_proc;
static ProcRecord brush_get_hardness_proc;
static ProcRecord brush_get_aspect_ratio_proc;
static ProcRecord brush_get_angle_proc;
static ProcRecord brush_set_shape_proc;
static ProcRecord brush_set_radius_proc;
static ProcRecord brush_set_spikes_proc;
static ProcRecord brush_set_hardness_proc;
static ProcRecord brush_set_aspect_ratio_proc;
static ProcRecord brush_set_angle_proc;

void
register_brush_procs (Gimp *gimp)
{
  procedural_db_register (gimp, &brush_new_proc);
  procedural_db_register (gimp, &brush_duplicate_proc);
  procedural_db_register (gimp, &brush_is_generated_proc);
  procedural_db_register (gimp, &brush_rename_proc);
  procedural_db_register (gimp, &brush_delete_proc);
  procedural_db_register (gimp, &brush_is_editable_proc);
  procedural_db_register (gimp, &brush_get_info_proc);
  procedural_db_register (gimp, &brush_get_pixels_proc);
  procedural_db_register (gimp, &brush_get_spacing_proc);
  procedural_db_register (gimp, &brush_set_spacing_proc);
  procedural_db_register (gimp, &brush_get_shape_proc);
  procedural_db_register (gimp, &brush_get_radius_proc);
  procedural_db_register (gimp, &brush_get_spikes_proc);
  procedural_db_register (gimp, &brush_get_hardness_proc);
  procedural_db_register (gimp, &brush_get_aspect_ratio_proc);
  procedural_db_register (gimp, &brush_get_angle_proc);
  procedural_db_register (gimp, &brush_set_shape_proc);
  procedural_db_register (gimp, &brush_set_radius_proc);
  procedural_db_register (gimp, &brush_set_spikes_proc);
  procedural_db_register (gimp, &brush_set_hardness_proc);
  procedural_db_register (gimp, &brush_set_aspect_ratio_proc);
  procedural_db_register (gimp, &brush_set_angle_proc);
}

static Argument *
brush_new_invoker (Gimp         *gimp,
                   GimpContext  *context,
                   GimpProgress *progress,
                   Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpData *data = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      if (strlen (name))
        data = gimp_data_factory_data_new (gimp->brush_factory, name);

      success = (data != NULL);
    }

  return_args = procedural_db_return_args (&brush_new_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = g_strdup (GIMP_OBJECT (data)->name);

  return return_args;
}

static ProcArg brush_new_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The requested name of the new brush"
  }
};

static ProcArg brush_new_outargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The actual new brush name"
  }
};

static ProcRecord brush_new_proc =
{
  "gimp-brush-new",
  "gimp-brush-new",
  "Creates a new brush",
  "This procedure creates a new, uninitialized brush",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_new_inargs,
  1,
  brush_new_outargs,
  { { brush_new_invoker } }
};

static Argument *
brush_duplicate_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpBrush *brush = NULL;
  GimpBrush *brush_copy = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush)
        {
          brush_copy = (GimpBrush *)
            gimp_data_factory_data_duplicate (gimp->brush_factory,
                                              GIMP_DATA (brush));

          success = (brush_copy != NULL);
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&brush_duplicate_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = g_strdup (GIMP_OBJECT (brush_copy)->name);

  return return_args;
}

static ProcArg brush_duplicate_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcArg brush_duplicate_outargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The name of the brush's copy"
  }
};

static ProcRecord brush_duplicate_proc =
{
  "gimp-brush-duplicate",
  "gimp-brush-duplicate",
  "Duplicates a brush",
  "This procedure creates an identical brush by a different name",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_duplicate_inargs,
  1,
  brush_duplicate_outargs,
  { { brush_duplicate_invoker } }
};

static Argument *
brush_is_generated_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush)
        success = TRUE;
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&brush_is_generated_proc, success);

  if (success)
    return_args[1].value.pdb_int = GIMP_IS_BRUSH_GENERATED (brush);

  return return_args;
}

static ProcArg brush_is_generated_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcArg brush_is_generated_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "generated",
    "True if the brush is generated"
  }
};

static ProcRecord brush_is_generated_proc =
{
  "gimp-brush-is-generated",
  "gimp-brush-is-generated",
  "Tests if generated",
  "Returns True if this brush is parametric, False for other types",
  "Bill Skaggs <weskaggs@primate.ucdavis.edu",
  "Bill Skaggs",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_is_generated_inargs,
  1,
  brush_is_generated_outargs,
  { { brush_is_generated_invoker } }
};

static Argument *
brush_rename_invoker (Gimp         *gimp,
                      GimpContext  *context,
                      GimpProgress *progress,
                      Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gchar *new_name;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  new_name = (gchar *) args[1].value.pdb_pointer;
  if (new_name == NULL || !g_utf8_validate (new_name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush && GIMP_DATA (brush)->writable)
        gimp_object_set_name (GIMP_OBJECT (brush), new_name);
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&brush_rename_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = g_strdup (GIMP_OBJECT (brush)->name);

  return return_args;
}

static ProcArg brush_rename_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  },
  {
    GIMP_PDB_STRING,
    "new-name",
    "The new name of the brush"
  }
};

static ProcArg brush_rename_outargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The actual new name of the brush"
  }
};

static ProcRecord brush_rename_proc =
{
  "gimp-brush-rename",
  "gimp-brush-rename",
  "Rename a brush",
  "This procedure renames a brush",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  2,
  brush_rename_inargs,
  1,
  brush_rename_outargs,
  { { brush_rename_invoker } }
};

static Argument *
brush_delete_invoker (Gimp         *gimp,
                      GimpContext  *context,
                      GimpProgress *progress,
                      Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush && GIMP_DATA (brush)->deletable)
        {
          GError *error = NULL;

          success = gimp_data_factory_data_delete (gimp->brush_factory,
                                                   GIMP_DATA (brush),
                                                   TRUE, &error);

          if (! success)
            {
              g_message (error->message);
              g_clear_error (&error);
            }
        }
      else
        success = FALSE;
    }

  return procedural_db_return_args (&brush_delete_proc, success);
}

static ProcArg brush_delete_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcRecord brush_delete_proc =
{
  "gimp-brush-delete",
  "gimp-brush-delete",
  "Deletes a brush",
  "This procedure deletes a brush",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_delete_inargs,
  0,
  NULL,
  { { brush_delete_invoker } }
};

static Argument *
brush_is_editable_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush)
        success = TRUE;
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&brush_is_editable_proc, success);

  if (success)
    return_args[1].value.pdb_int = GIMP_DATA (brush)->writable;

  return return_args;
}

static ProcArg brush_is_editable_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcArg brush_is_editable_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "editable",
    "True if the brush can be edited"
  }
};

static ProcRecord brush_is_editable_proc =
{
  "gimp-brush-is-editable",
  "gimp-brush-is-editable",
  "Tests if brush can be edited",
  "Returns True if you have permission to change the brush",
  "Bill Skaggs <weskaggs@primate.ucdavis.edu",
  "Bill Skaggs",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_is_editable_inargs,
  1,
  brush_is_editable_outargs,
  { { brush_is_editable_invoker } }
};

static Argument *
brush_get_info_invoker (Gimp         *gimp,
                        GimpContext  *context,
                        GimpProgress *progress,
                        Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      success = (brush != NULL);
    }

  return_args = procedural_db_return_args (&brush_get_info_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = brush->mask->width;
      return_args[2].value.pdb_int = brush->mask->height;
      return_args[3].value.pdb_int = brush->mask->bytes;
      return_args[4].value.pdb_int = brush->pixmap ? brush->pixmap->bytes : 0;
    }

  return return_args;
}

static ProcArg brush_get_info_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcArg brush_get_info_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "width",
    "The brush width"
  },
  {
    GIMP_PDB_INT32,
    "height",
    "The brush height"
  },
  {
    GIMP_PDB_INT32,
    "mask-bpp",
    "The brush mask bpp"
  },
  {
    GIMP_PDB_INT32,
    "color-bpp",
    "The brush color bpp"
  }
};

static ProcRecord brush_get_info_proc =
{
  "gimp-brush-get-info",
  "gimp-brush-get-info",
  "Retrieve information about the specified brush.",
  "This procedure retrieves information about the specified brush. This includes the brush name, and the brush extents (width and height).",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_get_info_inargs,
  4,
  brush_get_info_outargs,
  { { brush_get_info_invoker } }
};

static Argument *
brush_get_pixels_invoker (Gimp         *gimp,
                          GimpContext  *context,
                          GimpProgress *progress,
                          Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 mask_bpp = 0;
  gint32 num_mask_bytes = 0;
  guint8 *mask_bytes = NULL;
  gint32 color_bpp = 0;
  gint32 num_color_bytes = 0;
  guint8 *color_bytes = NULL;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush)
        {
          mask_bpp       = brush->mask->bytes;
          num_mask_bytes = brush->mask->height * brush->mask->width;
          mask_bytes     = g_memdup (temp_buf_data (brush->mask), num_mask_bytes);

          if (brush->pixmap)
            {
              color_bpp       = brush->pixmap->bytes;
              num_color_bytes = brush->pixmap->height * brush->pixmap->width;
              color_bytes     = g_memdup (temp_buf_data (brush->pixmap),
                                          num_color_bytes);
            }
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&brush_get_pixels_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = brush->mask->width;
      return_args[2].value.pdb_int = brush->mask->height;
      return_args[3].value.pdb_int = mask_bpp;
      return_args[4].value.pdb_int = num_mask_bytes;
      return_args[5].value.pdb_pointer = mask_bytes;
      return_args[6].value.pdb_int = color_bpp;
      return_args[7].value.pdb_int = num_color_bytes;
      return_args[8].value.pdb_pointer = color_bytes;
    }

  return return_args;
}

static ProcArg brush_get_pixels_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcArg brush_get_pixels_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "width",
    "The brush width"
  },
  {
    GIMP_PDB_INT32,
    "height",
    "The brush height"
  },
  {
    GIMP_PDB_INT32,
    "mask-bpp",
    "The brush mask bpp"
  },
  {
    GIMP_PDB_INT32,
    "num-mask-bytes",
    "Length of brush mask data"
  },
  {
    GIMP_PDB_INT8ARRAY,
    "mask-bytes",
    "The brush mask data"
  },
  {
    GIMP_PDB_INT32,
    "color-bpp",
    "The brush color bpp"
  },
  {
    GIMP_PDB_INT32,
    "num-color-bytes",
    "Length of brush color data"
  },
  {
    GIMP_PDB_INT8ARRAY,
    "color-bytes",
    "The brush color data"
  }
};

static ProcRecord brush_get_pixels_proc =
{
  "gimp-brush-get-pixels",
  "gimp-brush-get-pixels",
  "Retrieve information about the specified brush.",
  "This procedure retrieves information about the specified brush. This includes the brush extents (width and height) and its pixels data.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_get_pixels_inargs,
  8,
  brush_get_pixels_outargs,
  { { brush_get_pixels_invoker } }
};

static Argument *
brush_get_spacing_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      success = (brush != NULL);
    }

  return_args = procedural_db_return_args (&brush_get_spacing_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_brush_get_spacing (brush);

  return return_args;
}

static ProcArg brush_get_spacing_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcArg brush_get_spacing_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "spacing",
    "The brush spacing: 0 <= spacing <= 1000"
  }
};

static ProcRecord brush_get_spacing_proc =
{
  "gimp-brush-get-spacing",
  "gimp-brush-get-spacing",
  "Get the brush spacing.",
  "This procedure returns the spacing setting for the specified brush. The return value is an integer between 0 and 1000 which represents percentage of the maximum of the width and height of the mask.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_get_spacing_inargs,
  1,
  brush_get_spacing_outargs,
  { { brush_get_spacing_invoker } }
};

static Argument *
brush_set_spacing_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  gint32 spacing;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  spacing = args[1].value.pdb_int;
  if (spacing < 0 || spacing > 1000)
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush)
        gimp_brush_set_spacing (brush, spacing);
      else
        success = FALSE;
    }

  return procedural_db_return_args (&brush_set_spacing_proc, success);
}

static ProcArg brush_set_spacing_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  },
  {
    GIMP_PDB_INT32,
    "spacing",
    "The brush spacing: 0 <= spacing <= 1000"
  }
};

static ProcRecord brush_set_spacing_proc =
{
  "gimp-brush-set-spacing",
  "gimp-brush-set-spacing",
  "Set the brush spacing.",
  "This procedure modifies the spacing setting for the specified brush. The value should be a integer between 0 and 1000.",
  "Bill Skaggs <weskaggs@primate.ucdavis.edu",
  "Bill Skaggs",
  "2004",
  NULL,
  GIMP_INTERNAL,
  2,
  brush_set_spacing_inargs,
  0,
  NULL,
  { { brush_set_spacing_invoker } }
};

static Argument *
brush_get_shape_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      success = (brush != NULL && GIMP_IS_BRUSH_GENERATED (brush));
    }

  return_args = procedural_db_return_args (&brush_get_shape_proc, success);

  if (success)
    return_args[1].value.pdb_int = GIMP_BRUSH_GENERATED (brush)->shape;

  return return_args;
}

static ProcArg brush_get_shape_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcArg brush_get_shape_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "shape",
    "An enumerated value representing the brush shape"
  }
};

static ProcRecord brush_get_shape_proc =
{
  "gimp-brush-get-shape",
  "gimp-brush-get-shape",
  "Get the shape of a generated brush.",
  "This procedure gets the shape value for a generated brush. If called for any other type of brush, it does not succeed. The current possibilities are Circle (GIMP_BRUSH_GENERATED_CIRCLE), Square (GIMP_BRUSH_GENERATED_SQUARE), and Diamond (GIMP_BRUSH_GENERATED_DIAMOND). Other shapes are likely to be added in the future.",
  "Bill Skaggs <weskaggs@primate.ucdavis.edu",
  "Bill Skaggs",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_get_shape_inargs,
  1,
  brush_get_shape_outargs,
  { { brush_get_shape_invoker } }
};

static Argument *
brush_get_radius_invoker (Gimp         *gimp,
                          GimpContext  *context,
                          GimpProgress *progress,
                          Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      success = (brush != NULL && GIMP_IS_BRUSH_GENERATED (brush));
    }

  return_args = procedural_db_return_args (&brush_get_radius_proc, success);

  if (success)
    return_args[1].value.pdb_float = GIMP_BRUSH_GENERATED (brush)->radius;

  return return_args;
}

static ProcArg brush_get_radius_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcArg brush_get_radius_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "radius",
    "The radius of the brush in pixels"
  }
};

static ProcRecord brush_get_radius_proc =
{
  "gimp-brush-get-radius",
  "gimp-brush-get-radius",
  "Get the radius of a generated brush.",
  "This procedure gets the radius value for a generated brush. If called for any other type of brush, it does not succeed.",
  "Bill Skaggs <weskaggs@primate.ucdavis.edu",
  "Bill Skaggs",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_get_radius_inargs,
  1,
  brush_get_radius_outargs,
  { { brush_get_radius_invoker } }
};

static Argument *
brush_get_spikes_invoker (Gimp         *gimp,
                          GimpContext  *context,
                          GimpProgress *progress,
                          Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      success = (brush != NULL && GIMP_IS_BRUSH_GENERATED (brush));
    }

  return_args = procedural_db_return_args (&brush_get_spikes_proc, success);

  if (success)
    return_args[1].value.pdb_int = GIMP_BRUSH_GENERATED (brush)->spikes;

  return return_args;
}

static ProcArg brush_get_spikes_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcArg brush_get_spikes_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "spikes",
    "The number of spikes on the brush."
  }
};

static ProcRecord brush_get_spikes_proc =
{
  "gimp-brush-get-spikes",
  "gimp-brush-get-spikes",
  "Get the number of spikes for a generated brush.",
  "This procedure gets the number of spikes for a generated brush. If called for any other type of brush, it does not succeed.",
  "Bill Skaggs <weskaggs@primate.ucdavis.edu",
  "Bill Skaggs",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_get_spikes_inargs,
  1,
  brush_get_spikes_outargs,
  { { brush_get_spikes_invoker } }
};

static Argument *
brush_get_hardness_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      success = (brush != NULL && GIMP_IS_BRUSH_GENERATED (brush));
    }

  return_args = procedural_db_return_args (&brush_get_hardness_proc, success);

  if (success)
    return_args[1].value.pdb_float = GIMP_BRUSH_GENERATED (brush)->hardness;

  return return_args;
}

static ProcArg brush_get_hardness_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcArg brush_get_hardness_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "hardness",
    "The hardness of the brush."
  }
};

static ProcRecord brush_get_hardness_proc =
{
  "gimp-brush-get-hardness",
  "gimp-brush-get-hardness",
  "Get the hardness of a generated brush.",
  "This procedure gets the hardness of a generated brush. The hardness of a brush is the amount its intensity fades at the outside edge. If called for any other type of brush, the function does not succeed.",
  "Bill Skaggs <weskaggs@primate.ucdavis.edu",
  "Bill Skaggs",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_get_hardness_inargs,
  1,
  brush_get_hardness_outargs,
  { { brush_get_hardness_invoker } }
};

static Argument *
brush_get_aspect_ratio_invoker (Gimp         *gimp,
                                GimpContext  *context,
                                GimpProgress *progress,
                                Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      success = (brush != NULL && GIMP_IS_BRUSH_GENERATED (brush));
    }

  return_args = procedural_db_return_args (&brush_get_aspect_ratio_proc, success);

  if (success)
    return_args[1].value.pdb_float = GIMP_BRUSH_GENERATED (brush)->aspect_ratio;

  return return_args;
}

static ProcArg brush_get_aspect_ratio_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcArg brush_get_aspect_ratio_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "aspect-ratio",
    "The aspect ratio of the brush."
  }
};

static ProcRecord brush_get_aspect_ratio_proc =
{
  "gimp-brush-get-aspect-ratio",
  "gimp-brush-get-aspect-ratio",
  "Get the aspect ratio of a generated brush.",
  "This procedure gets the aspect ratio of a generated brush. If called for any other type of brush, it does not succeed.",
  "Bill Skaggs <weskaggs@primate.ucdavis.edu",
  "Bill Skaggs",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_get_aspect_ratio_inargs,
  1,
  brush_get_aspect_ratio_outargs,
  { { brush_get_aspect_ratio_invoker } }
};

static Argument *
brush_get_angle_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      success = (brush != NULL && GIMP_IS_BRUSH_GENERATED (brush));
    }

  return_args = procedural_db_return_args (&brush_get_angle_proc, success);

  if (success)
    return_args[1].value.pdb_float = GIMP_BRUSH_GENERATED (brush)->angle;

  return return_args;
}

static ProcArg brush_get_angle_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  }
};

static ProcArg brush_get_angle_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "angle",
    "The rotation angle of the brush."
  }
};

static ProcRecord brush_get_angle_proc =
{
  "gimp-brush-get-angle",
  "gimp-brush-get-angle",
  "Get the rotation angle of a generated brush.",
  "This procedure gets the angle of rotation for a generated brush. If called for any other type of brush, it does not succeed.",
  "Bill Skaggs <weskaggs@primate.ucdavis.edu",
  "Bill Skaggs",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  brush_get_angle_inargs,
  1,
  brush_get_angle_outargs,
  { { brush_get_angle_invoker } }
};

static Argument *
brush_set_shape_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 shape_in;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  shape_in = args[1].value.pdb_int;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush && GIMP_DATA (brush)->writable && GIMP_IS_BRUSH_GENERATED (brush))
        gimp_brush_generated_set_shape (GIMP_BRUSH_GENERATED (brush), shape_in);
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&brush_set_shape_proc, success);

  if (success)
    return_args[1].value.pdb_int = GIMP_BRUSH_GENERATED (brush)->shape;

  return return_args;
}

static ProcArg brush_set_shape_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  },
  {
    GIMP_PDB_INT32,
    "shape-in",
    "An enumerated value representing the desired brush shape"
  }
};

static ProcArg brush_set_shape_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "shape-out",
    "The brush shape actually assigned"
  }
};

static ProcRecord brush_set_shape_proc =
{
  "gimp-brush-set-shape",
  "gimp-brush-set-shape",
  "Set the shape of a generated brush.",
  "This procedure sets the shape value for a generated brush. If called for any other type of brush, it does not succeed. The current possibilities are Circle (GIMP_BRUSH_GENERATED_CIRCLE), Square (GIMP_BRUSH_GENERATED_SQUARE), and Diamond (GIMP_BRUSH_GENERATED_DIAMOND). Other shapes are likely to be added in the future.",
  "Bill Skaggs <weskaggs@primate.ucdavis.edu",
  "Bill Skaggs",
  "2004",
  NULL,
  GIMP_INTERNAL,
  2,
  brush_set_shape_inargs,
  1,
  brush_set_shape_outargs,
  { { brush_set_shape_invoker } }
};

static Argument *
brush_set_radius_invoker (Gimp         *gimp,
                          GimpContext  *context,
                          GimpProgress *progress,
                          Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gdouble radius_in;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  radius_in = args[1].value.pdb_float;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush && GIMP_DATA (brush)->writable && GIMP_IS_BRUSH_GENERATED (brush))
        gimp_brush_generated_set_radius (GIMP_BRUSH_GENERATED (brush), radius_in);
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&brush_set_radius_proc, success);

  if (success)
    return_args[1].value.pdb_float = GIMP_BRUSH_GENERATED (brush)->radius;

  return return_args;
}

static ProcArg brush_set_radius_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  },
  {
    GIMP_PDB_FLOAT,
    "radius-in",
    "The desired brush radius"
  }
};

static ProcArg brush_set_radius_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "radius-out",
    "The brush radius actually assigned"
  }
};

static ProcRecord brush_set_radius_proc =
{
  "gimp-brush-set-radius",
  "gimp-brush-set-radius",
  "Set the radius of a generated brush.",
  "This procedure sets the radius for a generated brush. If called for any other type of brush, it does not succeed.",
  "Bill Skaggs <weskaggs@primate.ucdavis.edu",
  "Bill Skaggs",
  "2004",
  NULL,
  GIMP_INTERNAL,
  2,
  brush_set_radius_inargs,
  1,
  brush_set_radius_outargs,
  { { brush_set_radius_invoker } }
};

static Argument *
brush_set_spikes_invoker (Gimp         *gimp,
                          GimpContext  *context,
                          GimpProgress *progress,
                          Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 spikes_in;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  spikes_in = args[1].value.pdb_int;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush && GIMP_DATA (brush)->writable && GIMP_IS_BRUSH_GENERATED (brush))
        gimp_brush_generated_set_spikes (GIMP_BRUSH_GENERATED (brush), spikes_in);
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&brush_set_spikes_proc, success);

  if (success)
    return_args[1].value.pdb_int = GIMP_BRUSH_GENERATED (brush)->spikes;

  return return_args;
}

static ProcArg brush_set_spikes_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  },
  {
    GIMP_PDB_INT32,
    "spikes-in",
    "The desired number of spikes"
  }
};

static ProcArg brush_set_spikes_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "spikes-out",
    "The number of spikes actually assigned"
  }
};

static ProcRecord brush_set_spikes_proc =
{
  "gimp-brush-set-spikes",
  "gimp-brush-set-spikes",
  "Set the number of spikes for a generated brush.",
  "This procedure sets the number of spikes for a generated brush. If called for any other type of brush, it does not succeed.",
  "Bill Skaggs <weskaggs@primate.ucdavis.edu",
  "Bill Skaggs",
  "2004",
  NULL,
  GIMP_INTERNAL,
  2,
  brush_set_spikes_inargs,
  1,
  brush_set_spikes_outargs,
  { { brush_set_spikes_invoker } }
};

static Argument *
brush_set_hardness_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gdouble hardness_in;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  hardness_in = args[1].value.pdb_float;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush && GIMP_DATA (brush)->writable && GIMP_IS_BRUSH_GENERATED (brush))
        gimp_brush_generated_set_hardness (GIMP_BRUSH_GENERATED (brush), hardness_in);
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&brush_set_hardness_proc, success);

  if (success)
    return_args[1].value.pdb_float = GIMP_BRUSH_GENERATED (brush)->hardness;

  return return_args;
}

static ProcArg brush_set_hardness_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  },
  {
    GIMP_PDB_FLOAT,
    "hardness-in",
    "The desired brush hardness"
  }
};

static ProcArg brush_set_hardness_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "hardness-out",
    "The brush hardness actually assigned"
  }
};

static ProcRecord brush_set_hardness_proc =
{
  "gimp-brush-set-hardness",
  "gimp-brush-set-hardness",
  "Set the hardness of a generated brush.",
  "This procedure sets the hardness for a generated brush. If called for any other type of brush, it does not succeed.",
  "Bill Skaggs <weskaggs@primate.ucdavis.edu",
  "Bill Skaggs",
  "2004",
  NULL,
  GIMP_INTERNAL,
  2,
  brush_set_hardness_inargs,
  1,
  brush_set_hardness_outargs,
  { { brush_set_hardness_invoker } }
};

static Argument *
brush_set_aspect_ratio_invoker (Gimp         *gimp,
                                GimpContext  *context,
                                GimpProgress *progress,
                                Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gdouble aspect_ratio_in;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  aspect_ratio_in = args[1].value.pdb_float;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush && GIMP_DATA (brush)->writable && GIMP_IS_BRUSH_GENERATED (brush))
        gimp_brush_generated_set_aspect_ratio (GIMP_BRUSH_GENERATED (brush), aspect_ratio_in);
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&brush_set_aspect_ratio_proc, success);

  if (success)
    return_args[1].value.pdb_float = GIMP_BRUSH_GENERATED (brush)->aspect_ratio;

  return return_args;
}

static ProcArg brush_set_aspect_ratio_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  },
  {
    GIMP_PDB_FLOAT,
    "aspect-ratio-in",
    "The desired brush aspect ratio"
  }
};

static ProcArg brush_set_aspect_ratio_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "aspect-ratio-out",
    "The brush aspect ratio actually assigned"
  }
};

static ProcRecord brush_set_aspect_ratio_proc =
{
  "gimp-brush-set-aspect-ratio",
  "gimp-brush-set-aspect-ratio",
  "Set the aspect ratio of a generated brush.",
  "This procedure sets the aspect ratio for a generated brush. If called for any other type of brush, it does not succeed.",
  "Bill Skaggs <weskaggs@primate.ucdavis.edu",
  "Bill Skaggs",
  "2004",
  NULL,
  GIMP_INTERNAL,
  2,
  brush_set_aspect_ratio_inargs,
  1,
  brush_set_aspect_ratio_outargs,
  { { brush_set_aspect_ratio_invoker } }
};

static Argument *
brush_set_angle_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gdouble angle_in;
  GimpBrush *brush = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  angle_in = args[1].value.pdb_float;

  if (success)
    {
      brush = (GimpBrush *)
        gimp_container_get_child_by_name (gimp->brush_factory->container, name);

      if (brush && GIMP_DATA (brush)->writable && GIMP_IS_BRUSH_GENERATED (brush))
        gimp_brush_generated_set_angle (GIMP_BRUSH_GENERATED (brush), angle_in);
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&brush_set_angle_proc, success);

  if (success)
    return_args[1].value.pdb_float = GIMP_BRUSH_GENERATED (brush)->angle;

  return return_args;
}

static ProcArg brush_set_angle_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The brush name"
  },
  {
    GIMP_PDB_FLOAT,
    "angle-in",
    "The desired brush rotation angle"
  }
};

static ProcArg brush_set_angle_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "angle-out",
    "The brush rotation angle actually assigned"
  }
};

static ProcRecord brush_set_angle_proc =
{
  "gimp-brush-set-angle",
  "gimp-brush-set-angle",
  "Set the rotation angle of a generated brush.",
  "This procedure sets the rotation angle for a generated brush. If called for any other type of brush, it does not succeed.",
  "Bill Skaggs <weskaggs@primate.ucdavis.edu",
  "Bill Skaggs",
  "2004",
  NULL,
  GIMP_INTERNAL,
  2,
  brush_set_angle_inargs,
  1,
  brush_set_angle_outargs,
  { { brush_set_angle_invoker } }
};
