/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpfontselect_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"

/**
 * gimp_fonts_popup:
 * @font_callback: The callback PDB proc to call when font selection is made.
 * @popup_title: Title of the font selection dialog.
 * @initial_font: The name of the font to set as the first selected.
 *
 * Invokes the Gimp font selection.
 *
 * This procedure opens the font selection dialog.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_fonts_popup (const gchar *font_callback,
                  const gchar *popup_title,
                  const gchar *initial_font)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-fonts-popup",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, font_callback,
                                    GIMP_PDB_STRING, popup_title,
                                    GIMP_PDB_STRING, initial_font,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_fonts_close_popup:
 * @font_callback: The name of the callback registered for this pop-up.
 *
 * Close the font selection dialog.
 *
 * This procedure closes an opened font selection dialog.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_fonts_close_popup (const gchar *font_callback)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-fonts-close-popup",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, font_callback,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_fonts_set_popup:
 * @font_callback: The name of the callback registered for this pop-up.
 * @font_name: The name of the font to set as selected.
 *
 * Sets the current font in a font selection dialog.
 *
 * Sets the current font in a font selection dialog.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_fonts_set_popup (const gchar *font_callback,
                      const gchar *font_name)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-fonts-set-popup",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, font_callback,
                                    GIMP_PDB_STRING, font_name,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}
