/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppaletteselect_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimppaletteselect
 * @title: gimppaletteselect
 * @short_description: Methods of a palette chooser dialog
 *
 * A dialog letting a user choose a palette.  Read more at
 * gimpfontselect.
 **/


/**
 * gimp_palettes_popup:
 * @palette_callback: The callback PDB proc to call when user chooses a palette.
 * @popup_title: Title of the palette selection dialog.
 * @initial_palette: The palette to set as the initial choice.
 * @parent_window: An optional parent window handle for the popup to be set transient to.
 *
 * Invokes the Gimp palette selection dialog.
 *
 * Opens a dialog letting a user choose a palette.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_palettes_popup (const gchar *palette_callback,
                     const gchar *popup_title,
                     GimpPalette *initial_palette,
                     GBytes      *parent_window)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, palette_callback,
                                          G_TYPE_STRING, popup_title,
                                          GIMP_TYPE_PALETTE, initial_palette,
                                          G_TYPE_BYTES, parent_window,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-palettes-popup",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_palettes_close_popup:
 * @palette_callback: The name of the callback registered for this pop-up.
 *
 * Close the palette selection dialog.
 *
 * Closes an open palette selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_palettes_close_popup (const gchar *palette_callback)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, palette_callback,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-palettes-close-popup",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_palettes_set_popup:
 * @palette_callback: The name of the callback registered for this pop-up.
 * @palette: The palette to set as selected.
 *
 * Sets the current palette in a palette selection dialog.
 *
 * Sets the current palette in a palette selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_palettes_set_popup (const gchar *palette_callback,
                         GimpPalette *palette)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, palette_callback,
                                          GIMP_TYPE_PALETTE, palette,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-palettes-set-popup",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
