/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpbase/gimpbase.h"

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimp.h"
#include "core/gimpparamspecs-desc.h"
#include "core/gimpparamspecs.h"
#include "gimp-pdb-compat.h"
#include "gimppdb-query.h"
#include "plug-in/gimpplugin-proc.h"
#include "plug-in/gimppluginmanager-data.h"
#include "plug-in/gimppluginmanager.h"
#include "plug-in/gimppluginprocedure.h"

#include "gimppdb.h"
#include "gimppdberror.h"
#include "gimppdb-utils.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GimpProcedure *
lookup_procedure (GimpPDB          *pdb,
                  const gchar      *proc_name,
                  GError          **error)
{
  GimpProcedure *proc = gimp_pdb_lookup_procedure (pdb, proc_name);

  if (! proc)
    {
      const gchar *compat_name = gimp_pdb_lookup_compat_proc_name (pdb,
                                                                   proc_name);

      if (compat_name)
        proc = gimp_pdb_lookup_procedure (pdb, compat_name);
    }

  if (! proc)
    g_set_error (error, GIMP_PDB_ERROR, GIMP_PDB_ERROR_PROCEDURE_NOT_FOUND,
                 _("Procedure '%s' not found"), proc_name);

  return proc;
}

static GimpValueArray *
pdb_temp_name_invoker (GimpProcedure         *procedure,
                       Gimp                  *gimp,
                       GimpContext           *context,
                       GimpProgress          *progress,
                       const GimpValueArray  *args,
                       GError               **error)
{
  GimpValueArray *return_vals;
  gchar *temp_name = NULL;

  static gint proc_number = 0;

  temp_name = g_strdup_printf ("temp-procedure-number-%d", proc_number++);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_take_string (gimp_value_array_index (return_vals, 1), temp_name);

  return return_vals;
}

static GimpValueArray *
pdb_dump_invoker (GimpProcedure         *procedure,
                  Gimp                  *gimp,
                  GimpContext           *context,
                  GimpProgress          *progress,
                  const GimpValueArray  *args,
                  GError               **error)
{
  gboolean success = TRUE;
  GFile *file;

  file = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      if (file)
        success = gimp_pdb_dump (gimp->pdb, file, error);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
pdb_query_invoker (GimpProcedure         *procedure,
                   Gimp                  *gimp,
                   GimpContext           *context,
                   GimpProgress          *progress,
                   const GimpValueArray  *args,
                   GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *name;
  const gchar *blurb;
  const gchar *help;
  const gchar *authors;
  const gchar *copyright;
  const gchar *date;
  const gchar *proc_type;
  gint num_matches = 0;
  gchar **procedure_names = NULL;

  name = g_value_get_string (gimp_value_array_index (args, 0));
  blurb = g_value_get_string (gimp_value_array_index (args, 1));
  help = g_value_get_string (gimp_value_array_index (args, 2));
  authors = g_value_get_string (gimp_value_array_index (args, 3));
  copyright = g_value_get_string (gimp_value_array_index (args, 4));
  date = g_value_get_string (gimp_value_array_index (args, 5));
  proc_type = g_value_get_string (gimp_value_array_index (args, 6));

  if (success)
    {
      success = gimp_pdb_query (gimp->pdb,
                                name, blurb, help, authors,
                                copyright, date, proc_type,
                                &num_matches, &procedure_names,
                                error);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_int (gimp_value_array_index (return_vals, 1), num_matches);
      gimp_value_take_string_array (gimp_value_array_index (return_vals, 2), procedure_names, num_matches);
    }

  return return_vals;
}

static GimpValueArray *
pdb_proc_exists_invoker (GimpProcedure         *procedure,
                         Gimp                  *gimp,
                         GimpContext           *context,
                         GimpProgress          *progress,
                         const GimpValueArray  *args,
                         GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *procedure_name;
  gboolean exists = FALSE;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      if (gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          GimpProcedure *proc = gimp_pdb_lookup_procedure (gimp->pdb,
                                                           procedure_name);

          if (! proc)
            {
              procedure_name = gimp_pdb_lookup_compat_proc_name (gimp->pdb,
                                                                 procedure_name);

              if (procedure_name)
                proc = gimp_pdb_lookup_procedure (gimp->pdb, procedure_name);
            }

          exists = (proc != NULL);
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), exists);

  return return_vals;
}

static GimpValueArray *
pdb_get_proc_info_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *procedure_name;
  gint proc_type = 0;
  gint num_args = 0;
  gint num_values = 0;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      if (gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          GimpProcedure *proc = lookup_procedure (gimp->pdb, procedure_name,
                                                  error);

          if (proc)
            {
              proc_type  = proc->proc_type;
              num_args   = proc->num_args;
              num_values = proc->num_values;
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_enum (gimp_value_array_index (return_vals, 1), proc_type);
      g_value_set_int (gimp_value_array_index (return_vals, 2), num_args);
      g_value_set_int (gimp_value_array_index (return_vals, 3), num_values);
    }

  return return_vals;
}

static GimpValueArray *
pdb_get_proc_argument_invoker (GimpProcedure         *procedure,
                               Gimp                  *gimp,
                               GimpContext           *context,
                               GimpProgress          *progress,
                               const GimpValueArray  *args,
                               GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *procedure_name;
  gint arg_num;
  GParamSpec *param_spec = NULL;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  arg_num = g_value_get_int (gimp_value_array_index (args, 1));

  if (success)
    {
      if (gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          GimpProcedure *proc = lookup_procedure (gimp->pdb, procedure_name,
                                                  error);

          if (proc && (arg_num >= 0 && arg_num < proc->num_args))
            {
              param_spec = g_param_spec_ref (proc->args[arg_num]);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_param (gimp_value_array_index (return_vals, 1), param_spec);

  return return_vals;
}

static GimpValueArray *
pdb_get_proc_return_value_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *procedure_name;
  gint val_num;
  GParamSpec *param_spec = NULL;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  val_num = g_value_get_int (gimp_value_array_index (args, 1));

  if (success)
    {
      if (gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          GimpProcedure *proc = lookup_procedure (gimp->pdb, procedure_name,
                                                  error);

          if (proc && (val_num >= 0 && val_num < proc->num_values))
            {
              param_spec = g_param_spec_ref (proc->values[val_num]);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_param (gimp_value_array_index (return_vals, 1), param_spec);

  return return_vals;
}

static GimpValueArray *
pdb_set_proc_image_types_invoker (GimpProcedure         *procedure,
                                  Gimp                  *gimp,
                                  GimpContext           *context,
                                  GimpProgress          *progress,
                                  const GimpValueArray  *args,
                                  GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;
  const gchar *image_types;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  image_types = g_value_get_string (gimp_value_array_index (args, 1));

  if (success)
    {
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in &&
          gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          success = gimp_plug_in_set_proc_image_types (plug_in, procedure_name,
                                                       image_types, error);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
pdb_get_proc_image_types_invoker (GimpProcedure         *procedure,
                                  Gimp                  *gimp,
                                  GimpContext           *context,
                                  GimpProgress          *progress,
                                  const GimpValueArray  *args,
                                  GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *procedure_name;
  gchar *image_types = NULL;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      if (gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          GimpProcedure *proc = lookup_procedure (gimp->pdb, procedure_name,
                                                  error);

          if (GIMP_IS_PLUG_IN_PROCEDURE (proc))
            {
              image_types = g_strdup (GIMP_PLUG_IN_PROCEDURE (proc)->image_types);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), image_types);

  return return_vals;
}

static GimpValueArray *
pdb_set_proc_sensitivity_mask_invoker (GimpProcedure         *procedure,
                                       Gimp                  *gimp,
                                       GimpContext           *context,
                                       GimpProgress          *progress,
                                       const GimpValueArray  *args,
                                       GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;
  gint mask;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  mask = g_value_get_int (gimp_value_array_index (args, 1));

  if (success)
    {
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in &&
          gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          success = gimp_plug_in_set_proc_sensitivity_mask (plug_in, procedure_name,
                                                            mask, error);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
pdb_set_proc_menu_label_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;
  const gchar *menu_label;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  menu_label = g_value_get_string (gimp_value_array_index (args, 1));

  if (success)
    {
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in &&
          gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          success = gimp_plug_in_set_proc_menu_label (plug_in, procedure_name,
                                                      menu_label, error);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
pdb_get_proc_menu_label_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *procedure_name;
  gchar *menu_label = NULL;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      if (gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          GimpProcedure *proc = lookup_procedure (gimp->pdb, procedure_name,
                                                  error);

          if (GIMP_IS_PLUG_IN_PROCEDURE (proc))
            {
              menu_label = g_strdup (GIMP_PLUG_IN_PROCEDURE (proc)->menu_label);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), menu_label);

  return return_vals;
}

static GimpValueArray *
pdb_add_proc_menu_path_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;
  const gchar *menu_path;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  menu_path = g_value_get_string (gimp_value_array_index (args, 1));

  if (success)
    {
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in &&
          gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          success = gimp_plug_in_add_proc_menu_path (plug_in, procedure_name,
                                                     menu_path, error);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
pdb_get_proc_menu_paths_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *procedure_name;
  gint num_menu_paths = 0;
  gchar **menu_paths = NULL;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      if (gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          GimpProcedure *proc = lookup_procedure (gimp->pdb, procedure_name,
                                                  error);

          if (GIMP_IS_PLUG_IN_PROCEDURE (proc))
            {
              GimpPlugInProcedure *plug_in_proc = GIMP_PLUG_IN_PROCEDURE (proc);

              num_menu_paths = g_list_length (plug_in_proc->menu_paths);

              if (num_menu_paths > 0)
                {
                  GList *list;
                  gint   i;

                  menu_paths = g_new0 (gchar *, num_menu_paths + 1);

                  for (list = plug_in_proc->menu_paths, i = 0;
                       list;
                       list = g_list_next (list), i++)
                    {
                      menu_paths[i] = g_strdup (list->data);
                    }
                }
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_int (gimp_value_array_index (return_vals, 1), num_menu_paths);
      gimp_value_take_string_array (gimp_value_array_index (return_vals, 2), menu_paths, num_menu_paths);
    }

  return return_vals;
}

static GimpValueArray *
pdb_set_proc_icon_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;
  gint icon_type;
  gint icon_data_length;
  const guint8 *icon_data;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  icon_type = g_value_get_enum (gimp_value_array_index (args, 1));
  icon_data_length = g_value_get_int (gimp_value_array_index (args, 2));
  icon_data = gimp_value_get_uint8_array (gimp_value_array_index (args, 3));

  if (success)
    {
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in &&
          gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          success = gimp_plug_in_set_proc_icon (plug_in, procedure_name,
                                                icon_type,
                                                icon_data, icon_data_length,
                                                error);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
pdb_set_proc_documentation_invoker (GimpProcedure         *procedure,
                                    Gimp                  *gimp,
                                    GimpContext           *context,
                                    GimpProgress          *progress,
                                    const GimpValueArray  *args,
                                    GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;
  const gchar *blurb;
  const gchar *help;
  const gchar *help_id;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  blurb = g_value_get_string (gimp_value_array_index (args, 1));
  help = g_value_get_string (gimp_value_array_index (args, 2));
  help_id = g_value_get_string (gimp_value_array_index (args, 3));

  if (success)
    {
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in &&
          gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          success = gimp_plug_in_set_proc_help (plug_in, procedure_name,
                                                blurb, help, help_id, error);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
pdb_get_proc_documentation_invoker (GimpProcedure         *procedure,
                                    Gimp                  *gimp,
                                    GimpContext           *context,
                                    GimpProgress          *progress,
                                    const GimpValueArray  *args,
                                    GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *procedure_name;
  gchar *blurb = NULL;
  gchar *help = NULL;
  gchar *help_id = NULL;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      if (gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          GimpProcedure *proc = lookup_procedure (gimp->pdb, procedure_name,
                                                  error);

          if (proc)
            {
              blurb   = g_strdup (gimp_procedure_get_blurb   (proc));
              help    = g_strdup (gimp_procedure_get_help    (proc));
              help_id = g_strdup (gimp_procedure_get_help_id (proc));
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_take_string (gimp_value_array_index (return_vals, 1), blurb);
      g_value_take_string (gimp_value_array_index (return_vals, 2), help);
      g_value_take_string (gimp_value_array_index (return_vals, 3), help_id);
    }

  return return_vals;
}

static GimpValueArray *
pdb_set_proc_attribution_invoker (GimpProcedure         *procedure,
                                  Gimp                  *gimp,
                                  GimpContext           *context,
                                  GimpProgress          *progress,
                                  const GimpValueArray  *args,
                                  GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;
  const gchar *authors;
  const gchar *copyright;
  const gchar *date;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  authors = g_value_get_string (gimp_value_array_index (args, 1));
  copyright = g_value_get_string (gimp_value_array_index (args, 2));
  date = g_value_get_string (gimp_value_array_index (args, 3));

  if (success)
    {
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in &&
          gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          success = gimp_plug_in_set_proc_attribution (plug_in, procedure_name,
                                                       authors, copyright, date,
                                                       error);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
pdb_get_proc_attribution_invoker (GimpProcedure         *procedure,
                                  Gimp                  *gimp,
                                  GimpContext           *context,
                                  GimpProgress          *progress,
                                  const GimpValueArray  *args,
                                  GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *procedure_name;
  gchar *authors = NULL;
  gchar *copyright = NULL;
  gchar *date = NULL;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      if (gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          GimpProcedure *proc = lookup_procedure (gimp->pdb, procedure_name,
                                                  error);

          if (proc)
            {
              authors   = g_strdup (proc->authors);
              copyright = g_strdup (proc->copyright);
              date      = g_strdup (proc->date);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_take_string (gimp_value_array_index (return_vals, 1), authors);
      g_value_take_string (gimp_value_array_index (return_vals, 2), copyright);
      g_value_take_string (gimp_value_array_index (return_vals, 3), date);
    }

  return return_vals;
}

static GimpValueArray *
pdb_set_file_proc_load_handler_invoker (GimpProcedure         *procedure,
                                        Gimp                  *gimp,
                                        GimpContext           *context,
                                        GimpProgress          *progress,
                                        const GimpValueArray  *args,
                                        GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;
  const gchar *extensions;
  const gchar *prefixes;
  const gchar *magics;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  extensions = g_value_get_string (gimp_value_array_index (args, 1));
  prefixes = g_value_get_string (gimp_value_array_index (args, 2));
  magics = g_value_get_string (gimp_value_array_index (args, 3));

  if (success)
    {
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in &&
          gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          success = gimp_plug_in_set_file_proc_load_handler (plug_in,
                                                             procedure_name,
                                                             extensions, prefixes,
                                                             magics, error);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
pdb_set_file_proc_save_handler_invoker (GimpProcedure         *procedure,
                                        Gimp                  *gimp,
                                        GimpContext           *context,
                                        GimpProgress          *progress,
                                        const GimpValueArray  *args,
                                        GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;
  const gchar *extensions;
  const gchar *prefixes;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  extensions = g_value_get_string (gimp_value_array_index (args, 1));
  prefixes = g_value_get_string (gimp_value_array_index (args, 2));

  if (success)
    {
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in &&
          gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          success = gimp_plug_in_set_file_proc_save_handler (plug_in,
                                                             procedure_name,
                                                             extensions, prefixes,
                                                             error);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
pdb_set_file_proc_priority_invoker (GimpProcedure         *procedure,
                                    Gimp                  *gimp,
                                    GimpContext           *context,
                                    GimpProgress          *progress,
                                    const GimpValueArray  *args,
                                    GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;
  gint priority;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  priority = g_value_get_int (gimp_value_array_index (args, 1));

  if (success)
    {
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in &&
          gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          success = gimp_plug_in_set_file_proc_priority (plug_in,
                                                         procedure_name,
                                                         priority, error);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
pdb_set_file_proc_mime_types_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;
  const gchar *mime_types;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));
  mime_types = g_value_get_string (gimp_value_array_index (args, 1));

  if (success)
    {
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in &&
          gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          success = gimp_plug_in_set_file_proc_mime_types (plug_in,
                                                           procedure_name,
                                                           mime_types, error);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
pdb_set_file_proc_handles_remote_invoker (GimpProcedure         *procedure,
                                          Gimp                  *gimp,
                                          GimpContext           *context,
                                          GimpProgress          *progress,
                                          const GimpValueArray  *args,
                                          GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in &&
          gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          success = gimp_plug_in_set_file_proc_handles_remote (plug_in,
                                                               procedure_name,
                                                               error);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
pdb_set_file_proc_handles_raw_invoker (GimpProcedure         *procedure,
                                       Gimp                  *gimp,
                                       GimpContext           *context,
                                       GimpProgress          *progress,
                                       const GimpValueArray  *args,
                                       GError               **error)
{
  gboolean success = TRUE;
  const gchar *procedure_name;

  procedure_name = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in &&
          gimp_pdb_is_canonical_procedure (procedure_name, error))
        {
          success = gimp_plug_in_set_file_proc_handles_raw (plug_in,
                                                            procedure_name,
                                                            error);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
pdb_set_file_proc_thumbnail_loader_invoker (GimpProcedure         *procedure,
                                            Gimp                  *gimp,
                                            GimpContext           *context,
                                            GimpProgress          *progress,
                                            const GimpValueArray  *args,
                                            GError               **error)
{
  gboolean success = TRUE;
  const gchar *load_proc;
  const gchar *thumb_proc;

  load_proc = g_value_get_string (gimp_value_array_index (args, 0));
  thumb_proc = g_value_get_string (gimp_value_array_index (args, 1));

  if (success)
    {
      GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

      if (plug_in &&
          gimp_pdb_is_canonical_procedure (load_proc, error) &&
          gimp_pdb_is_canonical_procedure (thumb_proc, error))
        {
          success = gimp_plug_in_set_file_proc_thumb_loader (plug_in,
                                                             load_proc, thumb_proc,
                                                              error);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
pdb_get_data_invoker (GimpProcedure         *procedure,
                      Gimp                  *gimp,
                      GimpContext           *context,
                      GimpProgress          *progress,
                      const GimpValueArray  *args,
                      GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *identifier;
  gint bytes = 0;
  guint8 *data = NULL;

  identifier = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      if (gimp_is_canonical_identifier (identifier))
        {
          const guint8 *orig_data;

          orig_data = gimp_plug_in_manager_get_data (gimp->plug_in_manager,
                                                     identifier, &bytes);

          if (orig_data)
            data = g_memdup (orig_data, bytes);
          else
            success = FALSE;
        }
      else
        {
          g_set_error (error, GIMP_PDB_ERROR, GIMP_PDB_ERROR_INVALID_ARGUMENT,
                       _("Data label '%s' is not a canonical identifier"),
                       identifier);
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_int (gimp_value_array_index (return_vals, 1), bytes);
      gimp_value_take_uint8_array (gimp_value_array_index (return_vals, 2), data, bytes);
    }

  return return_vals;
}

static GimpValueArray *
pdb_get_data_size_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  const gchar *identifier;
  gint bytes = 0;

  identifier = g_value_get_string (gimp_value_array_index (args, 0));

  if (success)
    {
      if (gimp_is_canonical_identifier (identifier))
        {
          if (! gimp_plug_in_manager_get_data (gimp->plug_in_manager,
                                               identifier, &bytes))
            success = FALSE;
        }
      else
        {
          g_set_error (error, GIMP_PDB_ERROR, GIMP_PDB_ERROR_INVALID_ARGUMENT,
                       _("Data label '%s' is not a canonical identifier"),
                       identifier);
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_int (gimp_value_array_index (return_vals, 1), bytes);

  return return_vals;
}

static GimpValueArray *
pdb_set_data_invoker (GimpProcedure         *procedure,
                      Gimp                  *gimp,
                      GimpContext           *context,
                      GimpProgress          *progress,
                      const GimpValueArray  *args,
                      GError               **error)
{
  gboolean success = TRUE;
  const gchar *identifier;
  gint bytes;
  const guint8 *data;

  identifier = g_value_get_string (gimp_value_array_index (args, 0));
  bytes = g_value_get_int (gimp_value_array_index (args, 1));
  data = gimp_value_get_uint8_array (gimp_value_array_index (args, 2));

  if (success)
    {
      if (gimp_is_canonical_identifier (identifier))
        {
          gimp_plug_in_manager_set_data (gimp->plug_in_manager,
                                         identifier, bytes, data);
        }
      else
        {
          g_set_error (error, GIMP_PDB_ERROR, GIMP_PDB_ERROR_INVALID_ARGUMENT,
                       _("Data label '%s' is not a canonical identifier"),
                       identifier);
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_pdb_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-pdb-temp-name
   */
  procedure = gimp_procedure_new (pdb_temp_name_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-temp-name");
  gimp_procedure_set_static_help (procedure,
                                  "Generates a unique temporary PDB name.",
                                  "This procedure generates a temporary PDB entry name that is guaranteed to be unique.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Andy Thomas",
                                         "Andy Thomas",
                                         "1998");
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("temp-name",
                                                           "temp name",
                                                           "A unique temporary name for a temporary PDB entry",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-dump
   */
  procedure = gimp_procedure_new (pdb_dump_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-dump");
  gimp_procedure_set_static_help (procedure,
                                  "Dumps the current contents of the procedural database",
                                  "This procedure dumps the contents of the procedural database to the specified file. The file will contain all of the information provided for each registered procedure.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Josh MacDonald",
                                         "Spencer Kimball & Josh MacDonald & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               g_param_spec_object ("file",
                                                    "file",
                                                    "The dump filename",
                                                    G_TYPE_FILE,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-query
   */
  procedure = gimp_procedure_new (pdb_query_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-query");
  gimp_procedure_set_static_help (procedure,
                                  "Queries the procedural database for its contents using regular expression matching.",
                                  "This procedure queries the contents of the procedural database. It is supplied with seven arguments matching procedures on { name, blurb, help, authors, copyright, date, procedure type}. This is accomplished using regular expression matching. For instance, to find all procedures with \"jpeg\" listed in the blurb, all seven arguments can be supplied as \".*\", except for the second, which can be supplied as \".*jpeg.*\". There are two return arguments for this procedure. The first is the number of procedures matching the query. The second is a concatenated list of procedure names corresponding to those matching the query. If no matching entries are found, then the returned string is NULL and the number of entries is 0.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The regex for procedure name",
                                                       TRUE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("blurb",
                                                       "blurb",
                                                       "The regex for procedure blurb",
                                                       TRUE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("help",
                                                       "help",
                                                       "The regex for procedure help",
                                                       TRUE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("authors",
                                                       "authors",
                                                       "The regex for procedure authors",
                                                       TRUE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("copyright",
                                                       "copyright",
                                                       "The regex for procedure copyright",
                                                       TRUE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("date",
                                                       "date",
                                                       "The regex for procedure date",
                                                       TRUE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("proc-type",
                                                       "proc type",
                                                       "The regex for procedure type: { 'Internal GIMP procedure', 'GIMP Plug-in', 'GIMP Extension', 'Temporary Procedure' }",
                                                       TRUE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("num-matches",
                                                     "num matches",
                                                     "The number of matching procedures",
                                                     0, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string_array ("procedure-names",
                                                                 "procedure names",
                                                                 "The list of procedure names",
                                                                 GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-proc-exists
   */
  procedure = gimp_procedure_new (pdb_proc_exists_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-proc-exists");
  gimp_procedure_set_static_help (procedure,
                                  "Checks if the specified procedure exists in the procedural database",
                                  "This procedure checks if the specified procedure is registered in the procedural database.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Sven Neumann <sven@gimp.org>",
                                         "Sven Neumann",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The procedure name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("exists",
                                                         "exists",
                                                         "Whether a procedure of that name is registered",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-get-proc-info
   */
  procedure = gimp_procedure_new (pdb_get_proc_info_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-get-proc-info");
  gimp_procedure_set_static_help (procedure,
                                  "Queries the procedural database for information on the specified procedure.",
                                  "This procedure returns information on the specified procedure. The procedure type, number of input, and number of return values are returned. For specific information on each input argument and return value, use the 'gimp-pdb-db-proc-argument' and 'gimp-pdb-db-proc-return-value' procedures.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1997");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The procedure name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("proc-type",
                                                      "proc type",
                                                      "The procedure type",
                                                      GIMP_TYPE_PDB_PROC_TYPE,
                                                      GIMP_PDB_PROC_TYPE_INTERNAL,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("num-args",
                                                     "num args",
                                                     "The number of input arguments",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("num-values",
                                                     "num values",
                                                     "The number of return values",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-get-proc-argument
   */
  procedure = gimp_procedure_new (pdb_get_proc_argument_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-get-proc-argument");
  gimp_procedure_set_static_help (procedure,
                                  "Queries the procedural database for information on the specified procedure's argument.",
                                  "This procedure returns the #GParamSpec of procedure_name's argument.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2019");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The procedure name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("arg-num",
                                                 "arg num",
                                                 "The argument number",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_param ("param-spec",
                                                       "param spec",
                                                       "The GParamSpec of the argument",
                                                       G_TYPE_PARAM,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-get-proc-return-value
   */
  procedure = gimp_procedure_new (pdb_get_proc_return_value_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-get-proc-return-value");
  gimp_procedure_set_static_help (procedure,
                                  "Queries the procedural database for information on the specified procedure's return value.",
                                  "This procedure returns the #GParamSpec of procedure_name's return value.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2019");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The procedure name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("val-num",
                                                 "val num",
                                                 "The return value number",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_param ("param-spec",
                                                       "param spec",
                                                       "The GParamSpec of the return value",
                                                       G_TYPE_PARAM,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-set-proc-image-types
   */
  procedure = gimp_procedure_new (pdb_set_proc_image_types_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-set-proc-image-types");
  gimp_procedure_set_static_help (procedure,
                                  "Set the supported image types for a plug-in procedure.",
                                  "This procedure sets the supported images types for the given procedure.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2019");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The procedure for which to install the menu path",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("image-types",
                                                       "image types",
                                                       "The procedure's supported image types",
                                                       FALSE, TRUE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-get-proc-image-types
   */
  procedure = gimp_procedure_new (pdb_get_proc_image_types_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-get-proc-image-types");
  gimp_procedure_set_static_help (procedure,
                                  "Queries the procedural database for the image types supported by the specified procedure.",
                                  "This procedure returns the image types supported by the specified procedure.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2019");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The procedure name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("image-types",
                                                           "image types",
                                                           "The image types",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-set-proc-sensitivity-mask
   */
  procedure = gimp_procedure_new (pdb_set_proc_sensitivity_mask_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-set-proc-sensitivity-mask");
  gimp_procedure_set_static_help (procedure,
                                  "Set the sensitivity mask for a plug-in procedure.",
                                  "This procedure sets the sensitivity mask for the given procedure.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2021");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The procedure",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("mask",
                                                 "mask",
                                                 "The procedure's sensitivity mask",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-set-proc-menu-label
   */
  procedure = gimp_procedure_new (pdb_set_proc_menu_label_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-set-proc-menu-label");
  gimp_procedure_set_static_help (procedure,
                                  "Set the menu label for a plug-in procedure.",
                                  "This procedure sets the menu label for the given procedure.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2019");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The procedure for which to install the menu path",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("menu-label",
                                                       "menu label",
                                                       "The procedure's menu label",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-get-proc-menu-label
   */
  procedure = gimp_procedure_new (pdb_get_proc_menu_label_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-get-proc-menu-label");
  gimp_procedure_set_static_help (procedure,
                                  "Queries the procedural database for the procedure's menu label.",
                                  "This procedure returns the menu label of the specified procedure.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2019");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The procedure name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("menu-label",
                                                           "menu label",
                                                           "The menu_label",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-add-proc-menu-path
   */
  procedure = gimp_procedure_new (pdb_add_proc_menu_path_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-add-proc-menu-path");
  gimp_procedure_set_static_help (procedure,
                                  "Register an additional menu path for a plug-in procedure.",
                                  "This procedure installs an additional menu entry for the given procedure.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2019");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The procedure for which to install the menu path",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("menu-path",
                                                       "menu path",
                                                       "The procedure's additional menu path",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-get-proc-menu-paths
   */
  procedure = gimp_procedure_new (pdb_get_proc_menu_paths_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-get-proc-menu-paths");
  gimp_procedure_set_static_help (procedure,
                                  "Queries the procedural database for the procedure's menu paths.",
                                  "This procedure returns the menu paths of the specified procedure.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2019");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The procedure name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("num-menu-paths",
                                                     "num menu paths",
                                                     "The number of menu paths",
                                                     0, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string_array ("menu-paths",
                                                                 "menu paths",
                                                                 "The menu paths of the plug-in",
                                                                 GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-set-proc-icon
   */
  procedure = gimp_procedure_new (pdb_set_proc_icon_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-set-proc-icon");
  gimp_procedure_set_static_help (procedure,
                                  "Register an icon for a plug-in procedure.",
                                  "This procedure installs an icon for the given procedure.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2019");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The procedure for which to install the icon",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("icon-type",
                                                  "icon type",
                                                  "The type of the icon",
                                                  GIMP_TYPE_ICON_TYPE,
                                                  GIMP_ICON_TYPE_ICON_NAME,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("icon-data-length",
                                                 "icon data length",
                                                 "The length of 'icon-data'",
                                                 1, G_MAXINT32, 1,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_uint8_array ("icon-data",
                                                            "icon data",
                                                            "The procedure's icon. The format depends on the 'icon_type' parameter",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-set-proc-documentation
   */
  procedure = gimp_procedure_new (pdb_set_proc_documentation_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-set-proc-documentation");
  gimp_procedure_set_static_help (procedure,
                                  "Set the documentation for a plug-in procedure.",
                                  "This procedure sets the documentation for the given procedure.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2019");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The procedure for which to install the menu path",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("blurb",
                                                       "blurb",
                                                       "A short blurb",
                                                       FALSE, TRUE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("help",
                                                       "help",
                                                       "Detailed procedure help",
                                                       FALSE, TRUE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("help-id",
                                                       "help id",
                                                       "The procedure help_id",
                                                       FALSE, TRUE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-get-proc-documentation
   */
  procedure = gimp_procedure_new (pdb_get_proc_documentation_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-get-proc-documentation");
  gimp_procedure_set_static_help (procedure,
                                  "Queries the procedural database for documentation on the specified procedure.",
                                  "This procedure returns documentation on the specified procedure. A short blurb, detailed help and help_id.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2019");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The procedure name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("blurb",
                                                           "blurb",
                                                           "A short blurb",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("help",
                                                           "help",
                                                           "Detailed procedure help",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("help-id",
                                                           "help id",
                                                           "The procedure help_id",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-set-proc-attribution
   */
  procedure = gimp_procedure_new (pdb_set_proc_attribution_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-set-proc-attribution");
  gimp_procedure_set_static_help (procedure,
                                  "Set the attribution for a plug-in procedure.",
                                  "This procedure sets the attribution for the given procedure.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2019");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The procedure for which to install the menu path",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("authors",
                                                       "authors",
                                                       "Authors of the procedure",
                                                       FALSE, TRUE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("copyright",
                                                       "copyright",
                                                       "The copyright",
                                                       FALSE, TRUE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("date",
                                                       "date",
                                                       "Copyright date",
                                                       FALSE, TRUE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-get-proc-attribution
   */
  procedure = gimp_procedure_new (pdb_get_proc_attribution_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-get-proc-attribution");
  gimp_procedure_set_static_help (procedure,
                                  "Queries the procedural database for attribution information on the specified procedure.",
                                  "This procedure returns attribution information on the specified procedure. The authors, copyright information and date are returned.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2019");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The procedure name",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("authors",
                                                           "authors",
                                                           "Authors of the procedure",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("copyright",
                                                           "copyright",
                                                           "The copyright",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("date",
                                                           "date",
                                                           "Copyright date",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-set-file-proc-load-handler
   */
  procedure = gimp_procedure_new (pdb_set_file_proc_load_handler_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-set-file-proc-load-handler");
  gimp_procedure_set_static_help (procedure,
                                  "Registers a file load handler procedure.",
                                  "Registers a procedural database procedure to be called to load files of a particular file format using magic file information.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The name of the procedure to be used for loading",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("extensions",
                                                       "extensions",
                                                       "comma separated list of extensions this handler can load (i.e. \"jpg,jpeg\")",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE | GIMP_PARAM_NO_VALIDATE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("prefixes",
                                                       "prefixes",
                                                       "comma separated list of prefixes this handler can load (i.e. \"http:,ftp:\")",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE | GIMP_PARAM_NO_VALIDATE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("magics",
                                                       "magics",
                                                       "comma separated list of magic file information this handler can load (i.e. \"0,string,GIF\")",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE | GIMP_PARAM_NO_VALIDATE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-set-file-proc-save-handler
   */
  procedure = gimp_procedure_new (pdb_set_file_proc_save_handler_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-set-file-proc-save-handler");
  gimp_procedure_set_static_help (procedure,
                                  "Registers a file save handler procedure.",
                                  "Registers a procedural database procedure to be called to save files in a particular file format.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The name of the procedure to be used for saving",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("extensions",
                                                       "extensions",
                                                       "comma separated list of extensions this handler can save (i.e. \"jpg,jpeg\")",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE | GIMP_PARAM_NO_VALIDATE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("prefixes",
                                                       "prefixes",
                                                       "comma separated list of prefixes this handler can save (i.e. \"http:,ftp:\")",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE | GIMP_PARAM_NO_VALIDATE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-set-file-proc-priority
   */
  procedure = gimp_procedure_new (pdb_set_file_proc_priority_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-set-file-proc-priority");
  gimp_procedure_set_static_help (procedure,
                                  "Sets the priority of a file handler procedure.",
                                  "Sets the priority of a file handler procedure. When more than one procedure matches a given file, the procedure with the lowest priority is used; if more than one procedure has the lowest priority, it is unspecified which one of them is used. The default priority for file handler procedures is 0.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Ell",
                                         "Ell",
                                         "2018");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The name of the procedure to set the priority of.",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("priority",
                                                 "priority",
                                                 "The procedure priority.",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-set-file-proc-mime-types
   */
  procedure = gimp_procedure_new (pdb_set_file_proc_mime_types_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-set-file-proc-mime-types");
  gimp_procedure_set_static_help (procedure,
                                  "Associates MIME types with a file handler procedure.",
                                  "Registers MIME types for a file handler procedure. This allows GIMP to determine the MIME type of the file opened or saved using this procedure. It is recommended that only one MIME type is registered per file procedure; when registering more than one MIME type, GIMP will associate the first one with files opened or saved with this procedure.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Sven Neumann <sven@gimp.org>",
                                         "Sven Neumann",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The name of the procedure to associate a MIME type with.",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("mime-types",
                                                       "mime types",
                                                       "A comma-separated list of MIME types, such as \"image/jpeg\".",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-set-file-proc-handles-remote
   */
  procedure = gimp_procedure_new (pdb_set_file_proc_handles_remote_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-set-file-proc-handles-remote");
  gimp_procedure_set_static_help (procedure,
                                  "Registers a file handler procedure as capable of handling remote URIs.",
                                  "Registers a file handler procedure as capable of handling remote URIs. This allows GIMP to call the procedure directly for all kinds of URIs, not only on local file:// URIs.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2012");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The name of the procedure to enable remote URIs for.",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-set-file-proc-handles-raw
   */
  procedure = gimp_procedure_new (pdb_set_file_proc_handles_raw_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-set-file-proc-handles-raw");
  gimp_procedure_set_static_help (procedure,
                                  "Registers a file handler procedure as capable of handling raw camera files.",
                                  "Registers a file handler procedure as capable of handling raw digital camera files. Use this procedure only to register raw load handlers, calling it on a save handler will generate an error.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2017");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("procedure-name",
                                                       "procedure name",
                                                       "The name of the procedure to enable raw handling for.",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-set-file-proc-thumbnail-loader
   */
  procedure = gimp_procedure_new (pdb_set_file_proc_thumbnail_loader_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-set-file-proc-thumbnail-loader");
  gimp_procedure_set_static_help (procedure,
                                  "Associates a thumbnail loader with a file load procedure.",
                                  "Some file formats allow for embedded thumbnails, other file formats contain a scalable image or provide the image data in different resolutions. A file plug-in for such a format may register a special procedure that allows GIMP to load a thumbnail preview of the image. This procedure is then associated with the standard load procedure using this function.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Sven Neumann <sven@gimp.org>",
                                         "Sven Neumann",
                                         "2004");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("load-proc",
                                                       "load proc",
                                                       "The name of the procedure the thumbnail loader with.",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("thumb-proc",
                                                       "thumb proc",
                                                       "The name of the thumbnail load procedure.",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-get-data
   */
  procedure = gimp_procedure_new (pdb_get_data_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-get-data");
  gimp_procedure_set_static_help (procedure,
                                  "Returns data associated with the specified identifier.",
                                  "This procedure returns any data which may have been associated with the specified identifier. The data is a variable length array of bytes. If no data has been associated with the identifier, an error is returned.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1997");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("identifier",
                                                       "identifier",
                                                       "The identifier associated with data",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("bytes",
                                                     "bytes",
                                                     "The number of bytes in the data",
                                                     1, G_MAXINT32, 1,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_uint8_array ("data",
                                                                "data",
                                                                "A byte array containing data",
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-get-data-size
   */
  procedure = gimp_procedure_new (pdb_get_data_size_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-get-data-size");
  gimp_procedure_set_static_help (procedure,
                                  "Returns size of data associated with the specified identifier.",
                                  "This procedure returns the size of any data which may have been associated with the specified identifier. If no data has been associated with the identifier, an error is returned.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Nick Lamb",
                                         "Nick Lamb",
                                         "1998");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("identifier",
                                                       "identifier",
                                                       "The identifier associated with data",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("bytes",
                                                     "bytes",
                                                     "The number of bytes in the data",
                                                     1, G_MAXINT32, 1,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pdb-set-data
   */
  procedure = gimp_procedure_new (pdb_set_data_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pdb-set-data");
  gimp_procedure_set_static_help (procedure,
                                  "Associates the specified identifier with the supplied data.",
                                  "This procedure associates the supplied data with the provided identifier. The data may be subsequently retrieved by a call to 'procedural-db-get-data'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1997");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("identifier",
                                                       "identifier",
                                                       "The identifier associated with data",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("bytes",
                                                 "bytes",
                                                 "The number of bytes in the data",
                                                 1, G_MAXINT32, 1,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_uint8_array ("data",
                                                            "data",
                                                            "A byte array containing data",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
