/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#if !defined (__GTK_H_INSIDE__) && !defined (GTK_COMPILATION)
#error "Only <gtk/gtk.h> can be included directly."
#endif

#ifndef __GTK_OBJECT_H__
#define __GTK_OBJECT_H__


#include <gdkconfig.h>
#include <gtk/gtkenums.h>
#include <gtk/gtktypeutils.h>
#include <gtk/gtkdebug.h>


G_BEGIN_DECLS

/* macros for casting a pointer to a GtkObject or GtkObjectClass pointer,
 * and to test whether `object' and `klass' are of type GTK_TYPE_OBJECT.
 * these are the standard macros for all GtkObject-derived classes.
 */
#define GTK_TYPE_OBJECT              (gtk_object_get_type ())
#define GTK_OBJECT(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), GTK_TYPE_OBJECT, GtkObject))
#define GTK_OBJECT_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_OBJECT, GtkObjectClass))
#define GTK_IS_OBJECT(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), GTK_TYPE_OBJECT))
#define GTK_IS_OBJECT_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_OBJECT))
#define GTK_OBJECT_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), GTK_TYPE_OBJECT, GtkObjectClass))

#if !defined (GTK_DISABLE_DEPRECATED) || defined (GTK_COMPILATION)
/* GtkObject only uses the first 4 bits of the flags field.
 * Derived objects may use the remaining bits. Though this
 * is a kinda nasty break up, it does make the size of
 * derived objects smaller.
 */
/**
 * GtkObjectFlags:
 * @GTK_IN_DESTRUCTION: the object is currently being destroyed. This is used
 *   internally by GTK+ to prevent reinvokations during destruction.
 * @GTK_RESERVED_1: reserved for future use
 * @GTK_RESERVED_2: reserved for future use
 *
 * Tells about the state of the object.
 *
 * Deprecated: 2.22: Do not re-use #GtkObject flags but use your own variable to
 *   store flags.
 */
typedef enum
{
  GTK_IN_DESTRUCTION	= 1 << 0, /* Used internally during dispose */
  GTK_RESERVED_1	= 1 << 2,
  GTK_RESERVED_2	= 1 << 3
} GtkObjectFlags;

/**
 * GTK_OBJECT_FLAGS:
 * @obj: the object whose flags are returned.
 *
 * Gets the #GtkObjectFlags for an object without directly
 * accessing its members.
 *
 * Deprecated: 2.22: Do not re-use #GtkObject flags but use your own variable to
 *   store flags.
 */
#define GTK_OBJECT_FLAGS(obj)		  (GTK_OBJECT (obj)->flags)

/* Macros for setting and clearing bits in the object_flags field of GtkObject.
 */
#define GTK_OBJECT_SET_FLAGS(obj,flag)	  G_STMT_START{ (GTK_OBJECT_FLAGS (obj) |= (flag)); }G_STMT_END
#define GTK_OBJECT_UNSET_FLAGS(obj,flag)  G_STMT_START{ (GTK_OBJECT_FLAGS (obj) &= ~(flag)); }G_STMT_END
#endif

typedef struct _GtkObjectClass	GtkObjectClass;


struct _GtkObject
{
  GInitiallyUnowned parent_instance;

  /* 32 bits of flags. GtkObject only uses 4 of these bits and
   *  GtkWidget uses the rest. This is done because structs are
   *  aligned on 4 or 8 byte boundaries. If a new bitfield were
   *  used in GtkWidget much space would be wasted.
   */
  guint32 GSEAL (flags);
};

struct _GtkObjectClass
{
  GInitiallyUnownedClass parent_class;

  /* Default signal handler for the ::destroy signal, which is
   *  invoked to request that references to the widget be dropped.
   *  If an object class overrides destroy() in order to perform class
   *  specific destruction then it must still invoke its superclass'
   *  implementation of the method after it is finished with its
   *  own cleanup. (See gtk_widget_real_destroy() for an example of
   *  how to do this).
   */
  void (*destroy)  (GtkObject *object);
};

/* Application-level methods */

GType gtk_object_get_type (void) G_GNUC_CONST;

void gtk_object_destroy	  (GtkObject *object);

G_END_DECLS

#endif /* __GTK_OBJECT_H__ */
