/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <gtk/gtk.h>
#include "gtkrootwindow.h"

struct XXX_Data {
    GtkWidget *src;
    gint ptr_x;
    gint ptr_y;

/***/
    GtkWidget *dst;
    GdkGC     *gc_dst;

/***/
    gint timeout;
    gint timeout_tag;

/***/
    gint x_offset;
    gint y_offset;
    gint mag_x;
    gint mag_y;
};

static void
real_draw (GdkDrawable *gdk_drawable, GdkGC *gdk_gc,
	   GdkImage *gdk_image, gint img_width, gint img_height,
	   gint mag_x, gint mag_y)
{
  gint i,j;
  gint m,n;
  guint32 pixel;
  GdkColor gdk_color;

  GdkImage *tmp_gdk_image;

  tmp_gdk_image = gdk_image_new(GDK_IMAGE_FASTEST,
				gdk_window_get_visual(gdk_drawable),
				img_width * mag_x, img_height * mag_y);
  
  for (j = 0; j < img_height; ++j) {
      for (i = 0; i < img_width; ++i) {
	  pixel = gdk_image_get_pixel(gdk_image, i, j);
	  gdk_color.pixel = pixel;
	  for (m = 0; m <= mag_y; ++m) {
	      for (n = 0; n <= mag_x; ++n) {
		  gdk_image_put_pixel(tmp_gdk_image,
				      (i * mag_x + n), (j * mag_y + m), pixel);
	      }
	  }
      }
  }
  gdk_draw_image(gdk_drawable, gdk_gc,
		 tmp_gdk_image, 0, 0, 0, 0, img_width*mag_x, img_height*mag_y);

  gdk_image_destroy(tmp_gdk_image);
}


static gint
draw (gpointer data)
{
  struct XXX_Data *xxx_data;

  GtkWidget *src;
  GtkWidget *dst;
  GdkGC     *gc_dst;

  GdkModifierType dummy;
  GdkImage *gdk_image;

  gint x_offset, y_offset, mag_x, mag_y;

  gint width, height;
  gint src_width, src_height;
  gint dst_width, dst_height;
  gint ptr_x, ptr_y;
  gint tmp_ptr_x, tmp_ptr_y;
  gint src_x, src_y;
  gint min_src_x, min_src_y;
  gint max_src_x, max_src_y;
  gint tmp_src_x, tmp_src_y;
  

  xxx_data = (struct XXX_Data *)data;

  src = xxx_data->src;
  dst = xxx_data->dst;
  if (xxx_data->gc_dst == NULL) {
      xxx_data->gc_dst = gdk_gc_new(dst->window);
  }
  gc_dst = xxx_data->gc_dst;
  
  x_offset = xxx_data->x_offset;
  y_offset = xxx_data->y_offset;
  mag_x = xxx_data->mag_x;
  mag_y = xxx_data->mag_y;

  gdk_window_get_pointer(src->window, &tmp_ptr_x, &tmp_ptr_y, &dummy);
#if 0
  if (tmp_ptr_x != xxx_data->ptr_x) { }
  if (tmp_ptr_y != xxx_data->ptr_y) { }
#endif
  ptr_x = tmp_ptr_x;
  ptr_y = tmp_ptr_y;

  gdk_window_get_size(src->window, &src_width, &src_height);
  gdk_window_get_size(dst->window, &dst_width, &dst_height);
  
  width = dst_width / mag_x + ((dst_width % mag_x) ? 1 : 0);
  height = dst_height / mag_y + ((dst_height % mag_y) ? 1 : 0);

  tmp_src_x = ptr_x - (width / 2) + x_offset;
  tmp_src_y = ptr_y - (height / 2) + y_offset;

  min_src_x = 0;
  max_src_x = src_width - width;
  min_src_y = 0;
  max_src_y = src_height - height;

  src_x = CLAMP(tmp_src_x, min_src_x, max_src_x);
  src_y = CLAMP(tmp_src_y, min_src_y, max_src_y);


  gdk_image = gdk_image_get(src->window,
			    src_x,src_y, width,height);
  real_draw(dst->window, gc_dst, gdk_image, width, height, mag_x, mag_y);
  gdk_image_destroy(gdk_image);


  xxx_data->timeout_tag = 0;
  return FALSE;
}

static void
delayed_draw (gpointer data)
{
  struct XXX_Data *xxx_data;

  xxx_data = (struct XXX_Data *)data;
    
  if (!xxx_data->timeout_tag) {
      xxx_data->timeout_tag
	  = gtk_timeout_add(xxx_data->timeout, (GtkFunction)draw, data);
  }
}

static void
motion_notify_event_handler(GtkWidget *widget, GdkEvent *event,
			    gpointer data)
{
    struct XXX_Data *xxx_data;
    GdkEventMotion *motion_event;

    motion_event = (GdkEventMotion *)event;

    xxx_data = (struct XXX_Data *)data;
    xxx_data->ptr_x = motion_event->x;
    xxx_data->ptr_y = motion_event->y;

    delayed_draw(xxx_data);
}

static void
expose_event_handler(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  struct XXX_Data *xxx_data;

  xxx_data = (struct XXX_Data *)data;

  delayed_draw(xxx_data);
}

static void
create_widgets()
{
    struct XXX_Data *xxx_data;
    
    GtkWidget *gtk_root_window;
    GtkWidget *window, *drawing_area;


    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    drawing_area = gtk_drawing_area_new();
    gtk_drawing_area_size(GTK_DRAWING_AREA (drawing_area), 50, 50);
    gtk_widget_set_events(drawing_area,
			  (GDK_BUTTON_PRESS_MASK | GDK_EXPOSURE_MASK));
    gtk_signal_connect(GTK_OBJECT(drawing_area), "button_press_event",
		       (GtkSignalFunc)gtk_main_quit, NULL);
    gtk_container_add(GTK_CONTAINER (window), drawing_area);
    gtk_widget_show(drawing_area);
    gtk_widget_show(window);

    gtk_root_window = gtk_root_window_widget();
    gtk_root_window_set_events(GTK_ROOT_WINDOW(gtk_root_window),
			       GDK_POINTER_MOTION_MASK);


    xxx_data = g_new(struct XXX_Data, 1);
    xxx_data->x_offset = 0;
    xxx_data->y_offset = 0;
    xxx_data->mag_x = 4;
    xxx_data->mag_y = 4;
    xxx_data->timeout = 30;
    xxx_data->src = gtk_root_window;
    xxx_data->dst = drawing_area;

    gtk_signal_connect(GTK_OBJECT (gtk_root_window),
		       "motion_notify_event",
		       (GtkSignalFunc)motion_notify_event_handler,
		       (gpointer)xxx_data);
    gtk_signal_connect(GTK_OBJECT (drawing_area),
		       "expose_event",
		       (GtkSignalFunc)expose_event_handler,
		       (gpointer)xxx_data);
}

int
main(int argc, char **argv)
{
    gtk_init(&argc, &argv);

    create_widgets();

    gtk_main();

    return 0;
}
