/* gtkcombo - combo widget for gtk+
 * Copyright 1997 Paolo Molaro
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef __GTK_COMBO_H__
#define __GTK_COMBO_H__

#include <gtk/gtkentry.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtkarrow.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_COMBO(obj)			GTK_CHECK_CAST (obj, gtk_combo_get_type (), GtkCombo)
#define GTK_COMBO_CLASS(klass)	GTK_CHECK_CLASS_CAST (klass, gtk_combo_get_type (), GtkComboClass)
#define GTK_IS_COMBO(obj)       GTK_CHECK_TYPE (obj, gtk_combo_get_type ())

typedef struct _GtkCombo		GtkCombo;
typedef struct _GtkComboClass	GtkComboClass;

typedef enum {
	GTK_COMBO_EVERY_VALUE,
	GTK_COMBO_IN_LIST_VALUE
} GtkComboFlag;

/* this func retrieves a static string from a listitem */
typedef gchar* (*GtkComboFunc)(GtkWidget* item);

struct _GtkCombo {
	GtkHBox hbox;
	GtkWidget *entry;
	GtkWidget *button;
	GtkWidget *popup;
	GtkWidget *popwin;
	GtkWidget *list;

	GtkComboFunc func;

	gint entry_change_id;
	gint list_change_id;

	gint flag;
};

struct _GtkComboClass {
	GtkHBoxClass parent_class;
};

guint      gtk_combo_get_type (void);
GtkWidget *gtk_combo_new      (void);
void       gtk_combo_set_flag (GtkCombo* combo, 
                               GtkComboFlag flag);
void       gtk_combo_set_func (GtkCombo* combo, 
                               GtkComboFunc func);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GTK_COMBO_H__ */

