/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball, Josh MacDonald
 * Copyright (C) 1997-1998 Jay Painter <jpaint@serv.net><jpaint@gimp.org>
 *
 * GtkCTree widget for GTK+
 * Copyright (C) 1998 Lars Hamann and Stefan Jeske
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GTK_CTREE_H__
#define __GTK_CTREE_H__

#include <gtk/gtkclist.h>

#ifdef __cplusplus
extern "C"
{
#endif				/* __cplusplus */

#define GTK_CTREE(obj)          GTK_CHECK_CAST (obj, gtk_ctree_get_type (), GtkCTree)
#define GTK_CTREE_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_ctree_get_type (), GtkCTreeClass)
#define GTK_IS_CTREE(obj)       GTK_CHECK_TYPE (obj, gtk_ctree_get_type ())

#define GTK_CTREE_ROW(glist)  ((GtkCTreeRow *)((glist)->data))
#define GTK_CTREE_TREE(_ctree_, _glist_)  ((GtkCellTree *) &(((GtkCTreeRow *)((_glist_)->data))->cell[(_ctree_)->tree_col]))


#define GTK_CTREE_FUNC(_func_) ((GtkCTreeFunc)(_func_))

typedef struct _GtkCTree GtkCTree;
typedef struct _GtkCTreeClass GtkCTreeClass;
typedef struct _GtkCTreeRow GtkCTreeRow;

struct _GtkCTree
{
  GtkCList clist;

  gint tree_indent;
  gint tree_column;
  GList *selection_last;
  guint draw_lines : 1;
};

struct _GtkCTreeClass
{
  GtkCListClass parent_class;

  void (*tree_select_row) (GtkCTree * ctree,
			   GList *row,
			   gint column);
  void (*tree_unselect_row) (GtkCTree * ctree,
			     GList *row,
			     gint column);
};


struct _GtkCTreeRow
{
  GtkCListRow row;

  GList *parent;
  GList *sibling;
  GList *children;

  gint16 level;
  gint expanded : 1;

  GdkPixmap *pixmap_closed;
  GdkBitmap *mask_closed;
  GdkPixmap *pixmap_opened;
  GdkBitmap *mask_opened;
};


typedef void (*GtkCTreeFunc) (GtkCTree *ctree,
			      GList    *list,
			      gpointer  data1);

guint      gtk_ctree_get_type               (void);
void       gtk_ctree_construct              (GtkCTree      *ctree,
					     gint          columns, 
					     gint          tree_column,
					     gchar        *titles[]);
GtkWidget* gtk_ctree_new_with_titles        (gint          columns, 
					     gint          tree_column,
					     gchar        *titles[]);
GtkWidget* gtk_ctree_new                    (gint          columns, 
					     gint          tree_column);
GList*     gtk_ctree_insert                 (GtkCTree     *ctree,
					     GList        *parent, 
					     GList        *sibling,
					     gchar        *text[],
					     guint8        spacing,
					     GdkPixmap    *pixmap_closed,
					     GdkBitmap    *mask_closed,
					     GdkPixmap    *pixmap_opened,
					     GdkBitmap    *mask_opened,
					     guint         expanded);
void       gtk_ctree_collapse               (GtkCTree     *ctree,
					     GList        *list);
void       gtk_ctree_collapse_recursive     (GtkCTree     *ctree,
					     GList        *list);
void       gtk_ctree_expand                 (GtkCTree     *ctree,
					     GList        *list);
void       gtk_ctree_expand_recursive       (GtkCTree     *ctree,
					     GList        *list);
void       gtk_ctree_set_text               (GtkCTree     *ctree,
					     GList        *child,
					     gint          column,
					     gchar        *text);
void       gtk_ctree_set_pixmap             (GtkCTree     *ctree,
					     GList        *child,
					     gint          column,
					     GdkPixmap    *pixmap,
					     GdkBitmap    *mask);
void       gtk_ctree_set_pixtext            (GtkCTree     *ctree,
					     GList        *child,
					     gint          column,
					     gchar        *text,
					     guint8        spacing,
					     GdkPixmap    *pixmap,
					     GdkBitmap    *mask);
void       gtk_ctree_recursive              (GtkCTree     *ctree, 
					     GList        *list,
					     GtkCTreeFunc  func,
					     gpointer      data);
void       gtk_ctree_select                 (GtkCTree     *ctree, 
					     GList        *list);
void       gtk_ctree_unselect               (GtkCTree     *ctree, 
					     GList        *list);
void       gtk_ctree_select_recursive       (GtkCTree     *ctree, 
					     GList        *list);
void       gtk_ctree_unselect_recursive     (GtkCTree     *ctree, 
					     GList        *list);
void       gtk_ctree_real_select_recursive  (GtkCTree     *ctree, 
					     GList        *list, 
					     gint          state);
void       gtk_ctree_remove                 (GtkCTree     *ctree, 
					     GList        *list);
gint       gtk_ctree_is_hot_spot            (GtkCTree     *ctree,
					     GtkCTreeRow  *tree_row,
					     gint          row,
					     gint          x,
					     gint          y);
GList*     gtk_ctree_find_row               (GtkCTree     *ctree,
					     GList        *list,
					     GtkCTreeRow  *row);
void       gtk_ctree_set_draw_lines         (GtkCTree     *ctree, 
					     gint          draw_lines);
gint       gtk_ctree_is_visible             (GtkCTree     *ctree, 
					     GtkCTreeRow  *ctree_row);

#ifdef __cplusplus
}
#endif				/* __cplusplus */


#endif				/* __GTK_CTREE_H__ */
