/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998  Elmar Ludwig - Universitaet Osnabrueck
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef GTOOLKIT_GTK_H
#define GTOOLKIT_GTK_H

#define GTK_DISABLE_COMPAT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <gtk/gtkenums.h>
#include <glib.h>

@class NSArray, NSMutableArray, NSNotification;
@class GTKApplication, GTKAction;

@class GTKAccelGroup;
@class GTKAccelLabel;
@class GTKAdjustment;
@class GTKAlignment;
@class GTKArrow;
@class GTKAspectFrame;
@class GTKBin;
@class GTKBox;
@class GTKButton;
@class GTKButtonBox;
@class GTKCList;
@class GTKCTree;
@class GTKCalendar;
@class GTKCheckButton;
@class GTKCheckMenuItem;
@class GTKColorSelection;
@class GTKColorSelectionDialog;
@class GTKCombo;
@class GTKContainer;
@class GTKCurve;
@class GTKData;
@class GTKDialog;
@class GTKDrawingArea;
@class GTKEditable;
@class GTKEntry;
@class GTKEventBox;
@class GTKFileSelection;
@class GTKFixed;
@class GTKFontSelection;
@class GTKFontSelectionDialog;
@class GTKFrame;
@class GTKGammaCurve;
@class GTKHBox;
@class GTKHButtonBox;
@class GTKHPaned;
@class GTKHRuler;
@class GTKHScale;
@class GTKHScrollbar;
@class GTKHSeparator;
@class GTKHandleBox;
@class GTKImage;
@class GTKInputDialog;
@class GTKInvisible;
@class GTKItem;
@class GTKItemFactory;
@class GTKLabel;
@class GTKLayout;
@class GTKList;
@class GTKListItem;
@class GTKMenu;
@class GTKMenuBar;
@class GTKMenuFactory;
@class GTKMenuItem;
@class GTKMenuShell;
@class GTKMisc;
@class GTKNotebook;
@class GTKObject;
@class GTKOptionMenu;
@class GTKPacker;
@class GTKPaned;
@class GTKPixmap;
@class GTKPlug;
@class GTKPreview;
@class GTKProgress;
@class GTKProgressBar;
@class GTKRadioButton;
@class GTKRadioMenuItem;
@class GTKRange;
@class GTKRuler;
@class GTKScale;
@class GTKScrollbar;
@class GTKScrolledWindow;
@class GTKSeparator;
@class GTKSocket;
@class GTKSpinButton;
@class GTKStatusbar;
@class GTKStyle;
@class GTKTable;
@class GTKTearoffMenuItem;
@class GTKText;
@class GTKTipsQuery;
@class GTKToggleButton;
@class GTKToolbar;
@class GTKTooltips;
@class GTKTree;
@class GTKTreeItem;
@class GTKVBox;
@class GTKVButtonBox;
@class GTKVPaned;
@class GTKVRuler;
@class GTKVScale;
@class GTKVScrollbar;
@class GTKVSeparator;
@class GTKViewport;
@class GTKWidget;
@class GTKWindow;

typedef struct _GTKItemFactoryEntry GTKItemFactoryEntry;

#define String_to_NSString(s)	[NSString stringWithCString:s]
#define NSString_to_String(s)	(char *)[(NSString *)(s) cString]

extern NSArray *GList_to_NSArray (GList *glist);
extern GList *NSArray_to_GList (NSArray *array);

extern NSArray *StrVec_to_NSArray (const char **strvec);
extern const char **NSArray_to_StrVec (NSArray *array);

/* Find Objective-C object for given gtk-object pointer */
extern id Gtk_to_Object (gpointer gtk, const char *class);
#define GTK_GET_OBJECT(gtk)	Gtk_to_Object(gtk,0)

/*
 * GTK is the base class of all classes in the Objective-C interface to
 * the GIMP Toolkit. It provides access to the internal gtk-object and
 * methods to connect signals to actions, which represent object/selector
 * combinations.<p>
 * All objects may be assigned a /tag/ (a user defined integer value) to
 * allow for easy identification.<p>
 * Note!!: The methods below that control signal connections and actions are
 * valid only for instances of the @GTKObject class and its subclasses.
 */
@interface GTK : NSObject
{
    gpointer gtk;		// internal gtk-object pointer
    gint32 tag;			// assigned tag value
    NSMutableArray *actions;	// array of connected actions
}

/* internal methods */
+ (void) taskNowMultiThreaded:(NSNotification *) event;
- initWithGtk:(gpointer) gtk;

/* commonly used methods */
- (gpointer) gtk;
- (void) setTag:(gint32) tag;
- (gint32) tag;

/* signal handling for GTKObject */
+ (void) addUserSignal:(NSString *) signal flags:(GtkSignalRunType) flags;
- (void) emit:sender signal:(NSString *) signal;
- (void) stop:sender signal:(NSString *) signal;
- (void) connectSignal:(NSString *) signal withAction:(GTKAction *) action;
- (void) connectSignal:(NSString *) signal withTarget:target sel:(SEL) sel;
- (void) connectSignal:(NSString *) signal withTarget:target sel:(SEL) sel
	 data:(const void *) data;
- (void) connectSignal:(NSString *) signal withActionAfter:(GTKAction *) action;
- (void) disconnectAction:(GTKAction *) action;
- (void) blockAction:(GTKAction *) action;
- (void) unblockAction:(GTKAction *) action;
@end

#endif
