/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkctree.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#ifndef GTOOLKIT_GTKCTREE_H
#define GTOOLKIT_GTKCTREE_H

#include <GToolKit/GTKCList.h>
#include <gtk/gtkctree.h>

@class GTKStyle;

@interface GTKCTree : GTKCList
+ (GtkType) getType;
+ (id) cTreeWithTitles:(gint) columns treeColumn:(gint) tree_column titles:(NSArray  *) titles;
- (id) initWithTitles:(gint) columns treeColumn:(gint) tree_column titles:(NSArray  *) titles;
+ (id) cTreeWithColumns:(gint) columns treeColumn:(gint) tree_column;
- (id) initWithColumns:(gint) columns treeColumn:(gint) tree_column;
- (GtkCTreeNode *) insertNode:(GtkCTreeNode *) parent sibling:(GtkCTreeNode *) sibling text:(NSArray  *) text spacing:(guint8) spacing pixmapClosed:(GdkPixmap *) pixmap_closed maskClosed:(GdkBitmap *) mask_closed pixmapOpened:(GdkPixmap *) pixmap_opened maskOpened:(GdkBitmap *) mask_opened isLeaf:(gboolean) is_leaf expanded:(gboolean) expanded;
- (void) removeNode:(GtkCTreeNode *) node;
- (GtkCTreeNode *) insertGnode:(GtkCTreeNode *) parent sibling:(GtkCTreeNode *) sibling gnode:(GNode *) gnode func:(GtkCTreeGNodeFunc) func data:(gpointer) data;
- (GNode *) exportToGnode:(GNode *) parent sibling:(GNode *) sibling node:(GtkCTreeNode *) node func:(GtkCTreeGNodeFunc) func data:(gpointer) data;
- (void) postRecursive:(GtkCTreeNode *) node func:(GtkCTreeFunc) func data:(gpointer) data;
- (void) postRecursive:(GtkCTreeNode *) node toDepth:(gint) depth func:(GtkCTreeFunc) func data:(gpointer) data;
- (void) preRecursive:(GtkCTreeNode *) node func:(GtkCTreeFunc) func data:(gpointer) data;
- (void) preRecursive:(GtkCTreeNode *) node toDepth:(gint) depth func:(GtkCTreeFunc) func data:(gpointer) data;
- (gboolean) isViewable:(GtkCTreeNode *) node;
- (GtkCTreeNode *) last:(GtkCTreeNode *) node;
- (GtkCTreeNode *) findNodePtr:(GtkCTreeRow *) ctree_row;
- (GtkCTreeNode *) nodeNth:(guint) row;
- (gboolean) find:(GtkCTreeNode *) node child:(GtkCTreeNode *) child;
- (gboolean) isAncestor:(GtkCTreeNode *) node child:(GtkCTreeNode *) child;
- (GtkCTreeNode *) findByRow:(GtkCTreeNode *) node data:(gpointer) data;
- (GList *) findAllByRow:(GtkCTreeNode *) node data:(gpointer) data;
- (GtkCTreeNode *) findByRowDataCustom:(GtkCTreeNode *) node data:(gpointer) data func:(GCompareFunc) func;
- (GList *) findAllByRowDataCustom:(GtkCTreeNode *) node data:(gpointer) data func:(GCompareFunc) func;
- (gboolean) isHotSpot:(gint) x y:(gint) y;
- (void) move:(GtkCTreeNode *) node newParent:(GtkCTreeNode *) new_parent newSibling:(GtkCTreeNode *) new_sibling;
- (void) expand:(GtkCTreeNode *) node;
- (void) expandRecursive:(GtkCTreeNode *) node;
- (void) expand:(GtkCTreeNode *) node toDepth:(gint) depth;
- (void) collapse:(GtkCTreeNode *) node;
- (void) collapseRecursive:(GtkCTreeNode *) node;
- (void) collapse:(GtkCTreeNode *) node toDepth:(gint) depth;
- (void) toggleExpansion:(GtkCTreeNode *) node;
- (void) toggleExpansionRecursive:(GtkCTreeNode *) node;
- (void) select:(GtkCTreeNode *) node;
- (void) selectRecursive:(GtkCTreeNode *) node;
- (void) unselect:(GtkCTreeNode *) node;
- (void) unselectRecursive:(GtkCTreeNode *) node;
- (void) realSelectRecursive:(GtkCTreeNode *) node state:(gint) state;
- (void) nodeSetText:(GtkCTreeNode *) node column:(gint) column text:(NSString *) text;
- (void) nodeSetPixmap:(GtkCTreeNode *) node column:(gint) column pixmap:(GdkPixmap *) pixmap mask:(GdkBitmap *) mask;
- (void) nodeSetPixtext:(GtkCTreeNode *) node column:(gint) column text:(NSString *) text spacing:(guint8) spacing pixmap:(GdkPixmap *) pixmap mask:(GdkBitmap *) mask;
- (void) setNodeInfo:(GtkCTreeNode *) node text:(NSString *) text spacing:(guint8) spacing pixmapClosed:(GdkPixmap *) pixmap_closed maskClosed:(GdkBitmap *) mask_closed pixmapOpened:(GdkPixmap *) pixmap_opened maskOpened:(GdkBitmap *) mask_opened isLeaf:(gboolean) is_leaf expanded:(gboolean) expanded;
- (void) nodeSetShift:(GtkCTreeNode *) node column:(gint) column vertical:(gint) vertical horizontal:(gint) horizontal;
- (void) nodeSet:(GtkCTreeNode *) node selectable:(gboolean) selectable;
- (gboolean) nodeGetSelectable:(GtkCTreeNode *) node;
- (GtkCellType) nodeGetCellType:(GtkCTreeNode *) node column:(gint) column;
- (gint) nodeGetText:(GtkCTreeNode *) node column:(gint) column text:(NSString **) text;
- (gint) nodeGetPixmap:(GtkCTreeNode *) node column:(gint) column pixmap:(GdkPixmap **) pixmap mask:(GdkBitmap **) mask;
- (gint) nodeGetPixtext:(GtkCTreeNode *) node column:(gint) column text:(NSString **) text spacing:(guint8 *) spacing pixmap:(GdkPixmap **) pixmap mask:(GdkBitmap **) mask;
- (gint) getNodeInfo:(GtkCTreeNode *) node text:(NSString **) text spacing:(guint8 *) spacing pixmapClosed:(GdkPixmap **) pixmap_closed maskClosed:(GdkBitmap **) mask_closed pixmapOpened:(GdkPixmap **) pixmap_opened maskOpened:(GdkBitmap **) mask_opened isLeaf:(gboolean *) is_leaf expanded:(gboolean *) expanded;
- (void) nodeSetRow:(GtkCTreeNode *) node style:(GTKStyle *) style;
- (GTKStyle *) nodeGetRowStyle:(GtkCTreeNode *) node;
- (void) nodeSetCellStyle:(GtkCTreeNode *) node column:(gint) column style:(GTKStyle *) style;
- (GTKStyle *) nodeGetCellStyle:(GtkCTreeNode *) node column:(gint) column;
- (void) nodeSetForeground:(GtkCTreeNode *) node color:(GdkColor *) color;
- (void) nodeSetBackground:(GtkCTreeNode *) node color:(GdkColor *) color;
- (void) nodeSetRow:(GtkCTreeNode *) node data:(gpointer) data;
- (void) nodeSetRowDataFull:(GtkCTreeNode *) node data:(gpointer) data destroy:(GtkDestroyNotify) destroy;
- (gpointer) nodeGetRowData:(GtkCTreeNode *) node;
- (void) nodeMoveto:(GtkCTreeNode *) node column:(gint) column rowAlign:(gfloat) row_align colAlign:(gfloat) col_align;
- (GtkVisibility) nodeIsVisible:(GtkCTreeNode *) node;
- (void) setIndent:(gint) indent;
- (void) setSpacing:(gint) spacing;
- (void) setShowStub:(gboolean) show_stub;
- (void) setLineStyle:(GtkCTreeLineStyle) line_style;
- (void) setExpanderStyle:(GtkCTreeExpanderStyle) expander_style;
- (void) setDragCompareFunc:(GtkCTreeCompareDragFunc) cmp_func;
- (void) sortNode:(GtkCTreeNode *) node;
- (void) sortRecursive:(GtkCTreeNode *) node;
@end

#endif /* GTOOLKIT_GTKCTREE_H */
