/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkwindow.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#ifndef GTOOLKIT_GTKWINDOW_H
#define GTOOLKIT_GTKWINDOW_H

#include <GToolKit/GTKBin.h>
#include <gtk/gtkwindow.h>

@class GTKAccelGroup;
@class GTKWidget;

@class GTKWindow;

/*
 * Notification strings
 */
extern NSString *GTKWindowDidBecomeMainNotification;
extern NSString *GTKWindowDidResignMainNotification;
extern NSString *GTKWindowWillCloseNotification;
extern NSString *GTKWindowWillOpenNotification;

/*
 * These methods may be implemented by the delegate.
 */
@protocol GTKWindowDelegate
- (void) windowDidBecomeMain:(NSNotification *) event;
- (void) windowDidResignMain:(NSNotification *) event;
- (BOOL) windowShouldClose:(GTKWindow *) sender;
- (void) windowWillClose:(NSNotification *) event;
@end

@interface GTKWindow : GTKBin
{
    id delegate;		// delegate of this window object
@private
    guint handler_id;		// /delete_event/ signal handler id
}

+ (GtkType) getType;
+ (id) windowWithType:(GtkWindowType) type;
- (id) initWithType:(GtkWindowType) type;
- (void) setTitle:(NSString *) title;
- (void) setWmclass:(NSString *) wmclass_name wmclassClass:(NSString *) wmclass_class;
- (void) setPolicy:(gint) allow_shrink allowGrow:(gint) allow_grow autoShrink:(gint) auto_shrink;
- (void) addAccelGroup:(GTKAccelGroup *) accel_group;
- (void) removeAccelGroup:(GTKAccelGroup *) accel_group;
- (void) setPosition:(GtkWindowPosition) position;
- (gint) activateFocus;
- (gint) activateDefault;
- (void) setTransientFor:(GTKWindow *) parent;
- (void) setGeometryHints:(GTKWidget *) geometry_widget geometry:(GdkGeometry *) geometry geomMask:(GdkWindowHints) geom_mask;
- (void) setDefaultSize:(gint) width height:(gint) height;
- (void) setModal:(gboolean) modal;
- (void) setDelegate:(id) object;
- (id) delegate;
- (void) performClose:(id) sender;
- (NSString *) title;
- (GTKWidget *) focusWidget;
- (GTKWidget *) defaultWidget;
@end

#endif /* GTOOLKIT_GTKWINDOW_H */
