
/* Copyright (C) 1997,1998, Kenneth Albanowski.
   This code may be distributed under the same terms as Perl itself. */

#ifndef _Gtk_Types_h_
#define _Gtk_Types_h_

#ifndef PerlGtkDeclareFunc
#include "PerlGtkInt.h"
#endif

#ifndef GTK_MAJOR_VERSION
#define GTK_MAJOR_VERSION 0
#endif

#ifndef GTK_MINOR_VERSION
#define GTK_MINOR_VERSION 0
#endif

#ifndef GTK_MICRO_VERSION
#define GTK_MICRO_VERSION 0
#endif

#if (GTK_MAJOR_VERSION < 1) || ((GTK_MAJOR_VERSION == 1) && (GTK_MINOR_VERSION < 1))
# define GTK_1_0
#else
# define GTK_1_1
#endif

struct PerlGtkTypeHelper {
	SV * (*GtkGetArg_f)(GtkArg *);
	int (*GtkSetArg_f)(GtkArg * a, SV * v, SV * Class, GtkObject * Object);
	int (*GtkSetRetArg_f)(GtkArg * a, SV * v, SV * Class, GtkObject * Object);
	SV * (*GtkGetRetArg_f)(GtkArg * a);
	
	struct PerlGtkTypeHelper * next;
};


struct PerlGtkSignalHelper {
	GtkType type;
	char ** signals;
	int (*Unpacker_f)(SV ** * _sp, int match, GtkObject * object, char * signame, guint nparams, GtkArg * args, GtkType * arg_types, GtkType return_type);
	int (*Repacker_f)(SV ** * _sp, int count, int match, GtkObject * object, char * signame, guint nparams, GtkArg * args, GtkType * arg_types, GtkType return_type);
	
	struct PerlGtkSignalHelper * next;
};

PerlGtkDeclareVar(struct PerlGtkTypeHelper *, PerlGtkTypeHelpers);
PerlGtkDeclareFunc(void, AddTypeHelper)(struct PerlGtkTypeHelper * h);

PerlGtkDeclareVar(struct PerlGtkSignalHelper *, PerlGtkSignalHelpers);
PerlGtkDeclareFunc(void, AddSignalHelper)(struct PerlGtkSignalHelper * h);
PerlGtkDeclareFunc(void, AddSignalHelperParts)(GtkType type, char ** names, void * unpacker, void * repacker);

PerlGtkDeclareFunc(SV *, GtkGetArg)(GtkArg *);
PerlGtkDeclareFunc(void, GtkSetArg)(GtkArg * a, SV * v, SV * Class, GtkObject * Object);
PerlGtkDeclareFunc(void, GtkSetRetArg)(GtkArg * a, SV * v, SV * Class, GtkObject * Object);
PerlGtkDeclareFunc(SV *, GtkGetRetArg)(GtkArg * a);

PerlGtkDeclareVar(AV *, gtk_typecasts);

PerlGtkDeclareVar(int, did_we_init_gdk);
PerlGtkDeclareVar(int, did_we_init_gtk);
PerlGtkDeclareFunc(void, GtkInit_internal)(void);

/*extern HV * signal_fixups;*/

/*typedef GtkNotebookPage * Gtk__NotebookPage;
typedef GtkBoxChild * Gtk__BoxChild;   */
typedef GtkMenuFactory * Gtk__MenuFactory;
typedef GtkSelectionData * Gtk__SelectionData;

typedef GtkWidget * Gtk__Widget_Up;
typedef GtkWidget * Gtk__Widget_Sink_Up;
typedef GtkWidget * Gtk__Widget_OrNULL_Up;

#define CastupGtk__Widget GTK_WIDGET

typedef GtkObject * Gtk__Object_Up;
typedef GtkObject * Gtk__Object_Sink_Up;
typedef GtkObject * Gtk__Object_OrNULL_Up;

#define CastupGtk__Object GTK_OBJECT

PerlGtkDeclareFunc(void, UnregisterGtkObject)(SV * sv_object, GtkObject * gtk_object);
PerlGtkDeclareFunc(void, RegisterGtkObject)(SV * sv_object, GtkObject * gtk_object);
PerlGtkDeclareFunc(SV *, RetrieveGtkObject)(GtkObject * gtk_object);

PerlGtkDeclareFunc(SV *, newSVGtkObjectRef)(GtkObject * object, char * classname);
PerlGtkDeclareFunc(GtkObject *, SvGtkObjectRef)(SV * o, char * name);
/*PxerlGtkFunc(void, disconnect_GtkObjectRef)(SV * o);*/

PerlGtkDeclareFunc(SV *, newSVGtkMenuEntry)(GtkMenuEntry * o);
PerlGtkDeclareFunc(GtkMenuEntry *, SvGtkMenuEntry)(SV * o, GtkMenuEntry * e);

/*extern SV * newSVGtkRequisition(GtkRequisition * o);
extern GtkRequisition * SvGtkRequisition(SV * o, GtkRequisition * e);*/
 
PerlGtkDeclareFunc(SV *, newSVGtkSelectionDataRef)(GtkSelectionData * o);
PerlGtkDeclareFunc(GtkSelectionData *, SvGtkSelectionDataRef)(SV * data);

/*
#define newSVGtkNotebookPage(n) newSVMiscRef(n, "Gtk::NotebookPage", 0)
#define SvGtkNotebookPage(data) ((GtkNotebookPage*)SvMiscRef(data, "Gtk::NotebookPage"))

#define newSVGtkBoxChild(n) newSVMiscRef(n, "Gtk::BoxChild", 0)
#define SvGtkBoxChild(data) ((GtkBoxChild*)SvMiscRef(data, "Gtk::BoxChild"))
*/

PerlGtkDeclareFunc(int, GCGtkObjects)(void);

PerlGtkDeclareFunc(void, FreeHVObject)(HV * hv_object);

PerlGtkDeclareFunc(int, type_name)(char * name);

PerlGtkDeclareFunc(GtkType, FindArgumentType)(GtkObject * object, SV * name, GtkArg * result);

#ifdef GTK_TTY

#define gtk_vtemu_ref(x) do{}while(0)
#define gtk_vtemu_unref(x) do{}while(0)

#endif


PerlGtkDeclareFunc(int, type_name)(char * name);

PerlGtkDeclareFunc(void,add_typecast)(int type, char * perlName);

#define newSVgchar(x) newSViv(x)
#define Svgchar(x) SvIV(x)

#define newSVgshort(x) newSViv(x)
#define Svgshort(x) SvIV(x)

#define newSVglong(x) newSViv(x)
#define Svglong(x) SvIV(x)

#define newSVgint(x) newSViv(x)
#define Svgint(x) SvIV(x)

#define newSVgboolean(x) newIV(x)
#define Svgboolean(x) SvIV(x)

#define newSVgfloat(x) newSVnv(x)
#define Svgfloat(x) SvNV(x)

#define newSVgdouble(x) newSVnv(x)
#define Svgdouble(x) SvNV(x)

#define newSVguchar(x) newSViv(x)
#define Svguchar(x) SvIV(x)

#define newSVgushort(x) newSViv(x)
#define Svgushort(x) SvIV(x)

#define newSVgulong(x) newSViv(x)
#define Svgulong(x) SvIV(x)

#define newSVguint(x) newSViv(x)
#define Svguint(x) SvIV(x)

#define newSVgint8(x) newSViv(x)
#define Svgint8(x) SvIV(x)

#define newSVgint16(x) newSViv(x)
#define Svgint16(x) SvIV(x)

#define newSVgint32(x) newSViv(x)
#define Svgint32(x) SvIV(x)

#define newSVguint8(x) newSViv(x)
#define Svguint8(x) SvIV(x)

#define newSVguint16(x) newSViv(x)
#define Svguint16(x) SvIV(x)

#define newSVguint32(x) newSViv(x)
#define Svguint32(x) SvIV(x)

#endif /*_Gtk_Types_h_*/

