
#include <Application.h>
#include <MessageFilter.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include "gdkprivate.h"

class TestView : public BView {
  public:
    TestView();
    void Draw(BRect rect);
    void MessageReceived(BMessage *message);
  private:
    GdkWindow *gdkwin;
};

class TestWindow : public BWindow {
  public:
    TestWindow();
    void DispatchMessage(BMessage *msg, BHandler *target);
  private:
    TestView *view;
};

class TestApp : public BApplication {
  public:
    TestApp();
    void ReadyToRun();
  private:
    TestWindow *win;
};

TestView::TestView()
 : BView(BRect(0,0,200,200), "TestView", B_FOLLOW_ALL, B_WILL_DRAW)
{
  GdkWindowPrivate *priv;
  priv = (GdkWindowPrivate*) g_malloc(sizeof (GdkWindowPrivate*));

  priv->destroyed = FALSE;
  priv->xwindow = (GdkBView*) this; 
  
  gdkwin = (GdkWindow*) priv;
}

void
TestView::MessageReceived (BMessage *message)
{
  printf("received...\n");
}

void
TestWindow::DispatchMessage(BMessage *msg, BHandler *target)
{
  switch (msg->what)
    {
    default:
      printf("Warning: Unknown Message: %c%c%c%c for target %#x\n",
             ((char*)(&(msg->what)))[3],
             ((char*)(&(msg->what)))[2],
             ((char*)(&(msg->what)))[1],
             ((char*)(&(msg->what)))[0],
             target);
      BWindow::DispatchMessage(msg, target);
    }
}


void
TestView::Draw(BRect rect)
{
  GdkGC *gc;

  printf("draw...\n");
  gc = gdk_gc_new(gdkwin);

  gdk_draw_line(gdkwin, gc, 0, 0, 30, 30);

}

TestWindow::TestWindow()
 : BWindow(BRect(100,100,300,300), "TestWindow", B_TITLED_WINDOW, B_WILL_DRAW)
{
  view = new TestView();
  AddChild(view);
}

TestApp::TestApp()
 : BApplication("application/x-vnd.EventLoop-TestGDK")
{
}

void
TestApp::ReadyToRun () 
{
  win = new TestWindow();
  win->Show();
}

int
main (int argc, char **argv)
{
  be_app = new TestApp();
  be_app->Run();
}
