enum {
  ENC_ISO_8859_1  = 1 << 0,
  ENC_ISO_8859_2  = 1 << 1,
  ENC_ISO_8859_3  = 1 << 2,
  ENC_ISO_8859_4  = 1 << 3,
  ENC_ISO_8859_5  = 1 << 4,
  ENC_ISO_8859_6  = 1 << 5,
  ENC_ISO_8859_7  = 1 << 6,
  ENC_ISO_8859_8  = 1 << 7,
  ENC_ISO_8859_9  = 1 << 8,
  ENC_ISO_8859_10 = 1 << 9,
  ENC_ISO_8859_13 = 1 << 10,
  ENC_ISO_8859_14 = 1 << 11,
  ENC_ISO_8859_15 = 1 << 12,
  ENC_KOI8_R      = 1 << 13,
  ENC_TIS_620     = 1 << 14,
  ENC_JIS_0208    = 1 << 15,
  ENC_GB_2312     = 1 << 16,
  ENC_KSC_5601    = 1 << 17,
  ENC_JIS_0201    = 1 << 18,
  ENC_JIS_0212    = 1 << 19,
  ENC_BIG5_1	  = 1 << 20,
  ENC_BIG5	  = 1 << 21,
  ENC_GB18030_0   = 1 << 22,
  ENC_GB18030_1   = 1 << 23,
  ENC_HKSCS_1	  = 1 << 24,
  ENC_CNS11643_1  = 1 << 25,
  ENC_CNS11643_2  = 1 << 26,
  ENC_CNS11643_3  = 1 << 27,
  ENC_GBK         = 1 << 28,
  ENC_ISO_10646   = 1 << 29
};

static Charset charsets[] = {
  { 0,  NULL,           "iso8859-1",       conv_ucs4 },
  { 1,  "ISO-8859-2",   "iso8859-2",       conv_8bit },
  { 2,  "ISO-8859-3",   "iso8859-3",       conv_8bit },
  { 3,  "ISO-8859-4",   "iso8859-4",       conv_8bit },
  { 4,  "ISO-8859-5",   "iso8859-5",       conv_8bit },
  { 5,  "ISO-8859-6",   "iso8859-6",       conv_8bit },
  { 6,  "ISO-8859-7",   "iso8859-7",       conv_8bit },
  { 7,  "ISO-8859-8",   "iso8859-8",       conv_8bit },
  { 8,  "ISO-8859-9",   "iso8859-9",       conv_8bit },
  { 9,  "ISO-8859-10",  "iso8859-10",      conv_8bit },
  { 10, "ISO-8859-13",  "iso8859-13",      conv_8bit },
  { 11, "ISO-8859-14",  "iso8859-14",      conv_8bit },
  { 12, "ISO-8859-15",  "iso8859-15",      conv_8bit },
  { 13, "KOI8-R",       "koi8-r",          conv_8bit },
  { 14, "TIS-620",      "tis620.2529-1",   conv_8bit },
  { 15, "EUC-JP",       "jisx0208.1983-0", conv_eucjp },
  { 16, "GB2312",       "gb2312.1980-0",   conv_16bit },
  { 17, "EUC-KR",       "ksc5601.1987-0",  conv_16bit },
  { 18, "EUC-JP",       "jisx0201.1976-0", conv_eucjp },
  { 19, "EUC-JP",       "jisx0212.1990-0", conv_eucjp },
  { 20, "BIG5",	        "big5-1",	   conv_16bit_MSB_on },
  { 21, "BIG5",	        "big5-0",	   conv_16bit_MSB_on },
  { 22, "GB18030",      "gb18030.2000-0",  conv_16bit_MSB_on },
  { 23, "GB18030",      "gb18030.2000-1",  conv_gb18030_1 },
  { 24, "BIG5-HKSCS",   "hkscs-1",	   conv_16bit_MSB_on },
  { 25, "EUC-TW",       "cns11643-1",	   conv_16bit },
  { 26, "EUC-TW",       "cns11643-2",	   conv_euctw },
  { 27, "EUC-TW",       "cns11643-3",	   conv_euctw },
  { 28, "GBK",          "gbk-0",           conv_16bit_MSB_on },
  { 29, NULL,           "iso10646-1",      conv_ucs4 }
};

static CharsetOrdering charset_orderings[] = {
	{ "ja", { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 18, 19, 16, 17, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29} },
	{ "ko", { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29} },
	{ "zh-cn", { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 22, 23, 28, 16, 17, 15, 18, 19, 20, 21, 24, 25, 26, 27, 29} },
	{ "zh", { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 22, 23, 28, 16, 17, 15, 18, 19, 20, 21, 24, 25, 26, 27, 29} },
	{ "zh-tw", { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 20, 21, 25, 26, 27, 24, 22, 23, 16, 17, 15, 18, 19, 28, 29} },
	{ "zh-hk", { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 24, 20, 21, 25, 26, 27, 22, 23, 16, 17, 15, 18, 19, 28, 29} },
	{ NULL, { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 29, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28} }
};
static const guint32 char_mask_map[] = {
  0,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KOI8_R,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0201|ENC_KOI8_R|ENC_TIS_620,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KOI8_R|ENC_TIS_620,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212|ENC_KOI8_R|ENC_TIS_620,
  ENC_GB18030_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_GB18030_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KOI8_R,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_15|ENC_ISO_8859_9|ENC_JIS_0212|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_BIG5_1|ENC_BIG5|ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_6|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_15|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0201,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212|ENC_KOI8_R,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_GB18030_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_15|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KOI8_R|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KOI8_R|ENC_KSC_5601,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GBK|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KOI8_R|ENC_KSC_5601,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0212|ENC_KSC_5601,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_GB18030_1|ENC_HKSCS_1|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB18030_1|ENC_HKSCS_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB18030_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB18030_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB18030_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB18030_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB18030_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212|ENC_KSC_5601,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB18030_1|ENC_HKSCS_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB18030_1|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB18030_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB18030_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_15|ENC_KSC_5601,
  ENC_GB18030_1|ENC_HKSCS_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB18030_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB18030_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_JIS_0212,
  ENC_GB18030_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_15|ENC_JIS_0212|ENC_KSC_5601,
  ENC_GB18030_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KOI8_R|ENC_KSC_5601,
  ENC_GB18030_1|ENC_HKSCS_1|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_JIS_0212|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_HKSCS_1|ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_2|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_13|ENC_ISO_8859_2|ENC_JIS_0212,
  ENC_ISO_8859_3|ENC_JIS_0212,
  ENC_ISO_8859_14|ENC_ISO_8859_3|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_JIS_0212|ENC_KSC_5601,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_HKSCS_1|ENC_ISO_8859_2|ENC_JIS_0212,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_ISO_8859_2|ENC_JIS_0212,
  ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_4,
  ENC_ISO_8859_3|ENC_JIS_0212|ENC_KSC_5601,
  ENC_ISO_8859_10|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212|ENC_KSC_5601,
  ENC_JIS_0212|ENC_KSC_5601,
  ENC_ISO_8859_10|ENC_ISO_8859_4|ENC_JIS_0212|ENC_KSC_5601,
  ENC_ISO_8859_13|ENC_ISO_8859_2|ENC_JIS_0212|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GBK|ENC_ISO_8859_13|ENC_ISO_8859_2|ENC_JIS_0212,
  ENC_GB18030_0|ENC_GBK|ENC_ISO_8859_2|ENC_JIS_0212,
  ENC_HKSCS_1|ENC_ISO_8859_10|ENC_ISO_8859_4|ENC_JIS_0212|ENC_KSC_5601,
  ENC_ISO_8859_15|ENC_JIS_0212|ENC_KSC_5601,
  ENC_HKSCS_1|ENC_ISO_8859_15|ENC_JIS_0212|ENC_KSC_5601,
  ENC_ISO_8859_13|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_JIS_0212,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_JIS_0212,
  ENC_ISO_8859_14|ENC_JIS_0212,
  ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_JIS_0212,
  ENC_ISO_8859_13|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_JIS_0212,
  ENC_HKSCS_1|ENC_JIS_0212,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0212,
  ENC_JIS_0212,
  ENC_GB18030_0|ENC_GBK,
  ENC_HKSCS_1,
  ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_JIS_0212|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GBK,
  ENC_KSC_5601,
  ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_JIS_0212|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GBK|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_JIS_0212|ENC_KSC_5601,
  ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_JIS_0212|ENC_KSC_5601,
  ENC_ISO_8859_2|ENC_JIS_0212|ENC_KSC_5601,
  ENC_ISO_8859_7|ENC_JIS_0212,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_ISO_8859_7|ENC_JIS_0208|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_ISO_8859_5|ENC_JIS_0208|ENC_KOI8_R|ENC_KSC_5601,
  ENC_ISO_8859_5|ENC_JIS_0212,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_ISO_8859_5|ENC_JIS_0208|ENC_KOI8_R|ENC_KSC_5601,
  ENC_ISO_8859_8,
  ENC_GB18030_1|ENC_ISO_8859_6,
  ENC_GB18030_1,
  ENC_TIS_620,
  ENC_ISO_8859_14,
  ENC_GB18030_0|ENC_GBK|ENC_JIS_0208,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_ISO_8859_10|ENC_ISO_8859_7|ENC_JIS_0208|ENC_KSC_5601,
  ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0208,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_ISO_8859_13|ENC_ISO_8859_7|ENC_JIS_0208|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_ISO_8859_13|ENC_JIS_0208|ENC_KSC_5601,
  ENC_ISO_8859_13,
  ENC_JIS_0208|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GBK|ENC_JIS_0208|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0208|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_JIS_0201,
  ENC_GB18030_0|ENC_GBK|ENC_ISO_8859_15,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GBK|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_ISO_8859_5|ENC_JIS_0212|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK,
  ENC_CNS11643_1|ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_KSC_5601,
  ENC_JIS_0208,
  ENC_CNS11643_1|ENC_GB18030_0|ENC_GBK,
  ENC_KOI8_R,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0208|ENC_KOI8_R|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_GB18030_0|ENC_GBK,
  ENC_BIG5_1|ENC_BIG5|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_KOI8_R,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_KOI8_R|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GBK|ENC_JIS_0208,
  ENC_CNS11643_1,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1|ENC_KOI8_R,
  ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1|ENC_KOI8_R,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GBK|ENC_KOI8_R,
  ENC_KOI8_R|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GBK|ENC_KOI8_R,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1,
  ENC_BIG5_1|ENC_BIG5|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0208,
  ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0208,
  ENC_BIG5_1|ENC_BIG5|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0208|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0208,
  ENC_CNS11643_1|ENC_GB_2312|ENC_JIS_0208,
  ENC_CNS11643_3|ENC_GB18030_1,
  ENC_GB18030_1|ENC_HKSCS_1,
  ENC_CNS11643_3|ENC_GB18030_1|ENC_HKSCS_1,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GBK,
  ENC_GB18030_0|ENC_GBK|ENC_JIS_0212,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0212,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GBK|ENC_JIS_0212,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_2|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0208|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_2|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0212,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_2|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0208,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_2|ENC_GB18030_0|ENC_GBK,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0208,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GBK|ENC_JIS_0212,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0208,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GB_2312|ENC_GBK,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0212,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0208,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0212,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_2|ENC_GB18030_0|ENC_GBK|ENC_JIS_0212,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_2|ENC_GB18030_0|ENC_GBK|ENC_JIS_0208,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_2|ENC_GB18030_0|ENC_GBK|ENC_JIS_0208|ENC_KSC_5601,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GBK|ENC_JIS_0208,
  ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0212,
  ENC_GB18030_0|ENC_GBK|ENC_KSC_5601,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0208,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_2|ENC_GB18030_0|ENC_GB_2312|ENC_GBK,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0208,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GBK|ENC_JIS_0212|ENC_KSC_5601,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0212,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0212|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_2|ENC_GB18030_0|ENC_GBK|ENC_JIS_0212|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_2|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0212|ENC_KSC_5601,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0212|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_2|ENC_GB18030_0|ENC_GBK|ENC_KSC_5601,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GBK|ENC_KSC_5601,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GBK|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GBK|ENC_JIS_0212|ENC_KSC_5601,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0208|ENC_KSC_5601,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GBK|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0212|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0208,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1|ENC_KSC_5601,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GBK|ENC_JIS_0212|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0212,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_3|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0208,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0212|ENC_KSC_5601,
  ENC_CNS11643_3|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_2|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_KSC_5601,
  ENC_BIG5_1|ENC_BIG5|ENC_CNS11643_1|ENC_GB18030_0|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0208|ENC_KSC_5601,
  ENC_CNS11643_1|ENC_GB18030_1,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_KSC_5601,
  ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_HKSCS_1|ENC_JIS_0208|ENC_KSC_5601,
  ENC_JIS_0201,
  ENC_BIG5_1|ENC_BIG5|ENC_JIS_0201,
  ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_KSC_5601,
  ENC_CNS11643_1|ENC_GB18030_0|ENC_GB_2312|ENC_GBK|ENC_JIS_0208|ENC_KSC_5601,
  ENC_BIG5|ENC_BIG5|ENC_BIG5|ENC_BIG5|ENC_BIG5|ENC_BIG5|ENC_BIG5,
};

static const guchar char_masks[] = {
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  4,  1,
  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,  7, 16, 17, 18, 19, 20,
 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,  7, 16, 31, 32, 31,  7,
 33, 34, 35, 36, 37, 38, 39, 40, 33, 41, 33, 35, 42, 35, 35, 43,
 44, 42, 33, 45, 35, 38, 37, 46, 39, 42, 35, 47, 37, 48, 49, 50,
 51, 52, 35, 36, 37, 38, 39, 40, 51, 53, 51, 35, 51, 52, 35, 43,
 49, 42, 51, 54, 35, 38, 37, 55, 56, 51, 52, 47, 53, 48, 49, 57,
 58, 59, 60, 60, 61, 61, 62, 62, 63, 63, 64, 64, 61, 61, 60, 60,
 65, 66, 58, 59,  0,  0, 67, 67, 61, 61, 68, 69, 63, 63, 70, 70,
 64, 64, 67, 71, 63, 63, 72, 72, 73, 73, 67, 59,  0,  0, 67, 67,
 70, 74, 75, 75, 63, 63, 67, 67, 76, 60, 60, 67, 67, 60, 60, 75,
 75, 77, 77, 62, 78, 67, 67, 60, 79, 75, 76, 80, 58, 59,  0,  0,
 60, 60, 81, 82, 60, 60, 83, 83, 60, 60, 62, 62, 63, 63, 84, 84,
 85, 85, 60, 60, 60, 60, 76, 76, 73, 73, 67, 59, 63, 63, 60, 60,
 60, 60, 67, 67, 86, 86, 86, 86, 87, 62, 62, 88, 88, 85, 85,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 89, 90, 91,
 90, 89, 90, 91, 90, 91, 90, 91, 90, 91, 90, 91, 90,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 91,  0,  0,  0, 92,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 93, 94,  0,  0, 93,  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,
  0, 94,  0,  0,  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 93,  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 93, 95,  0, 96, 97, 97,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 99, 100, 75, 101,  0, 102,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 103, 103, 103,  0, 103, 103, 103,  0, 103,  0, 103, 103,
 103, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
 104, 104,  0, 104, 104, 104, 104, 104, 104, 104, 103, 103, 103, 103, 103, 103,
 103, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104,
 104, 104, 103, 104, 104, 104, 104, 104, 104, 104, 103, 103, 103, 103, 103,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 105, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106,  0, 106, 106,
 107, 107, 107, 107, 105, 105, 105, 105, 105, 105, 105, 105, 105, 107, 107, 107,
 107, 107, 107, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105,
 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105,
 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105, 105,
  0, 105, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106,  0, 106, 106,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108,
 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 109, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 109, 110, 110, 110, 109,
 110, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109,
 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 110, 110, 110, 110, 110,
 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109, 109,
 109, 109, 109, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111,
 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111,
 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111,
 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111,  0,  0,  0,  0, 111,
 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111,
 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 112, 112,  0,  0,  0,  0,  0,  0, 112, 112,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 112, 112,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 112, 112,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 112, 112,  0,  0,  0,  0,  0,  0,  0,  0,
 112, 112,  0,  0,  0,  0,  0,  0,  0,  0, 112, 112,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 112, 112, 112, 112, 112, 112,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 93, 93,
 93, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 112, 112,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 108, 108,
 113,  0,  0, 97, 97, 114, 115, 108, 104, 116,  0,  0, 117, 117, 118,  0,
 119, 119, 120,  0,  0, 121, 122,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 123,  0, 122, 123,  0, 97,  0,  0,  0,  0,  0, 122,  0,  0, 124,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,
  0, 98, 98, 98, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 125,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 122,  0, 97,  0,  0,  0, 126,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 98,  0,  0, 127,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 128, 75,  0,  0,  0, 98,  0,  0,  0,  0, 119,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0, 98, 98, 98, 98,  0,
 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 130, 130,  0,  0,  0,  0,
 131, 131, 131, 131, 131, 131, 131, 131, 131, 131,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 122, 122, 122, 122, 98, 98, 126, 126, 126, 126,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 93, 93,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 119,  0, 119,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 119,  0, 119, 119,  0,  0,  0, 119, 123,  0,  0, 119,  0,  0,  0, 132,
  0, 132, 133,  0,  0, 134,  0,  0,  0, 135, 136,  0,  0, 123, 122, 97,
 122,  0,  0, 137,  0, 138,  0, 123, 123, 122, 122, 122, 119,  0, 129,  0,
  0,  0,  0,  0, 122, 122, 130, 130,  0,  0,  0,  0, 139, 123,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 140,  0,  0,  0, 130,  0,  0,  0,
  0,  0, 121,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 122, 122,  0,  0, 141, 141, 142, 142,  0,  0, 119, 119,  0,  0, 130, 130,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 119, 119,  0,  0, 119, 119,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 92,  0,  0,  0, 132,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 122,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 97,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 123,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 135, 135,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
  0, 143,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 98, 98, 98, 98, 98,  0,
  0,  0,  0,  0, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 132, 132,
 132, 132, 132, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 136, 123, 136, 123, 130, 130, 130, 130, 130, 130, 130, 130, 136, 132, 132, 123,
 136, 132, 132, 123, 136, 132, 132, 123, 136, 132, 132, 123, 136, 123, 132, 132,
 123, 132, 132, 123, 136, 123, 132, 132, 123, 132, 132, 123, 136, 132, 132, 123,
 123, 132, 132, 123, 136, 132, 132, 123, 123, 132, 132, 123, 136, 132, 132, 123,
 132, 132, 123, 132, 132, 132, 132, 132, 132, 132, 132, 123,  0,  0,  0,  0,
 145, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 145, 146,
 146, 145, 146, 146, 146, 146, 146, 146, 146, 146, 145, 146, 146, 147, 147, 147,
 147, 97, 97, 97,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 135, 97, 97, 97, 148, 97, 97, 97, 148, 97, 97, 97, 148, 97, 97, 97,
 135, 135, 149, 150, 97, 97,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 136, 122,  0, 98, 98, 98, 98, 98, 98, 98,  0,  0,  0,  0,  0,  0,
  0,  0, 122, 122,  0,  0, 98, 98,  0,  0,  0,  0, 121, 121,  0,  0,
 98, 98,  0,  0,  0,  0, 122, 122, 98,  0,  0, 122,  0,  0, 122, 122,
 98, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 97, 97, 97, 97,  0,  0,  0,  0,  0,  0,  0,  0,  0, 133,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 122, 122,  0,  0, 97,  0,  0,  0,  0, 98, 98,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0, 98,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 122, 151, 122,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98, 98, 98,  0, 98, 98, 98, 119,  0, 98, 119,  0, 133,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 93,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 93, 92,  0,  0, 94,  0, 93, 93, 94,  0, 93, 92, 94, 93,  0,  0,
  0,  0,  0,  0,  0, 93,  0, 92,  0,  0,  0,  0, 93, 93,  0,  0,
  0,  0,  0,  0,  0, 93,  0, 94,  0,  0, 94,  0, 93,  0, 94,  0,
  0,  0,  0, 92,  0,  0, 94, 92,  0,  0,  0, 92, 93,  0, 93,  0,
  0,  0,  0,  0,  0,  0, 93,  0,  0,  0, 94,  0, 93, 93,  0, 93,
  0,  0,  0,  0,  0,  0, 93, 93,  0,  0,  0,  0,  0,  0, 93,  0,
  0,  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92,  0,  0,  0,  0,
 122, 122, 122, 122,  0, 152, 153, 153, 122, 122, 122, 122, 122, 122, 122, 122,
 122, 122, 142, 123, 122, 122, 130, 130,  0,  0,  0,  0, 133, 97, 97,  0,
  0, 97, 97, 97, 97, 97, 97, 97, 97, 97,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 92,  0,
  0, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154,
 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154,
 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154,
 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154,
 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154,
 154, 154, 154, 154,  0,  0,  0,  0,  0,  0,  0, 153, 153, 155, 155,  0,
  0, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154,
 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154,
 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154,
 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154,
 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 154,
 154, 154, 154, 154, 154, 154, 154,  0,  0,  0,  0, 156, 153, 153, 155,  0,
  0,  0,  0,  0,  0, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96,
 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96,
 96, 96, 96, 96, 96, 96, 96, 96, 96, 96,  0,  0,  0,  0,  0,  0,
  0, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,  0,  0,  0,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,  0,  0,  0,  0,  0,  0,
  0, 94,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,  0,  0,  0, 98,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 97,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98, 98, 98, 98,  0,  0,  0, 98, 98, 98, 98, 98, 98, 126, 126,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 126, 126, 126, 98,
 98, 126, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 126, 98, 98, 98, 98, 98, 98,  0,  0,  0, 97, 98,
 98, 97, 97, 98,  0, 97, 98,  0, 98,  0,  0, 98, 98, 98,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 157, 110, 110, 157, 110, 110, 110, 157, 157, 110, 157, 110, 110, 157, 110,
 110, 157, 157, 157, 157, 158, 110, 110, 110, 157, 110, 157, 157, 110, 110, 110,
 158, 110, 157, 157, 157, 110, 110, 92, 110, 157, 110, 110, 158, 157, 110, 110,
 110, 157, 110, 110, 110, 110, 110, 157, 110, 110, 157, 110, 110, 157, 110, 110,
 110, 110, 110, 110, 159, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157,
 157, 110, 110, 94, 157, 110, 110, 110, 110, 110, 159, 157, 157, 159, 158, 110,
 110, 110, 110, 110, 110, 110, 157, 110, 110, 157, 110, 157, 157, 157, 110, 110,
 110, 110, 157, 159, 110, 157, 159, 157, 110, 157, 110, 110, 110, 157, 157, 110,
 110, 110, 110, 110, 110, 159, 157, 110, 110, 110, 157, 110, 110, 110, 110, 159,
 157, 110, 157, 157, 110, 110, 110, 157, 157, 110, 157, 110, 158, 110, 110, 110,
 110, 158, 157, 157, 110, 157, 110, 157, 159, 110, 157, 157, 157, 110, 110, 157,
 157, 157, 110, 110, 157, 157, 110, 157, 110, 110, 110, 110, 157, 110, 110, 158,
 110, 110, 110, 110, 158, 110, 110, 157, 157, 157, 110, 110, 110, 110, 157, 157,
 110, 110, 110, 110, 110, 110, 110, 157, 110, 110, 110, 159, 110, 157, 110, 110,
 110, 110, 110, 157, 157, 110, 158, 157, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 110, 110, 110, 110, 157, 110,
 110, 110, 157, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 110,
 110, 110, 157, 110, 110, 110, 110, 110, 110, 157, 110, 157, 110, 157, 158, 110,
 110, 110, 157, 110, 157, 157, 157, 157, 157, 110, 157, 157, 110, 157, 110, 110,
 110, 159, 110, 158, 157, 157, 157, 110, 157, 110, 110, 157, 157, 110, 110, 110,
 157, 159, 110, 110, 157, 157, 157, 157, 110, 157, 110, 157, 157, 158, 110, 157,
 158, 157, 159, 157, 110, 110, 157, 159, 159, 110, 157, 110, 110, 110, 110, 110,
 157, 157, 157, 157, 159, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110,
 157, 110, 157, 157, 110, 110, 110, 159, 158, 110, 110, 110, 110, 110, 92, 157,
 157, 158, 110, 157, 157, 158, 157, 110, 110, 110, 110, 110, 110, 158, 110, 110,
 110, 110, 110, 110, 157, 110, 110, 157, 110, 157, 157, 110, 110, 157, 157, 159,
 110, 159, 110, 157, 110, 158, 110, 159, 110, 110, 158, 157, 110, 157, 158, 110,
 157, 110, 158, 110, 110, 110, 159, 110, 110, 110, 157, 159, 110, 158, 110, 110,
 110, 110, 110, 157, 157, 157, 110, 110, 110, 157, 157, 110, 110, 110, 110, 110,
 110, 158, 158, 159, 110, 157, 110, 110, 110, 110, 110, 158, 110, 157, 158, 110,
 110, 157, 157, 110, 110, 110, 110, 157, 110, 158, 110, 110, 157, 110, 92, 110,
 110, 110, 110, 110, 157, 157, 110, 110, 158, 157, 160, 110, 110, 157, 157, 157,
 110, 157, 157, 159, 110, 110, 157, 157, 110, 157, 157, 110, 157, 159, 110, 157,
 157, 157, 110, 157, 157, 158, 157, 110, 157, 159, 157, 157, 110, 110, 158, 157,
 110, 110, 157, 157, 157, 157, 110, 159, 159, 159, 157, 110, 110, 110, 158, 157,
 110, 157, 110, 157, 110, 157, 110, 110, 110, 110, 110, 157, 157, 110, 110, 158,
 110, 110, 110, 157, 110, 157, 110, 110, 157, 157, 110, 157, 157, 110, 110, 110,
 157, 110, 157, 157, 157, 157, 157, 110, 157, 157, 158, 110, 157, 110, 110, 110,
 110, 159, 110, 110, 157, 157, 110, 110, 110, 110, 110, 110, 157, 110, 157, 157,
 157, 110, 110, 157, 110, 110, 110, 110, 110, 110, 159, 110, 110, 110, 157, 157,
 110, 157, 157, 157, 157, 158, 110, 110, 157, 157, 159, 157, 159, 157, 157, 110,
 159, 159, 110, 157, 157, 159, 157, 157, 157, 158, 157, 157, 159, 157, 110, 157,
 110, 159, 110, 158, 159, 159, 110, 158, 158, 110, 110, 110, 110, 157, 157, 157,
 157, 157, 110, 159, 159, 157, 159, 110, 110, 157, 110, 157, 157, 159, 157, 110,
 110, 158, 158, 110, 110, 158, 159, 157, 157, 157, 110, 157, 157, 157, 157, 157,
 157, 157, 157, 157, 157, 159, 110, 157, 110, 110, 157, 157, 110, 157, 157, 110,
 110, 158, 157, 159, 157, 110, 157, 110, 159, 157, 159, 157, 110, 159, 110, 157,
 157, 157, 157, 157, 110, 157, 110, 110, 110, 110, 157, 157, 159, 110, 110, 110,
 157, 157, 158, 158, 110, 159, 157, 110, 157, 157, 157, 110, 158, 158, 110, 110,
 159, 157, 158, 158, 157, 157, 157, 110, 157, 110, 158, 157, 157, 157, 110, 110,
 159, 110, 110, 159, 157, 110, 110, 110, 157, 110, 157, 110, 157, 110, 157, 110,
 157, 110, 157, 110, 157, 157, 157, 110, 110, 110, 110, 157, 157, 157, 110, 110,
 157, 110, 159, 110, 110, 110, 110, 157, 110, 110, 110, 157, 110, 110, 110, 158,
 110, 157, 110, 110, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 157, 110, 110, 110,
 157, 157, 110, 110, 157, 157, 157, 158, 110, 157, 110, 110, 110, 110, 110, 110,
 158, 157, 157, 110, 157, 157, 157, 157, 157, 110, 110, 110, 110, 157, 110, 157,
 110, 110, 157, 110, 110, 157, 157, 110, 110, 159, 110, 110, 110, 110, 159, 110,
 157, 157, 110, 110, 157, 110, 110, 110, 110, 110, 157, 110, 110, 157, 110, 110,
 110, 157, 110, 110, 157, 110, 110, 157, 157, 110, 157, 110, 110, 157, 110, 110,
 157, 110, 110, 110, 110, 157, 157, 157, 157, 110, 110, 157, 110, 157, 110, 157,
 110, 110, 158, 110, 110, 110, 157, 110, 158, 110, 110, 158, 110, 110, 157, 110,
 157, 157, 110, 110, 157, 110, 110, 110, 157, 110, 110, 110, 157, 110, 110, 159,
 110, 110, 110, 110, 110, 110, 157, 110, 157, 159, 110, 110, 157, 110, 110, 110,
 158, 110, 110, 110, 110, 110, 157, 110, 110, 157, 110, 110, 110, 159, 110, 157,
 110, 110, 157, 110, 110, 110, 159, 110, 158, 157, 110, 157, 110, 110, 110, 110,
 110, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110,
 110, 110, 110, 157, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 157, 110, 157, 158, 110, 110, 110, 110, 110, 157, 110, 110, 110, 157, 110, 157,
 157, 157, 157, 110, 110, 110, 110, 110, 110, 157, 110, 157, 110, 157, 157, 110,
 110, 110, 110, 110, 110, 110, 157, 110, 157, 110, 110, 110, 157, 110, 110, 110,
 157, 110, 110, 157, 110, 110, 110, 110, 157, 157, 110, 110, 110, 110, 110, 110,
 159, 157, 110, 110, 110, 110, 110, 110, 110, 157, 157, 110, 157, 110, 157, 110,
 110, 110, 157, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 157, 157, 110,
 110, 110, 110, 158, 110, 110, 157, 110, 110, 110, 110, 157, 158, 157, 157, 157,
 157, 158, 110, 157, 157, 110, 110, 110, 110, 157, 110, 110, 157, 110, 110, 157,
 110, 110, 110, 110, 110, 157, 157, 110, 110, 110, 110, 110, 157, 110, 110, 110,
 110, 110, 110, 110, 110, 157, 110, 110, 110, 110, 158, 157, 157, 110, 110, 110,
 110, 157, 157, 157, 110, 157, 110, 110, 159, 110, 110, 157, 157, 110, 110, 110,
 157, 157, 110, 157, 158, 110, 110, 110, 92, 157, 110, 157, 110, 110, 110, 157,
 110, 110, 110, 110, 110, 110, 110, 158, 157, 110, 157, 110, 157, 110, 110, 110,
 157, 110, 159, 157, 110, 157, 110, 157, 110, 157, 110, 110, 110, 110, 110, 158,
 157, 110, 110, 157, 110, 110, 110, 157, 157, 110, 110, 157, 157, 159, 157, 110,
 110, 157, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110,
 157, 110, 110, 158, 157, 110, 110, 157, 110, 110, 110, 157, 157, 157, 92, 110,
 110, 110, 157, 110, 110, 157, 157, 110, 110, 157, 157, 110, 110, 110, 110, 157,
 158, 110, 157, 157, 157, 110, 110, 110, 110, 159, 159, 110, 110, 157, 110, 110,
 110, 110, 158, 110, 157, 110, 157, 110, 110, 158, 110, 158, 110, 110, 157, 110,
 110, 159, 110, 110, 158, 110, 110, 110, 157, 110, 110, 157, 110, 157, 157, 157,
 110, 110, 110, 110, 110, 110, 110, 157, 159, 110, 110, 110, 157, 157, 110, 110,
 110, 110, 157, 110, 110, 157, 110, 110, 110, 110, 110, 157, 157, 157, 157, 92,
 92, 110, 110, 157, 110, 157, 157, 110, 110, 110, 157, 110, 158, 110, 110, 92,
 110, 110, 158, 157, 157, 159, 157, 110, 157, 110, 157, 110, 158, 110, 157, 157,
 110, 157, 157, 157, 157, 157, 110, 157, 159, 110, 110, 158, 157, 110, 158, 157,
 157, 158, 157, 158, 157, 110, 158, 157, 157, 110, 110, 157, 110, 157, 110, 157,
 110, 110, 110, 157, 157, 110, 110, 159, 158, 110, 110, 157, 110, 110, 157, 157,
 110, 110, 157, 157, 157, 157, 157, 157, 157, 159, 159, 110, 110, 110, 110, 110,
 157, 157, 157, 110, 159, 157, 157, 110, 157, 110, 157, 110, 157, 110, 110, 157,
 157, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 158, 110, 110, 157, 110,
 110, 110, 159, 110, 110, 157, 157, 159, 157, 157, 157, 157, 159, 157, 159, 110,
 110, 157, 110, 110, 110, 157, 159, 158, 157, 110, 157, 110, 157, 157, 110, 110,
 157, 110, 110, 161, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 157, 110, 110, 110, 110, 157, 110, 157, 110, 110, 110, 157, 110, 157, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 158, 110, 110, 157, 110, 110, 110, 110, 157,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 159, 110, 110, 110, 157,
 110, 157, 110, 110, 157, 110, 157, 157, 157, 110, 110, 110, 110, 158, 110, 110,
 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 157, 157, 110, 110, 110, 110,
 110, 110, 110, 157, 157, 157, 110, 157, 157, 157, 110, 110, 110, 157, 158, 110,
 159, 157, 110, 110, 110, 110, 110, 110, 110, 157, 110, 157, 110, 110, 110, 110,
 158, 110, 158, 157, 110, 157, 110, 157, 157, 110, 157, 158, 110, 157, 110, 110,
 110, 110, 110, 157, 157, 157, 157, 157, 157, 157, 110, 110, 157, 157, 158, 157,
 157, 110, 110, 110, 157, 157, 110, 110, 110, 159, 110, 157, 157, 110, 110, 110,
 157, 157, 158, 110, 110, 110, 110, 110, 110, 157, 157, 159, 157, 157, 110, 110,
 157, 110, 157, 157, 157, 110, 157, 110, 157, 158, 110, 110, 110, 110, 110, 157,
 110, 157, 159, 110, 157, 110, 110, 157, 157, 110, 157, 157, 110, 110, 92, 110,
 110, 157, 157, 110, 110, 157, 110, 110, 158, 110, 110, 110, 157, 110, 110, 110,
 159, 110, 157, 110, 110, 110, 110, 110, 157, 110, 157, 157, 110, 110, 110, 110,
 110, 159, 159, 110, 110, 110, 110, 110, 110, 157, 110, 159, 159, 110, 110, 110,
 159, 110, 110, 157, 110, 157, 157, 157, 157, 110, 110, 110, 157, 157, 157, 110,
 110, 110, 157, 157, 157, 110, 159, 110, 157, 159, 157, 157, 157, 110, 110, 157,
 110, 159, 110, 157, 110, 110, 110, 110, 110, 157, 110, 110, 157, 110, 157, 110,
 110, 110, 110, 157, 157, 110, 110, 110, 157, 110, 157, 110, 158, 110, 158, 157,
 110, 110, 159, 110, 159, 110, 110, 157, 157, 110, 110, 110, 157, 157, 157, 157,
 157, 110, 110, 157, 110, 110, 157, 159, 110, 110, 157, 157, 157, 158, 157, 157,
 157, 110, 157, 110, 157, 157, 157, 110, 110, 110, 157, 110, 159, 157, 157, 110,
 110, 110, 159, 159, 158, 157, 157, 110, 110, 157, 110, 110, 110, 110, 110, 110,
 157, 110, 110, 110, 110, 157, 157, 110, 157, 157, 157, 110, 110, 159, 157, 110,
 157, 159, 110, 110, 110, 159, 157, 157, 110, 157, 157, 157, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110,
 110, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157,
 110, 110, 110, 157, 110, 110, 110, 110, 157, 157, 110, 110, 110, 110, 110, 110,
 110, 110, 157, 110, 159, 157, 110, 110, 157, 110, 157, 110, 110, 110, 157, 157,
 157, 157, 157, 110, 110, 110, 110, 110, 157, 110, 157, 110, 110, 157, 92, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 110, 110, 110, 157,
 110, 110, 110, 110, 157, 110, 157, 157, 110, 110, 157, 110, 157, 110, 157, 110,
 110, 110, 157, 110, 110, 110, 110, 110, 157, 110, 110, 110, 157, 110, 110, 110,
 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 110,
 110, 157, 110, 110, 157, 157, 157, 157, 110, 157, 157, 157, 110, 110, 157, 110,
 157, 110, 157, 110, 157, 110, 157, 110, 110, 110, 157, 159, 157, 159, 157, 157,
 110, 159, 157, 110, 110, 110, 159, 110, 110, 157, 110, 110, 158, 157, 157, 110,
 92, 110, 110, 110, 110, 157, 157, 110, 110, 157, 110, 159, 157, 157, 157, 158,
 110, 110, 110, 157, 110, 157, 110, 110, 157, 110, 157, 157, 157, 157, 110, 110,
 110, 110, 110, 110, 110, 157, 157, 157, 157, 110, 157, 110, 110, 110, 110, 110,
 110, 157, 110, 159, 110, 157, 157, 157, 110, 110, 157, 157, 157, 159, 110, 110,
 110, 110, 110, 110, 110, 110, 157, 157, 157, 157, 157, 110, 110, 110, 157, 110,
 157, 157, 158, 157, 157, 110, 110, 110, 157, 110, 110, 159, 157, 110, 157, 110,
 157, 110, 157, 110, 110, 110, 158, 110, 110, 110, 157, 110, 158, 157, 159, 110,
 110, 159, 110, 157, 110, 110, 157, 110, 157, 157, 110, 110, 110, 110, 110, 158,
 110, 157, 159, 110, 110, 157, 157, 110, 110, 159, 159, 110, 157, 110, 110, 159,
 157, 110, 110, 157, 110, 159, 110, 110, 157, 110, 110, 157, 110, 158, 110, 110,
 110, 110, 110, 110, 110, 158, 110, 110, 157, 110, 158, 110, 157, 110, 110, 158,
 110, 159, 110, 110, 110, 110, 110, 157, 157, 110, 157, 110, 157, 110, 110, 110,
 157, 157, 110, 110, 157, 158, 157, 110, 157, 110, 157, 157, 157, 159, 157, 157,
 157, 110, 110, 157, 158, 157, 110, 110, 110, 157, 157, 157, 110, 110, 110, 158,
 110, 110, 157, 110, 110, 157, 158, 158, 110, 157, 157, 157, 158, 159, 157, 157,
 157, 110, 157, 159, 110, 110, 110, 110, 157, 157, 110, 158, 110, 110, 110, 110,
 157, 157, 110, 110, 110, 110, 157, 158, 158, 110, 110, 159, 157, 157, 157, 157,
 110, 110, 110, 158, 157, 157, 110, 159, 157, 110, 110, 157, 159, 158, 157, 110,
 157, 157, 110, 157, 157, 110, 158, 110, 157, 157, 157, 157, 110, 110, 110, 110,
 157, 157, 110, 157, 157, 157, 157, 110, 157, 110, 157, 110, 110, 157, 157, 110,
 110, 110, 110, 110, 110, 110, 157, 157, 110, 157, 110, 110, 110, 110, 110, 110,
 157, 157, 110, 157, 110, 157, 157, 110, 110, 110, 110, 110, 110, 157, 110, 110,
 159, 110, 110, 158, 110, 110, 110, 157, 158, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 159, 157, 110, 110, 110, 110, 110, 110, 110, 157, 110,
 157, 110, 110, 110, 157, 157, 157, 110, 110, 110, 110, 110, 110, 110, 157, 110,
 110, 157, 110, 110, 158, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 157, 110, 110, 110, 110,
 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 159, 158, 159, 157, 157, 159, 157, 110,
 157, 159, 110, 157, 110, 157, 110, 157, 159, 110, 110, 110, 110, 110, 110, 158,
 157, 157, 159, 110, 157, 110, 110, 158, 157, 157, 159, 157, 158, 157, 157, 110,
 158, 159, 110, 110, 157, 157, 159, 159, 110, 110, 158, 110, 110, 110, 159, 157,
 110, 159, 158, 110, 110, 110, 110, 159, 110, 158, 110, 158, 110, 157, 157, 157,
 159, 157, 157, 158, 158, 157, 110, 110, 157, 157, 158, 110, 158, 157, 110, 159,
 158, 110, 157, 110, 158, 110, 158, 157, 110, 110, 110, 110, 110, 110, 158, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 157, 110, 157, 157, 110, 157,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 110, 110,
 110, 157, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 110,
 157, 110, 157, 158, 110, 110, 110, 157, 158, 159, 110, 110, 110, 110, 157, 157,
 110, 110, 157, 159, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 157, 110, 110, 157, 110, 157, 157, 158, 157, 110, 110,
 110, 110, 157, 110, 110, 110, 110, 157, 110, 110, 110, 110, 157, 110, 110, 110,
 110, 157, 110, 158, 110, 157, 157, 110, 157, 110, 110, 110, 110, 157, 157, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 157, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110,
 158, 110, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 159, 110, 110, 110, 110, 159, 157, 157, 157,
 110, 157, 157, 157, 110, 158, 110, 110, 110, 110, 110, 110, 157, 158, 110, 110,
 110, 110, 110, 110, 110, 157, 157, 110, 110, 158, 158, 110, 110, 110, 110, 110,
 157, 110, 157, 157, 159, 110, 157, 110, 110, 110, 110, 157, 110, 110, 157, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 158, 157, 110,
 157, 157, 157, 110, 157, 110, 110, 110, 110, 110, 157, 157, 110, 110, 110, 157,
 110, 157, 110, 157, 110, 110, 110, 110, 110, 158, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 157, 110, 158, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157,
 110, 110, 110, 158, 157, 110, 92, 159, 110, 110, 110, 110, 110, 110, 157, 110,
 110, 110, 159, 157, 110, 158, 157, 157, 110, 110, 158, 110, 110, 110, 110, 159,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110,
 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 157, 157, 110, 110, 110, 157, 110, 157, 157, 110,
 110, 110, 110, 157, 157, 157, 110, 110, 158, 110, 110, 157, 110, 157, 110, 157,
 157, 110, 110, 110, 157, 110, 110, 110, 110, 110, 157, 158, 157, 110, 157, 158,
 110, 110, 110, 110, 110, 110, 110, 110, 158, 157, 110, 157, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 159, 157, 110, 157, 110, 110, 110, 158,
 110, 110, 110, 157, 110, 157, 157, 110, 110, 157, 110, 157, 110, 110, 110, 110,
 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 159, 157, 110, 157, 110, 110,
 110, 157, 110, 159, 159, 110, 110, 157, 157, 158, 110, 110, 110, 157, 159, 157,
 110, 157, 157, 157, 110, 157, 110, 110, 110, 157, 110, 157, 110, 110, 110, 110,
 157, 157, 157, 110, 110, 157, 110, 157, 110, 110, 110, 157, 157, 157, 110, 110,
 110, 110, 158, 110, 110, 110, 110, 157, 157, 110, 110, 110, 110, 157, 110, 110,
 110, 110, 110, 110, 157, 110, 110, 157, 110, 110, 110, 110, 110, 110, 157, 110,
 157, 110, 157, 110, 110, 157, 110, 157, 110, 157, 110, 157, 110, 110, 110, 92,
 157, 157, 110, 157, 157, 110, 157, 158, 110, 110, 110, 110, 158, 110, 159, 110,
 157, 110, 157, 110, 110, 110, 157, 110, 110, 157, 110, 110, 110, 157, 110, 159,
 110, 157, 110, 110, 110, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110,
 159, 110, 110, 157, 157, 110, 110, 157, 157, 157, 110, 110, 157, 110, 110, 110,
 110, 157, 110, 157, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 158, 110, 110, 157, 157, 110, 110, 110, 110, 157, 110, 110, 110, 110,
 110, 110, 157, 157, 158, 110, 157, 157, 110, 157, 158, 110, 157, 110, 157, 158,
 110, 110, 110, 110, 110, 157, 110, 110, 110, 157, 110, 159, 110, 110, 110, 110,
 157, 110, 110, 110, 157, 110, 110, 110, 110, 110, 157, 110, 110, 157, 110, 159,
 110, 110, 110, 110, 110, 157, 110, 110, 110, 159, 157, 110, 157, 110, 157, 110,
 110, 110, 110, 110, 157, 110, 110, 157, 110, 110, 157, 110, 110, 110, 110, 110,
 110, 159, 157, 110, 157, 110, 157, 110, 110, 157, 110, 110, 110, 110, 110, 157,
 110, 110, 110, 110, 157, 157, 110, 110, 110, 110, 110, 110, 157, 110, 110, 110,
 157, 110, 110, 110, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110,
 159, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 157,
 110, 110, 110, 110, 110, 110, 110, 110, 157, 157, 110, 110, 110, 157, 110, 110,
 159, 157, 157, 110, 110, 110, 110, 110, 110, 157, 158, 157, 110, 110, 157, 110,
 110, 110, 110, 110, 110, 157, 110, 110, 110, 110, 158, 157, 157, 110, 110, 110,
 157, 110, 110, 110, 157, 157, 110, 157, 157, 157, 157, 157, 158, 157, 110, 157,
 157, 110, 157, 157, 159, 157, 157, 110, 110, 110, 157, 110, 157, 157, 110, 110,
 157, 110, 110, 110, 110, 157, 110, 110, 110, 157, 157, 110, 110, 110, 157, 110,
 110, 110, 110, 110, 157, 158, 110, 157, 157, 159, 110, 110, 159, 157, 110, 157,
 110, 157, 110, 157, 157, 110, 110, 110, 110, 110, 157, 157, 110, 110, 157, 110,
 110, 110, 157, 157, 157, 157, 110, 157, 157, 157, 157, 157, 110, 110, 157, 110,
 157, 157, 110, 110, 110, 157, 157, 157, 110, 110, 110, 110, 157, 157, 157, 157,
 110, 110, 157, 157, 158, 110, 110, 110, 157, 157, 157, 159, 159, 110, 110, 110,
 157, 110, 110, 157, 157, 157, 110, 157, 110, 157, 157, 110, 110, 157, 110, 157,
 110, 157, 110, 157, 157, 110, 110, 110, 110, 157, 157, 157, 110, 110, 110, 110,
 110, 157, 157, 110, 157, 110, 157, 157, 157, 157, 110, 158, 157, 110, 110, 110,
 110, 110, 157, 110, 110, 110, 110, 92, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 157, 157, 110, 110, 157, 110, 110, 110, 157, 110, 110, 110,
 157, 157, 157, 157, 110, 110, 110, 110, 110, 110, 110, 157, 157, 110, 157, 157,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 110, 110, 110, 158, 110,
 110, 110, 157, 110, 157, 110, 157, 110, 110, 157, 110, 110, 110, 110, 157, 157,
 110, 157, 110, 110, 110, 157, 157, 110, 110, 110, 110, 157, 110, 157, 110, 157,
 157, 110, 110, 110, 110, 110, 157, 159, 157, 157, 110, 110, 157, 157, 110, 110,
 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 92, 110, 110, 110,
 110, 92, 110, 157, 157, 157, 110, 110, 110, 157, 158, 110, 110, 110, 157, 157,
 110, 158, 157, 110, 110, 110, 110, 110, 157, 110, 157, 110, 110, 110, 110, 110,
 157, 110, 157, 157, 110, 110, 110, 110, 110, 158, 110, 157, 157, 92, 110, 158,
 110, 110, 157, 157, 110, 110, 157, 110, 110, 110, 110, 110, 110, 158, 110, 157,
 110, 110, 159, 110, 110, 110, 110, 110, 110, 157, 157, 157, 110, 110, 157, 110,
 110, 158, 158, 110, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 157,
 110, 110, 110, 159, 110, 110, 157, 110, 157, 157, 110, 110, 110, 110, 110, 110,
 110, 157, 110, 110, 110, 159, 157, 110, 110, 110, 110, 110, 110, 158, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 157, 157, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 157, 110, 157, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 157, 157, 110, 110, 110, 110, 110, 157, 157, 157, 110, 110, 157, 157,
 110, 110, 110, 157, 157, 110, 157, 110, 110, 110, 157, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 157, 110, 110, 110, 110, 157, 158, 110, 110, 110, 110, 110,
 110, 110, 157, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 158,
 110, 110, 110, 157, 157, 157, 110, 110, 157, 110, 157, 157, 157, 157, 110, 159,
 158, 110, 159, 157, 110, 157, 157, 110, 157, 157, 157, 157, 157, 110, 110, 110,
 158, 157, 110, 157, 157, 157, 110, 159, 110, 157, 157, 110, 110, 110, 110, 110,
 158, 157, 110, 110, 110, 159, 110, 110, 157, 110, 110, 110, 110, 110, 159, 110,
 110, 157, 157, 110, 110, 110, 92, 110, 110, 110, 110, 110, 110, 158, 110, 159,
 110, 157, 157, 110, 158, 157, 110, 157, 110, 158, 158, 158, 158, 110, 110, 110,
 157, 110, 110, 110, 158, 157, 157, 157, 110, 157, 110, 110, 110, 157, 110, 110,
 110, 157, 110, 158, 158, 157, 110, 110, 110, 159, 110, 158, 157, 157, 157, 110,
 157, 110, 110, 110, 157, 110, 159, 110, 110, 157, 157, 157, 110, 159, 110, 157,
 110, 157, 157, 157, 110, 157, 110, 158, 110, 110, 110, 157, 110, 110, 158, 110,
 110, 110, 110, 159, 110, 157, 110, 157, 110, 110, 110, 158, 110, 159, 110, 158,
 157, 110, 110, 158, 110, 110, 110, 110, 110, 110, 110, 110, 157, 157, 110, 157,
 110, 159, 159, 110, 110, 159, 157, 157, 157, 110, 110, 110, 158, 110, 110, 157,
 157, 110, 159, 110, 157, 110, 110, 110, 157, 110, 159, 110, 157, 110, 110, 157,
 110, 157, 110, 110, 157, 110, 110, 158, 157, 110, 110, 157, 157, 110, 110, 110,
 110, 157, 110, 110, 110, 158, 110, 110, 157, 110, 110, 157, 157, 157, 110, 157,
 110, 157, 157, 110, 110, 157, 157, 110, 110, 110, 110, 110, 110, 157, 157, 157,
 157, 110, 110, 110, 157, 157, 110, 157, 110, 110, 110, 110, 110, 110, 157, 110,
 157, 110, 110, 110, 157, 157, 110, 110, 157, 157, 110, 110, 110, 157, 110, 110,
 157, 110, 110, 110, 110, 157, 110, 110, 110, 157, 110, 157, 157, 110, 157, 157,
 110, 157, 110, 110, 110, 157, 110, 110, 157, 110, 110, 110, 157, 110, 157, 110,
 110, 110, 157, 110, 110, 110, 157, 110, 157, 158, 110, 157, 157, 110, 157, 110,
 110, 110, 157, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 157, 157, 110, 110, 110, 159, 157, 157, 110, 110, 110, 110, 157, 110, 159,
 110, 157, 157, 110, 110, 158, 110, 159, 110, 157, 157, 110, 157, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 157, 157, 157, 157, 110,
 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 157, 110, 110, 110, 110, 110,
 157, 157, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 92, 110, 110, 110,
 110, 157, 110, 110, 110, 110, 157, 157, 110, 157, 110, 159, 110, 157, 110, 110,
 110, 92, 110, 110, 110, 110, 110, 110, 157, 110, 157, 110, 110, 110, 157, 110,
 157, 110, 110, 110, 110, 110, 110, 157, 157, 110, 158, 110, 110, 110, 110, 157,
 159, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 157, 110, 110, 157, 110, 157, 110, 157, 110, 157, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110,
 157, 110, 157, 110, 157, 157, 110, 110, 110, 157, 157, 157, 110, 157, 157, 110,
 110, 110, 157, 110, 110, 157, 157, 110, 110, 157, 157, 157, 110, 110, 110, 158,
 159, 110, 157, 110, 157, 110, 157, 110, 110, 110, 157, 157, 157, 110, 110, 110,
 110, 157, 110, 110, 157, 110, 157, 157, 157, 110, 110, 110, 110, 157, 110, 110,
 110, 157, 110, 110, 157, 158, 110, 110, 157, 110, 157, 157, 110, 110, 157, 110,
 157, 157, 110, 110, 110, 110, 110, 157, 157, 110, 157, 110, 110, 157, 110, 110,
 110, 110, 110, 159, 110, 110, 157, 110, 159, 110, 110, 110, 110, 110, 110, 110,
 157, 110, 110, 92, 110, 110, 110, 110, 110, 92, 110, 110, 110, 157, 110, 157,
 110, 110, 110, 110, 110, 157, 110, 110, 110, 157, 110, 157, 110, 157, 110, 157,
 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 158, 110,
 110, 110, 110, 157, 157, 110, 110, 110, 157, 110, 110, 110, 157, 157, 157, 157,
 157, 157, 157, 110, 110, 157, 110, 110, 110, 110, 110, 110, 157, 110, 110, 110,
 110, 157, 157, 110, 110, 157, 157, 157, 110, 110, 110, 110, 94, 110, 157, 157,
 110, 110, 110, 110, 157, 110, 110, 110, 110, 157, 157, 110, 110, 92, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 158, 110, 110, 157, 157, 157, 110, 157,
 157, 110, 157, 110, 110, 110, 158, 110, 157, 110, 110, 110, 110, 110, 157, 110,
 157, 110, 110, 157, 110, 110, 159, 110, 110, 110, 110, 110, 157, 110, 110, 110,
 110, 110, 157, 110, 110, 110, 157, 110, 157, 110, 110, 110, 110, 110, 157, 110,
 110, 110, 110, 110, 157, 158, 157, 110, 110, 110, 157, 110, 110, 110, 157, 110,
 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 158, 110, 110,
 157, 157, 110, 110, 158, 110, 110, 110, 110, 110, 157, 110, 157, 157, 110, 110,
 159, 110, 157, 157, 110, 110, 110, 110, 110, 110, 157, 158, 110, 110, 157, 157,
 110, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 157, 157, 110,
 110, 110, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 157, 157, 157, 110, 110, 110, 157, 159, 157, 157, 110, 110, 110, 110, 157, 157,
 110, 157, 110, 110, 110, 157, 157, 157, 157, 110, 110, 157, 157, 157, 110, 157,
 157, 110, 157, 157, 110, 157, 110, 110, 110, 110, 110, 157, 110, 158, 110, 110,
 157, 110, 110, 110, 110, 157, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110,
 110, 158, 110, 110, 110, 110, 110, 110, 110, 157, 157, 110, 157, 110, 110, 157,
 110, 110, 110, 110, 157, 110, 110, 157, 110, 110, 157, 110, 110, 157, 110, 110,
 110, 110, 157, 110, 110, 157, 110, 110, 110, 157, 110, 159, 157, 110, 157, 110,
 157, 110, 157, 110, 110, 157, 157, 110, 110, 157, 157, 157, 157, 158, 158, 110,
 157, 110, 110, 157, 110, 157, 157, 157, 157, 110, 110, 157, 110, 157, 157, 110,
 110, 157, 157, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 157, 110,
 158, 157, 110, 110, 110, 157, 110, 110, 110, 110, 157, 157, 110, 158, 157, 110,
 110, 110, 110, 157, 110, 157, 110, 157, 157, 110, 110, 157, 110, 158, 110, 157,
 157, 157, 110, 158, 110, 157, 110, 110, 110, 110, 158, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 157, 110, 158, 110, 157, 110, 110, 110, 110, 110, 110, 110,
 110, 158, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 157, 159, 157,
 157, 157, 110, 110, 157, 158, 157, 110, 110, 110, 158, 157, 110, 159, 157, 110,
 157, 110, 110, 157, 157, 158, 110, 110, 157, 110, 110, 110, 158, 157, 159, 110,
 110, 110, 110, 110, 110, 159, 157, 92, 157, 110, 157, 157, 157, 110, 110, 110,
 157, 159, 157, 158, 157, 110, 157, 110, 110, 110, 157, 110, 110, 110, 157, 110,
 110, 157, 110, 110, 157, 159, 157, 157, 157, 110, 158, 157, 110, 157, 110, 110,
 110, 110, 159, 157, 157, 157, 110, 157, 157, 110, 92, 110, 110, 92, 110, 110,
 110, 110, 92, 92, 110, 92, 92, 110, 110, 158, 110, 110, 157, 110, 157, 110,
 157, 157, 157, 110, 110, 110, 157, 157, 157, 110, 157, 92, 110, 110, 157, 161,
 110, 158, 157, 110, 157, 157, 157, 159, 110, 110, 110, 110, 110, 157, 157, 110,
 110, 110, 110, 110, 110, 110, 92, 92, 110, 110, 157, 157, 110, 110, 110, 110,
 110, 110, 110, 157, 110, 110, 157, 110, 110, 110, 110, 157, 110, 157, 110, 110,
 157, 157, 110, 157, 157, 157, 157, 157, 110, 157, 157, 157, 110, 110, 157, 159,
 157, 157, 157, 157, 157, 159, 110, 159, 110, 110, 110, 110, 110, 110, 157, 110,
 110, 157, 110, 157, 157, 157, 157, 110, 157, 157, 157, 157, 157, 157, 157, 157,
 157, 110, 157, 157, 157, 157, 157, 157, 110, 157, 157, 157, 157, 110, 157, 158,
 110, 110, 157, 110, 157, 110, 110, 157, 157, 157, 110, 110, 157, 159, 110, 157,
 157, 110, 157, 110, 158, 110, 157, 157, 110, 110, 110, 110, 110, 157, 157, 157,
 110, 157, 110, 110, 110, 159, 157, 157, 157, 157, 157, 157, 110, 110, 110, 110,
 110, 110, 110, 157, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 157, 110, 157, 110, 110, 157, 110, 110, 110, 110, 110, 157, 157, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 157, 157, 110, 110, 110, 157, 157, 157, 110,
 110, 110, 110, 110, 110, 110, 110, 157, 157, 110, 110, 157, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 157, 110, 110, 157, 110, 110, 157, 110, 157, 110, 110,
 110, 110, 110, 110, 157, 110, 158, 110, 157, 110, 110, 110, 110, 157, 157, 110,
 157, 157, 157, 157, 110, 110, 157, 157, 157, 157, 110, 110, 110, 157, 110, 110,
 157, 110, 110, 110, 158, 110, 110, 110, 159, 110, 157, 110, 110, 110, 110, 157,
 110, 110, 110, 110, 110, 157, 110, 157, 157, 157, 110, 157, 110, 110, 157, 110,
 157, 159, 157, 157, 110, 157, 110, 110, 110, 157, 157, 110, 110, 157, 110, 110,
 110, 110, 110, 157, 158, 110, 110, 110, 110, 110, 110, 157, 110, 110, 110, 110,
 110, 110, 110, 157, 110, 110, 110, 157, 110, 110, 157, 110, 110, 110, 110, 158,
 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 157, 157, 157, 110, 159, 157, 110, 157, 110, 110, 110,
 157, 157, 157, 110, 157, 157, 110, 157, 110, 157, 157, 110, 158, 157, 157, 110,
 157, 157, 157, 110, 110, 157, 157, 158, 110, 157, 110, 110, 157, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 157, 110, 157, 110,
 110, 110, 110, 110, 110, 110, 110, 157, 110, 110, 157, 157, 110, 110, 110, 157,
 110, 110, 110, 157, 110, 110, 157, 110, 110, 110, 110, 157, 157, 110, 110, 158,
 159, 110, 159, 157, 157, 110, 157, 110, 157, 110, 157, 159, 157, 157, 159, 110,
 157, 157, 110, 157, 110, 110, 157, 157, 157, 110, 157, 110, 110, 110, 158, 157,
 159, 110, 157, 158, 110, 110, 159, 158, 157, 110, 110, 157, 110, 158, 157, 110,
 110, 110, 110, 110, 110, 157, 157, 110, 110, 110, 157, 110, 110, 110, 110, 157,
 110, 110, 110, 110, 110, 110, 157, 110, 110, 110, 157, 110, 110, 159, 158, 157,
 158, 157, 110, 110, 110, 110, 157, 157, 110, 157, 157, 110, 110, 110, 157, 157,
 157, 110, 110, 110, 110, 157, 110, 110, 110, 157, 110, 110, 110, 157, 110, 110,
 110, 157, 110, 110, 110, 110, 110, 157, 110, 110, 110, 110, 110, 157, 110, 110,
 110, 110, 110, 157, 110, 110, 157, 110, 110, 110, 157, 110, 110, 110, 110, 157,
 110, 110, 110, 110, 158, 157, 110, 158, 110, 110, 110, 110, 110, 157, 158, 110,
 110, 157, 110, 110, 110, 110, 110, 110, 110, 157, 157, 157, 157, 110, 157, 157,
 110, 110, 110, 157, 110, 157, 110, 110, 157, 110, 157, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 158, 110, 110, 158, 157,
 110, 110, 110, 157, 157, 110, 157, 157, 157, 157, 110, 157, 110, 110, 110, 157,
 110, 110, 110, 110, 157, 110, 157, 110, 110, 110, 110, 158, 110, 110, 110, 110,
 157, 110, 110, 110, 110, 110, 157, 157, 157, 110, 110, 157, 110, 158, 110, 157,
 110, 110, 157, 157, 110, 110, 157, 161, 110, 157, 157, 110, 157, 159, 110, 157,
 110, 110, 157, 110, 157, 110, 157, 110, 110, 110, 110, 110, 110, 110, 157, 157,
 110, 110, 157, 110, 110, 110, 157, 110, 110, 157, 110, 110, 110, 110, 110, 92,
 92, 92, 92, 92, 158, 157, 157, 157, 157, 157, 110, 157, 110, 110, 159, 110,
 158, 110, 110, 157, 157, 157, 110, 159, 110, 110, 157, 110, 157, 110, 157, 110,
 110, 110, 157, 110, 157, 110, 157, 110, 157, 110, 110, 157, 157, 158, 157, 157,
 157, 110, 157, 110, 110, 110, 110, 157, 157, 110, 110, 110, 110, 110, 157, 110,
 110, 159, 110, 110, 110, 110, 157, 110, 157, 157, 110, 110, 157, 158, 110, 110,
 157, 157, 110, 110, 110, 110, 157, 110, 110, 110, 157, 110, 157, 157, 110, 157,
 110, 110, 110, 110, 157, 157, 110, 110, 110, 158, 157, 110, 110, 157, 110, 157,
 159, 110, 157, 92, 92, 92, 92, 92, 92, 92, 110, 110, 110, 110, 110, 110,
 110, 110, 157, 157, 110, 110, 157, 110, 110, 157, 157, 157, 110, 110, 157, 110,
 110, 110, 110, 110, 158, 157, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 110, 110, 110, 110, 157,
 110, 110, 110, 157, 110, 110, 110, 157, 110, 157, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 157, 110, 110, 157, 110, 157, 110, 110, 110,
 110, 158, 110, 110, 110, 110, 110, 110, 110, 110, 157, 110, 158, 110, 157, 110,
 110, 110, 110, 110, 110, 110, 157, 157, 157, 110, 110, 110, 110, 110, 92, 110,
 110, 110, 110, 110, 110, 157, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 122, 122, 162, 122, 163, 164, 92, 165, 122, 122, 122, 122, 166, 122, 167, 168,
 169, 122, 162, 130, 122, 122, 122, 113, 122, 122, 170, 130, 170, 130, 122, 171,
 161, 172, 173, 162, 174, 130, 142, 130, 174, 92, 175, 176, 170, 122, 177, 162,
 176, 178, 122, 168, 130, 162, 175, 94, 122, 122, 130, 122, 178, 179, 130, 175,
 162, 162, 180, 122, 162, 122, 161, 166, 96, 179, 92, 122, 130, 122, 122, 122,
 130, 162, 96, 96, 173, 113, 122, 181, 122, 122, 182, 94, 166, 122, 122, 122,
 130, 130, 181, 164, 92, 92, 130, 92, 164, 176, 94, 183, 92, 183, 92, 92,
 130, 184, 92, 122, 162, 162, 183, 183, 94, 164, 92, 92, 92, 92, 122, 177,
 172, 160, 121, 168, 168, 172, 122, 160, 122, 175, 113, 122, 122, 166, 122, 173,
 183, 122, 122, 185, 122, 122, 162, 164, 186, 142, 170, 122, 181, 164, 121, 169,
 187, 122, 122, 161, 122, 122, 122, 130, 122, 130, 92, 122, 122, 122, 122, 164,
 181, 161, 173, 169, 92, 130, 180, 160, 92, 177, 122, 170, 160, 92, 161, 170,
 122, 122, 167, 176, 122, 173, 169, 122, 168, 185, 122, 122, 161, 122, 175, 181,
 162, 130, 92, 130, 122, 122, 122, 122, 122, 122, 177, 162, 168, 165, 169, 122,
 164, 166, 162, 122, 122, 122, 161, 161, 166, 168, 170, 170, 130, 113, 172, 164,
 122, 177, 122, 176, 168, 166, 122, 165, 160, 161, 161, 122, 161, 176, 162, 176,
 177, 122, 177, 163, 168, 168, 161, 161, 177, 122, 122, 188, 162, 122, 165, 122,
 122, 122, 177, 168, 168, 171, 164, 189, 185, 176, 175, 130, 181, 178, 130, 130,
 130, 92, 185, 92, 130, 130, 130, 130, 160, 94, 130, 130, 168, 168, 162, 122,
 169, 164, 179, 177, 122, 164, 122, 163, 122, 163, 122, 177, 122, 122, 177, 168,
 164, 168, 163, 122, 161, 160, 122, 121, 188, 177, 161, 163, 177, 122, 122, 122,
 122, 122, 177, 167, 171, 122, 177, 169, 166, 122, 122, 122, 122, 169, 169, 166,
 176, 168, 168, 176, 185, 130, 161, 185, 161, 122, 177, 168, 176, 161, 177, 122,
 122, 162, 160, 122, 185, 142, 165, 177, 177, 177, 188, 169, 167, 177, 190, 122,
 168, 191, 177, 122, 192, 177, 121, 168, 122, 166, 193, 122, 164, 122, 164, 122,
 177, 122, 177, 164, 166, 168, 121, 166, 180, 162, 177, 122, 168, 122, 177, 164,
 184, 181, 160, 173, 92, 130, 130, 130, 170, 130, 130, 153, 130, 113, 122, 122,
 160, 161, 177, 168, 161, 122, 121, 171, 161, 177, 168, 177, 162, 163, 164, 122,
 177, 177, 121, 122, 122, 166, 164, 168, 163, 191, 122, 177, 163, 177, 122, 176,
 169, 122, 164, 194, 180, 161, 168, 122, 169, 168, 122, 178, 166, 122, 96, 122,
 188, 122, 162, 184, 153, 172, 130, 161, 130, 130, 130, 92, 168, 130, 122, 122,
 164, 129, 163, 122, 168, 180, 178, 168, 122, 160, 122, 161, 164, 163, 169, 164,
 171, 162, 195, 160, 164, 178, 121, 177, 160, 121, 162, 121, 176, 122, 177, 169,
 164, 121, 122, 177, 169, 168, 121, 177, 176, 122, 122, 177, 192, 164, 191, 122,
 168, 122, 177, 121, 196, 169, 122, 191, 122, 169, 122, 121, 165, 122, 174, 168,
 177, 168, 164, 177, 94, 177, 181, 168, 161, 181, 130, 197, 96, 92, 130, 161,
 177, 177, 164, 122, 161, 177, 177, 122, 165, 121, 177, 168, 176, 168, 176, 122,
 181, 177, 164, 177, 161, 122, 172, 177, 160, 164, 122, 168, 122, 168, 168, 177,
 177, 168, 177, 177, 168, 122, 163, 162, 168, 168, 177, 168, 175, 171, 168, 97,
 177, 164, 178, 168, 121, 121, 122, 96, 196, 161, 97, 173, 161, 142, 130, 130,
 122, 163, 168, 177, 162, 122, 162, 168, 179, 161, 162, 168, 168, 122, 177, 164,
 182, 121, 177, 162, 177, 168, 171, 161, 121, 121, 142, 177, 177, 168, 177, 162,
 162, 162, 171, 185, 92, 130, 160, 130, 130, 130, 164, 161, 122, 121, 168, 171,
 177, 168, 122, 121, 178, 121, 168, 121, 168, 164, 166, 96, 161, 177, 121, 168,
 162, 168, 178, 164, 177, 121, 168, 171, 168, 180, 180, 168, 164, 172, 171, 122,
 163, 121, 161, 177, 177, 121, 122, 168, 164, 160, 122, 168, 164, 177, 196, 163,
 168, 160, 164, 178, 177, 121, 166, 122, 177, 171, 168, 161, 185, 122, 169, 177,
 168, 171, 162, 185, 160, 169, 177, 161, 168, 121, 162, 122, 160, 168, 177, 194,
 121, 198, 142, 177, 121, 97, 192, 166, 171, 121, 168, 166, 177, 163, 163, 161,
 171, 168, 122, 168, 142, 142, 181, 177, 142, 162, 178, 164, 177, 164, 164, 121,
 168, 122, 168, 162, 168, 168, 168, 164, 164, 168, 121, 160, 162, 177, 168, 164,
 168, 177, 121, 171, 177, 177, 161, 121, 171, 177, 180, 142, 121, 168, 161, 169,
 122, 122, 162, 122, 122, 122, 122, 121, 122, 122, 164, 122, 121, 122, 196, 162,
 181, 173, 121, 162, 169, 176, 179, 171, 162, 97, 167, 97, 122, 97, 97, 177,
 160, 97, 122, 97, 164, 122, 164, 126, 122, 121, 198, 122, 122, 122, 122, 92,
 130, 122, 161, 130, 170, 122, 122, 122, 122, 179, 92, 130, 122, 130, 164, 161,
 122, 130, 175, 162, 164, 184, 198, 168, 170, 169, 121, 164, 184, 122, 162, 178,
 181, 142, 122, 178, 168, 122, 175, 122, 177, 184, 94, 130, 170, 164, 168, 161,
 122, 164, 169, 164, 169, 122, 181, 94, 172, 113, 121, 187, 122, 162, 92, 130,
 169, 167, 175, 175, 172, 175, 122, 122, 163, 168, 162, 130, 166, 122, 177, 162,
 130, 161, 164, 160, 165, 178, 122, 179, 177, 186, 168, 122, 122, 121, 168, 174,
 168, 174, 163, 163, 168, 162, 181, 168, 177, 161, 161, 175, 121, 122, 191, 160,
 169, 122, 163, 161, 179, 164, 113, 113, 161, 113, 113, 130, 161, 175, 162, 130,
 122, 121, 162, 176, 163, 167, 122, 162, 122, 122, 122, 130, 170, 122, 172, 130,
 122, 176, 90, 122, 181, 163, 122, 122, 122, 168, 122, 172, 168, 130, 122, 161,
 168, 122, 176, 177, 181, 164, 176, 122, 189, 130, 130, 130, 168, 122, 168, 160,
 179, 168, 162, 161, 122, 121, 160, 172, 176, 122, 121, 173, 92, 130, 122, 161,
 122, 177, 177, 167, 160, 177, 122, 122, 122, 199, 122, 122, 163, 130, 161, 130,
 130, 96, 130, 122, 178, 164, 168, 121, 161, 177, 122, 121, 122, 122, 97, 181,
 130, 130, 168, 161, 122, 177, 122, 163, 162, 160, 177, 121, 176, 126, 167, 177,
 163, 192, 168, 181, 181, 184, 162, 173, 160, 122, 122, 168, 168, 168, 177, 122,
 181, 113, 122, 172, 142, 121, 161, 171, 177, 163, 168, 168, 168, 122, 161, 122,
 177, 185, 176, 121, 168, 162, 161, 121, 122, 121, 171, 168, 177, 121, 161, 94,
 179, 121, 200, 176, 172, 162, 177, 177, 177, 168, 163, 122, 164, 173, 173, 122,
 122, 170, 130, 122, 201, 162, 177, 162, 179, 122, 122, 122, 169, 167, 168, 162,
 162, 202, 130, 173, 181, 172, 162, 162, 162, 172, 162, 171, 178, 164, 122, 173,
 177, 121, 168, 122, 164, 198, 162, 122, 162, 122, 161, 130, 163, 180, 161, 164,
 179, 163, 122, 168, 164, 121, 192, 142, 122, 121, 92, 188, 162, 121, 121, 122,
 172, 163, 121, 121, 122, 162, 142, 181, 162, 177, 164, 168, 162, 161, 161, 168,
 176, 177, 181, 121, 177, 121, 162, 177, 121, 187, 122, 126, 168, 161, 122, 122,
 189, 153, 113, 164, 161, 122, 169, 161, 122, 168, 177, 177, 162, 122, 168, 122,
 122, 177, 168, 162, 161, 122, 122, 122, 162, 122, 167, 162, 177, 169, 164, 177,
 122, 122, 168, 122, 161, 164, 130, 163, 162, 162, 122, 162, 182, 177, 130, 121,
 177, 142, 163, 172, 168, 164, 161, 168, 172, 122, 184, 175, 177, 177, 176, 122,
 121, 122, 182, 122, 126, 169, 181, 122, 122, 122, 122, 164, 177, 180, 170, 173,
 161, 122, 122, 122, 121, 173, 130, 122, 181, 162, 122, 162, 122, 160, 122, 179,
 122, 176, 130, 166, 170, 164, 122, 179, 183, 175, 92, 130, 177, 163, 169, 122,
 122, 122, 177, 169, 186, 122, 161, 122, 169, 171, 173, 142, 168, 203, 182, 122,
 161, 92, 167, 162, 122, 130, 173, 162, 162, 173, 168, 173, 130, 130, 177, 168,
 92, 92, 168, 193, 177, 130, 178, 168, 165, 177, 122, 161, 168, 176, 168, 122,
 198, 162, 170, 130, 177, 122, 186, 168, 175, 175, 163, 163, 168, 121, 175, 162,
 172, 161, 171, 181, 177, 162, 175, 164, 162, 168, 164, 122, 92, 162, 161, 130,
 162, 179, 175, 121, 161, 163, 92, 92, 122, 122, 122, 122, 175, 122, 181, 162,
 160, 170, 163, 162, 122, 164, 122, 122, 170, 175, 163, 122, 161, 164, 162, 169,
 174, 180, 121, 122, 122, 122, 176, 162, 169, 122, 122, 122, 122, 122, 169, 122,
 122, 122, 122, 122, 161, 176, 175, 175, 122, 173, 113, 96, 96, 130, 94, 161,
 161, 169, 162, 122, 122, 161, 96, 168, 122, 122, 122, 142, 122, 122, 122, 122,
 122, 122, 96, 174, 94, 173, 179, 130, 168, 168, 163, 122, 168, 122, 96, 122,
 122, 174, 161, 179, 168, 168, 122, 176, 166, 122, 177, 122, 169, 169, 169, 174,
 168, 176, 179, 126, 189, 176, 142, 168, 122, 122, 161, 122, 122, 178, 122, 161,
 169, 168, 121, 176, 164, 168, 169, 177, 122, 181, 122, 179, 161, 163, 142, 177,
 173, 196, 130, 130, 185, 130, 130, 130, 130, 130, 161, 130, 130, 92, 162, 181,
 168, 168, 176, 168, 166, 168, 166, 177, 122, 163, 198, 177, 168, 163, 162, 168,
 178, 122, 185, 122, 177, 122, 169, 169, 96, 161, 168, 122, 122, 122, 168, 177,
 122, 177, 185, 162, 169, 163, 122, 168, 177, 164, 161, 169, 122, 177, 122, 175,
 122, 177, 169, 160, 179, 176, 176, 94, 168, 130, 96, 130, 182, 130, 160, 164,
 168, 177, 178, 179, 186, 178, 176, 176, 122, 176, 176, 122, 122, 166, 177, 169,
 168, 176, 172, 122, 179, 161, 168, 177, 122, 163, 177, 176, 178, 122, 178, 176,
 122, 122, 169, 168, 122, 168, 166, 169, 122, 122, 164, 160, 179, 174, 176, 185,
 179, 130, 130, 130, 130, 130, 168, 130, 113, 130, 179, 92, 130, 130, 185, 130,
 177, 121, 178, 94, 168, 122, 169, 185, 122, 169, 176, 168, 162, 122, 122, 163,
 161, 168, 122, 185, 161, 161, 164, 168, 168, 161, 122, 168, 176, 169, 162, 166,
 164, 176, 160, 168, 180, 177, 122, 122, 177, 176, 168, 168, 177, 163, 191, 169,
 122, 185, 168, 160, 169, 162, 113, 168, 160, 161, 168, 130, 183, 92, 94, 92,
 130, 92, 130, 170, 130, 94, 168, 96, 160, 161, 166, 163, 96, 168, 169, 122,
 185, 122, 177, 169, 168, 191, 177, 96, 142, 178, 161, 177, 166, 162, 122, 179,
 178, 176, 92, 96, 122, 178, 122, 182, 168, 174, 176, 168, 181, 177, 168, 121,
 166, 177, 168, 198, 161, 96, 122, 142, 164, 161, 164, 162, 169, 172, 188, 97,
 162, 176, 168, 121, 176, 185, 176, 130, 161, 94, 96, 160, 130, 130, 130, 92,
 92, 160, 160, 160, 92, 185, 185, 185, 130, 94, 161, 169, 122, 168, 169, 177,
 122, 166, 176, 169, 122, 161, 193, 122, 166, 122, 122, 169, 168, 168, 177, 166,
 94, 166, 177, 177, 176, 168, 161, 164, 122, 122, 121, 161, 122, 122, 181, 169,
 161, 168, 168, 177, 177, 168, 168, 122, 178, 198, 121, 121, 121, 177, 121, 161,
 153, 96, 171, 96, 160, 185, 113, 130, 92, 170, 160, 96, 94, 130, 130, 177,
 168, 163, 168, 177, 167, 122, 171, 121, 168, 176, 168, 177, 166, 185, 171, 168,
 168, 176, 166, 176, 165, 168, 185, 163, 182, 168, 121, 177, 122, 185, 163, 122,
 92, 96, 177, 122, 122, 96, 96, 97, 96, 177, 179, 130, 170, 92, 161, 96,
 160, 94, 185, 130, 161, 170, 171, 169, 161, 178, 168, 160, 168, 122, 122, 177,
 96, 185, 168, 161, 168, 163, 121, 161, 176, 122, 162, 161, 185, 171, 176, 166,
 171, 163, 177, 168, 121, 168, 142, 121, 184, 162, 92, 169, 168, 168, 179, 96,
 160, 94, 160, 170, 130, 94, 161, 185, 161, 142, 168, 161, 166, 179, 97, 121,
 171, 184, 122, 177, 122, 177, 122, 163, 178, 176, 168, 176, 162, 177, 168, 176,
 177, 177, 178, 182, 164, 168, 177, 161, 168, 177, 168, 164, 167, 174, 169, 163,
 172, 161, 160, 126, 174, 92, 161, 96, 185, 96, 168, 113, 130, 94, 177, 161,
 177, 163, 176, 177, 169, 97, 177, 161, 122, 176, 169, 122, 169, 177, 168, 171,
 168, 176, 177, 168, 121, 162, 96, 168, 142, 97, 153, 179, 170, 161, 168, 168,
 142, 168, 168, 168, 177, 176, 165, 142, 162, 160, 172, 182, 177, 168, 96, 169,
 97, 161, 160, 185, 181, 171, 161, 168, 168, 177, 177, 161, 168, 177, 163, 163,
 181, 94, 113, 130, 94, 121, 177, 177, 171, 162, 168, 177, 191, 177, 121, 179,
 161, 182, 168, 177, 121, 168, 142, 176, 161, 160, 161, 161, 122, 168, 177, 94,
 142, 142, 142, 178, 161, 177, 168, 161, 142, 171, 190, 177, 171, 191, 113, 162,
 162, 121, 161, 178, 185, 92, 94, 167, 181, 162, 122, 122, 162, 176, 122, 166,
 122, 166, 170, 181, 176, 177, 164, 177, 162, 161, 97, 176, 161, 174, 178, 160,
 122, 174, 181, 181, 130, 130, 164, 177, 161, 165, 122, 161, 161, 175, 130, 169,
 172, 177, 177, 122, 122, 161, 130, 177, 122, 169, 166, 121, 177, 121, 161, 181,
 92, 162, 121, 121, 168, 163, 121, 161, 121, 92, 177, 177, 167, 163, 168, 122,
 177, 161, 177, 166, 164, 162, 113, 181, 122, 176, 166, 92, 176, 122, 166, 176,
 122, 161, 160, 176, 177, 161, 161, 113, 113, 130, 130, 122, 161, 164, 176, 163,
 122, 168, 186, 160, 161, 177, 163, 122, 161, 168, 122, 168, 166, 190, 122, 169,
 122, 122, 177, 161, 160, 161, 161, 179, 161, 161, 130, 170, 130, 130, 130, 179,
 130, 122, 177, 161, 122, 164, 122, 163, 166, 169, 122, 166, 92, 166, 204, 166,
 191, 177, 168, 166, 177, 191, 185, 176, 161, 162, 182, 166, 190, 168, 182, 172,
 168, 164, 122, 176, 130, 130, 130, 92, 205, 113, 160, 122, 166, 160, 161, 168,
 160, 161, 173, 122, 177, 177, 161, 177, 168, 177, 177, 185, 163, 177, 177, 177,
 122, 174, 122, 122, 167, 168, 173, 174, 164, 206, 153, 130, 164, 130, 96, 92,
 113, 92, 130, 113, 170, 168, 168, 161, 166, 168, 168, 160, 168, 177, 160, 168,
 181, 168, 96, 122, 160, 161, 178, 191, 193, 161, 161, 122, 177, 161, 122, 166,
 168, 161, 167, 113, 169, 166, 113, 94, 130, 130, 130, 161, 178, 174, 163, 122,
 122, 177, 168, 178, 176, 168, 163, 177, 161, 177, 161, 92, 168, 166, 168, 179,
 191, 168, 168, 168, 165, 177, 177, 121, 166, 122, 122, 168, 180, 166, 163, 164,
 165, 168, 122, 163, 177, 121, 122, 185, 191, 188, 121, 167, 177, 166, 168, 161,
 168, 130, 160, 161, 168, 202, 92, 92, 161, 167, 161, 177, 168, 142, 192, 164,
 176, 122, 160, 168, 122, 168, 163, 191, 168, 168, 122, 161, 168, 177, 168, 121,
 122, 121, 177, 168, 121, 122, 168, 168, 168, 177, 198, 168, 161, 178, 161, 177,
 153, 113, 92, 92, 170, 161, 92, 160, 168, 177, 121, 121, 176, 166, 168, 191,
 164, 122, 142, 168, 122, 177, 161, 121, 122, 178, 121, 168, 160, 168, 122, 163,
 161, 204, 121, 168, 191, 185, 161, 164, 177, 172, 161, 169, 179, 97, 92, 168,
 113, 168, 172, 160, 168, 121, 168, 161, 164, 121, 168, 168, 191, 97, 122, 177,
 176, 166, 168, 122, 161, 122, 168, 177, 177, 192, 171, 168, 164, 164, 168, 177,
 177, 168, 173, 122, 177, 161, 164, 181, 168, 170, 170, 161, 121, 177, 129, 122,
 177, 177, 164, 168, 161, 168, 171, 160, 122, 190, 160, 178, 168, 161, 121, 168,
 160, 177, 164, 121, 161, 160, 94, 161, 113, 113, 180, 198, 166, 168, 121, 168,
 161, 122, 177, 161, 164, 122, 168, 121, 177, 168, 181, 94, 113, 164, 188, 168,
 164, 122, 177, 121, 177, 122, 177, 113, 121, 121, 177, 168, 172, 177, 121, 121,
 160, 162, 171, 168, 122, 113, 161, 168, 168, 171, 92, 122, 122, 92, 184, 121,
 175, 181, 172, 174, 168, 161, 130, 181, 92, 122, 121, 198, 178, 121, 168, 168,
 161, 161, 175, 168, 179, 163, 177, 170, 161, 181, 172, 164, 177, 185, 168, 122,
 181, 160, 177, 162, 190, 122, 122, 168, 181, 122, 122, 113, 122, 162, 92, 179,
 97, 162, 121, 164, 176, 169, 161, 122, 162, 122, 122, 122, 178, 122, 122, 166,
 164, 122, 172, 162, 179, 162, 164, 122, 169, 130, 130, 92, 185, 161, 121, 162,
 168, 130, 130, 162, 122, 168, 162, 122, 122, 122, 168, 173, 161, 161, 122, 122,
 121, 122, 164, 177, 122, 122, 130, 122, 169, 162, 122, 164, 168, 164, 164, 162,
 122, 177, 122, 164, 161, 187, 161, 121, 181, 142, 121, 191, 196, 188, 121, 162,
 168, 168, 177, 122, 122, 163, 176, 168, 122, 176, 161, 177, 177, 122, 168, 168,
 168, 169, 122, 122, 122, 168, 173, 130, 130, 160, 122, 162, 164, 169, 177, 168,
 168, 92, 176, 122, 160, 162, 122, 192, 168, 122, 160, 181, 161, 142, 96, 163,
 168, 168, 168, 169, 176, 122, 168, 177, 122, 130, 130, 130, 198, 164, 176, 176,
 163, 168, 167, 171, 168, 168, 168, 163, 160, 122, 177, 122, 177, 168, 122, 161,
 168, 177, 161, 191, 163, 97, 122, 168, 177, 198, 176, 122, 168, 171, 168, 168,
 122, 122, 176, 122, 122, 161, 168, 173, 96, 198, 122, 168, 122, 192, 177, 164,
 168, 168, 161, 176, 177, 169, 121, 164, 122, 168, 121, 172, 129, 168, 191, 163,
 160, 177, 177, 168, 177, 168, 178, 177, 203, 179, 168, 122, 168, 168, 168, 122,
 177, 122, 160, 122, 189, 130, 130, 130, 130, 169, 168, 160, 176, 163, 162, 168,
 161, 122, 163, 176, 161, 168, 168, 168, 122, 168, 181, 126, 122, 161, 177, 122,
 122, 160, 161, 176, 163, 122, 161, 182, 162, 122, 163, 160, 160, 177, 168, 181,
 162, 173, 130, 168, 130, 178, 122, 168, 168, 168, 161, 161, 122, 160, 168, 161,
 169, 121, 168, 168, 177, 163, 122, 177, 177, 122, 96, 161, 177, 168, 161, 161,
 177, 168, 168, 168, 160, 166, 168, 168, 168, 160, 122, 168, 168, 168, 177, 168,
 168, 160, 122, 163, 168, 177, 121, 166, 160, 168, 169, 160, 178, 177, 160, 161,
 168, 160, 92, 161, 130, 173, 130, 176, 168, 160, 166, 177, 168, 168, 163, 169,
 161, 160, 160, 168, 168, 161, 160, 161, 160, 161, 168, 177, 168, 161, 168, 168,
 177, 160, 122, 177, 168, 168, 163, 168, 161, 163, 122, 122, 177, 168, 177, 177,
 163, 160, 177, 161, 195, 168, 168, 171, 161, 168, 173, 160, 177, 92, 168, 168,
 168, 177, 176, 176, 168, 166, 168, 168, 166, 168, 177, 177, 142, 142, 169, 177,
 168, 122, 122, 160, 191, 161, 177, 168, 177, 122, 168, 178, 122, 168, 160, 163,
 181, 161, 130, 160, 130, 168, 169, 142, 96, 168, 177, 168, 166, 168, 168, 168,
 166, 122, 168, 169, 160, 177, 122, 161, 168, 122, 177, 185, 168, 168, 177, 161,
 160, 130, 94, 168, 168, 171, 177, 168, 168, 168, 172, 142, 161, 177, 160, 168,
 164, 177, 168, 168, 161, 194, 161, 168, 171, 122, 161, 121, 121, 160, 161, 168,
 168, 160, 161, 168, 168, 161, 165, 166, 161, 177, 168, 177, 161, 171, 168, 160,
 168, 177, 181, 168, 97, 177, 168, 168, 168, 161, 121, 160, 178, 177, 168, 168,
 142, 161, 167, 161, 176, 161, 113, 173, 171, 161, 161, 161, 168, 168, 178, 168,
 122, 182, 161, 121, 160, 178, 160, 168, 168, 161, 160, 177, 177, 168, 168, 160,
 122, 122, 162, 96, 122, 122, 177, 122, 122, 130, 122, 169, 122, 122, 162, 122,
 161, 92, 185, 122, 122, 167, 175, 161, 182, 122, 173, 121, 185, 94, 177, 162,
 122, 122, 168, 169, 160, 122, 160, 168, 121, 161, 122, 168, 193, 176, 164, 171,
 175, 166, 160, 169, 166, 122, 164, 122, 122, 122, 162, 122, 122, 181, 177, 122,
 182, 162, 168, 192, 164, 165, 204, 122, 122, 122, 122, 122, 122, 175, 179, 172,
 130, 130, 122, 122, 122, 122, 122, 168, 177, 162, 170, 173, 191, 177, 121, 162,
 122, 162, 162, 122, 122, 122, 122, 164, 122, 122, 162, 161, 164, 130, 130, 122,
 191, 177, 122, 198, 122, 122, 122, 122, 161, 113, 168, 168, 122, 177, 168, 162,
 122, 168, 122, 122, 180, 160, 177, 193, 177, 177, 164, 181, 161, 184, 122, 122,
 177, 122, 121, 168, 122, 122, 121, 121, 122, 121, 168, 121, 126, 92, 122, 191,
 169, 177, 168, 172, 162, 121, 121, 161, 122, 173, 122, 130, 130, 164, 181, 175,
 161, 122, 113, 168, 122, 172, 184, 121, 121, 122, 122, 121, 177, 121, 121, 122,
 168, 122, 168, 172, 179, 185, 122, 162, 173, 195, 169, 161, 170, 130, 163, 177,
 172, 161, 169, 182, 122, 185, 162, 130, 180, 162, 168, 164, 176, 113, 162, 161,
 177, 122, 162, 168, 130, 162, 164, 97, 122, 122, 122, 165, 122, 184, 122, 122,
 122, 169, 130, 92, 168, 122, 121, 168, 122, 179, 175, 122, 168, 121, 122, 169,
 169, 122, 161, 172, 168, 122, 168, 161, 97, 166, 162, 195, 171, 97, 175, 161,
 122, 184, 188, 166, 121, 122, 130, 177, 171, 177, 168, 161, 121, 177, 167, 122,
 162, 122, 92, 168, 177, 162, 113, 161, 161, 122, 166, 177, 177, 162, 168, 130,
 161, 130, 130, 92, 161, 160, 168, 162, 166, 168, 177, 168, 169, 185, 161, 177,
 122, 122, 177, 168, 169, 168, 130, 130, 130, 170, 170, 130, 179, 177, 160, 177,
 177, 121, 166, 166, 168, 168, 177, 168, 178, 122, 177, 122, 165, 185, 168, 168,
 168, 122, 162, 122, 164, 192, 178, 122, 122, 161, 193, 181, 113, 130, 200, 130,
 183, 179, 94, 92, 130, 113, 168, 178, 168, 177, 168, 166, 168, 161, 168, 168,
 168, 160, 176, 168, 168, 161, 168, 177, 168, 122, 168, 168, 161, 164, 168, 168,
 200, 184, 161, 92, 130, 179, 173, 92, 122, 172, 169, 161, 168, 169, 177, 198,
 122, 177, 162, 161, 188, 161, 121, 168, 168, 168, 181, 122, 161, 121, 161, 168,
 168, 171, 130, 130, 92, 92, 176, 122, 161, 161, 161, 178, 168, 191, 122, 168,
 160, 121, 177, 161, 122, 172, 122, 121, 172, 121, 178, 169, 161, 168, 185, 178,
 168, 161, 142, 177, 176, 168, 166, 190, 168, 122, 161, 162, 160, 130, 185, 160,
 168, 177, 168, 168, 176, 168, 168, 168, 168, 177, 168, 161, 168, 166, 179, 177,
 168, 168, 177, 177, 161, 168, 163, 96, 163, 168, 166, 165, 122, 161, 178, 161,
 121, 177, 178, 161, 92, 177, 94, 160, 130, 177, 92, 179, 113, 130, 168, 162,
 164, 162, 177, 168, 164, 168, 161, 168, 168, 122, 162, 185, 165, 164, 161, 122,
 182, 168, 168, 113, 170, 161, 113, 168, 161, 177, 177, 161, 168, 168, 177, 177,
 168, 177, 167, 164, 142, 94, 168, 121, 177, 168, 177, 198, 181, 168, 160, 161,
 181, 161, 177, 177, 171, 177, 161, 168, 161, 166, 168, 164, 168, 122, 168, 177,
 191, 168, 180, 161, 160, 161, 161, 177, 168, 168, 194, 163, 178, 168, 178, 168,
 177, 168, 177, 161, 177, 168, 160, 167, 188, 163, 121, 161, 121, 121, 161, 161,
 168, 160, 168, 177, 161, 130, 168, 177, 161, 142, 161, 177, 181, 122, 162, 168,
 164, 168, 121, 181, 97, 168, 121, 160, 177, 162, 92, 175, 92, 122, 122, 168,
 177, 122, 129, 181, 164, 122, 122, 122, 122, 206, 92, 122, 92, 92, 122, 130,
 168, 122, 122, 122, 122, 172, 161, 122, 162, 177, 161, 181, 92, 122, 122, 168,
 164, 130, 122, 122, 168, 130, 122, 162, 173, 160, 168, 172, 122, 162, 168, 130,
 130, 122, 163, 161, 166, 176, 122, 168, 176, 165, 169, 122, 130, 122, 161, 171,
 177, 168, 168, 168, 168, 121, 130, 130, 177, 168, 161, 121, 161, 122, 174, 181,
 181, 130, 164, 121, 168, 164, 121, 169, 122, 161, 161, 130, 130, 122, 177, 183,
 121, 168, 179, 142, 165, 122, 161, 196, 160, 162, 168, 177, 122, 168, 178, 168,
 162, 162, 161, 168, 169, 122, 162, 142, 177, 168, 161, 176, 177, 168, 174, 121,
 168, 122, 122, 121, 113, 161, 168, 168, 177, 168, 177, 171, 177, 177, 177, 168,
 177, 161, 122, 122, 122, 178, 169, 195, 122, 121, 175, 122, 122, 122, 121, 175,
 166, 181, 168, 172, 165, 161, 170, 122, 168, 168, 122, 166, 168, 168, 162, 122,
 173, 130, 161, 130, 130, 122, 169, 122, 161, 173, 122, 168, 122, 161, 130, 130,
 122, 161, 177, 168, 177, 166, 122, 122, 177, 161, 177, 121, 177, 122, 168, 161,
 168, 177, 168, 166, 168, 122, 122, 122, 122, 185, 161, 161, 92, 163, 190, 164,
 161, 142, 121, 113, 97, 168, 177, 168, 121, 122, 122, 177, 177, 160, 177, 181,
 198, 166, 166, 122, 177, 177, 122, 168, 168, 168, 121, 165, 177, 142, 177, 121,
 121, 178, 121, 121, 92, 177, 168, 168, 167, 178, 173, 162, 121, 161, 168, 168,
 181, 178, 168, 121, 175, 161, 122, 122, 172, 160, 122, 198, 172, 161, 169, 169,
 130, 122, 166, 184, 122, 168, 164, 177, 176, 113, 122, 169, 172, 172, 163, 122,
 113, 199, 97, 122, 121, 122, 113, 122, 122, 162, 168, 122, 162, 177, 161, 122,
 130, 164, 177, 177, 177, 175, 122, 122, 177, 122, 130, 162, 162, 169, 177, 184,
 177, 122, 161, 168, 164, 121, 177, 142, 178, 173, 207, 164, 122, 162, 181, 162,
 166, 113, 161, 168, 177, 162, 97, 162, 121, 168, 121, 168, 121, 163, 121, 168,
 174, 172, 173, 184, 177, 173, 165, 122, 166, 121, 161, 204, 153, 208, 134, 92,
 164, 175, 122, 163, 176, 97, 199, 191, 92, 122, 122, 121, 122, 122, 161, 177,
 122, 122, 163, 167, 177, 162, 168, 122, 177, 122, 162, 170, 122, 177, 177, 121,
 122, 122, 167, 172, 184, 122, 168, 122, 169, 176, 122, 122, 122, 164, 161, 164,
 122, 121, 122, 181, 161, 130, 177, 122, 122, 122, 161, 168, 176, 162, 121, 168,
 121, 122, 162, 92, 182, 168, 168, 163, 122, 121, 122, 177, 171, 167, 122, 177,
 162, 182, 168, 181, 181, 129, 168, 129, 164, 121, 160, 168, 167, 122, 168, 168,
 168, 168, 161, 122, 90, 122, 130, 164, 164, 166, 161, 162, 122, 122, 161, 185,
 166, 166, 166, 164, 177, 168, 122, 122, 122, 122, 161, 160, 181, 169, 177, 160,
 122, 166, 162, 168, 167, 168, 161, 173, 177, 164, 176, 122, 164, 166, 166, 177,
 181, 169, 164, 177, 168, 122, 164, 168, 169, 161, 177, 167, 164, 122, 173, 122,
 185, 130, 130, 130, 130, 130, 130, 164, 161, 168, 166, 168, 168, 166, 169, 122,
 178, 168, 122, 177, 176, 169, 122, 177, 164, 167, 177, 169, 165, 122, 168, 162,
 122, 122, 168, 160, 177, 122, 167, 122, 122, 169, 122, 169, 168, 177, 168, 122,
 161, 172, 168, 177, 168, 176, 161, 168, 92, 168, 113, 170, 130, 161, 92, 130,
 177, 165, 165, 122, 168, 168, 142, 177, 164, 177, 172, 184, 177, 122, 161, 161,
 122, 164, 186, 168, 177, 122, 164, 162, 168, 122, 167, 168, 161, 192, 168, 178,
 181, 164, 122, 122, 122, 121, 168, 166, 122, 122, 122, 169, 122, 122, 168, 122,
 122, 162, 168, 173, 161, 172, 130, 153, 130, 130, 130, 130, 173, 130, 163, 176,
 168, 178, 162, 167, 169, 126, 177, 168, 177, 122, 177, 181, 122, 122, 177, 92,
 168, 162, 167, 164, 122, 177, 122, 178, 164, 161, 122, 165, 168, 166, 163, 122,
 122, 161, 177, 122, 193, 162, 184, 198, 176, 181, 181, 130, 130, 130, 161, 130,
 191, 166, 122, 198, 122, 142, 121, 177, 122, 168, 168, 176, 122, 121, 177, 168,
 168, 168, 162, 168, 177, 122, 169, 121, 177, 177, 166, 176, 168, 168, 177, 177,
 161, 122, 161, 178, 177, 176, 161, 160, 169, 177, 122, 177, 122, 166, 163, 122,
 122, 121, 177, 172, 168, 164, 96, 175, 187, 179, 161, 130, 130, 130, 173, 130,
 122, 121, 177, 122, 169, 177, 122, 178, 177, 122, 122, 121, 177, 163, 168, 168,
 169, 122, 162, 178, 168, 168, 122, 163, 122, 122, 177, 168, 163, 122, 122, 122,
 177, 164, 171, 177, 177, 122, 177, 162, 168, 163, 122, 121, 171, 168, 164, 122,
 173, 181, 164, 96, 130, 161, 130, 122, 178, 168, 164, 166, 178, 92, 168, 168,
 193, 164, 168, 161, 121, 162, 177, 188, 161, 162, 161, 168, 196, 172, 121, 122,
 168, 177, 198, 161, 121, 177, 177, 121, 122, 177, 165, 121, 122, 142, 169, 168,
 160, 130, 168, 180, 168, 122, 168, 161, 121, 198, 142, 168, 160, 122, 177, 121,
 163, 168, 122, 121, 203, 178, 168, 122, 122, 161, 168, 121, 177, 92, 121, 172,
 122, 178, 177, 178, 178, 169, 121, 122, 164, 168, 168, 164, 171, 203, 121, 162,
 177, 193, 121, 177, 162, 161, 161, 172, 161, 168, 121, 166, 168, 177, 122, 161,
 121, 121, 177, 177, 122, 160, 178, 164, 193, 198, 121, 168, 163, 166, 161, 177,
 162, 168, 168, 161, 121, 162, 161, 122, 166, 122, 177, 121, 122, 177, 121, 168,
 168, 168, 121, 168, 168, 168, 121, 179, 177, 163, 180, 161, 177, 161, 122, 168,
 163, 177, 176, 180, 161, 168, 178, 121, 122, 121, 122, 122, 178, 142, 164, 163,
 172, 130, 130, 160, 130, 162, 168, 92, 168, 161, 160, 161, 164, 164, 177, 177,
 168, 162, 163, 142, 168, 177, 122, 177, 168, 177, 168, 168, 162, 177, 168, 162,
 168, 168, 121, 161, 113, 96, 121, 121, 121, 168, 121, 168, 121, 178, 142, 122,
 121, 177, 161, 177, 177, 161, 130, 191, 122, 178, 122, 130, 122, 122, 122, 173,
 122, 122, 122, 164, 178, 176, 122, 130, 173, 168, 122, 169, 162, 113, 181, 122,
 177, 122, 176, 177, 185, 185, 113, 177, 161, 177, 122, 177, 179, 168, 122, 181,
 121, 195, 142, 169, 122, 161, 126, 179, 181, 163, 168, 181, 161, 166, 129, 122,
 122, 122, 177, 166, 162, 161, 177, 122, 122, 122, 168, 122, 90, 122, 169, 161,
 177, 176, 176, 122, 176, 113, 162, 161, 122, 168, 177, 169, 177, 161, 178, 161,
 178, 168, 168, 169, 177, 168, 185, 173, 153, 130, 130, 130, 130, 176, 122, 176,
 185, 180, 168, 176, 168, 161, 122, 168, 161, 122, 177, 168, 122, 177, 169, 122,
 122, 168, 172, 178, 122, 160, 97, 168, 168, 122, 122, 161, 168, 164, 177, 177,
 182, 122, 122, 169, 178, 122, 169, 122, 122, 161, 130, 199, 181, 160, 181, 130,
 130, 130, 130, 161, 170, 173, 163, 161, 176, 168, 168, 122, 169, 168, 168, 168,
 168, 122, 161, 177, 168, 122, 177, 164, 168, 122, 164, 167, 122, 122, 177, 176,
 161, 161, 122, 94, 176, 175, 169, 122, 122, 122, 167, 97, 122, 122, 176, 180,
 122, 178, 122, 122, 122, 163, 190, 122, 122, 122, 176, 122, 122, 181, 161, 179,
 181, 181, 130, 130, 161, 170, 130, 130, 130, 130, 164, 168, 122, 122, 122, 122,
 168, 122, 177, 122, 176, 178, 167, 122, 168, 168, 168, 168, 176, 176, 122, 122,
 168, 122, 169, 177, 164, 161, 92, 122, 169, 122, 162, 177, 178, 177, 185, 168,
 177, 122, 92, 177, 168, 168, 176, 161, 182, 181, 130, 173, 92, 130, 130, 184,
 130, 173, 130, 130, 130, 130, 92, 113, 169, 177, 176, 122, 168, 177, 160, 122,
 161, 160, 185, 168, 168, 163, 177, 160, 168, 166, 122, 194, 177, 122, 121, 181,
 168, 177, 176, 166, 177, 185, 176, 168, 168, 122, 177, 166, 122, 169, 176, 122,
 122, 168, 164, 164, 177, 122, 168, 178, 177, 168, 168, 164, 181, 161, 130, 130,
 161, 130, 130, 130, 160, 177, 164, 122, 121, 169, 161, 142, 163, 166, 165, 168,
 168, 176, 121, 161, 164, 177, 169, 122, 177, 160, 122, 122, 177, 177, 161, 193,
 169, 168, 166, 121, 171, 168, 161, 166, 122, 122, 166, 160, 122, 168, 167, 169,
 166, 168, 122, 161, 177, 162, 122, 168, 122, 171, 162, 121, 168, 168, 177, 178,
 122, 121, 122, 169, 177, 122, 162, 122, 122, 122, 122, 178, 169, 166, 166, 177,
 185, 168, 181, 130, 202, 113, 161, 130, 130, 94, 173, 113, 130, 177, 167, 161,
 121, 163, 168, 178, 165, 177, 122, 168, 177, 169, 168, 168, 168, 96, 166, 122,
 122, 163, 169, 177, 162, 177, 122, 168, 168, 168, 121, 121, 177, 168, 179, 168,
 166, 122, 160, 169, 168, 177, 160, 168, 168, 169, 176, 168, 162, 129, 121, 168,
 168, 168, 166, 177, 122, 177, 165, 195, 174, 171, 181, 94, 94, 130, 160, 130,
 130, 130, 130, 161, 92, 130, 142, 160, 161, 177, 177, 185, 185, 121, 168, 122,
 166, 161, 177, 169, 190, 168, 121, 121, 177, 161, 168, 185, 122, 161, 176, 168,
 166, 185, 191, 168, 177, 177, 167, 168, 178, 164, 176, 168, 122, 122, 168, 177,
 177, 161, 160, 168, 169, 177, 142, 168, 160, 168, 186, 160, 161, 176, 121, 166,
 168, 185, 113, 168, 130, 130, 173, 173, 130, 161, 130, 177, 161, 168, 178, 164,
 168, 171, 176, 177, 176, 161, 161, 161, 122, 168, 182, 177, 177, 177, 185, 171,
 191, 177, 161, 162, 161, 168, 168, 169, 168, 122, 161, 168, 168, 176, 168, 121,
 168, 160, 168, 177, 177, 168, 178, 168, 122, 129, 122, 171, 160, 177, 161, 168,
 161, 161, 185, 181, 130, 166, 161, 176, 121, 168, 168, 168, 168, 160, 161, 177,
 171, 209, 122, 121, 161, 169, 185, 168, 177, 176, 121, 164, 168, 177, 122, 177,
 168, 164, 97, 177, 122, 121, 177, 161, 164, 169, 161, 121, 176, 122, 122, 160,
 122, 168, 121, 171, 160, 130, 160, 130, 130, 181, 130, 121, 169, 177, 171, 171,
 179, 121, 169, 168, 188, 122, 161, 121, 161, 177, 188, 171, 162, 122, 190, 168,
 166, 164, 122, 160, 121, 164, 168, 166, 122, 168, 121, 168, 161, 94, 130, 161,
 142, 198, 122, 178, 166, 193, 122, 198, 168, 177, 163, 168, 121, 171, 161, 178,
 171, 142, 121, 168, 121, 162, 181, 171, 168, 161, 121, 171, 168, 178, 121, 177,
 122, 177, 92, 168, 191, 181, 97, 168, 164, 166, 163, 161, 168, 168, 168, 171,
 168, 160, 130, 177, 171, 168, 177, 168, 122, 171, 161, 177, 142, 121, 163, 163,
 168, 168, 177, 121, 142, 185, 177, 161, 161, 177, 121, 122, 121, 168, 166, 122,
 94, 164, 168, 168, 175, 175, 122, 180, 122, 122, 162, 122, 162, 177, 122, 122,
 161, 168, 161, 177, 161, 122, 168, 162, 122, 176, 168, 161, 130, 198, 195, 122,
 162, 122, 162, 168, 171, 169, 122, 121, 142, 169, 161, 130, 168, 169, 122, 163,
 164, 161, 122, 122, 168, 168, 122, 177, 168, 92, 168, 174, 122, 203, 161, 168,
 184, 161, 122, 168, 122, 121, 168, 122, 121, 168, 177, 168, 168, 162, 183, 168,
 168, 177, 121, 121, 168, 193, 94, 122, 172, 172, 162, 173, 165, 161, 181, 92,
 122, 122, 177, 130, 168, 171, 168, 122, 162, 122, 161, 122, 122, 177, 168, 122,
 177, 122, 168, 162, 122, 122, 164, 122, 168, 130, 168, 122, 121, 184, 177, 122,
 122, 92, 177, 177, 162, 160, 168, 121, 168, 122, 161, 168, 122, 122, 160, 177,
 92, 122, 177, 167, 167, 122, 167, 161, 162, 164, 161, 122, 122, 168, 176, 122,
 177, 160, 165, 168, 182, 92, 176, 122, 162, 113, 168, 178, 161, 168, 168, 177,
 186, 178, 169, 203, 161, 122, 122, 184, 122, 122, 161, 161, 122, 122, 185, 185,
 166, 122, 177, 168, 191, 177, 173, 130, 92, 164, 122, 180, 194, 194, 164, 193,
 176, 161, 169, 167, 177, 168, 122, 121, 177, 191, 122, 168, 122, 177, 122, 122,
 194, 191, 177, 122, 122, 190, 162, 161, 160, 130, 161, 161, 178, 166, 193, 122,
 122, 177, 177, 163, 171, 122, 177, 122, 122, 164, 162, 177, 164, 122, 177, 122,
 193, 190, 168, 177, 165, 167, 165, 164, 161, 177, 194, 195, 184, 92, 130, 113,
 164, 122, 121, 122, 198, 171, 164, 168, 160, 121, 177, 186, 176, 161, 164, 122,
 161, 177, 169, 170, 130, 130, 130, 174, 162, 191, 96, 191, 177, 121, 121, 165,
 164, 166, 178, 160, 122, 194, 122, 198, 122, 196, 177, 193, 177, 161, 122, 122,
 169, 168, 168, 193, 122, 162, 122, 190, 191, 177, 122, 177, 177, 160, 176, 164,
 177, 181, 130, 113, 122, 94, 168, 122, 121, 121, 168, 177, 166, 171, 198, 161,
 191, 122, 163, 161, 168, 168, 122, 122, 121, 177, 163, 162, 164, 122, 92, 177,
 191, 168, 121, 92, 163, 161, 181, 130, 96, 168, 168, 121, 161, 163, 122, 168,
 168, 171, 191, 203, 122, 177, 160, 168, 142, 122, 168, 191, 181, 168, 165, 163,
 177, 181, 162, 164, 121, 161, 126, 121, 177, 121, 168, 168, 177, 160, 163, 177,
 161, 161, 168, 92, 164, 161, 121, 161, 168, 122, 178, 166, 122, 122, 168, 164,
 121, 161, 161, 168, 168, 161, 122, 161, 177, 169, 92, 177, 171, 168, 177, 161,
 122, 94, 122, 122, 122, 181, 168, 122, 121, 122, 197, 162, 122, 113, 122, 122,
 122, 168, 160, 121, 168, 177, 161, 162, 122, 122, 185, 122, 160, 122, 163, 178,
 185, 161, 168, 177, 122, 122, 172, 122, 168, 164, 161, 122, 162, 122, 198, 122,
 177, 168, 177, 168, 161, 160, 122, 121, 122, 92, 122, 122, 122, 122, 121, 173,
 92, 122, 161, 177, 122, 96, 198, 181, 178, 168, 165, 168, 168, 122, 177, 178,
 130, 113, 130, 130, 160, 177, 122, 177, 166, 122, 161, 168, 166, 168, 122, 122,
 122, 122, 161, 122, 164, 177, 122, 97, 161, 178, 168, 161, 122, 177, 122, 122,
 169, 175, 153, 113, 113, 184, 162, 94, 130, 130, 169, 161, 177, 122, 162, 122,
 122, 121, 169, 122, 177, 122, 177, 122, 168, 168, 168, 191, 169, 168, 122, 122,
 161, 166, 161, 168, 166, 178, 168, 122, 161, 122, 161, 122, 178, 168, 177, 193,
 122, 177, 168, 188, 168, 122, 164, 122, 166, 177, 122, 162, 122, 122, 130, 168,
 153, 113, 184, 173, 160, 130, 113, 130, 130, 113, 130, 130, 160, 130, 168, 122,
 190, 163, 177, 165, 142, 166, 122, 165, 122, 178, 168, 177, 164, 162, 183, 160,
 177, 167, 177, 166, 122, 177, 178, 161, 177, 177, 178, 168, 168, 168, 178, 122,
 122, 122, 190, 122, 122, 161, 160, 163, 167, 176, 122, 168, 166, 122, 169, 168,
 130, 162, 169, 168, 178, 96, 177, 178, 161, 122, 168, 168, 122, 168, 178, 122,
 192, 122, 177, 122, 122, 121, 191, 177, 168, 163, 168, 196, 168, 130, 198, 169,
 179, 160, 153, 153, 153, 173, 161, 130, 130, 130, 130, 130, 130, 94, 130, 130,
 160, 130, 194, 122, 177, 161, 165, 122, 97, 164, 168, 160, 168, 166, 172, 177,
 168, 122, 198, 161, 161, 168, 168, 164, 177, 169, 122, 178, 164, 177, 168, 191,
 164, 177, 167, 166, 178, 168, 160, 179, 122, 122, 168, 177, 122, 122, 179, 162,
 122, 122, 122, 122, 166, 176, 169, 160, 122, 185, 90, 168, 176, 178, 165, 168,
 122, 122, 164, 122, 122, 174, 160, 162, 164, 181, 161, 162, 113, 153, 161, 113,
 130, 130, 130, 202, 130, 170, 130, 202, 130, 130, 92, 166, 161, 194, 177, 177,
 164, 177, 177, 161, 167, 177, 122, 167, 168, 177, 164, 177, 177, 168, 178, 121,
 168, 122, 171, 169, 163, 122, 176, 168, 182, 168, 168, 168, 168, 113, 161, 165,
 168, 168, 168, 122, 121, 161, 177, 122, 163, 161, 164, 178, 177, 121, 161, 121,
 178, 188, 122, 177, 168, 164, 175, 122, 122, 177, 177, 168, 168, 122, 177, 122,
 122, 121, 177, 122, 168, 122, 198, 161, 161, 172, 113, 162, 113, 94, 92, 92,
 130, 161, 130, 160, 121, 193, 178, 168, 177, 122, 172, 122, 177, 122, 168, 164,
 177, 177, 122, 177, 178, 122, 177, 121, 122, 162, 122, 161, 177, 177, 168, 121,
 122, 178, 161, 169, 168, 164, 168, 121, 191, 168, 177, 177, 177, 164, 122, 178,
 166, 166, 121, 168, 168, 176, 177, 168, 168, 122, 122, 171, 166, 177, 161, 161,
 198, 175, 160, 160, 178, 122, 177, 168, 178, 163, 177, 167, 178, 122, 122, 178,
 166, 177, 122, 177, 168, 168, 162, 177, 160, 113, 153, 153, 181, 92, 161, 130,
 130, 113, 113, 113, 130, 178, 113, 183, 113, 161, 178, 92, 160, 130, 161, 168,
 122, 164, 168, 177, 167, 177, 172, 168, 177, 167, 92, 177, 168, 165, 160, 165,
 168, 168, 166, 160, 168, 177, 160, 161, 168, 177, 121, 168, 168, 161, 177, 168,
 161, 168, 168, 121, 122, 198, 168, 192, 168, 180, 122, 171, 178, 169, 122, 168,
 122, 198, 180, 190, 163, 177, 166, 160, 188, 177, 178, 122, 177, 121, 122, 180,
 177, 166, 182, 172, 178, 121, 168, 122, 165, 122, 177, 177, 184, 181, 113, 162,
 90, 113, 169, 168, 130, 160, 96, 130, 130, 130, 153, 92, 92, 166, 178, 161,
 168, 178, 164, 168, 169, 122, 177, 168, 174, 168, 168, 122, 122, 161, 168, 160,
 178, 177, 160, 97, 168, 191, 171, 165, 176, 168, 168, 176, 168, 176, 121, 177,
 168, 167, 172, 168, 122, 168, 168, 176, 162, 168, 164, 122, 177, 168, 178, 178,
 160, 122, 168, 121, 168, 164, 168, 113, 164, 168, 167, 121, 122, 121, 167, 168,
 122, 163, 161, 142, 185, 160, 163, 162, 181, 178, 92, 130, 92, 113, 113, 130,
 130, 160, 177, 161, 168, 177, 168, 178, 121, 160, 195, 178, 168, 169, 177, 164,
 161, 177, 167, 171, 168, 162, 168, 168, 168, 172, 160, 180, 168, 122, 177, 165,
 177, 171, 121, 182, 168, 142, 168, 168, 168, 168, 122, 172, 172, 168, 161, 177,
 161, 188, 181, 121, 178, 177, 168, 165, 185, 121, 163, 178, 160, 177, 121, 122,
 177, 122, 181, 121, 164, 168, 168, 168, 166, 181, 184, 153, 160, 160, 113, 130,
 162, 130, 177, 160, 177, 122, 181, 164, 121, 121, 121, 177, 168, 122, 166, 177,
 168, 168, 161, 161, 122, 163, 177, 169, 121, 177, 164, 121, 160, 168, 177, 168,
 166, 177, 193, 203, 168, 177, 177, 160, 122, 122, 168, 166, 161, 168, 168, 121,
 168, 122, 142, 161, 177, 170, 178, 177, 168, 168, 177, 126, 161, 168, 161, 168,
 161, 174, 113, 162, 94, 92, 168, 161, 113, 130, 160, 92, 130, 161, 171, 178,
 122, 177, 160, 177, 122, 168, 164, 177, 161, 191, 160, 162, 168, 180, 165, 160,
 169, 166, 168, 168, 97, 168, 168, 122, 161, 160, 168, 177, 121, 163, 177, 177,
 169, 168, 121, 121, 168, 177, 168, 160, 168, 130, 181, 174, 169, 168, 142, 171,
 164, 163, 160, 121, 177, 160, 168, 168, 142, 168, 168, 121, 161, 177, 163, 164,
 161, 181, 121, 121, 161, 168, 177, 168, 163, 182, 160, 168, 177, 168, 161, 168,
 177, 178, 161, 121, 163, 164, 162, 161, 160, 168, 121, 121, 177, 171, 178, 178,
 168, 168, 161, 161, 162, 97, 161, 177, 178, 161, 178, 168, 171, 161, 168, 168,
 177, 177, 162, 168, 161, 161, 128, 92, 168, 168, 142, 121, 177, 164, 161, 161,
 168, 161, 177, 177, 121, 153, 164, 164, 168, 177, 121, 168, 183, 161, 161, 177,
 171, 177, 180, 168, 161, 92, 121, 177, 168, 168, 168, 164, 161, 172, 177, 113,
 122, 122, 173, 122, 206, 168, 161, 184, 177, 161, 161, 164, 177, 168, 161, 177,
 161, 168, 122, 168, 168, 163, 177, 167, 178, 167, 122, 177, 168, 121, 122, 177,
 161, 168, 168, 167, 161, 168, 192, 122, 168, 169, 177, 168, 122, 177, 121, 161,
 121, 168, 163, 181, 178, 168, 177, 160, 164, 169, 92, 178, 97, 164, 168, 121,
 177, 121, 122, 122, 122, 129, 122, 176, 161, 181, 122, 164, 161, 168, 164, 172,
 162, 161, 126, 181, 172, 162, 168, 126, 121, 169, 160, 122, 130, 162, 177, 121,
 178, 179, 166, 122, 165, 162, 122, 130, 168, 122, 122, 184, 168, 167, 168, 168,
 161, 168, 130, 130, 168, 178, 122, 177, 121, 168, 130, 166, 161, 161, 180, 177,
 177, 173, 177, 177, 142, 168, 168, 168, 162, 162, 167, 178, 162, 177, 188, 121,
 177, 113, 121, 167, 184, 122, 168, 122, 162, 162, 121, 181, 121, 177, 164, 122,
 142, 207, 130, 177, 177, 122, 121, 168, 168, 177, 168, 122, 177, 122, 181, 129,
 168, 161, 122, 122, 122, 130, 192, 129, 180, 130, 171, 122, 160, 161, 168, 113,
 168, 174, 168, 177, 168, 161, 177, 177, 168, 161, 179, 122, 121, 161, 162, 169,
 168, 162, 168, 167, 161, 130, 161, 177, 168, 166, 160, 168, 168, 96, 168, 177,
 168, 168, 177, 168, 177, 176, 185, 130, 121, 177, 161, 168, 168, 166, 162, 122,
 176, 122, 162, 122, 167, 185, 96, 113, 185, 166, 185, 169, 160, 168, 161, 176,
 168, 185, 130, 121, 169, 168, 176, 176, 176, 130, 185, 97, 171, 161, 176, 96,
 185, 160, 173, 171, 122, 90, 177, 198, 122, 160, 182, 177, 161, 170, 121, 177,
 122, 122, 122, 168, 161, 161, 185, 130, 92, 170, 166, 177, 168, 171, 121, 177,
 122, 161, 177, 161, 166, 122, 161, 122, 160, 171, 198, 176, 166, 122, 122, 122,
 122, 96, 113, 161, 130, 168, 168, 177, 122, 185, 122, 177, 161, 191, 160, 177,
 122, 168, 122, 178, 176, 160, 190, 161, 177, 174, 121, 177, 161, 122, 122, 160,
 168, 122, 122, 122, 168, 190, 190, 191, 122, 176, 168, 168, 122, 142, 168, 185,
 122, 161, 121, 165, 190, 191, 121, 164, 171, 122, 180, 122, 177, 168, 161, 174,
 161, 184, 172, 130, 130, 130, 130, 130, 92, 130, 179, 122, 97, 185, 122, 160,
 177, 169, 174, 122, 177, 92, 168, 168, 122, 122, 178, 122, 122, 122, 122, 122,
 168, 121, 191, 168, 122, 169, 177, 168, 161, 122, 122, 160, 122, 177, 160, 177,
 166, 177, 177, 122, 166, 122, 176, 122, 161, 178, 177, 122, 171, 178, 185, 160,
 176, 122, 122, 122, 161, 122, 161, 177, 122, 177, 175, 192, 177, 168, 192, 122,
 122, 169, 177, 122, 164, 96, 130, 130, 130, 168, 130, 130, 130, 130, 130, 161,
 168, 185, 160, 168, 166, 160, 160, 166, 168, 168, 177, 122, 122, 168, 176, 177,
 168, 191, 167, 164, 161, 161, 168, 122, 168, 165, 166, 122, 161, 168, 122, 178,
 168, 161, 168, 161, 160, 122, 163, 190, 177, 121, 122, 169, 168, 168, 176, 177,
 168, 176, 122, 167, 168, 122, 121, 168, 121, 190, 168, 122, 166, 122, 122, 177,
 168, 122, 168, 130, 181, 184, 130, 130, 130, 92, 130, 130, 92, 130, 170, 130,
 92, 130, 130, 130, 130, 92, 161, 163, 168, 122, 122, 160, 186, 161, 166, 177,
 185, 177, 168, 165, 178, 171, 122, 177, 168, 122, 122, 161, 121, 168, 122, 166,
 177, 160, 160, 161, 122, 168, 168, 122, 122, 121, 168, 168, 166, 168, 168, 194,
 168, 160, 166, 168, 168, 122, 168, 188, 122, 129, 97, 168, 122, 194, 122, 160,
 168, 192, 177, 122, 176, 122, 163, 177, 177, 181, 161, 184, 113, 130, 130, 130,
 130, 130, 92, 130, 170, 160, 130, 130, 130, 130, 176, 185, 177, 161, 96, 122,
 161, 160, 122, 168, 177, 122, 161, 177, 169, 163, 168, 168, 142, 177, 168, 176,
 165, 161, 168, 195, 190, 122, 122, 122, 177, 168, 177, 122, 169, 168, 164, 191,
 168, 122, 142, 168, 168, 178, 166, 168, 122, 122, 126, 177, 168, 166, 122, 177,
 166, 122, 177, 168, 169, 177, 169, 161, 121, 177, 121, 122, 169, 168, 122, 177,
 177, 122, 168, 122, 177, 121, 177, 122, 195, 122, 121, 122, 166, 168, 161, 161,
 177, 161, 160, 168, 163, 169, 161, 181, 181, 181, 175, 113, 173, 130, 130, 160,
 130, 130, 161, 113, 130, 153, 130, 210, 160, 121, 122, 121, 168, 169, 164, 180,
 122, 122, 177, 122, 122, 122, 121, 177, 168, 175, 160, 165, 121, 122, 178, 122,
 168, 168, 190, 168, 129, 168, 191, 92, 122, 177, 122, 177, 191, 194, 121, 168,
 168, 168, 161, 122, 190, 177, 168, 168, 164, 177, 121, 177, 161, 122, 169, 163,
 160, 177, 177, 166, 176, 168, 122, 164, 122, 160, 168, 122, 191, 177, 191, 122,
 168, 168, 177, 171, 168, 168, 168, 121, 177, 97, 161, 165, 161, 161, 122, 121,
 161, 168, 121, 191, 168, 161, 172, 168, 168, 168, 183, 164, 160, 162, 184, 202,
 181, 92, 113, 130, 161, 130, 179, 92, 168, 96, 161, 160, 113, 177, 168, 167,
 122, 161, 168, 177, 168, 92, 121, 168, 169, 177, 160, 168, 122, 121, 168, 165,
 177, 168, 122, 168, 168, 122, 168, 176, 161, 161, 122, 126, 161, 162, 177, 122,
 168, 192, 167, 177, 96, 160, 122, 167, 160, 168, 122, 174, 97, 167, 168, 177,
 177, 166, 122, 177, 121, 121, 168, 176, 177, 180, 177, 122, 121, 177, 191, 166,
 168, 122, 168, 122, 122, 169, 168, 130, 168, 160, 179, 160, 168, 172, 202, 130,
 130, 130, 170, 161, 130, 130, 173, 92, 179, 179, 92, 177, 142, 177, 177, 121,
 161, 168, 142, 161, 122, 168, 168, 142, 180, 166, 160, 177, 168, 177, 121, 121,
 168, 121, 122, 168, 163, 168, 122, 168, 177, 167, 177, 160, 163, 177, 168, 122,
 161, 196, 168, 169, 122, 122, 182, 160, 177, 168, 177, 164, 168, 161, 168, 168,
 122, 168, 121, 121, 170, 168, 177, 168, 161, 176, 176, 122, 121, 166, 168, 176,
 177, 122, 121, 176, 160, 168, 166, 168, 121, 168, 168, 177, 177, 160, 169, 121,
 168, 180, 161, 168, 160, 113, 130, 130, 161, 161, 161, 130, 161, 130, 168, 177,
 168, 188, 177, 177, 121, 168, 94, 191, 122, 164, 191, 121, 175, 177, 192, 121,
 97, 177, 192, 168, 121, 161, 169, 168, 162, 168, 168, 168, 177, 122, 122, 142,
 121, 161, 185, 168, 175, 161, 168, 168, 169, 160, 122, 168, 122, 191, 191, 168,
 142, 198, 178, 162, 122, 168, 142, 177, 190, 185, 160, 177, 166, 192, 122, 161,
 191, 181, 177, 177, 191, 168, 177, 121, 92, 161, 162, 92, 130, 160, 168, 163,
 171, 169, 168, 180, 121, 177, 171, 190, 177, 168, 178, 168, 168, 168, 191, 191,
 177, 121, 168, 122, 97, 163, 176, 161, 168, 122, 168, 160, 177, 168, 203, 168,
 122, 121, 122, 121, 168, 162, 178, 177, 177, 185, 191, 168, 168, 168, 168, 168,
 161, 130, 130, 160, 178, 121, 161, 161, 142, 160, 193, 142, 168, 168, 166, 121,
 122, 122, 168, 168, 121, 161, 168, 168, 177, 188, 161, 121, 121, 168, 169, 122,
 171, 121, 168, 181, 168, 164, 172, 168, 160, 162, 142, 168, 177, 164, 121, 168,
 177, 180, 161, 160, 168, 191, 188, 177, 161, 121, 168, 121, 168, 177, 168, 121,
 161, 122, 92, 161, 168, 121, 168, 177, 121, 168, 122, 122, 194, 121, 198, 121,
 177, 168, 168, 192, 168, 161, 178, 180, 126, 168, 168, 168, 172, 161, 161, 191,
 142, 168, 142, 168, 177, 185, 161, 191, 168, 166, 168, 168, 177, 161, 121, 168,
 168, 168, 168, 177, 177, 168, 168, 161, 177, 177, 177, 163, 122, 161, 162, 130,
 128, 121, 168, 161, 163, 177, 168, 168, 121, 161, 168, 168, 160, 191, 176, 168,
 168, 168, 168, 121, 171, 177, 168, 160, 168, 168, 168, 122, 90, 130, 164, 175,
 122, 168, 161, 161, 168, 174, 176, 161, 122, 160, 168, 161, 122, 121, 174, 170,
 130, 163, 168, 168, 168, 192, 177, 161, 161, 175, 122, 160, 161, 161, 122, 160,
 161, 168, 122, 168, 166, 176, 166, 162, 191, 122, 194, 162, 130, 130, 92, 168,
 160, 194, 161, 160, 188, 160, 160, 160, 161, 168, 161, 190, 122, 122, 169, 122,
 177, 166, 161, 122, 177, 168, 161, 192, 122, 186, 142, 179, 170, 170, 168, 161,
 170, 130, 130, 130, 160, 168, 168, 168, 122, 161, 176, 180, 160, 168, 168, 121,
 160, 177, 168, 177, 177, 163, 163, 168, 190, 122, 168, 173, 177, 180, 168, 186,
 168, 168, 168, 161, 176, 161, 130, 130, 130, 130, 161, 130, 130, 130, 161, 96,
 168, 198, 161, 168, 168, 160, 168, 185, 168, 122, 177, 168, 168, 122, 160, 168,
 168, 161, 168, 164, 191, 182, 177, 164, 161, 122, 96, 177, 191, 168, 168, 164,
 185, 161, 161, 185, 113, 130, 130, 168, 130, 122, 122, 168, 142, 160, 191, 168,
 177, 121, 168, 168, 161, 168, 122, 161, 168, 94, 161, 163, 160, 164, 168, 166,
 190, 166, 168, 160, 160, 160, 122, 161, 164, 161, 168, 160, 113, 161, 94, 161,
 94, 177, 168, 168, 168, 174, 171, 191, 161, 121, 209, 177, 122, 168, 122, 160,
 191, 160, 177, 168, 168, 113, 121, 164, 168, 121, 177, 161, 190, 168, 190, 168,
 177, 168, 178, 168, 122, 121, 122, 122, 176, 121, 168, 160, 121, 161, 122, 161,
 168, 160, 185, 170, 161, 160, 160, 160, 185, 162, 170, 168, 160, 122, 160, 161,
 177, 168, 168, 161, 122, 177, 168, 177, 172, 194, 122, 161, 163, 161, 160, 165,
 168, 161, 188, 161, 122, 113, 160, 168, 170, 122, 177, 177, 168, 168, 168, 122,
 166, 168, 193, 160, 168, 168, 161, 168, 169, 168, 168, 161, 122, 160, 161, 177,
 177, 121, 177, 166, 160, 185, 161, 160, 168, 122, 193, 161, 168, 168, 121, 177,
 177, 191, 168, 122, 171, 168, 168, 168, 121, 121, 168, 177, 164, 161, 122, 168,
 121, 160, 121, 164, 165, 122, 177, 113, 168, 171, 177, 168, 171, 160, 161, 121,
 169, 168, 168, 161, 168, 122, 121, 122, 168, 161, 161, 160, 142, 121, 122, 161,
 168, 168, 168, 161, 97, 153, 94, 92, 171, 167, 161, 121, 121, 168, 188, 180,
 204, 168, 168, 168, 161, 168, 122, 177, 164, 182, 168, 161, 168, 142, 160, 160,
 121, 161, 161, 177, 168, 160, 160, 163, 161, 168, 177, 121, 161, 166, 168, 177,
 161, 161, 168, 168, 163, 161, 168, 168, 169, 168, 122, 182, 122, 121, 160, 162,
 122, 130, 196, 92, 162, 122, 122, 130, 176, 176, 121, 122, 181, 122, 121, 167,
 198, 177, 177, 162, 168, 162, 121, 122, 122, 168, 168, 178, 122, 130, 164, 177,
 163, 161, 122, 177, 92, 163, 176, 160, 121, 122, 177, 122, 182, 122, 177, 122,
 171, 122, 122, 177, 161, 161, 179, 122, 164, 122, 168, 162, 168, 161, 166, 176,
 168, 162, 122, 168, 142, 130, 168, 177, 177, 122, 173, 177, 177, 121, 167, 166,
 122, 122, 172, 161, 176, 168, 168, 172, 168, 177, 130, 185, 168, 166, 177, 170,
 168, 168, 169, 177, 160, 168, 142, 168, 168, 161, 168, 171, 92, 168, 168, 170,
 113, 168, 121, 168, 168, 168, 168, 121, 177, 168, 168, 161, 122, 90, 177, 122,
 185, 164, 172, 92, 166, 168, 184, 130, 130, 184, 168, 161, 161, 168, 164, 168,
 126, 166, 122, 167, 122, 168, 178, 164, 130, 177, 168, 168, 177, 179, 122, 161,
 122, 168, 167, 161, 168, 162, 177, 122, 177, 122, 168, 181, 168, 92, 130, 177,
 169, 122, 172, 168, 168, 164, 168, 161, 185, 122, 168, 168, 184, 184, 130, 130,
 130, 130, 130, 166, 166, 161, 168, 169, 122, 121, 166, 166, 122, 121, 177, 168,
 168, 185, 163, 130, 182, 162, 161, 177, 168, 92, 165, 177, 168, 162, 173, 168,
 160, 168, 177, 176, 92, 130, 122, 167, 177, 171, 161, 122, 122, 165, 166, 113,
 92, 130, 166, 168, 164, 122, 168, 177, 163, 122, 186, 186, 174, 168, 175, 181,
 168, 166, 177, 168, 169, 177, 121, 122, 179, 170, 177, 177, 168, 162, 122, 122,
 168, 160, 168, 177, 121, 121, 161, 161, 160, 168, 168, 161, 168, 166, 142, 172,
 190, 168, 192, 161, 161, 161, 162, 122, 177, 168, 168, 168, 92, 177, 177, 177,
 166, 168, 168, 113, 92, 168, 177, 177, 121, 177, 180, 177, 166, 130, 177, 166,
 121, 163, 121, 168, 94, 121, 168, 171, 121, 162, 121, 121, 177, 168, 185, 168,
 171, 177, 168, 177, 122, 177, 188, 122, 168, 122, 168, 122, 161, 161, 192, 160,
 162, 130, 168, 177, 194, 177, 122, 191, 193, 92, 92, 130, 163, 168, 163, 190,
 177, 168, 166, 161, 168, 171, 177, 203, 97, 122, 163, 176, 168, 191, 130, 173,
 130, 92, 122, 122, 168, 177, 168, 176, 168, 191, 130, 169, 177, 164, 168, 177,
 122, 161, 165, 168, 161, 177, 177, 168, 167, 209, 122, 177, 191, 122, 172, 209,
 179, 130, 177, 177, 168, 160, 191, 168, 168, 192, 168, 168, 168, 191, 122, 161,
 122, 163, 160, 191, 203, 165, 193, 166, 168, 192, 121, 168, 161, 122, 142, 160,
 92, 113, 130, 160, 177, 177, 168, 193, 178, 193, 177, 163, 168, 191, 121, 177,
 177, 191, 161, 122, 177, 122, 122, 191, 168, 122, 176, 168, 168, 97, 92, 130,
 130, 182, 160, 183, 160, 160, 168, 160, 161, 160, 166, 190, 160, 168, 160, 160,
 194, 194, 122, 168, 177, 122, 190, 161, 190, 177, 190, 191, 192, 177, 192, 188,
 192, 177, 178, 122, 122, 122, 122, 94, 203, 163, 121, 161, 179, 161, 161, 121,
 191, 122, 168, 193, 191, 160, 177, 163, 160, 160, 168, 191, 161, 177, 168, 168,
 168, 177, 177, 160, 168, 122, 160, 192, 161, 122, 122, 122, 122, 163, 122, 122,
 198, 161, 191, 142, 121, 203, 164, 177, 193, 121, 121, 163, 160, 176, 177, 121,
 169, 177, 177, 178, 160, 168, 175, 130, 92, 168, 160, 161, 168, 168, 122, 168,
 176, 166, 203, 122, 161, 177, 177, 192, 168, 191, 168, 122, 160, 160, 130, 162,
 166, 162, 177, 161, 168, 168, 161, 168, 188, 163, 177, 160, 190, 161, 122, 188,
 177, 191, 181, 188, 160, 194, 171, 122, 190, 176, 191, 177, 161, 168, 164, 177,
 121, 177, 191, 161, 160, 191, 168, 168, 168, 204, 185, 177, 161, 121, 168, 188,
 168, 168, 168, 168, 161, 168, 183, 161, 163, 164, 121, 168, 163, 161, 161, 121,
 163, 161, 130, 163, 121, 168, 97, 168, 191, 168, 188, 177, 122, 168, 166, 177,
 122, 168, 122, 122, 176, 168, 122, 153, 177, 142, 162, 164, 168, 161, 165, 189,
 153, 153, 153, 161, 166, 168, 169, 122, 153, 161, 162, 177, 162, 168, 168, 166,
 168, 195, 168, 178, 122, 153, 164, 168, 168, 161, 161, 168, 142, 169, 172, 185,
 168, 165, 177, 167, 168, 121, 177, 177, 122, 170, 122, 195, 169, 168, 172, 122,
 162, 177, 97, 196, 164, 122, 121, 162, 122, 176, 177, 122, 122, 96, 168, 166,
 122, 122, 122, 122, 94, 170, 162, 122, 122, 177, 165, 175, 113, 171, 166, 177,
 166, 161, 160, 162, 181, 130, 172, 191, 166, 181, 172, 169, 122, 172, 176, 122,
 164, 205, 162, 128, 122, 160, 161, 164, 161, 122, 169, 165, 122, 121, 164, 177,
 153, 164, 121, 168, 178, 122, 122, 172, 161, 113, 122, 142, 168, 172, 160, 191,
 121, 164, 170, 113, 202, 183, 121, 178, 122, 166, 193, 162, 162, 177, 177, 122,
 168, 164, 113, 179, 168, 162, 122, 121, 92, 181, 121, 122, 168, 94, 198, 122,
 177, 122, 174, 164, 167, 177, 130, 130, 168, 176, 169, 161, 162, 122, 160, 130,
 130, 130, 171, 169, 176, 122, 161, 168, 161, 92, 168, 122, 130, 92, 130, 130,
 185, 186, 122, 122, 174, 122, 168, 92, 122, 122, 177, 168, 122, 122, 122, 177,
 177, 177, 122, 175, 166, 122, 162, 122, 170, 130, 169, 168, 177, 122, 177, 177,
 168, 168, 165, 161, 122, 122, 130, 177, 122, 121, 168, 122, 182, 168, 169, 177,
 171, 177, 122, 169, 166, 161, 185, 166, 130, 113, 130, 130, 162, 168, 164, 177,
 122, 176, 121, 142, 122, 168, 168, 168, 168, 166, 121, 168, 165, 168, 178, 169,
 190, 169, 163, 166, 162, 130, 92, 163, 177, 142, 166, 142, 166, 121, 161, 177,
 185, 168, 162, 171, 168, 166, 177, 130, 130, 192, 168, 166, 177, 177, 177, 122,
 122, 121, 122, 177, 122, 166, 190, 142, 168, 176, 130, 130, 160, 166, 92, 168,
 167, 168, 177, 166, 169, 166, 161, 161, 176, 162, 171, 198, 166, 168, 130, 130,
 90, 162, 121, 166, 164, 164, 142, 178, 178, 177, 162, 162, 122, 170, 203, 160,
 168, 160, 121, 168, 170, 162, 122, 168, 142, 177, 168, 161, 167, 92, 130, 171,
 168, 121, 142, 130, 191, 171, 94, 172, 181, 121, 178, 130, 121, 177, 171, 174,
 180, 171, 121, 160, 182, 168, 172, 161, 122, 168, 153, 122, 121, 122, 122, 168,
 181, 177, 96, 181, 122, 162, 122, 122, 169, 168, 168, 169, 162, 162, 122, 168,
 198, 130, 168, 122, 161, 177, 169, 161, 161, 167, 142, 177, 177, 177, 168, 162,
 162, 160, 162, 164, 166, 163, 177, 162, 162, 161, 177, 168, 92, 177, 122, 168,
 142, 130, 130, 161, 169, 168, 92, 172, 178, 181, 121, 168, 161, 177, 168, 122,
 161, 164, 122, 121, 168, 176, 122, 161, 122, 177, 122, 164, 163, 169, 176, 130,
 130, 130, 122, 168, 176, 161, 186, 184, 130, 164, 168, 122, 121, 168, 121, 122,
 162, 121, 161, 121, 121, 169, 177, 121, 162, 168, 142, 161, 177, 168, 122, 96,
 177, 166, 122, 168, 122, 168, 162, 168, 122, 176, 168, 178, 190, 161, 122, 161,
 162, 122, 92, 168, 165, 168, 164, 169, 165, 122, 177, 122, 153, 130, 163, 160,
 168, 168, 177, 168, 162, 177, 161, 162, 161, 166, 166, 178, 162, 168, 198, 169,
 122, 161, 166, 168, 172, 178, 175, 168, 176, 122, 161, 160, 92, 166, 162, 166,
 161, 168, 168, 168, 177, 166, 176, 122, 122, 177, 122, 168, 122, 177, 171, 161,
 186, 130, 164, 179, 168, 177, 177, 167, 161, 161, 177, 168, 168, 191, 177, 171,
 130, 130, 177, 161, 168, 168, 177, 162, 160, 168, 167, 122, 171, 161, 171, 177,
 177, 122, 176, 122, 164, 169, 122, 177, 169, 168, 171, 122, 176, 168, 168, 168,
 162, 161, 182, 162, 164, 161, 161, 160, 160, 122, 163, 160, 168, 176, 165, 122,
 166, 168, 168, 168, 176, 185, 92, 97, 168, 168, 161, 121, 176, 166, 169, 168,
 161, 122, 130, 94, 162, 177, 164, 168, 160, 168, 177, 168, 168, 168, 121, 176,
 169, 168, 166, 168, 161, 122, 161, 176, 168, 173, 176, 168, 122, 121, 162, 163,
 122, 177, 168, 122, 168, 166, 178, 168, 161, 172, 168, 122, 121, 169, 163, 122,
 161, 161, 168, 182, 168, 160, 161, 142, 92, 177, 168, 94, 168, 167, 168, 168,
 168, 164, 162, 97, 168, 177, 161, 122, 168, 177, 142, 122, 122, 161, 177, 164,
 177, 92, 122, 122, 162, 122, 163, 167, 168, 122, 162, 130, 166, 122, 122, 121,
 177, 177, 168, 122, 163, 161, 130, 168, 166, 168, 168, 177, 178, 96, 170, 130,
 130, 130, 122, 168, 161, 177, 177, 161, 160, 166, 161, 161, 169, 176, 177, 168,
 168, 166, 165, 168, 169, 181, 130, 130, 170, 161, 130, 161, 170, 176, 160, 96,
 142, 177, 177, 166, 161, 122, 165, 122, 168, 185, 168, 168, 211, 176, 177, 168,
 176, 168, 121, 168, 122, 177, 161, 176, 96, 170, 202, 130, 170, 160, 130, 113,
 130, 92, 160, 171, 182, 165, 161, 174, 177, 168, 168, 160, 166, 168, 176, 195,
 185, 160, 166, 160, 160, 130, 130, 130, 161, 92, 92, 92, 177, 122, 177, 161,
 177, 162, 168, 164, 177, 168, 160, 92, 177, 168, 166, 122, 122, 185, 166, 121,
 168, 168, 113, 92, 113, 92, 161, 130, 161, 168, 163, 168, 122, 161, 177, 97,
 168, 198, 161, 168, 168, 168, 178, 165, 160, 96, 164, 161, 122, 186, 122, 177,
 161, 122, 161, 169, 177, 178, 168, 122, 176, 168, 167, 130, 130, 162, 177, 176,
 168, 166, 168, 122, 177, 185, 161, 122, 177, 121, 178, 168, 177, 177, 161, 172,
 176, 174, 166, 176, 185, 113, 94, 161, 160, 170, 121, 191, 121, 162, 169, 162,
 161, 122, 161, 168, 168, 122, 181, 163, 177, 166, 122, 122, 177, 168, 191, 168,
 122, 178, 163, 163, 167, 176, 164, 94, 160, 130, 142, 177, 161, 168, 168, 177,
 177, 177, 168, 168, 162, 168, 162, 142, 122, 168, 177, 161, 122, 168, 160, 121,
 160, 160, 166, 177, 169, 128, 162, 176, 161, 168, 176, 191, 168, 178, 168, 177,
 162, 122, 168, 92, 168, 185, 163, 181, 161, 168, 161, 161, 177, 161, 121, 92,
 177, 178, 178, 185, 168, 161, 183, 168, 161, 142, 164, 168, 177, 168, 166, 162,
 164, 168, 161, 168, 185, 177, 142, 177, 168, 177, 121, 121, 121, 177, 160, 168,
 161, 177, 160, 94, 90, 177, 94, 161, 168, 168, 122, 90, 175, 177, 122, 177,
 122, 122, 168, 92, 177, 177, 176, 121, 122, 122, 177, 177, 168, 161, 92, 177,
 121, 177, 168, 167, 177, 142, 122, 122, 163, 160, 122, 192, 192, 122, 122, 169,
 122, 168, 175, 168, 168, 122, 161, 166, 122, 177, 168, 177, 161, 122, 161, 130,
 168, 160, 177, 168, 168, 161, 161, 202, 130, 177, 122, 162, 177, 168, 163, 121,
 175, 122, 168, 160, 184, 202, 160, 160, 168, 161, 167, 177, 162, 121, 121, 122,
 168, 201, 168, 177, 177, 177, 177, 168, 177, 160, 185, 177, 177, 172, 161, 160,
 168, 177, 168, 161, 168, 160, 121, 122, 177, 163, 121, 177, 168, 168, 121, 164,
 178, 188, 168, 122, 177, 161, 168, 168, 177, 122, 169, 166, 161, 122, 122, 121,
 122, 122, 162, 173, 163, 168, 179, 164, 171, 122, 204, 122, 160, 185, 168, 177,
 161, 122, 122, 161, 163, 165, 177, 161, 122, 161, 164, 161, 168, 177, 177, 122,
 177, 181, 163, 169, 122, 164, 122, 122, 161, 122, 177, 166, 178, 166, 168, 130,
 184, 163, 161, 161, 94, 161, 168, 168, 166, 161, 168, 122, 162, 130, 92, 161,
 122, 92, 166, 166, 168, 126, 170, 164, 121, 164, 177, 122, 177, 122, 184, 161,
 168, 177, 168, 168, 122, 177, 92, 165, 178, 180, 122, 177, 121, 161, 176, 121,
 122, 162, 168, 130, 92, 161, 168, 162, 168, 161, 161, 177, 161, 163, 121, 177,
 177, 121, 181, 130, 162, 162, 183, 122, 164, 166, 163, 122, 122, 122, 172, 122,
 121, 161, 181, 153, 177, 163, 122, 177, 177, 198, 168, 97, 171, 121, 121, 181,
 113, 130, 92, 161, 168, 162, 177, 122, 168, 162, 168, 168, 177, 162, 92, 177,
 171, 121, 121, 113, 161, 182, 161, 177, 168, 121, 164, 121, 168, 177, 168, 161,
 165, 168, 161, 161, 122, 177, 122, 130, 166, 122, 122, 168, 161, 198, 177, 122,
 166, 122, 164, 175, 122, 177, 166, 168, 122, 168, 177, 177, 168, 130, 92, 168,
 177, 174, 122, 196, 177, 122, 169, 169, 122, 168, 161, 92, 130, 130, 177, 122,
 176, 161, 168, 177, 161, 130, 130, 161, 185, 121, 121, 168, 166, 130, 121, 121,
 172, 168, 168, 166, 168, 177, 178, 168, 168, 162, 121, 163, 182, 161, 168, 169,
 168, 168, 160, 153, 121, 121, 162, 121, 172, 163, 121, 122, 164, 181, 162, 172,
 161, 177, 181, 172, 161, 181, 130, 183, 168, 122, 172, 163, 172, 198, 130, 122,
 122, 181, 172, 122, 168, 122, 167, 160, 162, 163, 198, 177, 164, 122, 168, 122,
 181, 164, 161, 161, 162, 161, 121, 168, 181, 122, 122, 177, 161, 176, 163, 122,
 168, 168, 113, 130, 167, 168, 169, 162, 167, 168, 167, 175, 94, 161, 168, 165,
 168, 122, 168, 168, 174, 130, 161, 161, 178, 122, 168, 122, 161, 168, 122, 163,
 122, 161, 168, 177, 185, 167, 122, 182, 169, 163, 166, 166, 122, 191, 176, 177,
 177, 166, 168, 167, 177, 178, 181, 161, 185, 205, 130, 168, 130, 162, 130, 162,
 177, 164, 160, 160, 168, 167, 121, 166, 178, 122, 168, 122, 165, 121, 177, 122,
 122, 122, 122, 161, 122, 163, 122, 161, 185, 161, 130, 130, 92, 202, 161, 92,
 190, 168, 179, 168, 177, 178, 177, 142, 161, 177, 162, 161, 198, 177, 122, 163,
 178, 167, 166, 177, 178, 122, 168, 176, 168, 173, 113, 170, 92, 183, 130, 92,
 130, 161, 168, 161, 171, 185, 181, 121, 168, 162, 168, 121, 168, 167, 177, 121,
 166, 177, 172, 161, 122, 122, 177, 122, 178, 178, 200, 177, 167, 122, 164, 181,
 171, 122, 170, 160, 168, 162, 130, 130, 130, 130, 202, 130, 166, 122, 161, 177,
 162, 122, 163, 161, 122, 177, 162, 168, 122, 168, 162, 162, 162, 162, 168, 161,
 121, 122, 164, 161, 121, 162, 122, 122, 162, 121, 177, 178, 169, 161, 168, 153,
 160, 130, 183, 130, 177, 168, 162, 162, 168, 176, 166, 171, 168, 167, 168, 168,
 121, 96, 168, 168, 121, 167, 169, 168, 177, 121, 166, 168, 161, 181, 130, 92,
 168, 185, 177, 178, 177, 162, 181, 169, 177, 177, 163, 168, 174, 168, 176, 168,
 178, 177, 177, 177, 162, 168, 177, 122, 161, 177, 168, 166, 176, 142, 177, 166,
 168, 142, 198, 113, 113, 94, 130, 113, 161, 177, 161, 163, 168, 168, 126, 167,
 177, 121, 168, 142, 161, 177, 166, 122, 177, 168, 122, 121, 177, 168, 161, 161,
 168, 162, 161, 177, 164, 160, 162, 142, 169, 177, 162, 168, 168, 121, 121, 122,
 169, 130, 160, 121, 160, 168, 162, 168, 168, 168, 177, 161, 121, 122, 161, 113,
 142, 163, 162, 177, 178, 162, 172, 168, 181, 177, 177, 177, 177, 163, 164, 142,
 121, 162, 161, 171, 121, 142, 168, 177, 161, 177, 168, 168, 121, 163, 171, 168,
 182, 161, 171, 122, 179, 178, 161, 161, 168, 177, 168, 179, 174, 176, 153, 168,
 168, 178, 113, 198, 168, 168, 163, 164, 168, 122, 168, 181, 168, 178, 160, 162,
 113, 185, 122, 161, 177, 122, 168, 122, 165, 161, 161, 181, 179, 130, 166, 122,
 164, 178, 167, 168, 184, 122, 163, 198, 178, 161, 130, 113, 94, 113, 186, 168,
 164, 122, 165, 122, 168, 97, 162, 164, 160, 122, 177, 177, 166, 169, 122, 177,
 113, 130, 172, 161, 164, 167, 161, 174, 166, 163, 122, 168, 185, 174, 142, 162,
 168, 168, 178, 163, 177, 176, 122, 166, 113, 176, 163, 161, 169, 171, 121, 122,
 122, 161, 142, 161, 92, 92, 163, 121, 185, 162, 168, 162, 168, 160, 168, 169,
 97, 168, 178, 160, 178, 163, 178, 168, 169, 94, 181, 122, 160, 168, 121, 161,
 121, 168, 121, 177, 121, 121, 121, 188, 191, 171, 122, 121, 168, 121, 168, 177,
 121, 177, 177, 177, 121, 142, 177, 121, 180, 121, 121, 121, 142, 177, 177, 168,
 122, 121, 122, 162, 161, 160, 162, 130, 168, 168, 162, 122, 180, 164, 121, 122,
 121, 171, 142, 121, 161, 180, 168, 161, 168, 121, 180, 168, 171, 177, 177, 178,
 171, 177, 121, 121, 121, 180, 121, 177, 164, 161, 168, 113, 181, 163, 178, 178,
 121, 177, 168, 177, 168, 97, 178, 164, 168, 164, 163, 142, 177, 163, 121, 168,
 161, 121, 121, 178, 161, 162, 121, 177, 121, 168, 191, 168, 161, 168, 122, 168,
 171, 121, 121, 121, 161, 181, 196, 130, 164, 121, 177, 177, 168, 178, 161, 191,
 168, 171, 162, 177, 168, 177, 177, 161, 177, 172, 161, 164, 177, 177, 194, 121,
 161, 171, 168, 121, 168, 161, 177, 163, 161, 181, 113, 113, 121, 177, 171, 178,
 126, 168, 121, 178, 160, 92, 166, 177, 160, 168, 177, 172, 121, 121, 167, 178,
 142, 121, 121, 163, 121, 121, 164, 177, 121, 177, 121, 121, 168, 121, 121, 121,
 168, 168, 177, 162, 177, 177, 177, 121, 161, 168, 121, 180, 177, 163, 177, 172,
 160, 181, 142, 160, 94, 113, 195, 177, 121, 171, 121, 168, 172, 121, 121, 168,
 121, 180, 164, 126, 172, 163, 177, 168, 121, 121, 177, 164, 121, 164, 168, 121,
 168, 177, 142, 168, 121, 163, 177, 168, 161, 171, 177, 121, 161, 160, 160, 161,
 164, 181, 161, 168, 113, 113, 92, 160, 171, 121, 121, 178, 168, 168, 168, 168,
 171, 171, 178, 168, 168, 191, 168, 177, 92, 161, 168, 121, 177, 188, 121, 180,
 177, 180, 178, 121, 168, 168, 181, 163, 162, 168, 168, 121, 164, 177, 121, 188,
 168, 121, 142, 177, 97, 142, 177, 121, 168, 142, 178, 167, 168, 121, 121, 171,
 168, 122, 168, 121, 177, 171, 121, 192, 97, 168, 113, 113, 168, 181, 162, 161,
 177, 168, 188, 168, 121, 121, 178, 168, 177, 142, 142, 161, 168, 181, 121, 177,
 168, 188, 177, 168, 161, 182, 181, 153, 168, 121, 121, 188, 161, 121, 163, 177,
 180, 161, 168, 171, 168, 168, 168, 168, 177, 121, 168, 178, 121, 142, 177, 172,
 168, 177, 122, 113, 161, 161, 177, 177, 178, 181, 177, 168, 121, 177, 172, 121,
 113, 177, 172, 121, 142, 177, 121, 168, 191, 168, 177, 165, 121, 162, 164, 170,
 130, 130, 130, 130, 170, 130, 130, 130, 130, 130, 130, 130, 170, 130, 92, 130,
 130, 130, 130, 130, 92, 130, 130, 130, 130, 130, 170, 92, 92, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 130, 170, 130, 130, 130, 130, 130, 130, 130, 170,
 130, 130, 130, 130, 130, 130, 92, 130, 130, 130, 130, 130, 130, 130, 130, 170,
 130, 130, 130, 130, 92, 130, 130, 130, 130, 130, 130, 130, 92, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 92, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 170, 130, 130, 130, 92, 130, 130, 130, 130, 130,
 92, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 92, 130,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 122, 94, 122, 168, 122, 164, 162, 171, 177, 177,
 160, 160, 130, 177, 176, 167, 161, 163, 97, 94, 168, 168, 121, 178, 172, 177,
 122, 167, 182, 182, 122, 122, 92, 130, 167, 161, 130, 177, 177, 177, 168, 169,
 178, 166, 173, 177, 162, 177, 177, 178, 167, 169, 122, 180, 168, 177, 122, 161,
 121, 174, 122, 168, 130, 121, 168, 121, 172, 122, 168, 168, 168, 177, 166, 177,
 162, 130, 113, 178, 161, 121, 178, 178, 121, 168, 122, 171, 122, 177, 122, 163,
 162, 177, 168, 160, 122, 168, 177, 163, 92, 161, 122, 168, 177, 167, 122, 130,
 168, 166, 177, 172, 122, 168, 177, 185, 121, 121, 162, 92, 168, 177, 172, 169,
 185, 168, 122, 168, 163, 168, 142, 168, 122, 122, 168, 168, 176, 122, 168, 176,
 177, 122, 168, 177, 161, 122, 181, 168, 162, 168, 165, 168, 122, 168, 190, 177,
 168, 168, 121, 161, 122, 122, 161, 168, 130, 92, 92, 177, 168, 160, 168, 190,
 122, 122, 168, 177, 92, 166, 167, 160, 177, 122, 168, 180, 177, 168, 176, 177,
 122, 96, 177, 169, 168, 168, 161, 168, 168, 121, 163, 169, 122, 177, 177, 177,
 122, 122, 160, 122, 169, 122, 122, 177, 163, 183, 164, 169, 122, 176, 177, 177,
 122, 171, 169, 162, 166, 122, 166, 122, 122, 169, 161, 168, 169, 163, 177, 177,
 90, 178, 130, 161, 177, 170, 176, 130, 169, 185, 185, 161, 177, 183, 163, 160,
 177, 170, 92, 122, 177, 166, 122, 166, 130, 177, 162, 175, 163, 122, 177, 122,
 164, 161, 130, 211, 164, 161, 122, 168, 168, 161, 122, 130, 130, 130, 161, 168,
 168, 168, 169, 161, 170, 92, 121, 161, 122, 161, 122, 160, 168, 168, 121, 181,
 164, 172, 153, 160, 177, 161, 163, 168, 181, 130, 173, 161, 168, 162, 161, 121,
 121, 176, 121, 121, 181, 177, 142, 121, 168, 178, 161, 161, 161, 121, 121, 122,
 170, 162, 168, 130, 122, 121, 122, 122, 162, 122, 168, 122, 122, 161, 164, 168,
 168, 161, 168, 169, 161, 168, 122, 161, 169, 168, 169, 122, 166, 122, 162, 179,
 130, 122, 122, 168, 173, 122, 164, 163, 161, 122, 122, 176, 181, 167, 185, 122,
 161, 122, 122, 161, 122, 168, 160, 170, 177, 162, 122, 161, 170, 170, 130, 130,
 130, 130, 185, 122, 122, 168, 175, 168, 177, 168, 168, 161, 122, 166, 122, 177,
 168, 168, 164, 161, 177, 177, 169, 166, 177, 167, 122, 122, 185, 169, 122, 161,
 177, 122, 161, 168, 122, 122, 168, 130, 130, 170, 130, 130, 170, 176, 164, 169,
 176, 122, 166, 176, 122, 168, 174, 161, 122, 177, 166, 168, 169, 122, 177, 161,
 168, 168, 122, 163, 161, 121, 122, 198, 121, 175, 122, 162, 94, 130, 170, 130,
 130, 130, 170, 130, 179, 168, 176, 163, 192, 168, 186, 180, 162, 168, 166, 168,
 162, 168, 168, 121, 171, 168, 92, 177, 161, 121, 160, 126, 166, 168, 161, 122,
 171, 184, 170, 113, 160, 162, 130, 94, 130, 121, 177, 161, 162, 168, 122, 92,
 161, 161, 160, 168, 168, 164, 169, 177, 179, 161, 166, 122, 176, 168, 121, 168,
 122, 122, 177, 169, 122, 122, 94, 162, 92, 170, 170, 168, 168, 161, 168, 181,
 166, 177, 168, 161, 168, 122, 121, 166, 162, 166, 161, 121, 161, 174, 169, 177,
 122, 122, 168, 97, 169, 161, 168, 177, 121, 122, 122, 130, 170, 173, 130, 122,
 122, 164, 169, 178, 163, 162, 177, 168, 122, 168, 122, 177, 168, 168, 162, 122,
 162, 130, 161, 172, 161, 178, 164, 168, 176, 168, 121, 176, 122, 122, 177, 168,
 121, 161, 177, 165, 113, 94, 185, 168, 122, 142, 179, 168, 168, 161, 177, 161,
 178, 168, 177, 122, 177, 180, 94, 168, 181, 168, 122, 166, 168, 121, 121, 121,
 122, 170, 122, 176, 168, 177, 122, 168, 172, 142, 166, 162, 185, 121, 164, 171,
 168, 178, 168, 113, 161, 177, 161, 177, 121, 178, 142, 177, 92, 177, 177, 121,
 178, 177, 97, 122, 182, 121, 168, 122, 121, 168, 122, 162, 176, 122, 168, 160,
 162, 162, 177, 122, 122, 162, 163, 168, 177, 177, 121, 122, 122, 162, 122, 177,
 176, 167, 169, 164, 185, 122, 130, 121, 121, 142, 121, 168, 122, 122, 181, 162,
 169, 168, 122, 164, 176, 168, 178, 113, 172, 164, 163, 122, 122, 177, 122, 122,
 168, 192, 176, 130, 161, 168, 94, 161, 176, 172, 122, 122, 122, 179, 113, 185,
 130, 130, 177, 167, 166, 122, 122, 122, 167, 122, 177, 130, 168, 168, 170, 168,
 180, 161, 168, 162, 166, 191, 162, 122, 161, 185, 161, 176, 161, 92, 177, 166,
 168, 177, 168, 168, 94, 168, 177, 168, 169, 121, 167, 168, 177, 113, 168, 167,
 162, 168, 172, 177, 180, 160, 121, 162, 167, 168, 181, 178, 168, 177, 122, 122,
 130, 121, 122, 130, 166, 168, 198, 142, 180, 170, 170, 163, 168, 166, 122, 166,
 177, 162, 130, 177, 166, 168, 161, 182, 130, 162, 166, 122, 161, 122, 192, 185,
 168, 166, 122, 168, 177, 161, 162, 130, 166, 122, 191, 177, 173, 122, 168, 122,
 177, 166, 168, 171, 166, 122, 186, 177, 166, 192, 174, 167, 122, 122, 192, 122,
 176, 122, 164, 122, 166, 168, 168, 190, 122, 122, 177, 121, 191, 122, 176, 197,
 168, 130, 168, 168, 179, 113, 162, 130, 130, 161, 170, 130, 130, 130, 130, 170,
 163, 122, 122, 169, 122, 192, 168, 122, 179, 178, 162, 122, 169, 161, 122, 122,
 166, 165, 163, 169, 166, 122, 122, 121, 177, 161, 177, 167, 168, 177, 160, 176,
 168, 122, 168, 178, 167, 168, 177, 174, 161, 167, 178, 167, 160, 193, 191, 94,
 177, 190, 122, 122, 122, 122, 169, 166, 166, 122, 162, 163, 185, 168, 184, 130,
 161, 130, 161, 92, 130, 130, 178, 122, 172, 168, 170, 166, 167, 163, 177, 164,
 168, 164, 177, 181, 168, 168, 168, 185, 122, 168, 168, 122, 166, 166, 162, 165,
 162, 122, 142, 166, 122, 122, 122, 177, 122, 122, 166, 168, 166, 182, 161, 168,
 122, 168, 177, 176, 177, 178, 173, 192, 168, 122, 121, 168, 168, 177, 177, 122,
 169, 192, 122, 177, 176, 162, 177, 163, 181, 92, 130, 130, 130, 92, 130, 130,
 130, 130, 160, 179, 130, 130, 170, 130, 130, 130, 130, 130, 130, 130, 130, 170,
 162, 161, 161, 180, 168, 178, 168, 122, 176, 161, 168, 122, 169, 166, 168, 177,
 164, 168, 162, 168, 164, 175, 176, 178, 168, 122, 121, 168, 168, 177, 122, 168,
 168, 160, 176, 169, 177, 177, 121, 168, 190, 177, 178, 166, 174, 177, 122, 181,
 169, 161, 121, 168, 168, 168, 177, 171, 167, 192, 165, 122, 182, 164, 168, 168,
 185, 202, 130, 130, 130, 113, 130, 173, 130, 170, 130, 92, 130, 122, 182, 177,
 166, 122, 168, 168, 168, 122, 168, 166, 168, 191, 122, 168, 122, 160, 178, 166,
 162, 177, 161, 198, 176, 168, 165, 168, 167, 168, 161, 168, 122, 166, 168, 169,
 169, 185, 168, 168, 168, 185, 161, 168, 177, 122, 166, 180, 168, 160, 168, 121,
 122, 122, 122, 168, 121, 168, 177, 113, 176, 192, 168, 178, 177, 122, 168, 168,
 161, 166, 161, 122, 122, 160, 166, 142, 161, 168, 188, 169, 122, 122, 122, 166,
 168, 166, 168, 178, 160, 162, 160, 161, 179, 162, 92, 168, 170, 130, 161, 161,
 153, 160, 113, 168, 170, 130, 170, 130, 130, 180, 181, 168, 121, 168, 160, 177,
 168, 122, 168, 168, 168, 142, 168, 168, 122, 177, 168, 168, 169, 122, 160, 168,
 168, 161, 168, 168, 168, 177, 169, 177, 163, 121, 163, 168, 168, 177, 178, 164,
 168, 166, 177, 160, 168, 160, 177, 122, 163, 166, 166, 122, 174, 168, 168, 168,
 177, 122, 172, 122, 163, 177, 121, 177, 168, 169, 162, 122, 122, 169, 178, 180,
 177, 175, 160, 166, 177, 122, 166, 142, 166, 178, 165, 161, 162, 177, 168, 160,
 160, 162, 169, 161, 181, 162, 168, 130, 170, 130, 92, 202, 130, 168, 185, 168,
 121, 168, 163, 163, 180, 164, 160, 185, 168, 122, 168, 168, 122, 168, 171, 178,
 168, 165, 168, 160, 168, 161, 162, 168, 177, 177, 177, 168, 168, 172, 168, 166,
 168, 177, 122, 161, 166, 161, 168, 161, 122, 167, 166, 180, 121, 174, 182, 122,
 188, 167, 191, 161, 122, 168, 121, 177, 164, 122, 169, 121, 177, 165, 168, 177,
 167, 122, 168, 176, 168, 161, 167, 168, 161, 113, 198, 168, 162, 130, 160, 130,
 130, 160, 160, 130, 160, 170, 130, 177, 168, 168, 177, 168, 122, 161, 121, 177,
 166, 177, 177, 168, 180, 161, 168, 177, 160, 168, 177, 177, 165, 177, 168, 169,
 178, 161, 177, 163, 161, 160, 142, 177, 168, 168, 168, 168, 166, 168, 177, 168,
 182, 122, 168, 122, 121, 178, 168, 122, 180, 168, 122, 161, 177, 168, 191, 167,
 168, 122, 162, 188, 177, 188, 178, 177, 168, 168, 177, 166, 122, 121, 168, 191,
 168, 168, 162, 163, 163, 181, 162, 130, 170, 130, 130, 185, 130, 122, 168, 204,
 178, 180, 160, 122, 168, 168, 177, 168, 169, 122, 169, 172, 160, 168, 180, 162,
 162, 177, 182, 191, 168, 178, 166, 178, 178, 190, 172, 168, 164, 177, 176, 164,
 177, 177, 177, 180, 166, 168, 168, 168, 122, 121, 121, 177, 168, 121, 168, 163,
 160, 168, 130, 160, 130, 168, 168, 178, 168, 166, 166, 166, 168, 162, 169, 164,
 178, 177, 168, 168, 122, 166, 177, 122, 178, 177, 142, 177, 177, 168, 168, 192,
 178, 121, 161, 164, 121, 168, 168, 181, 177, 178, 168, 122, 169, 177, 168, 177,
 177, 168, 177, 168, 167, 162, 121, 177, 122, 121, 122, 181, 181, 162, 202, 122,
 129, 168, 161, 168, 177, 168, 177, 166, 177, 169, 121, 161, 162, 177, 177, 177,
 168, 186, 177, 168, 168, 168, 168, 177, 168, 122, 162, 177, 161, 121, 191, 122,
 169, 168, 168, 130, 161, 122, 161, 168, 177, 168, 177, 161, 165, 121, 168, 177,
 182, 168, 168, 168, 122, 121, 177, 161, 177, 122, 121, 168, 168, 177, 160, 168,
 168, 168, 168, 162, 161, 161, 177, 121, 168, 142, 121, 122, 163, 168, 178, 192,
 177, 168, 198, 161, 177, 166, 121, 121, 161, 168, 121, 142, 168, 163, 162, 161,
 163, 176, 162, 181, 94, 161, 186, 121, 177, 177, 121, 177, 168, 161, 177, 168,
 168, 177, 178, 168, 168, 168, 168, 166, 160, 166, 168, 161, 168, 121, 168, 172,
 113, 168, 168, 168, 168, 168, 177, 161, 176, 168, 177, 168, 166, 164, 168, 121,
 177, 164, 163, 168, 92, 160, 177, 168, 168, 161, 161, 168, 168, 167, 122, 130,
 122, 130, 177, 177, 122, 121, 177, 164, 164, 177, 184, 126, 121, 164, 122, 121,
 162, 177, 166, 177, 177, 168, 92, 121, 168, 177, 168, 169, 174, 168, 185, 177,
 168, 169, 160, 168, 168, 164, 164, 177, 161, 122, 176, 169, 185, 173, 170, 130,
 130, 130, 130, 92, 161, 168, 168, 168, 162, 161, 122, 167, 122, 166, 168, 161,
 168, 177, 160, 122, 168, 167, 177, 168, 177, 168, 177, 161, 176, 185, 168, 161,
 160, 177, 168, 122, 122, 168, 164, 166, 166, 122, 169, 113, 130, 182, 161, 169,
 167, 176, 160, 177, 166, 176, 169, 177, 177, 177, 185, 168, 168, 168, 168, 177,
 176, 177, 168, 177, 169, 177, 169, 122, 168, 169, 130, 122, 168, 113, 202, 130,
 96, 166, 162, 168, 122, 164, 168, 177, 185, 122, 177, 122, 177, 168, 169, 122,
 162, 161, 168, 177, 122, 162, 168, 162, 168, 167, 168, 168, 178, 122, 184, 153,
 130, 130, 130, 130, 130, 168, 168, 168, 167, 169, 177, 142, 164, 164, 122, 161,
 122, 168, 122, 122, 177, 177, 142, 176, 122, 167, 169, 177, 168, 167, 177, 162,
 162, 178, 167, 176, 162, 173, 161, 130, 122, 177, 165, 168, 122, 161, 166, 162,
 168, 166, 96, 166, 168, 169, 168, 168, 177, 169, 168, 161, 168, 168, 166, 162,
 168, 166, 177, 168, 169, 168, 161, 169, 168, 164, 177, 169, 177, 164, 166, 169,
 177, 168, 168, 177, 92, 164, 168, 173, 130, 202, 161, 113, 169, 177, 165, 168,
 168, 168, 168, 169, 168, 121, 168, 122, 177, 169, 168, 168, 168, 177, 168, 180,
 169, 177, 168, 167, 166, 166, 121, 168, 121, 168, 178, 168, 168, 168, 167, 177,
 170, 163, 162, 168, 122, 168, 122, 168, 121, 168, 168, 166, 130, 179, 130, 113,
 92, 168, 122, 176, 177, 166, 182, 177, 166, 177, 161, 174, 182, 122, 161, 168,
 177, 168, 168, 166, 168, 162, 168, 166, 177, 164, 168, 168, 168, 168, 171, 122,
 162, 161, 121, 177, 168, 160, 92, 162, 130, 160, 168, 169, 166, 166, 177, 167,
 168, 163, 168, 122, 168, 166, 168, 168, 168, 168, 122, 142, 168, 167, 177, 177,
 169, 163, 168, 168, 180, 168, 169, 181, 171, 177, 166, 169, 168, 161, 163, 92,
 113, 96, 169, 185, 168, 164, 163, 168, 168, 177, 163, 185, 177, 168, 168, 177,
 122, 168, 177, 177, 177, 185, 168, 168, 168, 161, 166, 177, 126, 177, 179, 121,
 161, 162, 121, 177, 168, 160, 178, 178, 164, 122, 177, 121, 168, 161, 122, 177,
 168, 177, 168, 166, 94, 121, 177, 161, 168, 177, 166, 177, 168, 142, 181, 172,
 177, 178, 164, 166, 171, 169, 167, 168, 163, 177, 164, 166, 177, 168, 162, 188,
 168, 169, 122, 121, 168, 168, 168, 172, 177, 168, 168, 168, 168, 163, 177, 168,
 177, 121, 166, 168, 161, 177, 121, 168, 168, 169, 162, 121, 166, 168, 168, 168,
 122, 177, 172, 177, 167, 174, 198, 161, 177, 162, 177, 177, 122, 122, 177, 160,
 161, 162, 180, 121, 130, 177, 177, 122, 164, 122, 177, 121, 164, 121, 172, 164,
 182, 122, 122, 122, 90, 170, 161, 168, 122, 166, 168, 122, 130, 168, 179, 168,
 122, 177, 165, 161, 168, 178, 168, 122, 161, 171, 161, 164, 168, 169, 165, 165,
 177, 122, 122, 168, 179, 130, 92, 160, 122, 168, 161, 122, 168, 122, 168, 161,
 161, 168, 122, 168, 161, 168, 122, 180, 177, 178, 177, 177, 174, 92, 121, 177,
 163, 168, 167, 161, 167, 161, 161, 168, 177, 161, 177, 122, 168, 130, 153, 92,
 113, 169, 168, 92, 198, 172, 168, 167, 168, 168, 177, 161, 185, 177, 177, 172,
 177, 122, 122, 113, 113, 187, 130, 94, 92, 185, 171, 177, 177, 177, 166, 198,
 168, 162, 176, 162, 122, 122, 168, 168, 169, 122, 168, 177, 121, 121, 177, 122,
 161, 121, 130, 130, 130, 130, 160, 177, 122, 161, 161, 168, 168, 161, 168, 171,
 166, 166, 178, 122, 122, 193, 168, 177, 122, 169, 168, 168, 167, 121, 167, 160,
 160, 177, 169, 161, 113, 168, 177, 121, 92, 168, 169, 168, 178, 162, 177, 164,
 122, 168, 122, 122, 168, 171, 177, 168, 191, 192, 176, 173, 162, 113, 178, 168,
 162, 96, 168, 168, 160, 122, 177, 177, 162, 168, 122, 169, 168, 168, 168, 168,
 166, 177, 171, 168, 130, 177, 122, 168, 121, 164, 162, 121, 168, 97, 177, 161,
 164, 165, 177, 172, 122, 162, 177, 94, 161, 177, 161, 168, 178, 172, 161, 177,
 168, 168, 177, 168, 160, 92, 142, 177, 168, 168, 177, 177, 177, 168, 169, 122,
 142, 177, 177, 177, 121, 160, 167, 161, 92, 168, 121, 177, 97, 178, 177, 142,
 162, 168, 121, 177, 178, 162, 168, 153, 161, 168, 177, 166, 177, 164, 178, 122,
 94, 122, 168, 122, 161, 168, 122, 198, 178, 163, 172, 121, 161, 162, 92, 121,
 162, 160, 161, 121, 163, 177, 121, 178, 178, 92, 181, 177, 171, 168, 168, 177,
 162, 180, 168, 168, 168, 163, 142, 172, 92, 198, 121, 161, 142, 168, 168, 178,
 164, 161, 121, 181, 162, 164, 177, 177, 92, 168, 121, 161, 163, 121, 168, 178,
 121, 170, 130, 92, 130, 130, 170, 130, 130, 130, 130, 130, 130, 92, 130, 130,
 130, 130, 122, 168, 171, 177, 166, 162, 162, 168, 167, 168, 167, 178, 130, 168,
 168, 168, 168, 122, 168, 166, 167, 172, 168, 177, 161, 166, 168, 177, 161, 130,
 168, 177, 168, 166, 121, 161, 177, 168, 121, 162, 168, 168, 97, 162, 168, 177,
 122, 92, 121, 121, 177, 164, 161, 166, 121, 92, 121, 161, 121, 161, 121, 171,
 142, 171, 177, 121, 162, 171, 121, 121, 121, 161, 92, 121, 160, 121, 177, 121,
 164, 161, 171, 121, 162, 121, 164, 168, 161, 160, 121, 163, 177, 121, 161, 162,
 168, 121, 161, 113, 121, 164, 121, 162, 160, 168, 121, 121, 142, 163, 176, 168,
 177, 142, 161, 164, 168, 177, 142, 162, 167, 163, 168, 161, 168, 177, 177, 168,
 121, 178, 178, 162, 121, 121, 171, 177, 177, 168, 161, 121, 162, 164, 121, 92,
 121, 177, 121, 121, 161, 164, 121, 163, 97, 121, 161, 142, 142, 121, 121, 161,
 121, 121, 121, 121, 168, 191, 177, 177, 161, 190, 177, 171, 142, 161, 163, 177,
 164, 168, 178, 177, 178, 121, 177, 121, 161, 202, 130, 177, 121, 121, 161, 177,
 163, 142, 177, 122, 160, 121, 177, 162, 121, 177, 142, 161, 160, 161, 121, 164,
 121, 121, 161, 121, 121, 121, 121, 171, 121, 163, 126, 168, 181, 113, 162, 163,
 121, 161, 121, 164, 160, 161, 171, 164, 168, 121, 168, 177, 121, 168, 191, 121,
 168, 161, 121, 177, 121, 168, 177, 121, 177, 171, 164, 121, 181, 121, 161, 180,
 161, 177, 121, 177, 177, 177, 121, 177, 168, 168, 153, 121, 121, 177, 178, 177,
 178, 180, 178, 161, 178, 161, 121, 121, 168, 161, 203, 121, 164, 121, 121, 168,
 177, 121, 168, 142, 177, 177, 188, 121, 121, 161, 121, 168, 171, 161, 121, 177,
 121, 121, 121, 161, 121, 177, 177, 167, 168, 161, 171, 177, 172, 168, 121, 168,
 121, 177, 168, 168, 180, 168, 180, 121, 168, 121, 180, 121, 177, 121, 177, 163,
 121, 113, 168, 168, 168, 168, 167, 168, 121, 161, 168, 121, 121, 163, 168, 168,
 177, 168, 161, 180, 161, 168, 168, 177, 161, 121, 168, 168, 177, 168, 178, 160,
 168, 121, 177, 163, 162, 177, 171, 168, 177, 121, 168, 168, 172, 163, 121, 121,
 168, 168, 177, 177, 177, 168, 178, 168, 121, 171, 121, 113, 121, 168, 182, 142,
 168, 161, 160, 177, 161, 168, 122, 168, 168, 160, 168, 142, 122, 177, 161, 121,
 121, 181, 113, 161, 121, 161, 162, 121, 177, 177, 168, 168, 164, 121, 177, 168,
 121, 163, 168, 181, 177, 177, 168, 161, 168, 92, 121, 177, 178, 164, 178, 162,
 198, 161, 121, 121, 177, 177, 121, 161, 168, 178, 121, 160, 171, 161, 177, 177,
 170, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 92, 130, 130, 130,
 130, 92, 130, 130, 130, 130, 130, 130, 130, 130, 130, 92, 130, 130, 170, 130,
 130, 130, 130, 130, 130, 130, 130, 92, 130, 130, 130, 130, 130, 130, 130, 130,
 92, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 130, 170, 130, 130, 130, 130, 130, 130, 130, 92, 130, 130, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 92, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 92, 130,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 130, 122, 162, 177, 181, 168, 168, 177, 177, 121,
 161, 122, 168, 168, 161, 177, 122, 166, 121, 176, 180, 177, 122, 168, 142, 177,
 142, 163, 161, 164, 171, 122, 168, 177, 164, 162, 122, 164, 168, 177, 161, 168,
 161, 122, 169, 164, 177, 168, 177, 161, 177, 177, 122, 122, 142, 171, 92, 168,
 168, 168, 168, 176, 161, 177, 177, 168, 167, 122, 122, 177, 181, 168, 164, 161,
 168, 168, 122, 161, 168, 167, 177, 164, 161, 169, 122, 162, 122, 142, 181, 168,
 177, 168, 177, 171, 167, 168, 161, 168, 167, 177, 168, 163, 177, 121, 121, 160,
 121, 121, 121, 168, 177, 168, 161, 121, 121, 121, 121, 121, 121, 172, 181, 121,
 180, 161, 142, 121, 121, 168, 121, 121, 121, 177, 177, 121, 121, 121, 168, 121,
 121, 121, 121, 121, 121, 171, 162, 121, 121, 164, 121, 162, 168, 172, 113, 177,
 161, 121, 97, 121, 160, 177, 163, 168, 161, 177, 180, 172, 121, 177, 121, 168,
 121, 171, 121, 121, 121, 168, 121, 168, 177, 160, 121, 160, 171, 121, 168, 164,
 177, 168, 163, 168, 126, 177, 161, 163, 171, 168, 142, 121, 121, 121, 177, 162,
 168, 162, 168, 163, 180, 121, 168, 180, 121, 177, 121, 172, 160, 121, 161, 142,
 178, 160, 163, 121, 178, 168, 121, 171, 160, 168, 161, 171, 160, 170, 130, 130,
 92, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 92, 92, 130, 130, 130, 130, 92, 130, 130, 130, 130, 130, 130, 130, 92,
 130, 130, 130, 130, 122, 164, 122, 169, 168, 177, 92, 122, 177, 169, 177, 168,
 122, 181, 168, 122, 122, 130, 185, 122, 168, 168, 160, 168, 161, 168, 161, 164,
 168, 169, 163, 161, 166, 122, 161, 161, 164, 168, 122, 173, 168, 177, 168, 168,
 177, 166, 168, 168, 185, 171, 168, 161, 161, 121, 161, 168, 168, 161, 162, 176,
 177, 168, 161, 122, 161, 168, 163, 168, 121, 160, 168, 177, 177, 168, 168, 177,
 161, 130, 177, 122, 96, 166, 168, 177, 130, 177, 122, 164, 166, 161, 122, 185,
 163, 168, 178, 170, 130, 177, 190, 177, 177, 161, 164, 122, 122, 168, 176, 165,
 168, 176, 161, 168, 163, 177, 167, 166, 168, 177, 169, 122, 168, 122, 130, 169,
 168, 121, 168, 165, 176, 162, 97, 177, 122, 168, 169, 167, 166, 161, 168, 122,
 177, 177, 177, 122, 177, 202, 92, 130, 130, 130, 96, 130, 142, 166, 168, 178,
 168, 163, 168, 168, 177, 166, 177, 168, 181, 167, 165, 164, 130, 168, 94, 122,
 121, 177, 168, 168, 166, 168, 177, 168, 168, 168, 168, 168, 168, 169, 122, 169,
 177, 171, 176, 166, 168, 168, 177, 177, 160, 96, 186, 97, 130, 94, 185, 130,
 180, 176, 161, 177, 142, 122, 177, 162, 177, 176, 170, 161, 168, 166, 168, 168,
 166, 166, 122, 161, 122, 168, 160, 165, 122, 122, 122, 176, 178, 177, 177, 163,
 178, 130, 130, 168, 177, 142, 168, 168, 161, 122, 168, 177, 177, 177, 177, 121,
 180, 177, 177, 142, 142, 168, 96, 168, 160, 166, 168, 161, 176, 166, 92, 166,
 189, 182, 169, 168, 122, 160, 122, 160, 168, 162, 171, 177, 169, 92, 94, 130,
 94, 122, 171, 164, 178, 169, 168, 122, 168, 171, 121, 142, 168, 121, 168, 130,
 166, 142, 177, 142, 167, 177, 168, 168, 168, 181, 177, 162, 130, 177, 166, 168,
 168, 142, 164, 168, 168, 168, 168, 163, 168, 177, 121, 122, 122, 163, 162, 184,
 172, 181, 96, 164, 161, 162, 160, 161, 161, 161, 176, 162, 160, 168, 113, 161,
 188, 164, 168, 163, 162, 113, 181, 162, 113, 168, 121, 121, 121, 121, 170, 171,
 92, 177, 121, 168, 171, 161, 161, 168, 168, 161, 94, 142, 177, 168, 168, 121,
 168, 168, 153, 113, 160, 168, 168, 168, 177, 168, 161, 180, 168, 182, 177, 168,
 162, 177, 160, 161, 168, 168, 168, 177, 121, 177, 177, 121, 142, 181, 121, 168,
 177, 168, 177, 121, 161, 180, 168, 177, 177, 121, 142, 168, 113, 168, 168, 162,
 177, 168, 121, 121, 121, 121, 177, 177, 177, 172, 168, 121, 121, 121, 188, 121,
 177, 162, 161, 177, 168, 171, 121, 204, 162, 121, 121, 161, 177, 163, 177, 121,
 160, 161, 168, 121, 177, 177, 177, 177, 121, 180, 162, 121, 161, 161, 121, 121,
 177, 163, 142, 177, 121, 121, 178, 177, 168, 121, 160, 168, 113, 121, 121, 177,
 168, 177, 177, 177, 171, 177, 168, 178, 177, 168, 168, 168, 172, 191, 177, 121,
 168, 142, 180, 178, 178, 164, 170, 170, 130, 130, 92, 130, 130, 130, 170, 130,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 92, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 92, 130, 130, 130,
 130, 130, 92, 170, 130, 130, 130, 130, 130, 130, 130, 122, 122, 164, 184, 169,
 163, 164, 161, 122, 164, 163, 188, 181, 122, 130, 161, 130, 161, 121, 142, 121,
 122, 122, 121, 160, 168, 163, 90, 153, 182, 179, 153, 153, 153, 130, 174, 178,
 162, 174, 122, 92, 169, 122, 171, 173, 130, 168, 163, 177, 160, 177, 122, 161,
 90, 122, 177, 166, 122, 166, 168, 168, 173, 173, 153, 130, 130, 130, 130, 130,
 177, 168, 169, 177, 176, 169, 122, 161, 176, 184, 122, 122, 92, 122, 166, 181,
 122, 164, 183, 130, 142, 177, 177, 122, 169, 186, 142, 177, 168, 122, 177, 168,
 122, 122, 192, 122, 166, 122, 122, 92, 193, 173, 130, 165, 177, 122, 181, 122,
 122, 165, 179, 181, 122, 121, 169, 122, 162, 121, 122, 176, 168, 122, 122, 122,
 122, 165, 122, 121, 168, 161, 130, 113, 164, 164, 164, 161, 164, 166, 122, 166,
 161, 121, 121, 182, 177, 122, 169, 163, 122, 113, 161, 173, 122, 168, 122, 177,
 161, 122, 122, 164, 166, 181, 161, 122, 161, 178, 121, 121, 163, 122, 121, 169,
 122, 122, 167, 122, 121, 121, 153, 130, 169, 121, 161, 176, 121, 188, 121, 161,
 121, 198, 176, 122, 94, 202, 162, 177, 169, 121, 161, 168, 182, 122, 122, 180,
 177, 161, 121, 168, 176, 122, 178, 121, 121, 177, 121, 168, 121, 122, 168, 122,
 122, 121, 122, 122, 121, 177, 168, 121, 190, 181, 121, 176, 162, 168, 162, 121,
 171, 122, 161, 173, 168, 190, 161, 166, 177, 192, 161, 166, 161, 130, 168, 168,
 177, 166, 190, 122, 161, 177, 122, 168, 198, 161, 122, 161, 130, 161, 170, 165,
 192, 122, 177, 166, 166, 122, 176, 161, 122, 173, 130, 170, 161, 177, 166, 168,
 161, 122, 161, 171, 174, 166, 161, 166, 177, 161, 122, 168, 162, 161, 169, 130,
 130, 130, 162, 130, 168, 177, 168, 166, 177, 177, 168, 167, 166, 176, 195, 177,
 168, 122, 169, 168, 178, 177, 130, 130, 122, 168, 168, 166, 168, 122, 161, 166,
 177, 168, 168, 168, 166, 121, 164, 181, 130, 168, 168, 168, 168, 122, 176, 177,
 177, 168, 122, 168, 166, 177, 177, 168, 177, 97, 161, 168, 161, 177, 168, 168,
 177, 168, 121, 161, 177, 195, 177, 171, 171, 122, 177, 168, 177, 168, 176, 168,
 177, 168, 166, 166, 168, 164, 168, 188, 168, 177, 168, 168, 168, 121, 177, 166,
 142, 176, 180, 168, 171, 168, 177, 164, 168, 176, 177, 168, 164, 164, 168, 168,
 168, 168, 92, 166, 168, 168, 185, 177, 171, 122, 122, 122, 122, 122, 165, 166,
 185, 160, 122, 177, 181, 168, 178, 176, 178, 163, 166, 162, 160, 130, 170, 168,
 168, 166, 165, 169, 166, 169, 92, 163, 168, 122, 122, 161, 122, 162, 185, 185,
 170, 130, 167, 178, 176, 122, 179, 122, 122, 166, 177, 164, 160, 130, 130, 130,
 168, 177, 178, 171, 168, 166, 177, 122, 161, 122, 177, 122, 179, 165, 163, 168,
 167, 166, 122, 177, 162, 164, 161, 113, 162, 168, 185, 185, 121, 168, 171, 168,
 168, 177, 167, 96, 113, 168, 162, 168, 177, 160, 167, 121, 188, 166, 190, 165,
 177, 188, 177, 177, 122, 165, 182, 168, 113, 168, 169, 163, 177, 177, 168, 164,
 121, 142, 177, 177, 160, 171, 142, 122, 113, 122, 130, 121, 122, 122, 122, 122,
 121, 122, 92, 177, 177, 168, 172, 188, 121, 171, 177, 181, 122, 121, 164, 172,
 161, 113, 168, 121, 177, 163, 142, 121, 168, 171, 191, 168, 177, 171, 177, 162,
 164, 177, 161, 168, 168, 121, 181, 177, 168, 177, 94, 162, 113, 177, 160, 178,
 177, 177, 168, 168, 177, 177, 177, 171, 160, 171, 177, 161, 177, 121, 172, 168,
 188, 121, 191, 163, 142, 142, 177, 194, 164, 168, 168, 161, 177, 162, 121, 92,
 161, 161, 161, 171, 177, 177, 177, 168, 182, 113, 94, 160, 113, 168, 177, 164,
 177, 168, 168, 177, 121, 163, 177, 142, 171, 171, 191, 161, 163, 97, 171, 121,
 188, 160, 162, 162, 172, 121, 177, 162, 178, 121, 177, 142, 168, 171, 177, 177,
 178, 171, 168, 168, 168, 160, 168, 121, 182, 164, 142, 121, 164, 163, 180, 160,
 177, 177, 198, 168, 121, 191, 180, 177, 162, 162, 161, 160, 168, 168, 163, 177,
 177, 113, 168, 161, 130, 162, 177, 182, 171, 177, 168, 171, 171, 177, 178, 177,
 121, 160, 168, 180, 160, 121, 168, 168, 177, 163, 177, 168, 168, 177, 166, 160,
 161, 121, 164, 121, 168, 178, 121, 177, 121, 177, 178, 178, 121, 168, 161, 162,
 177, 168, 168, 168, 177, 177, 168, 177, 171, 168, 168, 177, 97, 181, 179, 162,
 161, 160, 171, 126, 168, 168, 191, 121, 164, 198, 182, 171, 171, 162, 160, 163,
 177, 171, 177, 177, 168, 171, 177, 171, 166, 168, 168, 177, 191, 177, 177, 180,
 177, 168, 121, 177, 160, 177, 161, 177, 177, 177, 161, 160, 164, 177, 168, 177,
 177, 177, 161, 182, 121, 163, 168, 177, 177, 178, 121, 160, 182, 181, 177, 168,
 171, 168, 153, 172, 160, 161, 160, 168, 121, 177, 178, 177, 121, 160, 168, 177,
 177, 168, 177, 160, 126, 161, 178, 160, 177, 168, 161, 168, 168, 177, 168, 178,
 121, 162, 168, 168, 177, 171, 168, 161, 121, 142, 121, 168, 164, 177, 191, 191,
 121, 188, 121, 178, 191, 177, 121, 177, 121, 177, 177, 121, 172, 168, 121, 121,
 160, 160, 181, 171, 177, 178, 171, 162, 168, 168, 113, 113, 168, 92, 130, 161,
 94, 94, 160, 94, 153, 160, 168, 177, 193, 177, 126, 121, 168, 121, 168, 168,
 177, 177, 177, 161, 121, 177, 178, 177, 177, 168, 171, 121, 178, 161, 177, 160,
 178, 168, 160, 168, 177, 171, 160, 177, 160, 163, 166, 160, 142, 177, 198, 162,
 171, 177, 161, 163, 163, 121, 177, 168, 160, 168, 177, 168, 180, 163, 121, 164,
 177, 182, 171, 168, 94, 94, 160, 94, 177, 168, 171, 164, 180, 177, 168, 166,
 160, 168, 177, 161, 121, 177, 121, 142, 171, 168, 121, 177, 160, 168, 177, 168,
 160, 177, 97, 191, 177, 168, 177, 180, 177, 177, 168, 162, 121, 198, 142, 168,
 121, 168, 168, 97, 177, 177, 162, 168, 160, 113, 162, 160, 161, 160, 161, 94,
 168, 164, 168, 121, 177, 164, 163, 177, 142, 162, 166, 163, 177, 171, 168, 168,
 178, 121, 168, 163, 168, 168, 169, 142, 142, 177, 168, 160, 171, 142, 191, 171,
 160, 121, 171, 168, 121, 181, 177, 177, 142, 161, 161, 161, 168, 161, 168, 161,
 94, 160, 161, 160, 161, 168, 194, 177, 177, 177, 177, 177, 168, 171, 168, 168,
 168, 182, 164, 142, 193, 161, 168, 178, 163, 177, 168, 168, 168, 177, 177, 177,
 178, 168, 168, 178, 178, 177, 177, 163, 121, 178, 181, 160, 161, 94, 161, 164,
 168, 113, 161, 161, 160, 128, 94, 160, 168, 168, 168, 121, 168, 160, 171, 162,
 168, 177, 171, 171, 162, 121, 178, 168, 121, 168, 142, 177, 168, 177, 170, 177,
 168, 113, 160, 163, 121, 177, 168, 168, 177, 168, 177, 168, 177, 160, 161, 168,
 168, 121, 121, 113, 160, 177, 161, 168, 160, 162, 181, 198, 164, 168, 178, 164,
 142, 164, 178, 171, 97, 160, 161, 160, 177, 168, 142, 166, 160, 177, 177, 177,
 142, 177, 171, 168, 168, 178, 168, 142, 168, 94, 161, 160, 142, 121, 142, 121,
 168, 178, 168, 177, 164, 170, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 92, 130, 130, 130, 130, 92, 130, 92, 130, 130, 130, 130, 130, 130, 170,
 130, 130, 170, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 170, 130, 170, 130, 130, 130, 92, 130, 130, 130, 130, 130, 130, 130, 92,
 130, 130, 130, 92, 92, 130, 130, 130, 130, 130, 92, 130, 170, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 92, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 170, 130, 130, 130, 130, 92, 130, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 92, 130, 130, 130,
 92, 130, 130, 130, 130, 130, 130, 92, 130, 130, 130, 130, 130, 170, 130, 130,
 130, 130, 130, 92, 130, 130, 130, 130, 130, 130, 130, 130, 130, 92, 130, 130,
 130, 130, 130, 92, 130, 130, 130, 170, 92, 130, 130, 92, 130, 130, 130, 130,
 130, 130, 130, 130, 130, 92, 130, 130, 130, 130, 92, 130, 130, 130, 130, 130,
 92, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 92, 130,
 130, 130, 130, 130, 92, 92, 130, 121, 182, 164, 168, 168, 168, 168, 162, 170,
 121, 161, 142, 121, 162, 160, 168, 181, 177, 121, 113, 121, 177, 177, 171, 121,
 168, 121, 126, 121, 121, 161, 153, 160, 121, 172, 161, 168, 168, 162, 177, 177,
 153, 171, 172, 121, 121, 121, 182, 172, 121, 171, 94, 177, 177, 121, 168, 161,
 168, 126, 181, 161, 162, 168, 177, 168, 161, 178, 177, 121, 180, 177, 178, 177,
 168, 161, 161, 178, 161, 168, 171, 180, 171, 177, 121, 171, 142, 178, 161, 92,
 171, 177, 177, 177, 121, 121, 121, 161, 181, 162, 177, 168, 121, 164, 177, 177,
 177, 121, 121, 168, 177, 178, 162, 161, 170, 130, 130, 130, 92, 130, 130, 130,
 130, 130, 130, 130, 170, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 92,
 130, 130, 130, 130, 130, 130, 130, 92, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 92, 130, 130, 130, 130, 92, 130, 130, 92, 122, 174, 177, 130,
 168, 122, 166, 168, 177, 162, 164, 161, 178, 161, 122, 161, 171, 168, 122, 178,
 168, 176, 122, 174, 173, 130, 130, 164, 182, 177, 177, 122, 166, 166, 161, 122,
 122, 163, 122, 168, 122, 170, 130, 130, 130, 130, 168, 122, 122, 122, 168, 178,
 122, 168, 162, 168, 166, 130, 163, 162, 171, 161, 161, 122, 180, 121, 121, 165,
 161, 176, 122, 121, 122, 113, 113, 130, 130, 170, 122, 168, 169, 168, 164, 168,
 121, 168, 169, 121, 176, 122, 122, 122, 121, 161, 113, 163, 177, 121, 177, 164,
 168, 163, 164, 177, 171, 122, 122, 168, 167, 177, 121, 122, 161, 122, 121, 175,
 130, 177, 168, 168, 122, 121, 163, 167, 122, 122, 162, 121, 122, 164, 168, 164,
 181, 168, 168, 198, 177, 163, 162, 122, 121, 177, 121, 161, 168, 161, 177, 164,
 167, 121, 181, 166, 142, 161, 175, 196, 142, 169, 164, 121, 167, 179, 130, 168,
 122, 122, 168, 168, 122, 122, 122, 122, 168, 122, 171, 121, 122, 122, 165, 130,
 161, 181, 176, 168, 168, 122, 121, 168, 177, 121, 177, 121, 121, 177, 171, 177,
 130, 168, 121, 121, 161, 168, 161, 161, 122, 190, 122, 113, 161, 161, 161, 190,
 180, 177, 121, 130, 160, 168, 122, 122, 168, 122, 177, 121, 161, 168, 130, 168,
 122, 130, 177, 182, 169, 177, 122, 122, 167, 176, 181, 168, 161, 169, 169, 169,
 168, 121, 168, 122, 161, 161, 122, 161, 168, 180, 164, 163, 122, 177, 122, 168,
 168, 182, 177, 177, 142, 168, 168, 121, 177, 168, 169, 168, 168, 130, 168, 168,
 122, 163, 122, 164, 161, 168, 160, 161, 169, 122, 168, 161, 161, 121, 169, 168,
 160, 163, 121, 177, 121, 161, 178, 168, 121, 178, 162, 168, 92, 161, 162, 162,
 161, 203, 169, 130, 92, 164, 122, 182, 177, 184, 177, 176, 121, 160, 122, 160,
 169, 122, 122, 164, 181, 130, 142, 164, 142, 122, 177, 113, 168, 198, 177, 161,
 168, 153, 168, 166, 122, 92, 176, 191, 177, 181, 180, 177, 169, 177, 168, 177,
 177, 178, 168, 168, 178, 169, 113, 160, 168, 163, 168, 122, 161, 122, 168, 121,
 113, 130, 130, 161, 185, 162, 162, 177, 169, 177, 177, 160, 178, 168, 177, 163,
 122, 168, 177, 169, 168, 168, 142, 92, 180, 161, 168, 165, 177, 122, 177, 130,
 92, 163, 174, 178, 175, 164, 177, 168, 163, 177, 163, 168, 162, 160, 163, 177,
 160, 171, 94, 142, 177, 177, 121, 177, 172, 171, 164, 121, 171, 177, 177, 168,
 177, 162, 160, 121, 177, 168, 168, 177, 177, 177, 161, 162, 121, 177, 177, 168,
 182, 177, 161, 168, 164, 168, 170, 130, 92, 130, 130, 130, 130, 169, 172, 164,
 168, 177, 172, 122, 162, 175, 122, 162, 177, 97, 177, 121, 161, 168, 168, 121,
 194, 121, 121, 121, 168, 121, 121, 177, 121, 92, 188, 161, 121, 177, 177, 178,
 121, 121, 121, 121, 163, 160, 177, 121, 121, 164, 181, 168, 171, 168, 177, 160,
 177, 142, 161, 163, 142, 162, 177, 168, 168, 168, 161, 171, 113, 121, 163, 177,
 188, 161, 177, 163, 172, 177, 161, 142, 121, 126, 161, 121, 181, 181, 162, 161,
 161, 168, 161, 168, 177, 168, 121, 163, 168, 168, 177, 172, 121, 121, 121, 142,
 168, 177, 177, 171, 196, 181, 164, 177, 121, 177, 197, 142, 168, 168, 121, 168,
 168, 161, 177, 177, 168, 188, 163, 121, 161, 168, 177, 121, 163, 161, 161, 121,
 142, 142, 168, 178, 178, 170, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 92, 130, 130, 92, 130,
 130, 130, 92, 130, 130, 92, 130, 130, 130, 92, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 92, 130, 130, 130, 130, 121, 168, 113, 162, 168, 177, 177, 121,
 162, 121, 168, 97, 182, 161, 142, 163, 177, 160, 171, 177, 97, 168, 168, 177,
 168, 168, 177, 172, 121, 162, 178, 203, 163, 168, 160, 168, 177, 161, 170, 92,
 92, 130, 130, 130, 92, 130, 92, 92, 130, 130, 130, 121, 198, 161, 170, 122,
 94, 193, 121, 177, 161, 177, 163, 176, 130, 142, 171, 178, 160, 121, 200, 121,
 161, 160, 142, 164, 121, 160, 177, 161, 161, 168, 168, 92, 121, 121, 121, 161,
 168, 161, 177, 121, 92, 142, 161, 177, 177, 121, 121, 92, 121, 130, 160, 92,
 122, 177, 142, 121, 178, 177, 177, 177, 121, 160, 171, 171, 163, 181, 121, 177,
 196, 142, 164, 161, 178, 168, 162, 177, 121, 168, 168, 177, 178, 168, 169, 168,
 168, 177, 177, 177, 162, 171, 161, 94, 160, 163, 177, 163, 177, 142, 142, 97,
 163, 177, 172, 168, 161, 121, 162, 177, 177, 121, 94, 180, 180, 193, 177, 161,
 178, 121, 121, 168, 192, 169, 168, 121, 177, 177, 161, 177, 171, 160, 171, 177,
 162, 168, 94, 170, 92, 130, 92, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 92, 130, 130, 130, 130, 92, 92, 130, 92, 130, 130, 92, 130,
 130, 130, 92, 92, 130, 130, 130, 130, 130, 92, 130, 130, 92, 130, 92, 130,
 130, 130, 130, 130, 130, 130, 122, 167, 167, 122, 161, 182, 168, 191, 168, 162,
 161, 168, 161, 168, 160, 122, 177, 168, 122, 161, 160, 168, 121, 121, 121, 168,
 177, 188, 177, 121, 121, 177, 161, 161, 160, 191, 177, 168, 172, 177, 161, 164,
 161, 121, 168, 177, 172, 153, 113, 168, 181, 177, 161, 168, 168, 168, 168, 168,
 121, 121, 121, 177, 177, 121, 168, 168, 178, 188, 163, 142, 177, 121, 164, 121,
 161, 160, 142, 168, 168, 168, 160, 177, 161, 168, 177, 164, 177, 121, 178, 161,
 177, 121, 113, 161, 177, 163, 168, 168, 178, 177, 168, 178, 168, 177, 177, 121,
 161, 121, 177, 177, 177, 178, 168, 168, 195, 168, 168, 177, 163, 168, 121, 180,
 163, 177, 113, 113, 168, 168, 171, 161, 161, 121, 168, 168, 168, 168, 177, 160,
 177, 160, 177, 177, 177, 168, 160, 177, 113, 168, 168, 121, 168, 177, 177, 160,
 121, 168, 168, 162, 168, 171, 191, 121, 177, 168, 168, 160, 160, 168, 142, 168,
 121, 177, 178, 121, 177, 121, 168, 162, 168, 168, 177, 162, 177, 121, 177, 168,
 168, 164, 168, 168, 177, 121, 177, 121, 160, 168, 121, 121, 160, 162, 168, 121,
 168, 161, 121, 160, 178, 121, 168, 168, 168, 180, 121, 178, 170, 130, 130, 130,
 130, 130, 92, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 92, 130, 130, 130, 130, 130, 92, 130, 130, 130, 92, 92, 170,
 130, 130, 130, 130, 92, 92, 130, 130, 130, 92, 130, 130, 130, 130, 130, 130,
 130, 130, 130, 130, 130, 130, 92, 130, 122, 161, 162, 168, 162, 178, 162, 171,
 169, 185, 182, 168, 177, 164, 174, 96, 122, 177, 170, 177, 169, 160, 177, 177,
 167, 176, 185, 162, 181, 130, 177, 168, 164, 161, 168, 130, 130, 168, 164, 142,
 177, 169, 171, 122, 121, 177, 171, 163, 122, 161, 161, 162, 177, 161, 181, 167,
 163, 96, 172, 178, 164, 204, 169, 177, 161, 164, 181, 167, 177, 169, 121, 169,
 92, 178, 177, 177, 172, 164, 168, 178, 161, 166, 177, 169, 168, 177, 168, 182,
 164, 177, 163, 176, 177, 177, 142, 161, 166, 163, 168, 177, 177, 171, 177, 170,
 177, 168, 177, 130, 160, 168, 177, 168, 178, 177, 121, 162, 162, 161, 168, 167,
 177, 161, 142, 169, 168, 142, 164, 121, 142, 178, 198, 177, 161, 163, 178, 167,
 161, 121, 169, 177, 163, 177, 92, 177, 161, 182, 177, 167, 122, 164, 168, 168,
 160, 122, 122, 165, 122, 122, 168, 130, 166, 173, 168, 177, 177, 169, 142, 122,
 160, 169, 168, 161, 122, 177, 177, 164, 142, 168, 121, 177, 92, 161, 162, 168,
 168, 177, 92, 164, 168, 162, 177, 168, 177, 160, 162, 164, 177, 162, 162, 121,
 168, 168, 161, 162, 178, 177, 168, 171, 162, 162, 168, 168, 168, 168, 168, 182,
 177, 94, 168, 172, 164, 177, 177, 177, 168, 164, 162, 163, 161, 182, 198, 163,
 177, 121, 178, 178, 164, 168, 113, 153, 161, 161, 177, 168, 92, 163, 177, 198,
 178, 168, 168, 161, 168, 168, 177, 162, 178, 162, 142, 121, 162, 142, 121, 168,
 182, 162, 162, 92, 113, 168, 168, 162, 177, 178, 92, 164, 162, 168, 162, 177,
 142, 177, 161, 168, 168, 161, 178, 177, 171, 121, 142, 161, 161, 161, 162, 153,
 162, 113, 181, 168, 178, 168, 121, 177, 162, 168, 168, 142, 168, 182, 168, 164,
 168, 178, 178, 181, 180, 177, 168, 171, 121, 160, 177, 177, 168, 94, 161, 162,
 178, 153, 113, 162, 94, 113, 161, 177, 177, 164, 162, 161, 161, 171, 161, 163,
 164, 92, 163, 92, 181, 168, 178, 168, 178, 178, 172, 177, 172, 121, 168, 162,
 198, 162, 180, 142, 178, 198, 162, 168, 162, 162, 162, 172, 177, 168, 162, 160,
 94, 178, 162, 177, 178, 121, 182, 164, 177, 177, 162, 168, 168, 142, 181, 153,
 113, 171, 180, 168, 168, 163, 177, 177, 161, 178, 172, 121, 168, 177, 142, 168,
 168, 177, 92, 162, 177, 163, 178, 200, 178, 188, 177, 168, 168, 168, 177, 163,
 177, 161, 178, 163, 171, 168, 171, 121, 177, 168, 113, 162, 162, 163, 177, 171,
 178, 161, 168, 177, 92, 161, 168, 178, 177, 162, 162, 162, 161, 168, 177, 161,
 162, 168, 182, 168, 168, 177, 181, 171, 142, 168, 168, 163, 170, 92, 92, 130,
 92, 130, 130, 92, 92, 130, 130, 130, 130, 92, 92, 130, 92, 130, 130, 92,
 130, 130, 130, 92, 130, 130, 92, 92, 92, 92, 130, 130, 130, 92, 130, 130,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 92, 130, 92, 130, 130, 92,
 130, 130, 130, 130, 130, 130, 130, 130, 130, 92, 130, 130, 130, 130, 92, 92,
 92, 92, 92, 130, 130, 130, 130, 130, 92, 92, 130, 130, 130, 130, 130, 130,
 130, 92, 92, 130, 130, 130, 130, 130, 130, 130, 92, 92, 130, 130, 130, 130,
 92, 92, 130, 92, 92, 121, 177, 180, 161, 121, 168, 181, 181, 168, 161, 161,
 113, 168, 177, 121, 121, 168, 121, 177, 161, 177, 168, 168, 168, 168, 161, 168,
 168, 161, 163, 142, 168, 168, 142, 178, 178, 121, 161, 162, 160, 161, 113, 161,
 168, 162, 142, 161, 168, 142, 160, 177, 177, 168, 161, 121, 162, 177, 177, 178,
 168, 160, 168, 142, 161, 168, 121, 161, 121, 168, 181, 113, 113, 168, 168, 177,
 177, 168, 162, 177, 182, 161, 168, 168, 168, 160, 162, 121, 162, 177, 178, 142,
 168, 178, 177, 177, 172, 177, 113, 162, 113, 160, 177, 168, 168, 161, 160, 168,
 172, 121, 168, 177, 177, 161, 168, 168, 168, 178, 168, 168, 178, 121, 172, 177,
 121, 121, 162, 164, 113, 162, 161, 168, 168, 177, 171, 177, 121, 160, 160, 178,
 177, 168, 121, 168, 168, 168, 164, 177, 168, 168, 181, 177, 182, 168, 163, 168,
 168, 168, 168, 163, 177, 168, 177, 178, 168, 142, 177, 168, 168, 162, 162, 113,
 168, 161, 177, 182, 168, 164, 177, 177, 177, 168, 178, 168, 168, 168, 168, 168,
 168, 177, 168, 168, 178, 160, 168, 168, 168, 180, 177, 153, 177, 168, 164, 121,
 161, 177, 178, 168, 121, 177, 168, 168, 142, 177, 178, 178, 177, 160, 168, 177,
 94, 178, 142, 177, 198, 168, 113, 177, 168, 182, 177, 168, 168, 168, 168, 178,
 168, 168, 168, 142, 182, 177, 177, 188, 168, 178, 177, 168, 168, 168, 177, 177,
 162, 168, 168, 168, 168, 171, 178, 162, 168, 177, 92, 177, 168, 178, 177, 178,
 177, 92, 180, 177, 177, 168, 168, 168, 180, 121, 121, 168, 160, 178, 177, 168,
 168, 168, 177, 168, 168, 168, 168, 177, 161, 168, 182, 168, 94, 168, 163, 168,
 177, 177, 177, 168, 168, 177, 164, 168, 160, 177, 121, 142, 163, 177, 121, 170,
 130, 130, 130, 130, 92, 130, 130, 92, 130, 130, 130, 130, 130, 130, 92, 130,
 92, 130, 130, 130, 92, 130, 130, 130, 130, 130, 130, 92, 92, 130, 130, 130,
 92, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 92, 130, 130,
 92, 130, 92, 92, 92, 130, 92, 130, 130, 92, 130, 130, 130, 92, 130, 92,
 92, 92, 92, 130, 130, 92, 130, 130, 130, 130, 130, 130, 130, 130, 92, 92,
 130, 130, 92, 130, 92, 121, 92, 92, 113, 121, 177, 163, 171, 121, 130, 122,
 177, 172, 176, 177, 163, 163, 168, 166, 167, 168, 168, 169, 178, 168, 177, 162,
 160, 178, 122, 122, 168, 172, 182, 121, 163, 168, 168, 177, 168, 122, 163, 122,
 168, 168, 160, 161, 177, 121, 175, 168, 182, 142, 172, 160, 163, 178, 177, 163,
 177, 160, 161, 162, 190, 188, 168, 168, 202, 113, 113, 122, 142, 179, 122, 153,
 168, 160, 168, 126, 175, 161, 163, 94, 177, 130, 161, 162, 142, 122, 122, 169,
 178, 129, 181, 168, 122, 177, 168, 161, 122, 113, 168, 122, 122, 169, 121, 166,
 169, 92, 170, 161, 177, 167, 168, 166, 121, 130, 130, 168, 162, 177, 177, 169,
 177, 163, 177, 168, 121, 177, 178, 142, 182, 167, 168, 167, 167, 178, 179, 177,
 168, 168, 163, 164, 161, 161, 168, 121, 198, 177, 168, 130, 92, 130, 122, 177,
 166, 162, 177, 122, 164, 142, 177, 174, 168, 176, 177, 177, 168, 161, 168, 162,
 122, 113, 166, 168, 168, 168, 163, 160, 168, 168, 177, 177, 169, 168, 168, 176,
 168, 177, 177, 168, 171, 168, 168, 166, 168, 174, 162, 122, 162, 166, 169, 162,
 168, 177, 168, 177, 90, 163, 177, 177, 168, 168, 121, 121, 168, 168, 180, 178,
 179, 130, 121, 163, 178, 177, 177, 177, 177, 168, 163, 168, 97, 177, 177, 121,
 178, 121, 153, 142, 168, 168, 142, 121, 162, 163, 121, 168, 121, 162, 177, 177,
 177, 177, 142, 162, 168, 177, 178, 121, 168, 168, 177, 168, 161, 162, 168, 170,
 130, 92, 92, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 121, 160, 162,
 188, 177, 177, 161, 171, 180, 162, 164, 168, 170, 130, 130, 212, 181, 162, 170,
 167, 164, 177, 164, 168, 163, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0, 98, 98, 98, 98,  0,  0,  0,  0,  0,
 98, 98, 98, 98, 98, 98, 98, 98,  0, 98, 98, 98, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0, 98, 98,  0, 98,  0,  0,  0,  0,  0,
 98, 98,  0, 98, 98, 98, 98,  0,  0, 98, 98, 98, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0,  0,  0,  0, 98, 98, 98,  0, 98,  0,  0, 98,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,
  0, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0, 98,
 98, 98,  0, 98,  0, 98, 98,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0, 98, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0, 98, 98, 98, 98,  0,  0,  0,  0, 98, 98, 98,  0, 98,
  0, 98, 98,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0, 98,
 98, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0, 98, 98,  0, 98,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98, 98,  0,  0,  0, 98,  0, 98, 98, 98,  0,
 98,  0,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0, 98,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98, 98,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,  0,  0, 98,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98, 98, 98,  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0, 98, 98, 98,  0, 98,  0, 98, 98,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0, 98,  0, 98,  0, 98,  0,
  0,  0,  0, 98, 98, 98,  0, 98,  0, 98,  0,  0,  0, 98,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98, 98, 98,  0, 98,  0,  0, 98,
 98, 98, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98, 98, 98, 98, 98,
  0, 98,  0, 98, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98, 98,  0,  0,  0,
 98,  0, 98, 98,  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,
  0,  0,  0, 98, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0, 98, 98, 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0, 98, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98, 98, 98,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98, 98,  0,  0,  0, 98,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0, 98,  0, 98, 98, 98,  0, 98,  0,  0, 98, 98, 98, 98, 98,
  0,  0,  0, 98, 98, 98,  0, 98, 98, 98, 98, 98,  0,  0,  0, 98,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98, 98,  0, 98,  0,  0, 98, 98,  0, 98, 98,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0, 98,  0,  0, 98,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0, 98, 98,  0, 98,  0,
 98,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0, 98,  0, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0, 98, 98,  0, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0, 98, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98, 98, 98, 98,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0, 98, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0, 98, 98,  0,  0,  0,  0,
 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0, 98, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,  0,
  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0, 98,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98, 98,  0,  0,  0, 98, 98, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0,  0,  0, 98, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98, 98,  0,  0, 98, 98,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0, 98, 98,
 98, 98, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98, 98,  0,
  0, 98,  0, 98, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98, 98, 98, 98,  0,  0,  0,  0,  0,
 98, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98, 98,  0,
  0,  0,  0, 98, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 98, 98, 98,  0, 98,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98, 98,  0,  0,  0,
 98,  0, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0, 98,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98, 98,  0, 98,  0,  0, 98, 98, 98, 98,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0, 98,  0, 98,
 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0, 98,
 98,  0, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0, 98,
  0, 98,  0,  0, 98, 98, 98, 98, 98,  0,  0, 98, 98, 98, 98, 98,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0, 98,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98, 98, 98,  0,  0,  0, 98,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0, 98, 98,  0, 98,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98, 98,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0, 98,
 98, 98,  0,  0,  0, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98, 98,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0, 98, 98, 98, 98,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98,  0,  0,  0, 98, 98,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0, 98,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98, 98, 98,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0,
 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0, 98, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98,  0,  0, 98, 98, 98, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0, 98,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0, 98, 98, 98, 98,
 98,  0,  0, 98, 98,  0, 98, 98,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0,  0, 98,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0, 98, 98, 98,  0,
 98,  0,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0,  0,  0, 98,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0, 98,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0, 98,
  0, 98, 98,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0, 98, 98, 98,  0, 98,
  0, 98,  0,  0,  0,  0, 98,  0, 98, 98,  0, 98, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98, 98,  0,  0,
  0,  0,  0, 98, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0, 98,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0, 98,
 98,  0, 98,  0,  0,  0,  0,  0, 98, 98,  0,  0,  0, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0, 98,  0,  0,  0,  0, 98,
 98, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98, 98, 98,  0, 98, 98, 98,  0,
  0,  0,  0, 98, 98, 98,  0, 98, 98, 98,  0,  0,  0, 98, 98,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0, 98,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0,  0,  0, 98,  0, 98, 98,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98, 98,  0, 98, 98, 98, 98,  0,
  0,  0,  0,  0, 98, 98, 98, 98, 98, 98, 98,  0, 98,  0, 98,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0, 98, 98, 98,  0,
 98,  0,  0,  0, 98,  0, 98, 98,  0,  0,  0,  0, 98, 98, 98, 98,
 98, 98,  0,  0,  0, 98, 98, 98, 98,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98, 98, 98,  0,
 98,  0,  0, 98, 98, 98,  0, 98,  0, 98,  0, 98,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98, 98, 98,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,  0, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98,  0, 98,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0, 98,  0, 98, 98,  0, 98,
  0, 98, 98, 98, 98, 98, 98, 98, 98,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0, 98,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98, 98, 98,  0,
  0,  0,  0, 98, 98, 98,  0, 98, 98, 98, 98,  0,  0,  0, 98,  0,
 98, 98,  0,  0, 98,  0, 98, 98, 98,  0, 98,  0,  0,  0,  0,  0,
 98, 98,  0, 98, 98, 98, 98,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0, 98,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98, 98,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98, 98, 98,  0,  0,  0, 98, 98, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98, 98, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0, 98, 98,  0, 98,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98, 98,  0,  0, 98, 98,  0, 98, 98,  0,  0,
 98,  0, 98,  0, 98,  0,  0, 98,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0, 98,  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,  0, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
  0, 98, 98,  0,  0,  0,  0, 98, 98, 98,  0,  0, 98,  0, 98,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98, 98, 98, 98,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0, 98,
 98, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0, 98, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0,
 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98,  0,  0,  0,  0, 98,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0, 98,
 98,  0, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0, 98, 98, 98,  0,
 98,  0,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0, 98,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
 98, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0, 98,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0, 98,
 98,  0, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0, 98,
  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0, 98,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0, 98,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98, 98, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0, 98,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0, 98,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0, 98,
  0, 98,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0, 98,  0,  0,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0, 98,  0,  0, 98,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,
 98,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0, 98,  0,  0,  0,
  0,  0,  0,  0, 98,  0,  0, 98,  0, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0,  0, 98,  0, 98, 98, 98, 98,  0,  0,  0,  0,  0,  0,
 98, 98,  0, 98,  0, 98,  0,  0,  0, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0,
  0, 98,  0,  0,  0,  0,  0,  0, 98, 98,  0,  0, 98,  0,  0,  0,
 98,  0,  0,  0,  0,  0,  0,  0, 98, 98,  0, 98,  0, 98,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 94, 92, 94, 94, 92, 92, 92, 92, 92, 94, 94, 92, 94, 92, 94, 92,
 92, 92, 94, 94, 94, 94, 94, 92, 94, 92, 94, 94, 94, 94, 94, 92,
 94, 92, 94, 94, 92, 94, 92, 92, 92, 92, 92, 92, 92, 94, 94, 92,
 94, 92, 94, 94, 94, 94, 94, 94, 94, 92, 92, 94, 94, 92, 92, 92,
 92, 92, 92, 92, 92, 94, 92, 92, 92, 92, 92, 92, 94, 92, 92, 92,
 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 94, 92, 94, 92, 92, 94,
 94, 94, 92, 92, 94, 92, 94, 92, 92, 92, 92, 92, 94, 92, 92, 92,
 92, 94, 92, 92, 94, 94, 92, 92, 94, 92, 92, 92, 92, 94, 92, 92,
 92, 92, 92, 92, 92, 92, 92, 94, 92, 94, 94, 92, 94, 92, 92, 92,
 92, 92, 92, 94, 94, 92, 92, 92, 92, 94, 94, 92, 94, 94, 94, 92,
 92, 92, 92, 92, 92, 92, 94, 94, 92, 94, 92, 94, 92, 92, 94, 92,
 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 94, 92, 94, 92, 94, 92,
 92, 92, 92, 94, 92, 94, 92, 94, 94, 92, 94, 92, 92, 92, 92, 92,
 94, 92, 92, 92, 94, 94, 92, 92, 92, 92, 92, 92, 94, 92, 92, 94,
 92, 92, 94, 94, 94, 94, 92, 94, 94, 94, 92, 94, 94, 92, 94, 92,
 92, 92, 94, 92, 92, 92, 92, 92, 94, 94, 92, 94, 92, 94, 92, 92,
 92, 92, 92, 94, 92, 92, 94, 92, 92, 94, 94, 94, 92, 92, 92, 92,
 94, 92, 92, 92, 94, 94, 92, 92, 92, 92, 92, 92, 94, 94, 92, 92,
 92, 94, 92, 92, 92, 92, 94, 94, 94, 92, 92, 92, 92, 92, 92, 92,
 94, 94, 92, 92, 92, 92, 94, 92, 92, 94, 92, 92, 92, 92, 92, 92,
 92, 94, 94, 92, 92, 94, 92, 94, 94, 92, 94, 92, 92, 94, 92, 92,
 94, 92, 92, 92, 94, 94, 94, 94, 92, 94, 94, 92, 92, 94, 92, 92,
 92, 92, 94, 92, 92, 92, 92, 92, 94, 94, 94, 92, 92, 92, 92, 92,
 92, 94, 94, 92, 92, 94, 92, 92, 94, 94, 92, 94, 94, 92, 92, 94,
 94, 92, 92, 92, 92, 94, 92, 94, 92, 94, 92, 94, 92, 92, 92, 94,
 94, 92, 92, 94, 92, 94, 94, 92, 92, 92, 92, 92, 92, 92, 92, 94,
 94, 92, 92, 92, 94, 92, 94, 92, 92, 92, 94, 92, 92, 92, 94, 92,
 94, 94, 92, 94, 94, 92, 94, 92, 94, 92, 92, 94, 94, 94, 94, 94,
 92, 94, 92, 92, 94, 94, 92, 92, 94, 92, 92, 92, 94, 94, 92, 92,
 92, 92, 92, 92, 94, 94, 92, 94, 92, 92, 94, 92, 92, 94, 92, 92,
 92, 92, 94, 92, 92, 92, 94, 92, 92, 92, 92, 94, 92, 92, 92, 94,
 94, 92, 94, 92, 92, 92, 92, 94, 92, 92, 94, 92, 92, 92, 94, 92,
 94, 94, 94, 92, 92, 94, 92, 94, 92, 92, 94, 94, 94, 92, 92, 92,
 94, 92, 94, 94, 94, 94, 94, 92, 92, 94, 92, 94, 94, 92, 92, 94,
 94, 94, 92, 92, 92, 92, 94, 94, 94, 92, 94, 92, 92, 92, 92, 94,
 92, 94, 92, 94, 92, 92, 92, 94, 92, 92, 92, 94, 92, 94, 94, 92,
 92, 92, 92, 92, 92, 94, 92, 92, 94, 92, 94, 94, 94, 94, 94, 94,
 92, 94, 94, 94, 94, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92,
 92, 94, 92, 92, 92, 92, 92, 92, 94, 92, 92, 94, 92, 94, 94, 94,
 92, 94, 92, 92, 92, 92, 92, 92, 92, 92, 94, 92, 92, 94, 92, 92,
 92, 92, 94, 92, 92, 92, 92, 92, 94, 94, 92, 94, 92, 92, 92, 92,
 94, 94, 92, 92, 94, 94, 94, 92, 92, 94, 94, 94, 92, 92, 92, 94,
 92, 94, 92, 92, 94, 92, 94, 92, 92, 92, 92, 92, 92, 92, 92, 92,
 92, 92, 94, 94, 94, 94, 92, 94, 94, 92, 94, 92, 92, 92, 94, 94,
 92, 94, 92, 92, 92, 92, 92, 94, 92, 94, 92, 92, 92, 92, 92, 92,
 92, 92, 92, 92, 94, 92, 92, 92, 94, 94, 92, 92, 92, 92, 94, 92,
 94, 94, 94, 92, 92, 92, 92, 94, 92, 94, 92, 94, 94, 94, 92, 92,
 94, 94, 92, 92, 92, 92, 92, 92, 94, 92, 92, 92, 94, 92, 92, 94,
 94, 94, 92, 92, 92, 92, 94, 92, 94, 92, 92, 92, 94, 92, 92, 94,
 92, 94, 92, 94, 92, 94, 92, 92, 94, 92, 92, 94, 94, 92, 92, 94,
 92, 92, 92, 92, 92, 94, 92, 92, 92, 92, 92, 92, 94, 92, 92, 92,
 94, 94, 92, 92, 92, 94, 94, 92, 92, 92, 92, 94, 92, 94, 92, 92,
 92, 92, 94, 92, 92, 94, 92, 92, 94, 92, 92, 92, 92, 92, 92, 92,
 92, 92, 94, 92, 94, 92, 92, 92, 92, 92, 92, 94, 94, 92, 92, 92,
 94, 92, 94, 92, 94, 94, 92, 92, 92, 92, 92, 92, 92, 92, 92, 94,
 92, 92, 94, 92, 94, 94, 92, 94, 92, 94, 92, 94, 92, 92, 92, 92,
 92, 94, 94, 92, 92, 92, 94, 92, 94, 94, 94, 92, 92, 94, 92, 92,
 92, 94, 92, 94, 94, 92, 94, 92, 94, 92, 94, 94, 92, 92, 94, 94,
 94, 92, 94, 92, 92, 94, 94, 94, 94, 94, 92, 92, 94, 92, 92, 92,
 92, 94, 94, 92, 94, 94, 92, 92, 92, 94, 94, 94, 94, 94, 92, 92,
 92, 92, 92, 94, 92, 92, 92, 92, 94, 92, 92, 92, 94, 94, 92, 94,
 92, 92, 92, 92, 92, 94, 92, 92, 94, 94, 94, 92, 92, 92, 92, 92,
 92, 94, 92, 94, 92, 92, 92, 94, 92, 92, 92, 92, 92, 94, 94, 92,
 94, 92, 94, 94, 94, 92, 92, 92, 94, 92, 94, 92, 92, 94, 92, 94,
 92, 92, 92, 92, 92, 92, 92, 92, 92, 94, 94, 94, 92, 92, 92, 92,
 92, 92, 92, 92, 94, 92, 92, 92, 92, 92, 92, 94, 92, 94, 94, 92,
 92, 92, 92, 94, 92, 94, 94, 92, 94, 92, 92, 92, 94, 94, 92, 92,
 92, 92, 94, 92, 92, 92, 94, 92, 92, 92, 94, 94, 94, 92, 94, 92,
 94, 94, 92, 92, 94, 92, 92, 92, 94, 92, 92, 92, 94, 94, 94, 92,
 94, 94, 92, 92, 92, 92, 92, 92, 92, 94, 94, 92, 92, 94, 94, 92,
 92, 94, 94, 94, 92, 94, 92, 94, 94, 94, 94, 92, 94, 92, 94, 94,
 92, 94, 94, 92, 94, 92, 94, 92, 92, 92, 92, 92, 92, 92, 94, 94,
 92, 92, 92, 92, 94, 92, 94, 94, 94, 94, 94, 92, 92, 94, 94, 92,
 92, 94, 94, 92, 92, 94, 94, 94, 92, 92, 92, 92, 92, 92, 92, 92,
 92, 94, 94, 94, 94, 92, 92, 92, 92, 92, 92, 94, 92, 92, 92, 94,
 92, 92, 92, 94, 94, 94, 94, 94, 94, 94, 94, 92, 92, 92, 92, 92,
 92, 94, 92, 92, 92, 92, 94, 92, 92, 94, 92, 92, 92, 94, 94, 92,
 92, 92, 92, 92, 92, 92, 94, 92, 92, 94, 92, 92, 94, 94, 92, 92,
 92, 92, 92, 92, 94, 92, 94, 94, 94, 92, 92, 92, 92, 92, 94, 94,
 92, 92, 92, 92, 92, 92, 94, 92, 94, 94, 92, 92, 92, 92, 92, 94,
 92, 94, 94, 92, 92, 94, 92, 92, 92, 92, 94, 92, 92, 94, 92, 94,
 92, 92, 94, 92, 94, 92, 94, 92, 92, 92, 94, 92, 94, 94, 94, 94,
 94, 94, 92, 92, 94, 92, 92, 92, 94, 94, 94, 94, 94, 92, 94, 94,
 92, 92, 92, 92, 92, 92, 92, 94, 92, 92, 92, 92, 92, 92, 94, 92,
 92, 92, 92, 94, 92, 92, 92, 92, 92, 92, 92, 94, 92, 92, 92, 92,
 92, 92, 92, 92, 94, 94, 92, 94, 94, 94, 92, 94, 94, 92, 94, 94,
 92, 92, 94, 92, 92, 92, 94, 94, 92, 92, 92, 92, 92, 94, 94, 92,
 94, 92, 94, 94, 92, 94, 94, 94, 92, 94, 94, 92, 94, 94, 94, 92,
 94, 92, 94, 94, 94, 94, 94, 92, 94, 92, 92, 94, 94, 94, 94, 94,
 94, 92, 94, 94, 94, 92, 92, 92, 92, 92, 94, 92, 92, 94, 94, 94,
 94, 94, 92, 92, 94, 92, 94, 94, 94, 92, 94, 92, 92, 92, 92, 94,
 92, 94, 94, 92, 92, 94, 92, 94, 94, 92, 94, 94, 92, 92, 94, 94,
 94, 92, 94, 92, 92, 92, 92, 92, 94, 94, 92, 92, 92, 92, 92, 92,
 92, 92, 92, 92, 92, 92, 92, 94, 94, 94, 92, 94, 94, 92, 92, 94,
 92, 94, 94, 94, 92, 94, 94, 92, 92, 94, 92, 92, 92, 92, 94, 94,
 94, 94, 92, 94, 92, 92, 92, 92, 92, 92, 92, 94, 94, 92, 92, 92,
 94, 92, 94, 92, 94, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 94,
 94, 94, 94, 92, 92, 92, 92, 92, 92, 94, 94, 94, 94, 92, 92, 92,
 92, 94, 92, 94, 94, 92, 92, 94, 92, 92, 92, 94, 92, 92, 92, 92,
 92, 92, 94, 94, 94, 92, 92, 94, 94, 92, 94, 92, 94, 92, 92, 94,
 94, 94, 94, 92, 92, 94, 94, 92, 94, 92, 92, 94, 92, 92, 94, 94,
 92, 92, 94, 94, 94, 94, 92, 94, 94, 94, 92, 92, 92, 94, 94, 94,
 94, 92, 94, 94, 92, 94, 94, 94, 94, 92, 94, 92, 92, 92, 94, 94,
 92, 94, 92, 92, 92, 92, 94, 94, 94, 94, 92, 94, 94, 94, 92, 94,
 94, 92, 92, 94, 94, 94, 94, 94, 94, 92, 94, 94, 94, 92, 94, 94,
 94, 92, 94, 92, 92, 92, 94, 94, 92, 94, 94, 92, 94, 92, 94, 94,
 92, 94, 94, 92, 92, 92, 94, 92, 92, 92, 92, 92, 94, 94, 92, 92,
 92, 92, 94, 92, 92, 92, 92, 92, 92, 94, 94, 92, 92, 94, 94, 92,
 94, 94, 92, 92, 92, 94, 92, 94, 92, 92, 94, 92, 92, 92, 92, 92,
 92, 94, 94, 92, 92, 92, 92, 94, 94, 92, 94, 94, 92, 94, 94, 94,
 94, 94, 92, 92, 94, 94, 94, 92, 92, 92, 92, 92, 92, 92, 94, 92,
 92, 92, 94, 94, 92, 92, 92, 94, 92, 92, 94, 94, 94, 92, 92, 94,
 92, 94, 94, 92, 92, 92, 94, 94, 92, 94, 94, 92, 94, 92, 92, 92,
 94, 94, 92, 94, 92, 92, 92, 94, 94, 92, 94, 94, 92, 94, 92, 92,
 92, 92, 92, 92, 94, 94, 92, 92, 92, 92, 92, 94, 92, 92, 92, 94,
 92, 92, 92, 94, 94, 94, 94, 94, 92, 92, 92, 92, 94, 94, 92, 92,
 94, 94, 94, 92, 94, 92, 92, 94, 92, 92, 92, 92, 92, 94, 94, 94,
 92, 94, 94, 92, 92, 92, 92, 92, 92, 92, 92, 94, 94, 94, 92, 94,
 92, 94, 94, 92, 94, 94, 92, 94, 94, 94, 92, 92, 93, 94, 94, 92,
 94, 92, 92, 92, 92, 94, 92, 94, 94, 92, 94, 92, 94, 94, 92, 92,
 92, 92, 92, 92, 94, 92, 94, 92, 92, 94, 92, 94, 92, 94, 92, 92,
 94, 92, 94, 92, 94, 92, 94, 94, 92, 94, 92, 92, 92, 92, 92, 92,
 92, 92, 94, 92, 94, 94, 94, 94, 94, 94, 92, 92, 92, 92, 92, 92,
 92, 94, 92, 92, 94, 92, 92, 92, 94, 92, 92, 92, 94, 92, 92, 92,
 92, 92, 92, 92, 94, 92, 92, 92,  0, 92, 94, 92, 92, 92, 94, 92,
 92, 94, 92, 92, 92, 92, 92, 92, 94, 92, 94, 92, 94, 94, 92, 92,
 92, 92, 92, 92, 94, 92, 92, 93, 93, 93,  0, 93,  0, 93, 93, 93,
  0, 93, 93, 93, 92, 92, 92, 92, 94, 92, 92, 94, 94, 92, 92, 94,
 94, 94, 94, 92, 92, 92, 92, 92, 94, 92, 92, 92, 94, 92, 94, 94,
 92, 94, 92, 94, 92,  0, 94, 94, 94,  0, 93,  0,  0,  0, 92,  0,
  0, 93,  0,  0,  0,  0, 92, 93, 93,  0,  0, 92, 92, 93,  0, 93,
  0, 92, 92,  0,  0, 93,  0, 93, 93,  0, 93, 94,  0,  0,  0,  0,
  0, 93, 93, 92,  0,  0,  0,  0,  0,  0,  0, 93,  0, 93, 93,  0,
  0, 93,  0,  0, 92, 94, 93, 93, 93,  0,  0, 93, 93, 93,  0,  0,
 93, 93, 93,  0, 92, 93, 93, 93,  0, 93, 93,  0, 93,  0,  0,  0,
  0, 93,  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0, 93, 93, 93,
  0,  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,  0,  0,  0, 93,
  0, 93, 93,  0, 93, 93,  0,  0,  0,  0, 93,  0,  0, 93,  0,  0,
 93, 93,  0, 93, 93, 93, 93, 93,  0, 93, 93,  0, 93, 93, 93, 93,
 93,  0,  0,  0,  0, 93, 93,  0, 93,  0,  0,  0,  0, 93, 93, 93,
 93, 93, 93, 93,  0, 93,  0, 93,  0,  0,  0, 93,  0, 93, 93,  0,
 93, 93,  0, 93,  0, 93, 93,  0, 93, 93, 93,  0,  0, 93,  0, 93,
 93, 93,  0,  0,  0, 93, 93,  0, 93, 93, 93,  0,  0, 93,  0,  0,
  0, 93, 93,  0,  0, 93,  0,  0,  0,  0,  0, 93,  0,  0, 93,  0,
 93,  0,  0, 93,  0,  0,  0, 93, 93,  0,  0,  0, 93,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 93, 93,  0,  0,  0, 93,  0, 93, 93,
 93, 93, 93,  0,  0, 93, 93, 93, 93, 93, 93, 93, 93,  0, 93, 93,
  0,  0,  0, 93, 93, 93, 93,  0, 93,  0, 93,  0, 93, 93, 93,  0,
  0, 93,  0,  0, 93, 93,  0,  0, 93,  0,  0,  0,  0, 93,  0,  0,
 93,  0, 93, 93, 93, 93,  0, 93, 93,  0, 93,  0, 93, 93, 93,  0,
 93, 93,  0,  0, 93,  0,  0, 93, 93,  0,  0,  0,  0,  0, 93, 93,
  0,  0,  0, 93, 93, 93,  0, 93, 93,  0, 93, 93,  0, 93,  0,  0,
  0, 93, 93,  0,  0,  0,  0, 93,  0,  0, 93,  0,  0,  0, 93,  0,
  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 93,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 93,
 93, 93,  0,  0,  0, 93,  0,  0,  0, 93, 93, 93, 93,  0,  0, 93,
 93, 93,  0, 93, 93,  0, 93, 93, 93, 93, 93,  0, 93,  0, 93, 93,
 93, 93, 93, 93,  0,  0,  0, 93, 93, 93, 93, 93, 93,  0, 93,  0,
 93, 93, 93,  0, 93, 93, 93,  0, 93, 93, 93, 93,  0,  0, 93, 93,
 93,  0, 93, 93, 93, 93,  0,  0, 93, 93, 93, 93, 93, 93, 93, 93,
  0, 93, 93,  0,  0, 93,  0,  0, 93, 93, 93, 93, 93, 93,  0, 93,
 93, 93,  0, 93,  0, 93,  0, 93,  0,  0, 93,  0, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,  0,  0,  0, 93, 93, 93,
  0, 93,  0, 93, 93,  0, 93,  0,  0,  0, 93, 93, 93, 93, 93, 93,
 93,  0,  0, 93, 93, 93, 93, 93, 93, 93, 93, 93,  0, 93,  0, 93,
  0, 93, 93, 93,  0, 93,  0, 93, 93, 93,  0, 93,  0, 93,  0, 93,
 93, 93,  0, 93, 93,  0, 93, 93, 93,  0, 93,  0,  0,  0, 93, 93,
 93, 93,  0, 93, 93, 93,  0,  0, 93, 93, 93,  0, 93, 93, 93, 93,
 93,  0,  0, 93,  0, 93,  0, 93, 93, 93, 93, 93,  0,  0,  0, 93,
 93,  0, 93, 93,  0, 93, 93,  0, 93,  0, 93, 93,  0, 93, 93, 93,
 93,  0, 93, 93, 93,  0, 93,  0,  0, 93,  0,  0, 93, 93,  0, 93,
  0,  0, 93,  0,  0, 93, 93, 93, 93,  0, 93,  0, 93, 93, 93,  0,
 93,  0,  0, 93,  0, 93,  0, 93, 93,  0, 93, 93,  0, 93,  0, 93,
  0, 93,  0,  0, 93,  0,  0, 93, 93, 93,  0, 93, 93,  0, 93, 93,
  0, 93, 93,  0,  0, 93, 93,  0,  0, 93, 93, 93,  0, 93, 93,  0,
  0,  0,  0,  0,  0, 93, 93,  0, 93, 93,  0,  0, 93,  0, 93, 93,
 93,  0,  0, 93, 93,  0,  0, 93, 93, 93, 93, 93, 93, 93,  0,  0,
 93,  0, 93,  0, 93,  0, 93,  0,  0,  0, 93, 93, 93, 93, 93, 93,
  0, 93, 93,  0,  0, 93,  0, 93,  0,  0,  0, 93, 93,  0,  0, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,  0, 93, 93,  0,  0, 93,
  0,  0, 93,  0, 93,  0, 93, 93, 93,  0, 93,  0, 93, 93,  0, 93,
 93,  0, 93, 93,  0,  0,  0, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93,  0, 93, 93,  0,  0, 93,  0, 93,  0,  0, 93,  0,
 93,  0,  0,  0, 93,  0, 93,  0,  0,  0,  0,  0,  0, 93, 93,  0,
  0, 93, 93, 93, 93, 93, 93,  0, 93, 93, 93, 93,  0, 93, 93,  0,
 93,  0,  0, 93, 93,  0,  0, 93, 93,  0,  0, 93,  0, 93,  0, 93,
  0,  0,  0,  0, 93,  0, 93,  0,  0, 93, 93, 93,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 93,
  0,  0,  0,  0, 93,  0,  0,  0,  0,  0,  0, 93, 93,  0, 93, 93,
 93, 93,  0,  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 93,  0, 93,  0,  0, 93,  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,
  0,  0,  0,  0, 93,  0,  0, 93,  0,  0, 93,  0, 93, 93, 93, 93,
 93, 93,  0, 93,  0, 93, 93, 93, 93,  0, 93,  0, 93, 93, 93,  0,
  0,  0, 93,  0, 93, 93, 93, 93,  0, 93, 93,  0, 93, 93,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 93,  0, 93,  0,  0,
  0, 93, 93,  0,  0, 93,  0, 93,  0,  0, 93, 93,  0, 93, 93, 93,
  0, 93, 93, 93, 93,  0,  0, 93, 93,  0,  0,  0,  0,  0,  0, 93,
  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,
  0, 93, 93,  0,  0, 93,  0, 93, 93,  0, 93,  0,  0,  0,  0,  0,
  0, 93,  0,  0, 93, 93, 93,  0, 93, 93, 93, 93,  0,  0, 93,  0,
  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,  0, 93,
  0, 93,  0,  0,  0,  0,  0, 93,  0,  0, 93, 93,  0, 93,  0,  0,
  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 93,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,
  0, 93,  0,  0,  0, 93,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,
 93,  0, 93,  0,  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,  0,
 93, 93,  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0, 93,  0, 93,  0,  0,
 93,  0,  0,  0, 93,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,  0, 93,  0, 93,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,
  0, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,  0, 93, 93, 93, 93,
 93, 93,  0,  0, 93,  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93, 93, 93, 93, 93, 93, 93, 93,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 93,  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 93,  0, 93,  0,  0,  0, 93, 93,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 93, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 93,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 93,  0,  0,  0,  0,  0,  0,  0,  0, 93, 93,  0, 93,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 93, 93, 93, 93,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 93,  0,  0,
 93, 93, 93,  0, 93,  0, 93,  0, 93, 93,  0, 93,  0, 93,  0,  0,
 93, 93, 93,  0, 93, 93, 93, 93,  0,  0, 93, 93, 93, 93, 93, 93,
  0, 93, 93, 93,  0, 93, 93,  0,  0, 93,  0,  0, 93, 93, 93, 93,
  0,  0,  0,  0, 93,  0,  0, 93, 93, 93,  0, 93, 93, 93, 93,  0,
 93, 93,  0, 93, 93, 93,  0,  0, 93,  0,  0, 93,  0, 93, 93, 93,
 93, 93,  0,  0,  0,  0,  0, 93, 93,  0,  0, 93,  0,  0, 93,  0,
  0,  0,  0,  0, 93, 93, 93, 93,  0, 93, 93,  0,  0, 93,  0, 93,
 93,  0, 93, 93, 93,  0,  0, 93,  0,  0, 93, 93, 93, 93, 93, 93,
 93, 93,  0, 93, 93, 93,  0, 93, 93, 93, 93,  0, 93, 93, 93, 93,
  0, 93, 93, 93, 93, 93,  0, 93,  0, 93, 93, 93, 93, 93, 93, 93,
 93,  0, 93, 93, 93, 93, 93, 93, 93, 93,  0,  0,  0,  0,  0, 93,
  0,  0, 93, 93,  0,  0,  0,  0, 93,  0,  0,  0, 93,  0, 93, 93,
 93, 93,  0, 93,  0, 93,  0, 93, 93, 93, 93, 93, 93, 93, 93, 93,
 93, 93,  0, 93, 93, 93, 93,  0, 93, 93, 93, 93, 93, 93,  0, 93,
 93, 93, 93, 93, 93, 93, 93,  0,  0,  0, 93,  0,  0,  0,  0,  0,
  0,  0,  0, 93, 93,  0,  0,  0,  0,  0, 93, 93,  0, 93,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 93,  0,
  0,  0,  0, 93,  0,  0, 93,  0,  0, 93, 93,  0,  0,  0, 93,  0,
  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,  0, 93,  0,  0,  0,  0,
  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 93,  0,  0,  0,  0,  0,  0,  0,  0,  0, 93,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 93,  0,  0,
 93,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 93, 93,  0, 93,  0, 93, 93,  0, 93, 93,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 183, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 183, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 183, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 183, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 183, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 137, 137, 92, 92,
  0, 92,  0, 92, 92,  0,  0,  0, 92,  0,  0,  0,  0,  0,  0, 92,
 92, 92,  0, 92, 92,  0,  0, 92, 92, 92,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 97, 97, 213, 137, 137, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 110, 110, 110, 110, 97, 97, 97, 97, 97, 97, 137,
 97, 134, 97, 110, 97, 97, 97, 97, 110, 97, 97, 97, 97, 97, 97, 97,
 97, 97, 97, 97, 97, 97, 97, 110, 134, 97, 97, 97, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,
 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 110,  0,  0,  0,
  0, 122, 214, 122, 122, 122, 122, 214, 122, 122, 122, 122, 122, 129, 122, 122,
 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122,
 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122,
 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 215, 129, 215, 123, 122,
 123, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122,
 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 132,  0,
  0, 216, 216, 216, 217, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216,
 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216,
 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216,
 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216, 216,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 218, 218, 128, 123, 94, 219, 98,  0,  0,  0,  0,  0,  0, 93,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 220,
};
