/* Copyright (c) 1999, Red Hat Software, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 * X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * Except as contained in this notice, the name of the Red Hat Software shall not be
 * used in advertising or otherwise to promote the sale, use or other dealings
 * in this Software without prior written authorization from Red Hat Software
*/

#ifndef __GTK_GLYPH_LABEL_H__
#define __GTK_GLYPH_LABEL_H__

#include <gtk/gtkmisc.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_GLYPH_LABEL      gtk_glyph_label_get_type ()
#define GTK_GLYPH_LABEL(obj)     \
   GTK_CHECK_CAST ((obj), GTK_TYPE_GLYPH_LABEL, GtkGlyphLabel)
#define GTK_GLYPH_LABEL_CLASS(klass) \
   GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_GLYPH_LABEL, GtkGlyphLabelClass)
#define GTK_IS_GLYPH_LABEL(obj) \
   GTK_CHECK_TYPE ((obj), GTK_TYPE_GLYPH_LABEL)
#define GTK_IS_GLYPH_LABEL_CLASS(klass) \
   GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_GLYPH_LABEL)

typedef struct _GtkGlyphLabelClass GtkGlyphLabelClass;
typedef struct _GtkGlyphLabel GtkGlyphLabel;

struct _GtkGlyphLabelClass
{
  GtkMiscClass parent_class;
};

struct _GtkGlyphLabel
{
  GtkMisc misc;
  
  GdkFont *font;
  gboolean wide : 1;
  
  union {
    gchar *glyphs;
    guint16 *glyphs16;
  } u;
  gint length;
};

GtkType    gtk_glyph_label_get_type ();

GtkWidget *gtk_glyph_label_new          (GdkFont       *font);
void       gtk_glyph_label_set_string   (GtkGlyphLabel *glabel,
					 const gchar   *glyphs);
void       gtk_glyph_label_set_string16 (GtkGlyphLabel *glabel,
					 const guint16 *glyphs16);
void       gtk_glyph_label_set_font     (GtkGlyphLabel *glabel,
					  GdkFont      *font);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GTK_GLYPH_LABEL_H__ */

