
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>

#include "memory.h"

#define SIZE 10

GimpMemPtr ptrs[10];
GimpMemPtr * p[10];



void
dump (void)
{
  gint i;

  for (i = 0; i < 10; i++)
    {
      if (d_is_alloced (p[i]))
        {
          /* get the pointer for reading */
          d_read (p[i]);
      
          /* read value as a guchar */
          printf ("ptr %d: %s\n", i, guchar_d(p[i]));

          /* release value */
          d_release (p[i]);
        }
      else
        {
          /* no memory in this pointer */
          printf ("ptr %d: <unalloced>\n", i);
        }
    }
}


int
main (int    argc,
      char **argv)
{
  int i;

  gtk_init (&argc, &argv);
  gimp_memory_init ("foobar");
  
  g_warning ("create pointers");
  for (i = 0; i < 10; i++)
    {
      p[i] = &ptrs[i];
      d_init (p[i]);
    }
  dump ();  

  g_warning ("alloc and init 4 and 9");
  d_alloc (p[4], SIZE);
  d_write (p[4]);
  strncpy (gchar_d(p[4]), "444444444", 10);
  d_release (p[4]);

  d_alloc (p[9], SIZE);
  d_write (p[9]);
  strncpy (gchar_d(p[9]), "999999999", 10);
  d_release (p[9]);
  dump();

  
  g_warning ("make 0-3 COW refs to 4, 5-8 COW refs to 9");
  d_join (p[4], p[0]);
  d_join (p[4], p[1]);
  d_join (p[4], p[2]);
  d_join (p[4], p[3]);
  d_join (p[9], p[5]);
  d_join (p[9], p[6]);
  d_join (p[9], p[7]);
  d_join (p[9], p[8]);
  dump ();

#define CHANGEBAD(n,s) \
  d_update (p[n]); \
  strncpy (gchar_d(p[n]), s, 2); \
  d_release (p[n]);

#define CHANGEGOOD(n,s) \
  d_write (p[n]); \
  strncpy (gchar_d(p[n]), s, 2); \
  d_release (p[n]);


  g_warning ("touch 0 and 5");
  CHANGEGOOD (0,"0000");
  CHANGEGOOD (5,"5555");
  dump ();

  g_warning ("badtouch 1 and 6");
  CHANGEBAD (1,"1111");
  CHANGEBAD (6,"6666");
  dump ();

  g_warning ("unalloc 4 and 9");
  d_unalloc (p[4]);
  d_unalloc (p[9]);
  dump ();

  g_warning ("split 3 and 8");
  d_split (p[3]);
  d_split (p[8]);
  dump ();

  g_warning ("badtouch 2 3 7 8");
  CHANGEBAD (2,"2222");
  CHANGEBAD (3,"3333");
  CHANGEBAD (7,"7777");
  CHANGEBAD (8,"8888");
  dump ();
  
  return 0;
}


