#include <stdio.h>
#include "tile.h"


TileManager *
dup_buffer (TileManager * src)
{
  GimpBuffer * dst;
  GimpPortion p;
  GimpArea roi;
  
  dst = tile_manager_new (gimp_buffer_width (src),
                          gimp_buffer_height (src),
                          gimp_buffer_depth (src));
  
  roi.a.x = 0;
  roi.a.y = 0;
  roi.b.x = gimp_buffer_width (src);
  roi.b.y = gimp_buffer_height (src);

  g_return_val_if_fail (gimp_buffer_focus (src, &p, &roi) == TRUE, NULL);
  g_return_val_if_fail (gimp_buffer_map (dst, &p.max, src, &p.max) == TRUE, NULL);

  return dst;
}


Tile*
tile_manager_get (TileManager *tm,
		  int          tile_num,
		  int          wantread,
		  int          wantwrite)
{
  g_message ("kill me");
  return NULL;
}


void
tile_manager_get_async (TileManager *tm,
                        int          xpixel,
                        int          ypixel)
{
  g_message ("kill me 2");
}
    


/* leak 100K if someone gets a tile and forgets to release it */
typedef struct {
  Tile t;
  void * mem;
} Tile2;


Tile*
tile_manager_get_tile (TileManager *tm,
		       int          xpixel,
		       int          ypixel,
		       int          wantread,
		       int          wantwrite)
{
  GimpArea roi;
  Tile2 * t2;
  Tile * t;
  
  t2 = g_new (Tile2, 1);
  t2->mem =  g_malloc (1/*100000*/);  
  t = (Tile *) t2;
  t->b = tm;
  t->a.tag = 42;

  roi.a.x = xpixel;
  roi.a.y = ypixel;
  roi.b.x = t->b->_x.len;
  roi.b.y = t->b->_y.len;
  
  if (gimp_buffer_focus (t->b, &t->p, &roi) != TRUE)
    {
      tile_release (t, FALSE);
      return NULL;
    }

  if (wantwrite == TRUE)
    {
      if (gimp_buffer_use (t->b, &t->p, USE_WRITE) != TRUE)
        {
          tile_release (t, FALSE);
          return NULL;
        }
    }
  else if (wantread == TRUE)
    {
      if (gimp_buffer_use (t->b, &t->p, USE_READ) != TRUE)
        {
          tile_release (t, FALSE);
          return NULL;
        }
    }
  else
    {
      return t;
    }

  if (gimp_buffer_data (t->b, &t->p, &t->a) != TRUE)
    {
      tile_release (t, FALSE);
      return NULL;
    }

  return t;
}


void
tile_release (Tile *t,
              int dirty)
{
  if (t->a.tag != 42)
    gimp_buffer_use (t->b, &t->p, USE_RELEASE);
  g_free (((Tile2*)t)->mem);
  g_free (t);
}


void *
tile_data_pointer (Tile *t,
                   int x,
                   int y)
{
  guchar * d;

  d = guchar_d (gpa_data (&t->a))
    + (y * gpa_rowstride (&t->a))
    + (x * gpa_pixstride (&t->a));

  return (void*) d;
}


gint
tile_is_valid (Tile *tile)
{
  if (gimp_buffer_query (tile->b, &tile->p, &tile->s) == FALSE)
    return FALSE;

  return tile->s.valid;
}
