/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __DRAWABLE_PVT_H__
#define __DRAWABLE_PVT_H__

#include <gtk/gtkdata.h>

/* forward declarations */
struct _Canvas;


struct _GimpDrawable
{
  GtkData data;

  int ID;				/* provides a unique ID */
  int gimage_ID;			/* ID of gimage owner */

  char *name;				/* name of drawable */
  int offset_x, offset_y;		/* offset of layer in image */

  struct _Canvas *tiles;		/* tiles for drawable data */
  int visible;				/* controls visibility */
  int dirty;				/* dirty bit */

  struct _Canvas *preview;		/* preview of the channel */
  int preview_valid;			/* is the preview valid? */
};

struct _GimpDrawableClass
{
  GtkDataClass parent_class;

  void (*invalidate_preview) (GtkObject *);
};

#endif /* __DRAWABLE_PVT_H__ */
