#! /bin/sh
# Copyright (C) 2011-2012 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Test aclocal's '--acdir', '--automake-acdir' and '--system-acdir'
# options.  Also check that stuff in the automake acdir takes precedence
# over stuff in the system acdir.

. ./defs || Exit 1

mkdir am sys

cat >> configure.ac <<'END'
MY_MACRO
END

cat > am/foo.m4 <<'END'
AC_DEFUN([AM_INIT_AUTOMAKE], [fake--init--automake])
END

cat > sys/foo.m4 <<'END'
AC_DEFUN([MY_MACRO], [my--macro])
END

$ACLOCAL --automake-acdir am
$AUTOCONF --force
$FGREP 'fake--init--automake' configure
$FGREP 'MY_MACRO' configure

rm -rf autom4te*.cache

$ACLOCAL --system-acdir sys
$AUTOCONF --force
$FGREP 'am__api_version' configure
$FGREP 'my--macro' configure

rm -rf autom4te*.cache

$ACLOCAL --automake-acdir am --system-acdir sys
$AUTOCONF --force
$FGREP 'fake--init--automake' configure
$FGREP 'my--macro' configure

rm -rf autom4te*.cache

$ACLOCAL --system-acdir sys --automake-acdir am
$AUTOCONF --force
$FGREP 'fake--init--automake' configure
$FGREP 'my--macro' configure

rm -rf autom4te*.cache

# Stuff in automake acdir takes precedence over stuff in system acdir.
cat > am/bar.m4 <<'END'
AC_DEFUN([MY_MACRO], [am--macro])
END
$ACLOCAL --automake-acdir am --system-acdir sys
$AUTOCONF --force
$FGREP 'fake--init--automake' configure
$FGREP 'am--macro' configure
$FGREP 'my--macro' configure && Exit 1 # Just to be sure.

rm -rf autom4te*.cache

# Obsolescent '--acdir' option.
$ACLOCAL -Wobsolete --acdir am 2>stderr && { cat stderr >&2; Exit 1; }
cat stderr >&2
grep '.*--acdir.*deprecated' stderr

rm -rf autom4te*.cache

$ACLOCAL -Wno-obsolete --acdir am
$AUTOCONF --force
$FGREP 'fake--init--automake' configure
$FGREP 'am--macro' configure

rm -rf autom4te*.cache

$ACLOCAL -Wno-obsolete --acdir sys 2>stderr && { cat stderr >&2; Exit 1; }
cat stderr >&2
grep 'macro .*AM_INIT_AUTOMAKE.* not found' stderr

:
