#ifndef __GAMESTATEMANAGER_H__
#define __GAMESTATEMANAGER_H__


#include <string>
#include <vector>
#include <iostream>
#include <fstream>
using namespace std;

#include <sys/stat.h>

#include "SDL.h"
#include "SDL_image.h"
#include "SDL_mixer.h"

#include "font.h"
#include "globals.h"
#include "soundmanager.h"

class GameState;

class GameStateManager
{
public:
  void changeState (GameState * state);
  void pushState (GameState * state);
  void popState ();
  void init ();
  void initVideo ();
  void initAudio ();
  void toggleFullscreen ();
  void toggleSounds ()
  {
    m_playSounds = !m_playSounds;
  }
  void cleanup ();
  void handleEvents ();
  void update ();
  void draw ();
  void quit ();

  bool running ()
  {
    return m_running;
  }

  SDL_Surface *screen;

  SDL_Surface *imgSkin;

  int getTime ()
  {
    return m_time;
  }

  bool isFullscreen ()
  {
    return m_fullscreen;
  }
  bool playsSounds ()
  {
    return m_playSounds;
  }

  string getSkinFilename ()
  {
    return m_strSkinFilename;
  }
  void setSkin (string skinName, string skinFilename);

  void drawString (int font, string text, int x, int y);
  void drawStringCentered (int font, string text, int x, int y);
  void drawString (int font, string text, int x, int y, SDL_Surface * dest);
  void drawStringCentered (int font, string text, int x, int y,
			   SDL_Surface * dest);
  int getCharWidth (int font)
  {
    return fonts[font]->getCharWidth ();
  }
  int getCharHeight (int font)
  {
    return fonts[font]->getCharHeight ();
  }

  void loadSettings ();
  void saveSettings ();
  void loadSkin ();
  void setLevelset (string levelsetName, string levelsetFilename);
  void setStartLevel (int startLevel);
  string getLevelsetName ()
  {
    return m_strLevelsetName;
  }
  string getLevelsetFilename ()
  {
    return m_strLevelsetFilename;
  }
  int getStartLevel ()
  {
    return m_startLevel;
  }
  bool isEnteringHighScore ()
  {
    return m_enteringHighScore;
  }
  void setEnteringHighScore (bool enteringHighScore);
  void setScoreIndex (int scoreIndex);
  void setScore (int score);
  int getScoreIndex ()
  {
    return m_scoreIndex;
  }
  int getScore ()
  {
    return m_score;
  }
  void playSound (string name);
  void loopSound (string name);
  void stopSound ();
  void loadSounds ();
  void loadImages ();
private:
  void loadFonts ();
  void makeFont (string location, int charWidth, int charHeight, int r, int g,
		 int b);
  int maxFPS;
  int m_time;
  long m_lastTime;
  bool m_fullscreen;
  bool m_playSounds;
  bool m_running;
  bool m_enteringHighScore;
  int m_startLevel;
  string m_strSkinName;
  string m_strSkinFilename;
  string m_strLevelsetName;
  string m_strLevelsetFilename;
  int m_scoreIndex;
  int m_score;
  vector < GameState * >states;
  vector < Font * >fonts;
  SoundManager *m_soundManager;
};

#endif
