/*
 *  Ball And Paddle
 *
 *  Copyright (C) 2007 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#include "skinmenu.h"
#include "optionsmenu.h"

SkinMenu
  SkinMenu::m_instance;

void
SkinMenu::init ()
{
  string location = IMAGEPATH + "/menuback.png";
  SDL_Surface *temp = IMG_Load (location.c_str ());
  if (temp != NULL)
    imgBackground = SDL_DisplayFormat (temp);
  SDL_FreeSurface (temp);
  cursor = 0;
#ifndef SINGLEDIR
  location = string (PREFIX) + "/share/ballandpaddle/skins";
#endif
#ifdef SINGLEDIR
  location = string (PREFIX) + "/skins";
#endif
  ifstream file;
  file.open (location.c_str (), ifstream::in);
  int skinCount;
  file >> skinCount;
  // buffer to consume rest of line
  char buffer[256];
  // consume the rest of the line with the number of skins
  file.getline (buffer, 256);
  for (int i = 0; i < skinCount; i++)
    {
      char strSkinName[256];
      file.getline (strSkinName, 256);
      skinNames.push_back (string (strSkinName));
      char strSkinFilename[256];
      file.getline (strSkinFilename, 256);
      skinFilenames.push_back (string (strSkinFilename));
    }
  file.close ();
  for (int i = 0; i < skinNames.size (); i++)
    menuItems.push_back (skinNames[i] + " [ ]");
  menuItems.push_back ("Back");
  spacing = 40;
}

void
SkinMenu::cleanup ()
{
  while (!menuItems.empty ())
    menuItems.pop_back ();
  while (!skinNames.empty ())
    skinNames.pop_back ();
  while (!skinFilenames.empty ())
    skinFilenames.pop_back ();
  SDL_FreeSurface (imgBackground);
}

void
SkinMenu::pause ()
{
}

void
SkinMenu::resume ()
{
}

void
SkinMenu::draw (GameStateManager * gameStateManager)
{
  SDL_BlitSurface (imgBackground, NULL, gameStateManager->screen, NULL);
  SDL_Rect r = { 160, 230, 320, 230 };
  SDL_FillRect (gameStateManager->screen, &r,
		SDL_MapRGB (gameStateManager->screen->format, 64, 64, 64));
  for (int i = 0; i < menuItems.size (); i++)
    {
      if (cursor == i)
	gameStateManager->drawStringCentered (FONT_ACTIVE, menuItems[i], 320,
					      250 + i * spacing);
      else
	gameStateManager->drawStringCentered (FONT_INACTIVE, menuItems[i],
					      320, 250 + i * spacing);
    }
}

void
SkinMenu::handleEvents (GameStateManager * gameStateManager)
{

  int mouseX;
  int mouseY;

  SDL_Event event;

  while (SDL_PollEvent (&event))
    {
      switch (event.type)
	{
	case SDL_QUIT:
	  gameStateManager->quit ();
	  break;
	case SDL_KEYDOWN:
	  switch (event.key.keysym.sym)
	    {
	    case SDLK_RETURN:
	      handleItem (gameStateManager);
	      break;
	    case SDLK_UP:
	      cursor--;
	      if (cursor < 0)
		cursor = menuItems.size () - 1;
	      break;
	    case SDLK_DOWN:
	      cursor++;
	      if (cursor >= menuItems.size ())
		cursor = 0;
	      break;
	    }
	  break;
	case SDL_MOUSEMOTION:
	  mouseX = event.motion.x;
	  mouseY = event.motion.y;

	  int x1;
	  int x2;
	  for (int i = 0; i < menuItems.size (); i++)
	    {
	      x1 =
		320 -
		menuItems[i].length () *
		gameStateManager->getCharWidth (FONT_INACTIVE) / 2;
	      x2 =
		x1 +
		menuItems[i].length () *
		gameStateManager->getCharWidth (FONT_INACTIVE);
	      if (mouseX >= x1 && mouseX <= x2 && mouseY >= 250 + i * spacing
		  && mouseY <=
		  250 + gameStateManager->getCharHeight (FONT_INACTIVE) +
		  i * spacing)
		cursor = i;
	    }
	  break;
	case SDL_MOUSEBUTTONDOWN:
	  handleItem (gameStateManager);
	  break;
	}
    }

}

void
SkinMenu::update (GameStateManager * gameStateManager)
{
  for (int i = 0; i < skinNames.size (); i++)
    {
      if (gameStateManager->getSkinFilename ().compare (skinFilenames[i]) ==
	  0)
	{
	  if (menuItems[i].compare (skinNames[i] + " [X]") != 0)
	    menuItems[i] = skinNames[i] + " [X]";
	}
      else
	{
	  if (menuItems[i].compare (skinNames[i] + " [ ]") != 0)
	    menuItems[i] = skinNames[i] + " [ ]";
	}
    }
}

void
SkinMenu::handleItem (GameStateManager * gameStateManager)
{
  for (int i = 0; i < skinNames.size (); i++)
    {
      if (cursor == i)
	{
	  gameStateManager->setSkin (skinNames[i], skinFilenames[i]);
	  gameStateManager->saveSettings ();
	  gameStateManager->loadSkin ();
	}
    }
  if (cursor == menuItems.size () - 1)
    gameStateManager->changeState (OptionsMenu::instance ());
}
