#include "soundmanager.h"

SoundManager::SoundManager ()
{
}

SoundManager::~SoundManager ()
{
}

void
SoundManager::addSound (string name, string filename)
{
  Mix_Chunk *temp = Mix_LoadWAV (filename.c_str ());
  if (temp == NULL)
    {
      cout << "Couldn't load sound file: " << filename << endl;
      return;
    }
  sounds.push_back (temp);
  soundnames.push_back (name);
}

void
SoundManager::playSound (string name)
{
  for (int i = 0; i < sounds.size (); i++)
    {
      if (soundnames[i].compare (name) == 0)
	{
	  Mix_PlayChannel (-1, sounds[i], 0);
	}
    }
}

void
SoundManager::loopSound (string name)
{
  for (int i = 0; i < sounds.size (); i++)
    {
      if (soundnames[i].compare (name) == 0)
	{
	  if (Mix_PlayChannel (-1, sounds[i], -1) == -1)
	    cout << "Error playing sound \"" << name << "\"" << endl;
	}
    }
}

void
SoundManager::freeSounds ()
{
  for (int i = 0; i < sounds.size (); i++)
    Mix_FreeChunk (sounds[i]);
}
