// Copyright (C) 2005 Open Source Telecom Corp.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "module.h"

namespace binder {
using namespace ost;
using namespace std;

bool Methods::scrWait(void)
{
	const char *cp = getKeyword("id");
	state.timeout = getTimeoutKeyword("timeout");
	
	if(!cp)
		cp = getValue(NULL);

	if(cp)
	{
		state.join.peer = getSid(cp);
		if(!state.join.peer)
		{
			error("session-invalid");
			return true;
		}
	}
	else
		state.join.peer = NULL;

	state.join.dtmf = false;
	setState(STATE_WAIT);
	return false;
}

bool Methods::scrDial(void)
{
        unsigned len = 0;
        const char *cp;
        
        state.join.answer_timer = state.timeout = getTimeoutKeyword("timeout");
        
        while(NULL != (cp = getValue(NULL)))
        {
                setString(state.join.digits + len, sizeof(state.join.digits) - len, cp);
                len = strlen(state.join.digits);
        }

        state.join.dial = state.join.digits;
        setState(STATE_DIAL);
        return false;  
}

bool Methods::scrJoin(void)
{
	Event event;

	state.timeout = getTimeoutKeyword("timeout");
	state.join.peer = getSid(getValue(NULL));
	state.join.dtmf = false;

	if(!state.join.peer)
	{
		error("session-invalid");
		return true;
	}

	memset(&event, 0, sizeof(event));
	event.id = JOIN_PEER;
	release();
	if(!state.join.peer->postEvent(&event))
	{
		error("peer-invalid");
		return true;
	}
	setState(STATE_JOIN);
	return false;
}

bool Methods::scrSignal(void)
{
	Line *line = getLine();
	Event event;
	BayonneSession *session;

	if(!var_pid)
	{
		error("not-connected");
		return true;
	}

	session = getSid(var_pid);
	
	if(!session)
	{
		error("session-invalid");
		return true;
	}

	memset(&event, 0, sizeof(event));
	if(!strnicmp(line->cmd, "busy", 4))
		event.id = CHILD_BUSY;
	else
		event.id = CHILD_FAILED;
	session->queEvent(&event);
	strcpy(var_pid, "none");
	advance();
	return true;
}

bool Methods::scrStart(void)
{
	char nbuf[MAX_PATHNAME];
	const char *name = getValue(NULL);
	char *number = NULL;
	unsigned len = 0;
	const char *cp = getMember();
	Event event;
	ScriptImage *img = useImage();
	Name *scr;
	Line *sel;
	BayonneSession *child;
	BayonneSpan *span;
	const char *caller = getKeyword("caller");
	const char *display = getKeyword("display");
	Symbol *sym = getKeysymbol("session", 16);
	unsigned idx = 0;
	timeslot_t pos;
	unsigned count;
	Audio::Level level = 26000;
	TelTone::tonekey_t *key = NULL;
	BayonneDriver *drv = NULL;

	if(cp)
	{
		drv = BayonneDriver::get(cp);
		if(!drv)
		{
			error("start-driver-missing");
			return true;
		}
	}

	while(NULL != (cp = getValue(NULL)))
	{
		number = nbuf;
		snprintf(nbuf + len, sizeof(nbuf) - len, "%s", cp);
		len = strlen(nbuf);
	}

	scr = img->getScript(name);
	if(!scr)
	{
		endImage(img);
		if(!scriptEvent("start:missing"))
			goto failed;
		return true;
	}

	if(scr->access != ScriptInterp::scrPUBLIC)
	{
		endImage(img);
		if(!scriptEvent("start:invalid"))
			goto failed;
		return true;
	}

	release();	// release any global locks...

	if(drv || iface == IF_INET)
		goto any;

	sel = scr->select;
	if(!sel)
		goto any;

	while(sel)
	{
		idx = 0;
		cp = strchr(cp, '.');
		if(cp && !stricmp(cp, ".span"))
		     while(NULL != (cp = sel->args[idx++]))
		{
			span = BayonneSpan::get(atoi(cp));
			if(!span)
				continue;

			pos = span->getFirst();		
			count = span->getCount();
			while(count--)
			{
				child = getSession(pos++);
				if(!child)
					continue;

				child->enter();
				if(child->isIdle())
					goto start;
				child->leave();
			}
		}
	
		else while(NULL != (cp = sel->args[idx++]))
		{
			child = getSid(cp);
			if(!child)
				continue;

			child->enter();
			if(child->isIdle())
				goto start;
			child->leave();
		}
		sel = sel->next;
	}
	goto busy;

any:
	if(!drv)
		drv = driver;

	child = drv->getIdle();
	if(!child)
	{
busy:
		endImage(img);
		if(!scriptEvent("start:busy"))
			goto failed;
		return true;
	}

	child->enter();

start:
	if(caller)
		child->setConst("session.caller", caller);

	if(display)
		child->setConst("session.display", display);

	memset(&event, 0, sizeof(event));	
	event.id = START_OUTGOING;
	event.start.img = img;
	event.start.scr = scr;
	event.start.parent = this;
	event.start.dialing = number;

	if(child->postEvent(&event))
		goto success;

	child->leave();
	endImage(img);	

failed:
	if(!scriptEvent("start:failed"))
	{
		ScriptInterp::commit(sym, "none");
		error("start-failed");
	}
	return true;

success:
	if(sym)
		ScriptInterp::commit(sym, child->getExternal("session.id"));
	strcpy(state.tone.sessionid, child->getExternal("session.id"));
	child->leave();
	
	state.timeout = getTimeoutKeyword("timeout");
	state.tone.duration = getTimeoutKeyword("duration");
	if(state.timeout && state.timeout != TIMEOUT_INF)
	{
		if(audio.tone)
		{
			delete audio.tone;
			audio.tone = NULL;
		}
		cp = getKeyword("tone");
		if(cp)
			key = TelTone::find(cp, Bayonne::server->getLast("location"));
		if(key)
			audio.tone = new TelTone(key, level, getToneFraming());
		if(number)
			setState(STATE_CONNECT);
		else if(state.tone.duration && state.tone.duration != TIMEOUT_INF)
			setState(STATE_CONNECT);
		else
			setState(STATE_START);
		return false;
	}

	advance();
	return true;
}

bool Methods::scrKey(void)
{
        const char *cp;
        const char *val = getKeyword("value");
        const char *ind = getKeyword("index");
        Symbol *sym;

        while(NULL != (cp = getOption(NULL)))
        {
                sym = mapSymbol(cp, PersistProperty::getSize());
                if(!sym)
                        continue;
                PersistProperty::refresh(sym, ind, val);
        }
        advance();       
        return true;  
} 

bool Methods::scrCancel(void)
{
	Event event;
	BayonneSession *s;
	const char *cp;
	const char *errmsg = NULL;

	while(NULL != (cp = getValue(NULL)))
	{
		s = getSid(cp);
		if(!s)
		{
			errmsg = "invalid-timeslot";
			continue;
		}
		memset(&event, 0, sizeof(event));
		event.id = CANCEL_CHILD;
		queEvent(&event);
	}

	if(errmsg)
		error(errmsg);
	else
		advance();
	return true;
}	

bool Methods::scrDetach(void)
{
	Event event;
	BayonneSession *s;
	const char *cp;
	const char *errmsg = NULL;

	while(NULL != (cp = getValue(NULL)))
	{
		s = getSid(cp);
		if(!s)
		{
			errmsg = "invalid-timeslot";
			continue;
		}
		memset(&event, 0, sizeof(event));
		event.id = DETACH_CHILD;
		queEvent(&event);
	}

	if(errmsg)
		error(errmsg);
	else
		advance();
	return true;
}	

} // end namespace
