/* Declaration for error-reporting function
   Copyright (C) 1995-1997, 2003, 2006, 2008-2020 Free Software Foundation,
   Inc.
   This file is part of the GNU C Library.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

#ifndef _ERROR_H
#define _ERROR_H 1

/* On mingw, the flavor of printf depends on whether the extensions module
 * is in use; the check for <stdio.h> determines the witness macro.  */
#ifndef _GL_ATTRIBUTE_SPEC_PRINTF
# if GNULIB_PRINTF_ATTRIBUTE_FLAVOR_GNU
#  define _GL_ATTRIBUTE_SPEC_PRINTF __gnu_printf__
# else
#  define _GL_ATTRIBUTE_SPEC_PRINTF __printf__
# endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Print a message with 'fprintf (stderr, FORMAT, ...)';
   if ERRNUM is nonzero, follow it with ": " and strerror (ERRNUM).
   If STATUS is nonzero, terminate the program with 'exit (STATUS)'.  */

extern void error (int __status, int __errnum, const char *__format, ...)
     _GL_ATTRIBUTE_FORMAT ((_GL_ATTRIBUTE_SPEC_PRINTF, 3, 4));

extern void error_at_line (int __status, int __errnum, const char *__fname,
                           unsigned int __lineno, const char *__format, ...)
     _GL_ATTRIBUTE_FORMAT ((_GL_ATTRIBUTE_SPEC_PRINTF, 5, 6));

/* If NULL, error will flush stdout, then print on stderr the program
   name, a colon and a space.  Otherwise, error will call this
   function without parameters instead.  */
extern void (*error_print_progname) (void);

/* This variable is incremented each time 'error' is called.  */
extern unsigned int error_message_count;

/* Sometimes we want to have at most one error per line.  This
   variable controls whether this mode is selected or not.  */
extern int error_one_per_line;

#ifdef __cplusplus
}
#endif

#endif /* error.h */
