/* translation of file "petrinet-patterns-handlers.k" */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.11 (C) 1998-2007 Humboldt-University of Berlin $
 */
#define KC_FUNCTIONS_petrinet_patterns_handlers

#include <stdlib.h>
#include "ast-system-k.h"
#include "petrinet-patterns-handlers.h"
namespace kc { }
using namespace kc;
/* included stuff */
#line 27 "petrinet-patterns-handlers.k"
/*!
 * \file    petrinet-patterns-handlers.cc
 *
 * \brief   Petri net patterns for the handlers
 *
 * \author  Niels Lohmann <nlohmann@informatik.hu-berlin.de>,
 *          last changes of: \$Author: znamirow $ 
 * 
 * \since   2007-03-04
 *
 * \date    \$Date: 2007/07/13 12:50:47 $
 * 
 * \note    This file is part of the tool BPEL2oWFN and was created during the
 *          project "Tools4BPEL" at the Humboldt-Universitt zu Berlin. See
 *          http://www.informatik.hu-berlin.de/top/tools4bpel for details.
 *
 * \note    This file was created using Kimwitu++ reading file petrinet-patterns-scopes.k.
 *          See http://site.informatik.hu-berlin.de/kimwitu++ for details.
 *
 * \version \$Revision: 1.22 $
 */

#line  37 "petrinet-patterns-handlers.cc"
#line 61 "petrinet-patterns-handlers.k"
#include <cassert>

#include "ast-config.h"
#include "helpers.h"
#include "ast-tools.h"
#include "ast-details.h"
#include "options.h"
#include "globals.h"
#include "petrinet-patterns-shortcuts.h"

using std::cerr;
using std::endl;

extern PNapi::PetriNet PN;

#line  54 "petrinet-patterns-handlers.cc"
#line 86 "petrinet-patterns-handlers.k"
/*!
 * \fn      void kc::PFaultHandlers(impl_tFaultHandlers* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <faultHandlers> construct.
 *
 *          \image html "fh.png" "pattern"
 *
 * \note    This function embeds the <faultHandlers> to the parent scope.
 *
 * \todo    
 *          - Replace NoCatchAll by a CatchAll phylum with a <rethrow> activity?
 *          - Implement the new <faultHandlers> pattern.
 *
 * \ingroup patterns
 */

#line  72 "petrinet-patterns-handlers.cc"
#line 236 "petrinet-patterns-handlers.k"
/*!
 * \fn      void kc::PTerminationHandler(impl_tTerminationHandler* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <terminationHandler> construct.
 *
 *          \image html "th.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \note    This function embeds the <terminationHandler> to the parent scope.
 *
 * \ingroup patterns
 */

#line  89 "petrinet-patterns-handlers.cc"
#line 324 "petrinet-patterns-handlers.k"
/*!
 * \fn      void kc::PCompensationHandler(impl_tCompensationHandler* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <compensationHandler> construct.
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \note    This function embeds the <compensationHandler> to the parent scope.
 *
 * \ingroup patterns
 *
 * \todo    Remove or implement code snippet for loop count parameter.
 */

#line  106 "petrinet-patterns-handlers.cc"
#line 381 "petrinet-patterns-handlers.k"
/*!
 * \fn      void kc::PEventHandlers(impl_tEventHandlers* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <eventHandlers> construct.
 *
 *          \image html "eh.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 * 
 * \todo 
 *          - Use "receivingTransition" function in <onEvent> branches.
 *          - Implement <onAlarm> pattern with "repeatEvery" attribute.
 *          - Check the pattern with stopping constructs.
 */

#line  124 "petrinet-patterns-handlers.cc"
/* end included stuff */


namespace kc {

#ifndef KC_TRACE_PROVIDED
#define KC_TRACE_PROVIDED(COND,FILE,LINE,NODE) COND
#endif

void PFaultHandlers(impl_tFaultHandlers *abstract_phylum, uview current_view)
#line 103 "petrinet-patterns-handlers.k"
{
    impl_tFaultHandlers_FaultHandlers* phylum = static_cast<impl_tFaultHandlers_FaultHandlers*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id, true);
    string prefix = toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".faultHandlers.";



    Place *p1 =  PN.newPlace(prefix + "initial");
    Place *p2 =  PN.newPlace(prefix + "fault");
    Place *p3 =  PN.newPlace(prefix + "final");
    Place *p4 =  PN.newPlace(prefix + "stop");
    Place *p5 =  PN.newPlace(prefix + "stopped");
    Place *p6 =  PN.newPlace(prefix + "fault_up");
    Place *p7 =  PN.newPlace(prefix + "branch");
    Place *p8 =  PN.newPlace(prefix + "inner_stopped");
    Place *p9 =  PN.newPlace(prefix + "inner_finalized");

    if ( true ) 
    {

	Transition *t1 = PN.newTransition(prefix + "std_evaluate");
	PN.newArc(p1, t1);
	PN.newArc(p2, t1, READ);
	PN.newArc((PN.findPlace(globals::ASTEmap[phylum->id]->parentScopeId, ".internal.take_ch_fault")), t1, READ);
	PN.newArc(t1, p7);

	Transition *t2 = PN.newTransition(prefix + "ch_evaluate");
	PN.newArc(p1, t2);
	PN.newArc(p2, t2, READ);
	PN.newArc((PN.findPlace(globals::ASTEmap[phylum->id]->parentScopeId, ".internal.deny_ch_fault")), t2);
	PN.newArc(t2, (PN.findPlace(globals::ASTEmap[phylum->id]->parentScopeId, ".internal.take_ch_fault")));
	PN.newArc(t2, p7);

	Transition *t5 = PN.newTransition(prefix + "stopped_fh");
	PN.newArc(p8, t5);
	PN.newArc(p2, t5);
	PN.newArc(t5, p5);

	Transition *t6 = PN.newTransition(prefix + "finish_fh");
	PN.newArc(p9, t6);
	PN.newArc(p2, t6);
	PN.newArc(t6, p3);

	Transition *t7 = PN.newTransition(prefix + "stop_initial");
	PN.newArc(p1, t7);
	PN.newArc(p4, t7);
	PN.newArc(t7, p8);

	Transition *t8 = PN.newTransition(prefix + "stop_branching");
	PN.newArc(p7, t8);
	PN.newArc(p4, t8);
	PN.newArc(t8, p8);


	unsigned int catchBranches = 1;
	{
#line 160 "petrinet-patterns-handlers.k"
	    tCatch_list kc_fe_selvar_1 =  phylum->tCatch_list_1;

#line  197 "petrinet-patterns-handlers.cc"
	    while(
		    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
		) {
		tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
		{
#line 160 "petrinet-patterns-handlers.k"
		    {
#line 161 "petrinet-patterns-handlers.k"
			if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 161 "petrinet-patterns-handlers.k"
#line 160 "petrinet-patterns-handlers.k"
			    const tCatch catchBranch = kc_selvar_0_1;
#line 160 "petrinet-patterns-handlers.k"
			    const activity innerActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 161 "petrinet-patterns-handlers.k"


			    innerActivity->unparse(pseudoPrinter, current_view);

			    Transition *t3 = PN.newTransition(prefix + "catch" + toString(catchBranches));
			    PN.newArc(p7, t3);
			    PN.newArc(p2, t3, READ);
			    PN.newArc(t3, PN.findPlace(innerActivity->id, ".initial"));

			    PN.mergePlaces(prefix + "inner_finalized", toString(innerActivity->id) + ".final");
			    PN.mergePlaces(prefix + "stop", toString(innerActivity->id) + ".stop");
			    PN.mergePlaces(prefix + "inner_stopped", toString(innerActivity->id) + ".stopped");

#line  226 "petrinet-patterns-handlers.cc"
			} else
			{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
		    }

#line  231 "petrinet-patterns-handlers.cc"
		}
		kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 160 "petrinet-patterns-handlers.k"

#line  236 "petrinet-patterns-handlers.cc"
	    }
	}
#line 174 "petrinet-patterns-handlers.k"


	{
#line 176 "petrinet-patterns-handlers.k"
	    tCatchAll kc_selvar_0_1 = phylum_cast<tCatchAll>(phylum->tCatchAll_1);
#line 198 "petrinet-patterns-handlers.k"
	    if ((kc_selvar_0_1->prod_sel() == sel_NoCatchAll)) {
#line 198 "petrinet-patterns-handlers.k"
#line 198 "petrinet-patterns-handlers.k"

		Transition *t3 = throwFault(p1, p6, "initial", prefix, mkinteger(phylum->id), 4);
		Transition *t4 = stop(p6, "fault_up", prefix);

#line  253 "petrinet-patterns-handlers.cc"
	    } else
#line 179 "petrinet-patterns-handlers.k"
		if ((kc_selvar_0_1->prod_sel() == sel_CatchAll)) {
#line 179 "petrinet-patterns-handlers.k"
#line 178 "petrinet-patterns-handlers.k"
		const activity innerActivity = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->activity_1;
#line 178 "petrinet-patterns-handlers.k"
		const integer _id2 = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->integer_1;
#line 179 "petrinet-patterns-handlers.k"

		header(_id2, true);


		innerActivity->unparse(pseudoPrinter, current_view);

		Transition *t4 = PN.newTransition(prefix + "catchAll");
		PN.newArc(p7, t4);
		PN.newArc(p2, t4, READ);
		PN.newArc(t4, PN.findPlace(innerActivity->id, ".initial"));

		PN.mergePlaces(prefix + "inner_finalized", toString(innerActivity->id) + ".final");
		PN.mergePlaces(prefix + "stop", toString(innerActivity->id) + ".stop");
		PN.mergePlaces(prefix + "inner_stopped", toString(innerActivity->id) + ".stopped");

		footer(_id2, true);

#line  280 "petrinet-patterns-handlers.cc"
	    } else
	    {
#line 203 "petrinet-patterns-handlers.k"
#line 203 "petrinet-patterns-handlers.k"

#line  286 "petrinet-patterns-handlers.cc"
	    }
	}
#line 205 "petrinet-patterns-handlers.k"



	PN.mergePlaces((toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".internal.inner_stopped"), (prefix + "initial"));
	PN.mergePlaces((toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".internal.fh_fault"),      (prefix + "fault"));
	PN.mergePlaces((toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".internal.final"),         (prefix + "final"));
	if (globals::ASTEmap[phylum->id]->parentScopeId != 1)
	{
	    PN.mergePlaces((toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".internal.stop"),        (prefix + "stop"));
	    PN.mergePlaces((toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".internal.stopped"),     (prefix + "stopped"));
	}
	else
	{

	    PN.mergePlaces((toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".internal.inner_stop"),  (prefix + "stop"));
	    PN.mergePlaces((toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".internal.final"),       (prefix + "stopped"));
	}

    }
    footer(phylum->id, true);

#line 225 "petrinet-patterns-handlers.k"
}
#line  313 "petrinet-patterns-handlers.cc"

void PTerminationHandler(impl_tTerminationHandler *abstract_phylum, uview current_view)
#line 252 "petrinet-patterns-handlers.k"
{
    impl_tTerminationHandler_TerminationHandler* phylum = static_cast<impl_tTerminationHandler_TerminationHandler*>(abstract_phylum);
    assert(phylum != NULL);
    assert(globals::ASTEmap[phylum->id] != NULL);

    header(phylum->id, true);
    string prefix = toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".terminationHandler.";


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");
    Place *p3 = PN.newPlace(prefix + "stop");
    Place *p4 = PN.newPlace(prefix + "running");
    Place *p5 = PN.newPlace(prefix + "stopping");
    Place *p6 = PN.newPlace(prefix + "inner_initial");
    Place *p7 = PN.newPlace(prefix + "inner_final");
    Place *p8 = PN.newPlace(prefix + "inner_fault");

    Transition *t1 = PN.newTransition(prefix + "begin");
    PN.newArc(p1, t1);
    PN.newArc(t1, p4);
    PN.newArc(t1, p6);

    Transition *t2 = PN.newTransition(prefix + "end");
    PN.newArc(t2, p2);
    PN.newArc(p4, t2);
    PN.newArc(p7, t2);

    Transition *t3 = PN.newTransition(prefix + "abort");
    PN.newArc(t3, p3);
    PN.newArc(p4, t3);
    PN.newArc(t3, p5);
    PN.newArc(p8, t3);

    Transition *t4 = PN.newTransition(prefix + "ignore_fault");
    PN.newArc(p5, t4, READ);
    PN.newArc(p8, t4);

    Transition *t5 = PN.newTransition(prefix + "aborted");
    PN.newArc(t5, p2);
    PN.newArc(p5, t5);
    PN.newArc(p7, t5);



    phylum->activity_1->unparse(pseudoPrinter, current_view);


    PN.mergePlaces(prefix + "inner_initial", toString(phylum->activity_1->id) + ".initial");
    PN.mergePlaces(prefix + "inner_final",   toString(phylum->activity_1->id) + ".final");
    PN.mergePlaces(prefix + "stop",          toString(phylum->activity_1->id) + ".stop");
    PN.mergePlaces(prefix + "inner_final",   toString(phylum->activity_1->id) + ".stopped");


    PN.mergePlaces((toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".internal.th_initial"), (prefix + "initial"));
    PN.mergePlaces((toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".internal.stopped"),    (prefix + "final"));
    PN.mergePlaces((toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".internal.stop"),       (prefix + "stop"));
    PN.mergePlaces((toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".internal.stopped"),    (prefix + "final"));


    footer(phylum->id, true);

#line 313 "petrinet-patterns-handlers.k"
}
#line  381 "petrinet-patterns-handlers.cc"

void PCompensationHandler(impl_tCompensationHandler *abstract_phylum, uview current_view)
#line 340 "petrinet-patterns-handlers.k"
{
    impl_tCompensationHandler_CompensationHandler* phylum = static_cast<impl_tCompensationHandler_CompensationHandler*>(abstract_phylum);
    assert(phylum != NULL);
    assert(globals::ASTEmap[phylum->id] != NULL);

    header(phylum->id, true);

    if ( true) 
    {


	phylum->activity_1->unparse(pseudoPrinter, current_view);




	PN.mergePlaces((toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".internal.ch_initial"), (toString(phylum->activity_1->id) + ".initial"));
	PN.mergePlaces((toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".internal.compensated"), (toString(phylum->activity_1->id) + ".final"));
	PN.mergePlaces((toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".internal.ch_stop"),    (toString(phylum->activity_1->id) + ".stop"));
	PN.mergePlaces((toString(globals::ASTEmap[phylum->id]->parentScopeId) + ".internal.ch_stopped"), (toString(phylum->activity_1->id) + ".stopped"));

    }







    footer(phylum->id, true);

#line 370 "petrinet-patterns-handlers.k"
}
#line  418 "petrinet-patterns-handlers.cc"

void PEventHandlers(impl_tEventHandlers *abstract_phylum, uview current_view)
#line 398 "petrinet-patterns-handlers.k"
{
    impl_tEventHandlers_EventHandlers* phylum = static_cast<impl_tEventHandlers_EventHandlers*>(abstract_phylum);
    assert(phylum != NULL);
    assert(globals::ASTEmap[phylum->id] != NULL);

    header(phylum->id, true);
    string prefix = toString(phylum->id) + "."; 


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "disabled");
    Place *p3 = PN.newPlace(prefix + "start");
    Place *p4 = PN.newPlace(prefix + "active");
    Place *p7 = PN.newPlace(prefix + "disabling");


    Transition *t1 = PN.newTransition(prefix + "start_eh");
    PN.newArc(p1, t1);
    PN.newArc(t1, p3);
    PN.newArc(t1, p4);


    Transition *t2 = PN.newTransition(prefix + "disable_eh");
    PN.newArc(p7, t2);
    PN.newArc(t2, p2);



    if (current_view != petrinetsmall_enum)
    {
	Place *p5 = PN.newPlace(prefix + "stop");
	Place *p6 = PN.newPlace(prefix + "stopped");


	Transition *t7 = PN.newTransition(prefix + "stop_active");
	PN.newArc(p4, t7);
	PN.newArc(p5, t7);


	Transition *t8 = PN.newTransition(prefix + "stop_disabling");
	PN.newArc(p5, t8);
	PN.newArc(p7, t8);


	Transition *t11 = PN.newTransition(prefix + "eh_stopped");
	PN.newArc(t11, p6);
    }



    unsigned int event_number = 1;
    {
#line 449 "petrinet-patterns-handlers.k"
	tOnMessage_list kc_fe_selvar_1 =  phylum->tOnMessage_list_1;

#line  477 "petrinet-patterns-handlers.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
	    ) {
	    tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
	    {
#line 449 "petrinet-patterns-handlers.k"
		{
#line 450 "petrinet-patterns-handlers.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 450 "petrinet-patterns-handlers.k"
#line 449 "petrinet-patterns-handlers.k"
			const tOnMessage branch = kc_selvar_0_1;
#line 449 "petrinet-patterns-handlers.k"
			const tCorrelation_list my_corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 449 "petrinet-patterns-handlers.k"
			const tFromPart_list my_from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 449 "petrinet-patterns-handlers.k"
			const activity my_activity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 449 "petrinet-patterns-handlers.k"
			const integer my_integer = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 450 "petrinet-patterns-handlers.k"

			header(my_integer, true);
			assert(globals::ASTEmap[branch->id] != NULL);
			string event = toString(event_number++);



			my_activity->unparse(pseudoPrinter, current_view);


			Place *p8 = PN.newPlace(prefix + "active." + event);
			Place *p9 = PN.newPlace(prefix + "disabled." + event);
			Place *p10 = PN.findPlace(my_activity->id, ".initial");
			Place *p13 = PN.findPlace(my_activity->id, ".final");


			Transition *t4 = PN.newTransition(toString(my_integer->value) + "." + "onEvent." + event);
			PN.newArc(p8, t4);
			PN.newArc(t4, p10);
			PN.newArc(PN.findPlace("in." + globals::ASTEmap[branch->id]->channelName), t4);


			Transition *t5 = PN.newTransition(prefix + "loop." + event);
			PN.newArc(t5, p8);
			PN.newArc(p13, t5);
			PN.newArc(PN.findPlace(prefix + "active"), t5, READ);


			Transition *t6 = PN.newTransition(prefix + "disable_finished." + event);
			PN.newArc(t6, p9);
			PN.newArc(p13, t6);
			PN.newArc(PN.findPlace(prefix + "disabling"), t6, READ);


			Transition *t12 = PN.newTransition(prefix + "disable_active." + event);
			PN.newArc(t12, p9);
			PN.newArc(p8, t12);
			PN.newArc(PN.findPlace(prefix + "disabling"), t12, READ);


			PN.newArc(t1, p8);
			PN.newArc(p9, t2);



			if (current_view != petrinetsmall_enum)
			{
			    Place *p11 = PN.findPlace(my_activity->id, ".stop");
			    Place *p12 = PN.findPlace(my_activity->id, ".stopped");

			    Transition *t9 = PN.newTransition(prefix + "stop_active." + event);
			    PN.newArc(p8, t9);
			    PN.newArc(p11, t9);
			    PN.newArc(t9, p12);

			    Transition *t10 = PN.newTransition(prefix + "stop_disabled." + event);
			    PN.newArc(p9, t10);
			    PN.newArc(p11, t10);
			    PN.newArc(t10, p12);

			    Transition *t7 = PN.findTransition(prefix + "stop_active");
			    Transition *t8 = PN.findTransition(prefix + "stop_disabling");
			    Transition *t11 = PN.findTransition(prefix + "eh_stopped");    
			    PN.newArc(t7, p11);
			    PN.newArc(t8, p11);
			    PN.newArc(p12, t11);
			}

			footer(my_integer, true);

#line  569 "petrinet-patterns-handlers.cc"
		    } else
		    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
		}

#line  574 "petrinet-patterns-handlers.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 449 "petrinet-patterns-handlers.k"

#line  579 "petrinet-patterns-handlers.cc"
	}
    }
#line 520 "petrinet-patterns-handlers.k"



    {
#line 523 "petrinet-patterns-handlers.k"
	tOnAlarm_list kc_fe_selvar_1 =  phylum->tOnAlarm_list_1;

#line  590 "petrinet-patterns-handlers.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
	    ) {
	    tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
	    {
#line 523 "petrinet-patterns-handlers.k"
		{
#line 524 "petrinet-patterns-handlers.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 524 "petrinet-patterns-handlers.k"
#line 523 "petrinet-patterns-handlers.k"
			const tOnAlarm branch = kc_selvar_0_1;
#line 523 "petrinet-patterns-handlers.k"
			const tRepeatEvery my_RepeatEvery = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->tRepeatEvery_1;
#line 523 "petrinet-patterns-handlers.k"
			const activity my_activity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 523 "petrinet-patterns-handlers.k"
			const integer my_integer = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 524 "petrinet-patterns-handlers.k"

			header(my_integer, true);
			string event = toString(event_number++);


			my_activity->unparse(pseudoPrinter, current_view);


			Place *p8 = PN.newPlace(prefix + "active." + event);
			Place *p9 = PN.newPlace(prefix + "disabled." + event);
			Place *p10 = PN.findPlace(my_activity->id, ".initial");
			Place *p13 = PN.findPlace(my_activity->id, ".final");


			Transition *t4 = PN.newTransition(prefix + "onAlarm." + event);
			PN.newArc(p8, t4);
			PN.newArc(t4, p10);


			Transition *t12 = PN.newTransition(prefix + "disable_active." + event);
			PN.newArc(t12, p9);
			PN.newArc(p8, t12);
			PN.newArc(PN.findPlace(prefix + "disabling"), t12, READ);


			PN.newArc(t1, p8);
			PN.newArc(p9, t2);


			if(string(my_RepeatEvery->op_name())=="RepeatEvery")
			{

			    Transition *t5 = PN.newTransition(prefix + "loop." + event);
			    PN.newArc(p13, t5);
			    PN.newArc(t5, p8);      
			    PN.newArc(PN.findPlace(prefix + "active"), t5, READ);


			    Transition *t6 = PN.newTransition(prefix + "disable_final." + event);
			    PN.newArc(p13, t6);
			    PN.newArc(t6, p9);      
			    PN.newArc(PN.findPlace(prefix + "disabling"), t12, READ);

			}
			else
			{

			    PN.mergePlaces(p9, p13);
			}



			if (current_view != petrinetsmall_enum)
			{
			    Place *p11 = PN.findPlace(my_activity->id, ".stop");
			    Place *p12 = PN.findPlace(my_activity->id, ".stopped");

			    Transition *t9 = PN.newTransition(prefix + "stop_active." + event);
			    PN.newArc(p8, t9);
			    PN.newArc(p11, t9);
			    PN.newArc(t9, p12);

			    Transition *t7 = PN.findTransition(prefix + "stop_active");
			    Transition *t8 = PN.findTransition(prefix + "stop_disabling");
			    Transition *t11 = PN.findTransition(prefix + "eh_stopped");    
			    PN.newArc(t7, p11);
			    PN.newArc(t8, p11);
			    PN.newArc(p12, t11);

			    if(string(my_RepeatEvery->op_name())=="RepeatEvery")
			    {

				Transition *t10 = PN.newTransition(prefix + "stop_disable." + event);
				PN.newArc(p9, t10);
				PN.newArc(p11, t10);
				PN.newArc(t10, p12);
			    }
			}

			footer(my_integer, true);

#line  691 "petrinet-patterns-handlers.cc"
		    } else
		    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
		}

#line  696 "petrinet-patterns-handlers.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 523 "petrinet-patterns-handlers.k"

#line  701 "petrinet-patterns-handlers.cc"
	}
    }
#line 605 "petrinet-patterns-handlers.k"


    footer(phylum->id, true);

#line 608 "petrinet-patterns-handlers.k"
}
#line  711 "petrinet-patterns-handlers.cc"


} // namespace kc
