// Copyright (C) 1999-2002 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of ccRTP.
// 
// The exception is that, if you link the ccRTP library with other
// files to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the ccRTP library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name ccRTP.  If you copy code from other releases into a copy of
// ccRTP, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for ccRTP, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

/** 
 * @file private.h 
 * @brief Declaration of ccRTP internal stuff.
 *
 * This header includes the autogenerated config.h, the general header
 * (rtp.h) and the nana assertion checking library headers. It also
 * defines common macros and constants.
 */

// This is for the main page in Doxygen documentation
/**
 * @mainpage ccRTP Library Reference
 **/

// This will make doxygen to generate example descriptions
/**
 * @example rtpduphello.cpp
 *
 * A basic example of how to use RTPDuplex
 **/
/** 
 * @example rtphello.cpp
 *
 * A basic example of how to use RTPPacket
 **/
/**
 * @example rtpsend.cpp
 */
/**
 * @example rtplisten.cpp
 */
/**
 * @example audio.h
 */
/**
 * @example audiotx.cpp
 */
/**
 * @example audiorx.cpp
 */
/**
 * @example ccrtptest.cpp
 */

#ifndef	CCXX_RTP_PRIVATE_H_
#define CCXX_RTP_PRIVATE_H_

#include <cc++/config.h>
#include <cc++/thread.h>
#include <cc++/socket.h>
#include <cc++/process.h>
#include <cc++/export.h>

#ifndef	CCRTP_CAPE
#include "config.h"
#endif

#undef	PACKAGE
#undef	VERSION

// This is only of interest for developers, so it is included only if
// --with-nana flag is given to configure
#ifdef HAVE_LIBNANA
#   include "nana.h"
#   include "DL.h"
#else
#   define I(e)    /* empty */
#   define DL(e)   /* empty */
#   define VDL(e)  /* empty */
#endif

#ifdef  CCXX_NAMESPACES
namespace ost {
#endif

#ifdef WIN32

#ifndef timeradd
#define timeradd(a, b, result)	                               \
{                                                              \
  (result)->tv_sec = (a)->tv_sec + (b)->tv_sec;                \
  (result)->tv_usec = (a)->tv_usec + (b)->tv_usec;             \
  if ( (result)->tv_usec >= 1000000 ) {                        \
	  (result)->tv_sec++; (result)->tv_usec -= 1000000ul;  \
  }                                                            \
}
#endif

#ifndef timersub
#define timersub(a, b, result)                                 \
{                                                              \
  (result)->tv_sec = (a)->tv_sec - (b)->tv_sec;                \
  (result)->tv_usec = (a)->tv_usec - (b)->tv_usec;             \
  if ( (result)->tv_usec < 0 ) {                               \
	  (result)->tv_sec--; (result)->tv_usec += 1000000ul;  \
  }                                                            \
}
#endif

#endif // WIN32

// Number of seconds ellapsed from 1900 to 1970
const uint32 NTP_EPOCH_OFFSET = static_cast<uint32>(2208992400ul);

uint32 random32();
uint16 random16();

#ifdef  CCXX_NAMESPACES
}
#endif

#endif // ifndef CCXX_RTP_PRIVATE_H_

/** EMACS **
 * Local variables:
 * mode: c++
 * c-basic-offset: 8
 * End:
 */
