/* LocaleInformation_en.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_en extends ListResourceBundle
{
  private static final String collation_rules = 
    "<0<1<2<3<4<5<6<7<8<9<A,a<b,B<c,C<d,D<e,E<f,F<g,G<h,H<i,I<j,J<k,K" +
    "<l,L<m,M<n,N<o,O<p,P<q,Q<r,R<s,S<t,T<u,U<v,V<w,W<x,X<y,Y<z,Z";

  private static final String currenciesDisplayNameKeys = "JOD|BOV|XAU|FOK|LBP|EUR|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAG|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|CHE|CHC|ATS|USD|ETD|BND|JMP|ETB|XXX|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|ESB|ESA|IRR|CFP|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDR|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|EQE|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTS|XTR|LUL|FIN|FIM|SBD|LUF|LUC|TTO|AOS|AOR|RHD|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|LSM|BGX|TRY|LSL|GAF|BGO|BGN|BGM|XRE|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|XPT|MKD|VDD|TPP|XPF|BEL|XPD|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|SRD|YEI|CSD|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|COU|PHP|UZS|COP|THB|BUR|IBP|COF|BUK|COB|UAK|UZC|QAR|UAH|GNS|CNY|CNX|MZM|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|JPY|MVR|XCF|MVP|DDR|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesDisplayNameValues = "Jordanian Dinar|Bolivian Mvdol|Gold|Faeroe Islands Kronur|Lebanese Pound|Euro|Vietnamese Dong|Tanzanian Shilling|Bolivian Peso|Cambodian Riel|Asian Monetary Unit|Boliviano (1863-1962)|Cambodian Old Riel|Zambian Pound|Australian Pound|Silver|CFA Franc BEAC|Maltese Pound|Ghana Revalued Cedi|Zambian Kwacha|Asian Dinar Unit of Account|Ghana Pound|Boliviano|Ghana Old Cedi|Maltese Lira|Australian Dollar|US Dollar (Same day)|Italian Lira|US Dollar (Next day)|Ghana Cedi|Singapore Dollar|Panamanian Balboa|Laotian Kip|Kyrgystan Som|Swiss Franc|WIR Euro|WIR Franc|Austrian Schilling|US Dollar|Ethiopian Dollar|Brunei Dollar|Jamaican Pound|Ethiopian Birr|No Currency|Algerian Franc Germinal|Algerian New Franc|Algerian Dinar|Paraguay Guarani|Libyan Pound|Jamaican Dollar|Icelandic Krona|Spanish Peseta|Bermudan Pound|Libyan Dinar|Libyan British Military Authority Lira|Bermudan Dollar|Netherlands Guilder|Mauritania Ouguiya|Spanish Peseta (convertible account)|Spanish Peseta (A account)|Iranian Rial|CFP Franc|Swedish Krona|Eritrean Nakfa|Kenyan Shilling|Central African Republic CFA Franc|Argentine Peso|Argentine Peso (1983-1985)|Argentine Peso Moneda Nacional|Taiwan New Dollar|IMF SDR|Sudanese Pound|Georgian Lari|Georgian Kupon Larit|Martinique Franc|Falkland Islands Pound|Argentine Austral|Sudanese Dinar|Iraqi Dinar|Ekwele|Tuvalu Dollar|Seychelles Rupee|Latvian Ruble|Fiji Pound|Latvian Lats|Congolese Zaire|Congolese Republic Franc|Congolese Franc Congolais|Fiji Dollar|Nicaraguan Cordoba Oro|Macao Pataca|Nicaraguan Gold Cordoba|Nicaraguan Cordoba|Testing Currency Code|COMECON Transferable Ruble|Luxembourg Financial Franc|Finnish Markka (1860-1962)|Finnish Markka|Solomon Islands Dollar|Luxembourg Franc|Luxembourg Convertible Franc|Trinidad and Tobago Old Dollar|Angolan Escudo|Angolan Kwanza Reajustado (1995-1999)|Rhodesian Dollar|Mongolian Tugrik|Hungarian Forint|Burundi Franc|Angolan New Kwanza (1990-2000)|Angolan Kwanza (1977-1990)|Trinidad and Tobago Dollar|Swaziland Lilangeni|New Hebrides CFP Franc|British Pound Sterling|Saudi Sovereign Riyal|Saudi Riyal|Lithuanian Talonas|Indian Rupee|Portuguese Escudo|Angolan Kwanza|Portuguese Conto|Lithuanian Lita|Kazakhstan Tenge|Kazakhstan Ruble|British Virgin Islands Dollar|Nigerian Pound|Myanmar Dollar Foreign Exchange Certificates|Nigerian Naira|Haitian Gourde|Syrian Pound|Palestine Pound|Bahraini Dinar|Myanmar Kyat|Netherlands Antillan Guilder|Czech Republic Koruna|Isle of Man Pound Sterling|Maloti|Bulgarian Lev Foreign Exchange Certificates|New Turkish Lira|Lesotho Loti|Gabon CFA Franc|Bulgarian Lev (1879-1952)|Bulgarian New Lev|Bulgarian Socialist Lev|RINET Funds|Canadian Dollar|Bulgarian Hard Lev|Turkish Lira|Cayman Islands Dollar|Cyprus Pound|Israeli New Sheqel|Guyana Dollar|Armenian Dram|Israeli Pound|Mali Franc|Israeli Sheqel|Venezuelan Bolivar|Albanian Dollar Foreign Exchange Certificates|Liberian Dollar|Albanian Lek Valute|Croatian Kuna|Reunion Franc|Croatian Dinar|Albanian Lek|Jersey Pound Sterling|Albanian Lek (1946-1961)|Macedonian Denar (1992-1993)|North Vietnam Viet Minh Piastre Dong Viet|North Vietnam New Dong|Platinum|Macedonian Denar|North Vietnam Piastre Dong Viet|Timor Pataca|CFP Franc|Belgian Franc (financial)|Palladium|Guinea-Bissau Peso|Kuwaiti Dinar|Portuguese Guinea Mil Reis|Belgian Franc|Timor Escudo|Belgian Franc (convertible)|Portuguese Guinea Escudo|El Salvador Colon|Curacao Guilder|Bangladesh Taka|Tonga Pound Sterling|Tonga Pa\u02bbanga|CFA Franc BCEAO|Soviet Rouble|Soviet New Ruble|New Caledonia Franc Germinal|Cape Verde Escudo|French Antilles CFA Franc|South African Rand|Dominican Peso|Cuban Foreign Exchange Certificates|South African Pound|South African Rand (financial)|Tunisian Dinar|Cuban Peso|French Guyana Franc Guiana|Ugandan Shilling|Ceylon Rupee|Affars and Issas Franc|Vatican City Lira|Sao Tome and Principe Escudo|Ugandan Shilling (1966-1987)|Sao Tome and Principe Dobra|Marshall Islands Dollar|New Zealand Pound|Western Samoa Tala|Western Samoa Pound|Hoduras Lempira|French Metropolitan Nouveau Franc|Turkmenistan Manat|Guatemala Quetzal|New Zealand Dollar|Scotland Pound|Barbados Dollar|Namibia Dollar|Madagascar Franc|Madagascar Ariary|Egyptian Pound|British Honduras Dollar|Polish Zloty (1950-1995)|Bosnia-Herzegovina New Dinar|Polish US Dollar Foreign Exchange Certificates|Bosnia-Herzegovina Convertible Mark|Belize Dollar|Bosnia-Herzegovina Dinar|Polish Zloty|Yemeni Rial|Suriname Guilder|Czechoslovak Hard Koruna|South Korean Won|Belarussian Ruble|Surinam Dollar|Yemeni Imadi Riyal|Serbian Dinar|Belarussian Ruble (1992-1994)|Czechoslovak Koruna|South Korean Old Won|South Korean Hwan|Belarussian New Ruble (1994-1999)|Somaliland Shilling|Greek New Drachma|Pakistan Rupee|Afghani|Zimbabwe Dollar|Sri Lanka Rupee|Greek Drachma|Irish Pound|Afghani (1927-2002)|Yemeni Dinar|Rwandan Franc|Costa Rican Colon|Tajikistan Somoni|Tajikistan Ruble|Estonian Kroon|Equatorial Guinea Peseta Guineana|Moldovan Ruble Cupon|Hong Kong Dollar|Danish Krone|Moldovan Leu|Equatorial Guinea Franco|Equatorial Guinea Ekwele Guineana|Indonesian Rupiah|United Arab Emirates Dirham|North Korean Won|Indonesian New Rupiah|Botswanan Pula|Moldovan Leu Cupon|Indonesian Java Rupiah|North Korean People\u2019s Won|Indonesian Nica Guilder|Vanuatu Vatu|Islamic Dinar|Somali Shilling|Andorran Peseta|Russian Ruble (1991-1998)|Guadeloupe Franc|Djibouti Franc|Andorran Diner|Monaco Franc Germinal|Monaco Franc Nouveau|Ecuador Unidad de Valor Constante (UVC)|Ecuador Sucre|Liechtenstein Franc|Russian Ruble|Unidad de Valor Real|Philippine Peso|Uzbekistan Sum|Colombian Peso|Thai Baht|Burmese Rupee|Northern Irish Pound|Congo CFA Franc|Burmese Kyat|Colombian Paper Peso|Ukrainian Karbovanetz|Uzbekistan Coupon Som|Qatari Rial|Ukrainian Hryvnia|Guinea Syli|Chinese Yuan Renminbi|Chinese US Dollar Foreign Exchange Certificates|Mozambique Metical|Uruguay Peso Uruguayo|Guinea Franc (1960-1972)|San Marino Lira|Chinese Jen Min Piao Yuan|Mozambique Escudo|Guinea Franc|Oman Rial Saidi|Papua New Guinea Kina|Oman Rial|Uruguay Peso (1975-1993)|French UIC-Franc|Bhutan Rupee|Zairean Zaire|Moroccan Franc|Moroccan Dirham|Bhutan Ngultrum|French Gold Franc|Uruguay Peso Fuerte|Malaysian Ringgit|Zairean New Zaire|Azerbaijanian Manat|Gambia Pound|Comoro Franc|Sierra Leone Leone|Gambia Dalasi|European Currency Unit|Bahamian Pound|Cameroon CFA Franc|Mexican Unidad de Inversion (UDI)|CFA Franc BCEAEC|Bahamian Dollar|Mexican Silver Peso (1861-1992)|Mexican Peso|Peruvian Sol|Greenland Krone|Brazilian Cruzeiro (1942-1967)|Peruvian Sol Nuevo|Chilean Peso|Slovak Koruna|Peruvian Inti|Brazilian Cruzeiro|Special Drawing Rights|French Franc Germinal/Franc Poincare|French Franc|Brazilian Cruzado Novo|Chilean Unidades de Fomento|Chilean Escudo|Brazilian Real|Chilean Condor|Brazilian Cruzeiro (1990-1993)|German Sperrmark|Malawi Pound|Brazilian Cruzado|Brazilian Cruzeiro Novo (1967-1986)|Malawi Kwacha|Transdniestria Ruble|Deutsche Mark|Chad CFA Franc|Transdniestria New Ruble|Transdniestria Ruble Kupon|Nepalese Rupee|Cook Islands Dollar|Japanese Yen|Maldive Islands Rufiyaa|CFA Nouveau Franc|Maldive Islands Rupee|East German Mark|East Caribbean Dollar|Slovenia Tolar|Yugoslavian Reformed Dinar|Aruban Guilder|Yugoslavian October Dinar|East German Ostmark|Yugoslavian Convertible Dinar|Yugoslavian Noviy Dinar|Turks and Caicos Crown|Yugoslavian 1994 Dinar|Yugoslavian Federation Dinar|Romanian New Leu|Yugoslavian Hard Dinar|Romanian Leu|Slovenia Tolar Bons|Norwegian Krone|Mauritius Rupee|European Unit of Account (XBD)|Gibraltar Pound|Vietnamese National Dong|European Unit of Account (XBC)|Vietnamese Republic Dong|European Monetary Unit|European Composite Unit|Kiribati Dollar|Saint Helena Pound|Vietnamese New Dong";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|BOV|XAU|FOK|LBP|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesSymbolValues = "JD|BOV|XAU|FOK|LL|VND|T Sh|BOP|CR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|Bs|GHO|Lm|$A|USS|USN|GHC|S$|PAB|LAK|som|SwF|ATS|US$|ETD|BND|JMP|Br|DZG|DZF|DA|PYG|LYP|J$|ISK|\u20a7|BMP|LD|LYB|Ber$|NLG|UM|RI|SKr|ERN|K Sh|CFF|Arg$|ARP|ARM|NT$|SDP|lari|GEK|MQF|FKP|ARA|SDD|ID|TVD|SR|LVR|FJP|LVL|CDL|CDG|CDF|F$|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SI$|LUF|TTO|AOS|AOR|Tug|Ft|Fbu|AON|AOK|TT$|E|NHF|SAS|SRl|LTT|PTE|AOA|PTC|LTL|T|KZR|VGD|NGP|MMX|NGN|HTG|LS|PSP|BD|MMK|NA f.|CZK|IMP|BGX|M|GAF|BGO|BGN|BGM|Can$|lev|TL|KYD|\u00a3C|ILS|G$|dram|ILP|MLF|ILL|Be|ALX|LRD|ALV|HRK|REF|HRD|lek|JEP|ALK|MKN|VDP|VDN|MDen|VDD|TPP|CFPF|BEL|GWP|KD|GWM|BF|TPE|BEC|GWE|SVC|CWG|Tk|TOS|T$|XOF|SUR|SUN|NCF|CVEsc|XNF|R|RD$|CUX|ZAP|ZAL|TND|CUP|GUF|U Sh|LNR|AIF|VAL|STE|UGS|Db|MHD|NZP|WST|WSP|L|XMF|TMM|Q|$NZ|SSP|BDS$|N$|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|KM|BZ$|BAD|Zl|YRl|Sf|CSK|KRW|Rbl|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|Pra|Af|Z$|SL Re|GRD|IR\u00a3|AFA|YDD|RWF|C|TJS|TJR|EEK|GQP|MDR|HK$|DKr|MDL|GQF|GQE|Rp|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VT|XID|So. Sh.|ADP|RUR|GPF|DF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|Col$|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QR|UAH|GNS|Y|Mt|CNX|Ur$|GNI|SML|CNP|MZE|GF|OMS|PGK|RO|UYP|XFU|BTR|ZRZ|MAF|MAD|Nu|XFO|UYF|RM|ZRN|AZM|GMP|CF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MEX$|PES|GLK|BRZ|PEN|Ch$|Sk|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|R$|CLC|BRE|DES|MWP|BRC|BRB|MK|PDR|DEM|TDF|PDN|PDK|Nrs|CKD|MVR|XCF|MVP|EC$|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|leu|SIB|NKr|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "May",
    "Jun",
    "Jul",
    "Aug",
    "Sep",
    "Oct",
    "Nov",
    "Dec",
    null,
  };

  private static final String[] months = {
    "January",
    "February",
    "March",
    "April",
    "May",
    "June",
    "July",
    "August",
    "September",
    "October",
    "November",
    "December",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "Sun",
    "Mon",
    "Tue",
    "Wed",
    "Thu",
    "Fri",
    "Sat",
  };

  private static final String[] weekdays = {
    null,
    "Sunday",
    "Monday",
    "Tuesday",
    "Wednesday",
    "Thursday",
    "Friday",
    "Saturday",
  };

  private static final String[] ampms = { "AM", "PM" };

  private static final String[] eras = {
    "BC",
    "AD",
  };

  private static final String[][] zoneStrings =
  {
    { "PST", "Pacific Standard Time", "PDT", "Pacific Daylight Time",  "America/Los_Angeles" },
    { "HST", "Hawaii Standard Time", "HDT", "Hawaii Daylight Time",  "Pacific/Honolulu" },
    { "GMT", "Greenwich Mean Time", "GMT", "Greenwich Mean Time",  "Etc/GMT" },
    { "BST", "British Standard Time", "BDT", "British Daylight Time",  "Europe/London" },
    { "MST", "Mountain Standard Time", "MDT", "Mountain Daylight Time",  "America/Phoenix" },
    { "MST", "Mountain Standard Time", "MDT", "Mountain Daylight Time",  "America/Denver" },
    { "IST", "Israel Standard Time", "IDT", "Israel Daylight Time",  "Asia/Jerusalem" },
    { "MST (CA)", "Mountain Standard Time (CA)", "MDT (CA)", "Mountain Daylight Time (CA)",  "America/Edmonton" },
    { "AKST", "Alaska Standard Time", "AKDT", "Alaska Daylight Time",  "America/Anchorage" },
    { "CEST", "Central European Standard Time", "CEDT", "Central European Daylight Time",  "Europe/Paris" },
    { "EST", "Eastern Standard Time", "EDT", "Eastern Daylight Time",  "America/Indianapolis" },
    { "EET", "Eastern European Standard Time", "EEST", "Eastern European Daylight Time",  "Europe/Bucharest" },
    { "JST", "Japan Standard Time", "JDT", "Japan Daylight Time",  "Asia/Tokyo" },
    { "CST (CA)", "Central Standard Time (CA)", "CDT (CA)", "Central Daylight Time (CA)",  "America/Winnipeg" },
    { "CST", "China Standard Time", "CDT", "China Daylight Time",  "Asia/Shanghai" },
    { "PST (CA)", "Pacific Standard Time (CA)", "PDT (CA)", "Pacific Daylight Time (CA)",  "America/Vancouver" },
    { "EST", "Eastern Standard Time", "EDT", "Eastern Daylight Time",  "America/New_York" },
    { "EST (CA)", "Eastern Standard Time (CA)", "EDT (CA)", "Eastern Daylight Time (CA)",  "America/Montreal" },
    { "AST", "Atlantic Standard Time", "ADT", "Atlantic Daylight Time",  "America/Halifax" },
    { "NST", "Newfoundland Standard Time", "NDT", "Newfoundland Daylight Time",  "America/St_Johns" },
    { "CST", "Central Standard Time", "CDT", "Central Daylight Time",  "America/Chicago" },
  };

  private static final String territoriesKeys = "GY|GW|GU|GT|GS|GR|GQ|GP|GN|GM|GL|GI|GH|GF|GE|GD|GB|GA|FX|FR|FQ|FO|FM|FK|FJ|FI|ET|ES|ER|EH|EG|EE|EC|DZ|DY|DO|DM|DK|DJ|DE|DD|CZ|CY|CX|CV|CU|CT|CS|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|CA|BZ|BY|BW|BV|BU|BT|BS|BR|BQ|BO|BN|BM|BJ|BI|BH|BG|BF|BE|BD|ZZ|BB|BA|ZW|ZR|AZ|AX|AW|ZM|AU|AT|AS|AR|AQ|AO|AN|AM|AL|ZA|AI|AG|AF|AE|AD|YU|YT|YE|YD|172|WS|WK|WF|155|154|151|150|VU|VN|VI|VG|VE|145|VD|VC|142|VA|UZ|UY|US|UM|UG|UA|TZ|TW|TV|TT|TR|TP|TO|TN|TM|TL|TK|TJ|TH|TG|TF|TD|TC|SZ|SY|SV|SU|ST|SR|SP|SO|SN|SM|SL|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|RW|RU|RO|RH|RE|062|061|QA|057|054|PZ|053|PY|PW|PU|PT|PS|PR|PN|PM|PL|PK|PH|PG|PF|PE|PC|PA|OM|833|830|039|035|NZ|030|NU|NT|NR|NQ|NP|NO|NL|NI|NH|NG|NF|NE|NC|NA|029|MZ|MY|MX|021|MW|MV|MU|MT|MS|MR|MQ|MP|MO|MN|MM|ML|MK|419|MI|MH|MG|MD|MC|MA|019|018|017|015|014|013|LY|011|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|009|005|KZ|003|KY|002|001|KW|KR|KP|KN|KM|KI|KH|KG|KE|JT|JP|JO|JM|IT|IS|IR|IQ|IO|IN|IL|IE|ID|HV|HU|HT|HR|HN|HM|HK";

  private static final String territoriesValues = "Guyana|Guinea-Bissau|Guam|Guatemala|South Georgia and the South Sandwich Islands|Greece|Equatorial Guinea|Guadeloupe|Guinea|Gambia|Greenland|Gibraltar|Ghana|French Guiana|Georgia|Grenada|United Kingdom|Gabon|Metropolitan France|France|French Southern and Antarctic Territories|Faroe Islands|Micronesia|Falkland Islands|Fiji|Finland|Ethiopia|Spain|Eritrea|Western Sahara|Egypt|Estonia|Ecuador|Algeria|Benin|Dominican Republic|Dominica|Denmark|Djibouti|Germany|East Germany|Czech Republic|Cyprus|Christmas Island|Cape Verde|Cuba|Canton and Enderbury Islands|Czechoslovakia|Costa Rica|Colombia|China|Cameroon|Chile|Cook Islands|C\u00f4te d\u2019Ivoire|Switzerland|Congo|Central African Republic|Democratic Republic of the Congo|Cocos (Keeling) Islands|Canada|Belize|Belarus|Botswana|Bouvet Island|Myanmar|Bhutan|Bahamas|Brazil|British Antarctic Territory|Bolivia|Brunei|Bermuda|Benin|Burundi|Bahrain|Bulgaria|Burkina Faso|Belgium|Bangladesh|Outlying Oceania|Barbados|Bosnia and Herzegovina|Zimbabwe|Congo, The Democratic Republic of the|Azerbaijan|Aland Islands|Aruba|Zambia|Australia|Austria|American Samoa|Argentina|Antarctica|Angola|Netherlands Antilles|Armenia|Albania|South Africa|Anguilla|Antigua and Barbuda|Afghanistan|United Arab Emirates|Andorra|Serbia and Montenegro|Mayotte|Yemen|People's Democratic Republic of Yemen|Commonwealth of Independent States|Samoa|Wake Island|Wallis and Futuna|Western Europe|Northern Europe|Eastern Europe|Europe|Vanuatu|Vietnam|U.S. Virgin Islands|British Virgin Islands|Venezuela|Western Asia|North Vietnam|Saint Vincent and the Grenadines|Asia|Vatican|Uzbekistan|Uruguay|United States|United States Minor Outlying Islands|Uganda|Ukraine|Tanzania|Taiwan|Tuvalu|Trinidad and Tobago|Turkey|Timor-Leste|Tonga|Tunisia|Turkmenistan|Timor-Leste|Tokelau|Tajikistan|Thailand|Togo|French Southern Territories|Chad|Turks and Caicos Islands|Swaziland|Syria|El Salvador|Union of Soviet Socialist Republics|Sao Tome and Principe|Suriname|Serbia|Somalia|Senegal|San Marino|Sierra Leone|Slovakia|Svalbard and Jan Mayen|Slovenia|Saint Helena|Singapore|Sweden|Sudan|Seychelles|Solomon Islands|Saudi Arabia|Rwanda|Russia|Romania|Zimbabwe|R\u00e9union|South-central Asia|Polynesia|Qatar|Micronesia|Melanesia|Panama Canal Zone|Australia and New Zealand|Paraguay|Palau|U.S. Miscellaneous Pacific Islands|Portugal|Palestinian Territory|Puerto Rico|Pitcairn|Saint Pierre and Miquelon|Poland|Pakistan|Philippines|Papua New Guinea|French Polynesia|Peru|Pacific Islands Trust Territory|Panama|Oman|Isle of Man|Channel Islands|Southern Europe|South-eastern Asia|New Zealand|Eastern Asia|Niue|Neutral Zone|Nauru|Dronning Maud Land|Nepal|Norway|Netherlands|Nicaragua|Vanuatu|Nigeria|Norfolk Island|Niger|New Caledonia|Namibia|Caribbean|Mozambique|Malaysia|Mexico|Northern America|Malawi|Maldives|Mauritius|Malta|Montserrat|Mauritania|Martinique|Northern Mariana Islands|Macao S.A.R., China|Mongolia|Myanmar|Mali|Macedonia|Latin America and the Caribbean|Midway Islands|Marshall Islands|Madagascar|Moldova|Monaco|Morocco|Americas|Southern Africa|Middle Africa|Northern Africa|Eastern Africa|Central America|Libya|Western Africa|Latvia|Luxembourg|Lithuania|Lesotho|Liberia|Sri Lanka|Liechtenstein|Saint Lucia|Lebanon|Laos|Oceania|South America|Kazakhstan|North America|Cayman Islands|Africa|World|Kuwait|South Korea|North Korea|Saint Kitts and Nevis|Comoros|Kiribati|Cambodia|Kyrgyzstan|Kenya|Johnston Island|Japan|Jordan|Jamaica|Italy|Iceland|Iran|Iraq|British Indian Ocean Territory|India|Israel|Ireland|Indonesia|Burkina Faso|Hungary|Haiti|Croatia|Honduras|Heard Island and McDonald Islands|Hong Kong S.A.R., China";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "gwi|akk|eka|ijo|xh|sux|sus|mis|loz|tog|pon|min|suk|wo|lol|kut|mic|wa|kum|zap|cus|jbo|doi|vo|oto|vi|vai|rar|ve|rap|raj|ota|nzi|nap|uz|uga|tmh|nai|nah|ur|fat|uk|egy|ug|fan|ssa|mga|bat|nyo|bas|nyn|nym|hmn|ban|osa|bal|ty|bai|tw|srr|tli|tlh|tt|ts|bad|tr|to|tn|tl|tk|ti|th|kru|tg|byn|te|kro|csb|ta|tkl|efi|sw|sv|su|krc|st|ss|sr|sq|men|crp|so|afh|sn|sm|sl|grc|sk|grb|si|sh|crh|afa|sg|se|sd|udm|sc|sa|rw|nwc|ru|mdr|ro|rn|rm|mdf|tiv|ady|zun|kpe|qu|tig|son|cpp|sog|ada|kos|hit|cpf|cpe|him|kok|hil|got|gor|gon|din|nub|pt|ps|fur|phn|goh|snk|cop|yap|ach|yao|phi|pl|ace|pi|pa|bug|iba|sms|bua|mas|smn|os|map|or|man|smj|smi|mak|om|mai|oj|mag|mad|sma|oc|nso|btk|myv|dgr|ny|myn|nv|kmb|nr|gmh|no|nn|nl|root|ng|sla|ne|nd|cmc|tet|nb|na|ter|tem|my|lez|mt|peo|ms|mr|fro|mo|frm|mn|jrb|ml|mk|mi|mh|mg|mwr|bra|mwl|den|lv|lu|del|lt|lo|ln|li|ewo|lg|lb|la|jpr|vot|sit|ky|kw|kv|ku|sio|ks|kr|awa|ko|kn|km|kl|kk|rom|kj|sid|ki|kg|non|ka|mus|roa|nog|mun|mul|jv|gil|znd|shn|fon|ji|xal|aus|kho|ja|khi|pau|chy|iw|tai|iu|pap|it|sgn|is|kha|chr|pam|pal|chp|io|cho|in|chn|chm|tyv|bnt|pag|ik|chk|ii|haw|lam|ig|chg|sga|paa|ie|id|lah|day|chb|ia|lad|hz|hai|dar|hy|ath|hu|ht|dak|hr|ho|hi|dyu|he|ast|ha|wen|gv|gu|sem|sel|iro|gn|gl|arw|gez|art|gd|ira|ga|arp|arn|fy|bla|gem|ypk|arc|fr|fo|cel|fj|fi|ff|tvl|ceb|fa|eu|sco|et|scn|es|eo|en|el|tut|niu|tup|ee|tum|mos|dz|nic|lus|fiu|dv|nia|moh|luo|lun|apa|fil|lui|hup|bin|de|lua|bik|was|und|war|da|dum|wal|mno|wak|sat|cy|sas|kbd|cv|cu|mni|cs|sam|cr|sal|dua|co|sai|mnc|sah|kaw|inh|gba|sad|ch|ine|bho|enm|kar|inc|ce|gay|ca|umb|syr|kam|tsi|ang|kac|cau|kab|kaa|bs|car|br|bo|bn|bm|gaa|cai|bi|bh|bg|be|cad|ba|zu|zen|pro|hsb|az|ay|av|as|dsb|ar|ilo|elx|zh|an|pra|am|new|ak|za|af|ae|alt|ab|aa|yo|alg|ale|mkh|yi|dra|ber|nds|bem|bej|tpi";

  private static final String languagesValues = "Gwich\u02bbin|Akkadian|Ekajuk|Ijo|Xhosa|Sumerian|Susu|Miscellaneous Languages|Lozi|Tonga (Nyasa)|Pohnpeian|Minangkabau|Sukuma|Wolof|Mongo|Kutenai|Micmac|Walloon|Kumyk|Zapotec|Cushitic (Other)|Lojban|Dogri|Volap\u00fck|Otomian Languages|Vietnamese|Vai|Rarotongan|Venda|Rapanui|Rajasthani|Turkish, Ottoman (1500-1928)|Nzima|Neapolitan|Uzbek|Ugaritic|Tamashek|North American Indian (Other)|Nahuatl|Urdu|Fanti|Ukrainian|Egyptian (Ancient)|Uighur|Fang|Nilo-Saharam (Other)|Irish, Middle (900-1200)|Baltic (Other)|Nyoro|Basa|Nyankole|Nyamwezi|Hmong|Balinese|Osage|Baluchi|Tahitian|Bamileke Languages|Twi|Serer|Tlingit|Klingon|Tatar|Tsonga|Banda|Turkish|Tonga (Tonga Islands)|Tswana|Tagalog|Turkmen|Tigrinya|Thai|Kurukh|Tajik|Blin|Telugu|Kru|Kashubian|Tamil|Tokelau|Efik|Swahili|Swedish|Sundanese|Karachay-Balkar|Sotho, Southern|Swati|Serbian|Albanian|Mende|Creoles and Pidgins (Other)|Somali|Afrihili|Shona|Samoan|Slovenian|Greek, Ancient (to 1453)|Slovak|Gerbo|Sinhalese|Serbo-Croatian|Crimean Turkish; Crimean Tatar|Afro-Asiatic (Other)|Sango|Northern Sami|Sindhi|Udmurt|Sardinian|Sanskrit|Kinyarwanda|Classical Newari|Russian|Mandar|Romanian|Rundi|Rhaeto-Romance|Moksha|Tiv|Adyghe|Zuni|Kpelle|Quechua|Tigre|Songhai|Creoles and pidgins, Portuguese-based (Other)|Sogdien|Adangme|Kosraean|Hittite|Creoles and Pidgins, French-based (Other)|Creoles and Pidgins, English-based (Other)|Himachali|Konkani|Hiligaynon|Gothic|Gorontalo|Gondi|Dinka|Nubian Languages|Portuguese|Pashto (Pushto)|Friulian|Phoenician|German, Old High (ca.750-1050)|Soninke|Coptic|Yapese|Acoli|Yao|Philippine (Other)|Polish|Achinese|Pali|Punjabi|Buginese|Iban|Skolt Sami|Buriat|Masai|Inari Sami|Ossetic|Austronesian|Oriya|Mandingo|Lule Sami|Sami languages (Other)|Makasar|Oromo|Maithili|Ojibwa|Magahi|Madurese|Southern Sami|Occitan (post 1500); Proven\u00e7al|Sotho, Northern|Batak|Erzya|Dogrib|Nyanja; Chichewa; Chewa|Mayan|Navajo|Kimbundu|Ndebele, South|German, Middle High (ca.1050-1500)|Norwegian|Norwegian Nynorsk|Dutch|Root|Ndonga|Slavic (Other)|Nepali|Ndebele, North|Chamic Languages|Tetum|Norwegian Bokm\u00e5l|Nauru|Tereno|Timne|Burmese|Lezghian|Maltese|Persian Old (ca.600-400 B.C.)|Malay|Marathi|French, Old (842-ca.1400)|Moldavian|French, Middle (ca.1400-1600)|Mongolian|Judeo-Arabic|Malayalam|Macedonian|Maori|Marshallese|Malagasy|Marwari|Braj|Mirandese|Slave|Latvian|Luba-Katanga|Delaware|Lithuanian|Lao|Lingala|Limburgish|Ewondo|Ganda|Luxembourgish|Latin|Judeo-Persian|Votic|Sino-Tibetan (Other)|Kirghiz|Cornish|Komi|Kurdish|Siouan Languages|Kashmiri|Kanuri|Awadhi|Korean|Kannada|Khmer|Kalaallisut|Kazakh|Romany|Kuanyama|Sidamo|Kikuyu|Kongo|Norse, Old|Georgian|Creek|Romance (Other)|Nogai|Munda Languages|Multiple Languages|Javanese|Gilbertese|Zande|Shan|Fon|Yiddish|Kalmyk|Australian Languages|Khotanese|Japanese|Khoisan (Other)|Palauan|Cheyenne|Hebrew|Tai (Other)|Inuktitut|Papiamento|Italian|Sign Languages|Icelandic|Khasi|Cherokee|Pampanga|Pahlavi|Chipewyan|Ido|Choctaw|Indonesian|Chinook Jargon|Mari|Tuvinian|Bantu|Pangasinan|Inupiaq|Chuukese|Sichuan Yi|Hawaiian|Lamba|Igbo|Chagatai|Irish, Old (to 900)|Papuan (Other)|Interlingue|Indonesian|Lahnda|Dayak|Chibcha|Interlingua|Ladino|Herero|Haida|Dargwa|Armenian|Athapascan Languages|Hungarian|Haitian|Dakota|Croatian|Hiri Motu|Hindi|Dyula|Hebrew|Asturian|Hausa|Sorbian Languages|Manx|Gujarati|Semitic (Other)|Selkup|Iroquoian languages|Guarani|Gallegan|Arawak|Geez|Artificial (Other)|Scottish Gaelic|Iranian|Irish|Arapaho|Araucanian|Frisian|Siksika|Germanic (Other)|Yupik Languages|Aramaic|French|Faroese|Celtic (Other)|Fijian|Finnish|Fulah|Tuvalu|Cebuano|Persian|Basque|Scots|Estonian|Sicilian|Spanish|Esperanto|English|Greek|Altaic (Other)|Niuean|Tupi languages|Ewe|Tumbuka|Mossi|Dzongkha|Niger - Kordofanian (Other)|Lushai|Finno - Ugrian (Other)|Divehi|Nias|Mohawk|Luo|Lunda|Apache Languages|Filipino|Luiseno|Hupa|Bini|German|Luba-Lulua|Bikol|Washo|Undetermined|Waray|Danish|Dutch, Middle (ca. 1050-1350)|Walamo|Manobo Languages|Wakashan Languages|Santali|Welsh|Sasak|Kabardian|Chuvash|Church Slavic|Manipuri|Czech|Samaritan Aramaic|Cree|Salishan languages|Duala|Corsican|South American Indian (Other)|Manchu|Yakut|Kawi|Ingush|Gbaya|Sandawe|Chamorro|Indo-European (Other)|Bhojpuri|English, Middle (1100-1500)|Karen|Indic (Other)|Chechen|Gayo|Catalan|Umbundu|Syriac|Kamba|Tsimshian|English, Old (ca.450-1100)|Kachin|Caucasian (Other)|Kabyle|Kara-Kalpak|Bosnian|Carib|Breton|Tibetan|Bengali|Bambara|Ga|Central American Indian (Other)|Bislama|Bihari|Bulgarian|Belarusian|Caddo|Bashkir|Zulu|Zenaga|Proven\u00e7al, Old (to 1500)|Upper Sorbian|Azerbaijani|Aymara|Avaric|Assamese|Lower Sorbian|Arabic|Iloko|Elamite|Chinese|Aragonese|Prakrit Languages|Amharic|Newari|Akan|Zhuang|Afrikaans|Avestan|Southern Altai|Abkhazian|Afar|Yoruba|Algonquian Languages|Aleut|Mon-Khmer (Other)|Yiddish|Dravidian (Other)|Berber|Low German; Low Saxon|Bemba|Beja|Tok Pisin";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final String variantsKeys = "REVISED|lojban|POSIX|gaulish|rozaj|nedis|boont|1996|guoyu|hakka|xiang|1901|scouse";

  private static final String variantsValues = "Revised Orthography|Lojban|Computer|Gaulish|Resian|Natisone dialect|Boontling|German orthography of 1996|Mandarin or Standard Chinese|Hakka|Xiang or Hunanese|Traditional German orthography|Scouse";

  private static final Hashtable variants;
  static
  {
    variants = new Hashtable();
    Enumeration keys = new StringTokenizer(variantsKeys, "|");
    Enumeration values = new StringTokenizer(variantsValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         variants.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "collation_rules", collation_rules },
    { "currencyFormat", "\u00a4#,##0.00;-\u00a4#,##0.00" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "ampms", ampms },
    { "eras", eras },
    { "shortDateFormat", "M/d/yy" },
    { "mediumDateFormat", "MMM d, yyyy" },
    { "localPatternChars", "GyMdkHmsSEDFwWahKz" },
    { "longDateFormat", "MMMM d, yyyy" },
    { "fullDateFormat", "EEEE, MMMM d, yyyy" },
    { "shortTimeFormat", "h:mm a" },
    { "mediumTimeFormat", "h:mm:ss a" },
    { "longTimeFormat", "h:mm:ss a z" },
    { "fullTimeFormat", "h:mm:ss a z" },
    { "zoneStrings", zoneStrings },
    { "decimalSeparator", "." },
    { "digit", "#" },
    { "exponential", "E" },
    { "groupingSeparator", "," },
    { "infinity", "\u221e" },
    { "NaN", "\ufffd" },
    { "minusSign", "-" },
    { "monetarySeparator", "." },
    { "patternSeparator", ";" },
    { "percent", "%" },
    { "perMill", "\u2030" },
    { "zeroDigit", "0" },
    { "numberFormat", "#,##0.###" },
    { "percentFormat", "#,##0%" },
    { "territories", territories },
    { "languages", languages },
    { "variants", variants },
  };

  public Object[][] getContents() { return contents; }
}
