<?xml version="1.0" encoding="utf-8"?>

<!-- descriptor.xsl
     Copyright (C) 2003 Free Software Foundation, Inc.
     
     This file is part of GNU Classpath.
     
     GNU Classpath is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2, or (at your option)
     any later version.
      
     GNU Classpath is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with GNU Classpath; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
     02111-1307 USA.
     -->

<!-- Creates the index.html file for HTML documentation. This is only
     a simple frameset.
     -->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:gjdoc="http://www.gnu.org/software/cp-tools/gjdocxml"
  xmlns:html="http://www.w3.org/TR/REC-html40"
  xmlns="http://www.w3.org/TR/REC-html40">

  <xsl:include href="html_common.xsl"/>

  <xsl:output method="xml"
    encoding="utf-8"
    indent="no"/>

  <xsl:strip-space elements="*"/>

  <xsl:template match="/">
    <gjdoc:descriptor>
      <gjdoc:about>
        This file was generated by Gjdoc <xsl:value-of select="$gjdoc.xmldoclet.version"/>
        on <xsl:value-of select="document('index.xml', /)/gjdoc:rootdoc/gjdoc:created"/>.
      
        <xsl:copy-of select="document('index.xml', /)/gjdoc:rootdoc/gjdoc:bottomnote"/>
      </gjdoc:about>
      <xsl:for-each select="/gjdoc:rootdoc/gjdoc:packagedoc">
        <gjdoc:package name="{@name}"/>
      </xsl:for-each>
      <xsl:for-each select="/gjdoc:rootdoc/gjdoc:classdoc">
        <gjdoc:class name="{@name}" qualifiedtypename="{@qualifiedtypename}"/>
      </xsl:for-each>
    </gjdoc:descriptor>
  </xsl:template>
</xsl:stylesheet>
