# stdint.m4 serial 1 (libunistring-0.0)
dnl Copyright (C) 2001-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible.
dnl Test whether <stdint.h> is supported or must be substituted.

AC_DEFUN([gt_STDINT_H],
[AC_MSG_CHECKING([for stdint.h])
AC_CACHE_VAL(gt_cv_header_stdint_h, [
  AC_TRY_COMPILE([#include <stdint.h>], [],
    gt_cv_header_stdint_h=yes, gt_cv_header_stdint_h=no)])
AC_MSG_RESULT([$gt_cv_header_stdint_h])
if test $gt_cv_header_stdint_h = yes; then
  AC_DEFINE(HAVE_STDINT_H, 1,
            [Define if you have a working <stdint.h> header file.])
  STDINT_H=''
else
  STDINT_H='stdint.h'

  dnl Is long == int64_t ?
  AC_CACHE_CHECK([whether 'long' is 64 bit wide], gt_cv_long_bitsize_64, [
    AC_TRY_COMPILE([
#define POW63  ((((((long) 1 << 15) << 15) << 15) << 15) << 3)
#define POW64  ((((((long) 1 << 15) << 15) << 15) << 15) << 4)
typedef int array [2 * (POW63 != 0 && POW64 == 0) - 1];
], , gt_cv_long_bitsize_64=yes, gt_cv_long_bitsize_64=no)])
  if test $gt_cv_long_bitsize_64 = yes; then
    HAVE_LONG_64BIT=1
  else
    HAVE_LONG_64BIT=0
  fi
  AC_SUBST(HAVE_LONG_64BIT)

  dnl Is long long == int64_t ?
  AC_CACHE_CHECK([whether 'long long' is 64 bit wide], gt_cv_longlong_bitsize_64, [
    AC_TRY_COMPILE([
#define POW63  ((((((long long) 1 << 15) << 15) << 15) << 15) << 3)
#define POW64  ((((((long long) 1 << 15) << 15) << 15) << 15) << 4)
typedef int array [2 * (POW63 != 0 && POW64 == 0) - 1];
], , gt_cv_longlong_bitsize_64=yes, gt_cv_longlong_bitsize_64=no)])
  if test $gt_cv_longlong_bitsize_64 = yes; then
    HAVE_LONGLONG_64BIT=1
  else
    HAVE_LONGLONG_64BIT=0
  fi
  AC_SUBST(HAVE_LONGLONG_64BIT)

fi
AC_SUBST(STDINT_H)
])
