/* Test of setting an ACL equivalent to a mode.
   Copyright (C) 2008-2021 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* Written by Bruno Haible <bruno@clisp.org>, 2008.  */

#include <config.h>

#include "acl.h"

#include <stdlib.h>

#include "macros.h"

int
main (int argc, char *argv[])
{
  const char *file;
  int mode;

  ASSERT (argc == 3);

  file = argv[1];
  mode = strtol (argv[2], NULL, 8);

  set_acl (file, -1, mode);

  return 0;
}
