/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * REVISIONS: -----------------------------------------------------
 * April, 15th, 2001
 * File creation.
 * This module contains functions for accessing static methods. 
 * For the moment we add a simple implementations only support first
 * level methods, that is. We can't access static methods in a inheritance
 * chain directly using them.
 * We obly can access the methods in the class specified.
 * --------------------------------------------------------------------
 * October, 19th,2001
 * Removing warnnings
 * -----------------------------------------------------------
 * March, 2nd, 2002
 * Code cleanup
 * -----------------------------------------------------
 * May, 10th, 2003
 * Modification to support changes to internal class structure
 * --------------------------------------------------------------------
 * July, 4th, 2003
 * Input Parameters Sanity Checks
 * --------------------------------------------------------------------------
 * July, 17th, 2003
 * Fixed issue with va_list and gcc-3.x
 * Method parameters are now retrieved using va_arg macro instead of referencing
 * directly va_start pointer. This should be portable almost for code generated by
 * the same compiler.
 * XXXXXXXXXXXXXXX CAUTION XXXXXXXXXXXXX CAUTION XXXXXXXXXXXXXXXXXXXXX
 * The changes haven't be fully tested against SIU proxies fall backs
 * XXXXXXXXXXXXXXX CAUTION XXXXXXXXXXXXX CAUTION XXXXXXXXXXXXXXXXXXXXX
 * This part of code will get platform-dependant due to ABI incompatibilities
 * among compilers and machines
 */

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include "portable.h"
#include "vglobal.h"
#include "classq.h"
#include "clas.h"
#include "pri1.h"
#include "spri3.h"
#include "misc.h"

#include "error.h"
#include "helper.h"

ESint32 EDMAPROC Look4Met1 (CLASSID id,EPChar MetName);

/***************************************************
 * Interface accessing using Class Name
 ******************************************************/

/* edma_smet3s
 *    Runs the static method Id of class cn with signature Sig 
 */

EPVoid EDMAPROC 
edma_smet3s (EPChar cn,EPChar Id,EPChar Sig,...) 
{
  CLASSID      idc;
  EPVoid       r;
  va_list      p;

  if (cn == NULL)
    {
      edma_printf_err ("%s", "[edma_smet3] Invalid Class Name (NULL)");
      return NULL;
    }

  if (Id == NULL)
    {
      edma_printf_err ("%s", "[edma_smet3] Invalid Static Method Name (NULL)");
      return NULL;
    }
  if (Sig == NULL)
    {
      edma_printf_err ("%s", "[edma_smet3] Invalid "
		       "Static Method Signature (NULL)");
      return NULL;
    }

  idc = edma_get_class_id(cn);
  if (idc == -1) 
    {
      return (EPVoid) _edma_system_exception ("[edma_smet3s] Class '%s' "
					      "don't exist",
					      cn);
    }
  
  va_start(p,Sig);

  r = (EPVoid) edma_smet3sx (idc,Id,Sig,p);
  
  va_end(p); /* XXXXXX */
  return r;
}

/* edma_smet3x
 *   Runs the static method Id of class idc with signature Sig and parameters p
 */

EPVoid	EDMAPROC 
edma_smet3sx (CLASSID idc,EPChar Id,EPChar Sig,va_list p) 
{
  OBJID		sObj;
  EUint32	i,l;
  EUint32	n,j,k;
  EChar		MiSig[50];
  EChar         SAux[2];   
  
  /* FIXME: Do we reach this point with parameters ok ??*/
  /* We build the signature for object's type... 
     not implemented at the moment*/
  memset (MiSig, 0, 50);
  j = strlen (Sig);
  n = 0;	/* We count how many parameter we have*/
  SAux[1] = 0;   
  for (i = 0; i < j; i++)
    if ((Sig[i] != 'O') && (Sig[i] != 'L'))
      { /* if it's a simple type*/
	SAux[0] = *(Sig + i);
	strcat (MiSig, SAux);
	n++;
      } 
    else	/*else*/
      if (Sig[i] == 'O')	
	{ /*if we must to expand signature*/
	  sObj = (OBJID) (*((EPUint32) p + n));
	  strncat (MiSig, gClass[idc]->ClassName, 50);
	  n++;
	} 
      else 
	{	/*else it's a class identifier*/
	  l = strchr (Sig + i, ';') - (Sig + i) - 1;
	  k = strlen (MiSig);
	  strncpy (MiSig + k, Sig + i + 1, l);
	  i += (l + 1);
	  n++;
	}
  return 0;
}

/* edma_smet3
 *   Executes static method Id of class cn with variable parameter number
 */

EPVoid EDMAPROC 
edma_smet3 (EPChar cn,EPChar Id,...) 
{
  CLASSID       idc;
  EPVoid        r;
  va_list       p;

  if (cn == NULL)
    {
      edma_printf_err ("%s", "[edma_smet3] Invalid Class Name (NULL)");
      return NULL;
    }

  if (Id == NULL)
    {
      edma_printf_err ("%s", "[edma_smet3] Invalid Static Method Name (NULL)");
      return NULL;
    }  

  idc = edma_get_class_id (cn);
  if (idc == -1) 
    {
      return (EPVoid) _edma_system_exception ("[edma_met3] Class '%s' "
					      "don't exist", cn);
    }

  if (ProcMapTable[idc] != CLASS_LOADED)
    edma_load_class_imp(idc);
  
  va_start(p,Id);
  
  r =  edma_smet3x (idc,Id,p);
  va_end(p); /* XXXXXX */

  return r;
}

/* edma_smet3x
 *  Executes method Id of class cid with parameters p
 */

EPVoid	EDMAPROC 
edma_smet3x (CLASSID cid,EPChar Id,va_list p) 
{
  EUint32	i;
  EPVoid        r;
  PPROC         Func;   
  long*        p2[16];
 

  if ((edma_check_class_id (cid, "edma_get_class_module")) == -1)
    return NULL;
 
  if (Id == NULL)
    {
      edma_printf_err ("%s", "[edma_smet3] Invalid Static Method Name (NULL)");
      return NULL;
    }
  
  /* FIXME: Check if this call is now obsolete */
  i = Look4Met1 (cid, Id);
  if (i == -1)
    return (EPVoid) _edma_system_exception ("[edma_smet3x] Method '%s' "
					    "not found in class '%s'",
					    Id, gClass[cid]->ClassName);

  if (pClass[cid]->Met[i].Static) 
    {
      Func = (PPROC) pClass[cid]->met_func[i].Func;
      p2[0] = va_arg(p,long*);
      p2[1] = va_arg(p,long*);
      p2[2] = va_arg(p,long*);
      p2[3] = va_arg(p,long*);
      p2[4] = va_arg(p,long*);
      p2[5] = va_arg(p,long*);
      p2[6] = va_arg(p,long*);
      p2[7] = va_arg(p,long*);
      p2[8] = va_arg(p,long*);
      r = (EPVoid) Func (cid, p2[0], p2[1], p2[2], p2[3], 
			 p2[4], p2[5], p2[6], p2[7], p2[8]);
      return r;
    } 
  else 
    {
      return (EPVoid) _edma_system_exception ("[edma_smet3x] Method '%s' "
					      "isn't static", Id);
    }
  return 0;
}

/* Look4Met1
 *   Looks for a method in a single class 
 */

ESint32 EDMAPROC 
Look4Met1 (CLASSID Tipo,EPChar MetName) 
{
  EUint32     i;
  
  /* First we look for at level 0*/
  for (i = 0; i < gClass[Tipo]->nMet; i++) 
    {
      if (strcmp (pClass[Tipo]->Met[i].IdMet, MetName) == 0) 
	break;
    }
  if (i == gClass[Tipo]->nMet) 
    {/* if we don't find it in the first level*/
      return -1;
    } 
  else 
    {
      return i;
    }
}
