/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/**************************************************
    Entorno de Desarrollo Modular y Abierto
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF WIzard Tcl/Tk 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : ID
    Description : Class Identifier
    Author      : David Martnez Oliveira
    Date        : 18 de Noviembre de 1997
-----------------------------------------------------
  REVISIONS :
 * 18/11/1997
    First Implementation
 * 27/02/2000
   Added to EDMA 0.5.1 and revised. A description field will be
   added to the class database.
***************************************************/
 
 
#include <stdio.h>
#include <string.h>
#include <edma.h>
 
typedef struct
  {
    EUint32	  nElems;
    EDMAT_BUFFER  List;
  } DtID;

/* Type for class list*/
#define MAX_ID    64
typedef struct
{
  EChar   ClassName[80];    /* Class Name  */
  EChar   StringId[80];     /* Class's string identifier */
  EChar   ByteId[80];       /* Class's byte string identifier */
  EChar   Description[80];  /* Class's description */
  EUint32 Offset;           /* Offset for byte string identifier */
} ID_LIST;
 
EUint32  EDMAPROC 
IDborn (OBJID IdObj)
{
  DtID	*m;
  
  m = (DtID*) edma_get_data_ref (IdObj);

  /* Nothing to do.... */
  return 0;
}
 
EUint32  EDMAPROC 
IDrip (OBJID IdObj)
{
  DtID	*m;
  
  m = (DtID*) edma_get_data_ref (IdObj);
  
  edma_buffer_free (&m->List);

  return 0;
}
 
EUint32  EDMAPROC 
IDGetClassZsZ (OBJID IdObj, EPChar Id, EPChar *Result)
{
  DtID	     *m;
  EUint32   i;
  ID_LIST   *Aux;
  
  m = (DtID*) edma_get_data_ref (IdObj);
  
  Aux = (ID_LIST*) (m->List.dat);
  for (i = 0; i < m->nElems; i++) 
    {
      if (strncmp (Aux[i].StringId, Id, 80) == 0)
	break;
    }

  if (i != m->nElems)
    *Result = Aux[i].ClassName;
  else 
    {
      *Result = NULL;
      edma_printf_obj (IdObj, "No class matches %s", Id);
    }
  
  return 0;
}

EUint32  EDMAPROC 
IDGetClassExZZsZ (OBJID IdObj, EPChar Id, EPChar Id1, EPChar *Result)
{
  DtID	*m;
  
  m = (DtID*) edma_get_data_ref (IdObj);
  
  edma_printf_obj (IdObj, "%s", "GetClassEx not implemented");
  
  return 0;
}

EUint32  EDMAPROC 
IDSetDBZ (OBJID IdObj, EPChar Name)
{
  DtID	   *m;
  FILE     *f;
  EUint32  i,n;
  ID_LIST  *Aux;
  EChar    temp[1024], *aux;
  
  m = (DtID*) edma_get_data_ref (IdObj);

  edma_buffer_alloc (&m->List, sizeof(ID_LIST) * MAX_ID);
  if (m->List.h == 0) 
    {
      edma_printf_obj (IdObj, "%s", "Can't create shared memory block");
      return -1;
    }

  if ((f = fopen (Name, "rt")) == NULL)
    {
      edma_printf_obj (IdObj, "Can't open config file %s", Name);
      edma_buffer_free (&m->List);
      return -1;
    }
  /* Read n clases from file */
  fscanf (f, "%ld\n", &n);

  m->nElems = n;
  Aux = (ID_LIST*) (m->List.dat);
  for (i = 0; i < n;i++)
    {
      memset (temp, 0, 1024);
      fgets (temp, 1024, f);
      // Remove CR/LF
      aux = temp;
      while (*++aux != 0) if (*aux == '\n' || *aux == '\r') *aux =0;
      strcpy (Aux[i].ClassName, strtok (temp, ":"));
      strcpy (Aux[i].StringId, strtok (NULL, ":"));
      strcpy (Aux[i].Description, strtok (NULL, ":"));
      //Aux[i].Description[strlen (Aux[i].Description) - 1] = 0;
      printf ("(%s)(%s)(%s)\n", Aux[i].ClassName, Aux[i].StringId, Aux[i].Description);
    }
  fclose (f);

  return 0;
}


EUint32 EDMAPROC 
IDGetItemU32sZsZsZ (OBJID IdObj, EUint32 i, EPChar cn, EPChar sid, EPChar des)
{
  DtID	   *m;
  ID_LIST  *Aux;
  
  m = (DtID*) edma_get_data_ref (IdObj); 
  Aux = (ID_LIST*) (m->List.dat);
  strcpy (cn, Aux[i].ClassName);
  strcpy (sid, Aux[i].StringId);
  strcpy (des, Aux[i].Description);

  return 0;
}

EUint32  EDMAPROC 
IDAddItemZZZ (OBJID IdObj)
{
  DtID	*m;
  
  m = (DtID*) edma_get_data_ref (IdObj);
  
  edma_printf_obj (IdObj, "%s", "AddItem not implemented");
  
  return 0;
}

EUint32  EDMAPROC 
IDDeleteItemZZ (OBJID IdObj)
{
  DtID	*m;
  
  m = (DtID*) edma_get_data_ref (IdObj);
  
  edma_printf_obj (IdObj, "%s", "DeleteItem not implemented");
  
  return 0;
}
