/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2011, 2013
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LEA_H
#define LEA_H

#ifdef __cplusplus
extern "C" {
#endif

#include <edma.h>

typedef struct _lea_proxy_data_t
{
  OBJID obj;
} *LEA_PROXY_data;


  CLASSID lea_create_class (EPChar name);
  CLASSID lea_create_proxy (EPChar name);
  CLASSID lea_create_handler (EPChar name);
  CLASSID lea_create_parser (EPChar name);

  int lea_add_property (CLASSID cid, EPChar name, ESint32 type);
  int lea_add_method (CLASSID cid, EPChar name, EPChar sig, PPROC func);
  int lea_add_virtual_method (CLASSID cid, EPChar name, EPChar sig, PPROC func);
  int lea_add_static_method (CLASSID cid, EPChar name, EPChar sig, PPROC func);
  int lea_add_abstract_method (CLASSID cid, EPChar name, EPChar sig);

  int lea_add_parse_method (CLASSID cid, PPROC func);
  int lea_add_handler_get_class (CLASSID cid, PPROC func);

  int lea_add_super (CLASSID cid, EPChar cname);

  int lea_finish_class (CLASSID cid);

#ifdef __cplusplus
}
#endif

#endif
