/*
 * Electric(tm) VLSI Design System
 *
 * File: eio.h
 * Input/output aid: header file
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#include <setjmp.h>

/* successive versions of the binary file have smaller numbers */
#define	MAGIC10              -1591		/* current magic number: version 10 */
#define	MAGIC9               -1589		/* older magic number: version 9 */
#define	MAGIC8               -1587		/* older magic number: version 8 */
#define	MAGIC7               -1585		/* older magic number: version 7 */
#define	MAGIC6               -1583		/* older magic number: version 6 */
#define	MAGIC5               -1581		/* older magic number: version 5 */
#define	MAGIC4               -1579		/* older magic number: version 4 */
#define	MAGIC3               -1577		/* older magic number: version 3 */
#define	MAGIC2               -1575		/* older magic number: version 2 */
#define	MAGIC1               -1573		/* oldest magic number: version 1 */

/* I/O formats: */
#define	FBINARY                  0		/* Binary */
#define	FCIF                     1		/* CIF */
#define	FDXF                     2		/* DXF format */
#define	FEDIF                    3		/* Electronic Design Interchange Format */
#define	FGDS                     4		/* Calma GDS-II format */
#define	FHPGL                    5		/* HPGL format (plotting) */
#define	FL                       6		/* L format (Silicon Compilers) */
#define	FPOSTSCRIPT              7		/* PostScript (plotting) */
#define	FPRINTEDPOSTSCRIPT       8		/* Printed PostScript (plotting) */
#define	FQUICKDRAW               9		/* Quickdraw (plotting) */
#define FSDF                    10		/* SDF */
#define	FTEXT                   11		/* Text */
#define	FVHDL                   12		/* VHDL */
#define	FSUE                    13		/* SUE */
#define	FLEF                    14		/* LEF (Library Exchange Format) */
#define	FDEF                    15		/* DEF (Design Exchange Format) */
#define	FSKILL                  16		/* SKILL (CADENCE command language) */
#define	FEAGLE                  17		/* EAGLE (CadSoft) netlist */
#define	FPADS                   18		/* PADS netlist */

/* aid:inout.IO_state: */
#define	CIFINSQUARE             01		/* bit set for CIF input to square wires */
#define	CIFOUTEXACT             02		/* bit set for CIF output to mimic screen */
#define	CIFOUTMERGE             04		/* bit set for CIF output to merge polygons */
#define	CIFOUTADDDRC           010		/* bit set for CIF output to include DRC layer */
#define	IODEBUG                020		/* bit set to debug input */
#define	PLOTFOCUS              040		/* bit set to focus plot output */
#define	PLOTDATES             0100		/* bit set to include dates in plot output */
#define CIFOUTNOTCEN          0200		/* bit set for non-centered CIF */
#define GDSOUTMERGE           0400		/* bit set for GDS output to merge polgons */
#define GDSOUTADDDRC         01000		/* bit set for GDS output to include DRC layer */
#define EPSPSCRIPT           02000		/* bit set for Encapsulated PostScript output */
#define HPGL2                04000		/* bit set for HPGL/2 output instead of HPGL */
#define EDIFSCHEMATIC       010000		/* bit set for EDIF write schematic instead of netlist */
#define DXFALLLAYERS        020000		/* bit set for DXF to read all layers instead of technology list */
#define DXFFLATTENINPUT     040000		/* bit set for DXF to flatten input */
#define DEFNOPHYSICAL      0100000		/* bit set to ignore DEF physical data */
#define GDSINTEXT          0200000		/* bit set for GDS input of text */
#define GDSINEXPAND        0400000		/* bit set for GDS expansion of cells */
#define GDSINARRAYS	      01000000		/* bit set for GDS array instantiation */
#define PSCOLOR           02000000		/* bit set for color PostScript output */
#define PSPLOTTER         04000000		/* bit set for PostScript plotting (continuous roll) */
#define PSROTATE         010000000		/* bit set for PostScript rotation (by 90 degrees) */
#define	CIFOUTNOTOPCALL  020000000		/* bit set for CIF output to not call top cell */
#define	GDSINIGNOREUKN   040000000		/* bit set for GDS input to ignore unknown layers */
#define DEFNOLOGICAL    0100000000		/* bit set to ignore DEF logical data */

#define	DEFAULTPSWIDTH         638		/* default PostScript page width (8.5" at 75dpi) */
#define	DEFAULTPSHEIGHT        825		/* default PostScript page height (11.0" at 75dpi) */
#define	DEFAULTPSMARGIN         56		/* default PostScript page height (0.75" at 75dpi) */

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
extern "C"
{
#endif

/* miscellaneous */
extern FILE        *io_fileout;			/* channel for output */
extern jmp_buf      io_filerror;		/* nonlocal jump when I/O fails */
extern INTSML       io_cifbase;			/* index used when writing CIF */
extern INTBIG       io_state;			/* key for "IO_state" */
extern INTBIG       io_postscriptfilename;/* key for "IO_postscript_filename" */
extern INTBIG       io_postscriptfiledate;/* key for "IO_postscript_filedate" */
extern INTBIG       io_postscriptepsscale;/* key for "IO_postscript_EPS_scale" */
extern INTSML       io_verbose;			/* 0: silent  1:verbose  -1:display facets during input */
extern AIDENTRY    *io_aid;				/* the I/O aid object */

/* prototypes for tool interface */
void io_init(INTBIG*, char*[], AIDENTRY*);
void io_done(void);
INTSML io_set(INTSML, char*[]);
INTBIG io_request(char*, va_list);
void io_slice(void);

/* prototypes for intratool interface */
PORTPROTO *io_convertoldportname(char *portname, NODEPROTO *np);
void       io_fixnewlib(LIBRARY *lib, INTBIG statusitem);
void       io_setoutputbloat(char *layer, INTBIG amount);
INTSML     io_setuptechorder(TECHNOLOGY *tech);
INTSML     io_nextplotlayer(INTBIG i);
INTBIG     io_getoutputbloat(char *layer);
INTSML     io_doreadbinlibrary(LIBRARY *lib, INTSML newprogress);
INTSML     io_doreadtextlibrary(LIBRARY *lib, INTSML newprogress);
INTSML     io_readbinlibrary(LIBRARY *lib);
INTSML     io_readciflibrary(LIBRARY *lib);
INTSML     io_readdeflibrary(LIBRARY *lib);
INTSML     io_readdxflibrary(LIBRARY *lib);
INTSML     io_readediflibrary(LIBRARY *lib);
INTSML     io_readgdslibrary(LIBRARY *lib, INTSML position);
INTSML     io_readleflibrary(LIBRARY *lib);
INTSML     io_readsdflibrary(LIBRARY *lib);
INTSML     io_readsuelibrary(LIBRARY *lib);
INTSML     io_readtextlibrary(LIBRARY *lib);
INTSML     io_readvhdllibrary(LIBRARY *lib);
INTSML     io_writebinlibrary(LIBRARY *lib);
INTSML     io_writeciflibrary(LIBRARY *lib);
INTSML     io_writedxflibrary(LIBRARY *lib);
INTSML     io_writeeaglelibrary(LIBRARY *lib);
INTSML     io_writeediflibrary(LIBRARY *lib);
INTSML     io_writegdslibrary(LIBRARY *lib);
INTSML     io_writehpgllibrary(LIBRARY *lib);
INTSML     io_writellibrary(LIBRARY *lib);
INTSML     io_writeleflibrary(LIBRARY *lib);
INTSML     io_writepadslibrary(LIBRARY *lib);
INTSML     io_writepostscriptlibrary(LIBRARY *lib, INTBIG printit);
INTSML     io_writequickdrawlibrary(LIBRARY *lib);
INTSML     io_writeskilllibrary(LIBRARY *lib);
INTSML     io_writetextlibrary(LIBRARY *lib);
void       io_freebininmemory(void);
void       io_freecifinmemory(void);
void       io_freecifparsmemory(void);
void       io_freecifoutmemory(void);
void       io_freedxfmemory(void);
void       io_freegdsoutmemory(void);
void       io_freepostscriptmemory(void);
void       io_freesdfimemory(void);
void       io_freesuememory(void);
void       io_freetextinmemory(void);
void       io_freedefimemory(void);
void       io_freelefimemory(void);
void       io_freeedifinmemory(void);
void       io_initskill(void);
void       io_initdef(void);
void       io_initdxf(void);
void       io_initcif(void);
void       io_initedif(void);
void       io_initgds(void);

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
}
#endif
