/*
 * Electric(tm) VLSI Design System
 *
 * File: drc.h
 * Design-rule check aid
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
extern "C"
{
#endif

/* the meaning of "DRC_options" */
#define DRCHIERDIALOG    1							/* set to force hierarchical DRC to use dialog */
#define DRCFIRSTERROR    2							/* set to stop after first error in a facet */
#define DRCREASONABLE    4							/* set to only examine "reasonable" number of polygons per node */

#define NODRCRULES ((DRCRULES *)-1)

typedef struct
{
	char    *techname;			/* name of the technology */
	INTBIG   numlayers;			/* number of layers in the technology */
	INTBIG   utsize;			/* size of upper-triangle of layers */
	INTBIG   widelimit;			/* width limit that triggers wide rules */
	char   **layernames;		/* names of layers */
	INTBIG  *minwidth;			/* minimum width of layers */
	char   **minwidthR;			/* minimum width rules */
	INTBIG  *conlist;			/* minimum distances when connected */
	char   **conlistR;			/* minimum distance ruless when connected */
	INTBIG  *unconlist;			/* minimum distances when unconnected */
	char   **unconlistR;		/* minimum distance rules when unconnected */
	INTBIG  *conlistW;			/* minimum distances when connected (wide) */
	char   **conlistWR;			/* minimum distance rules when connected (wide) */
	INTBIG  *unconlistW;		/* minimum distances when unconnected (wide) */
	char   **unconlistWR;		/* minimum distance rules when unconnected (wide) */
	INTBIG  *conlistM;			/* minimum distances when connected (multi-cut) */
	char   **conlistMR;			/* minimum distance rules when connected (multi-cut) */
	INTBIG  *unconlistM;		/* minimum distances when unconnected (multi-cut) */
	char   **unconlistMR;		/* minimum distance rules when unconnected (multi-cut) */
} DRCRULES;

extern AIDENTRY *dr_aid;							/* the DRC aid object */
extern INTBIG    dr_max_distanceskey;				/* key for "DRC_max_distances" */
extern INTBIG    dr_wide_limitkey;					/* key for "DRC_wide_limit" */
extern INTBIG    dr_min_widthkey;					/* key for "DRC_min_width" */
extern INTBIG    dr_min_width_rulekey;				/* key for "DRC_min_width_rule" */
extern INTBIG    dr_min_node_sizekey;				/* key for "DRC_min_node_size" */
extern INTBIG    dr_min_node_size_rulekey;			/* key for "DRC_min_node_size_rule" */
extern INTBIG    dr_connected_distanceskey;			/* key for "DRC_min_connected_distances" */
extern INTBIG    dr_connected_distances_rulekey;	/* key for "DRC_min_connected_distances_rule" */
extern INTBIG    dr_unconnected_distanceskey;		/* key for "DRC_min_unconnected_distances" */
extern INTBIG    dr_unconnected_distances_rulekey;	/* key for "DRC_min_unconnected_distances_rule" */
extern INTBIG    dr_connected_distancesWkey;		/* key for "DRC_min_connected_distances_wide" */
extern INTBIG    dr_connected_distancesW_rulekey;	/* key for "DRC_min_connected_distances_wide_rule" */
extern INTBIG    dr_unconnected_distancesWkey;		/* key for "DRC_min_unconnected_distances_wide" */
extern INTBIG    dr_unconnected_distancesW_rulekey;	/* key for "DRC_min_unconnected_distances_wide_rule" */
extern INTBIG    dr_connected_distancesMkey;		/* key for "DRC_min_connected_distances_multi" */
extern INTBIG    dr_connected_distancesM_rulekey;	/* key for "DRC_min_connected_distances_multi_rule" */
extern INTBIG    dr_unconnected_distancesMkey;		/* key for "DRC_min_unconnected_distances_multi" */
extern INTBIG    dr_unconnected_distancesM_rulekey;	/* key for "DRC_min_unconnected_distances_multi_rule" */
extern INTBIG    dr_ignore_listkey;					/* key for aid:drc.DRC_ignore_list */
extern INTBIG    dr_lastgooddrckey;					/* key for "DRC_last_good_drc" */
extern INTBIG    dr_options;						/* cached options */

void     dr_init(INTBIG*, char*[], AIDENTRY*);
void     dr_done(void);
INTSML   dr_set(INTSML, char*[]);
void     dr_examinenodeproto(NODEPROTO*);
void     dr_slice(void);
void     dr_modifynodeinst(NODEINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTSML,INTSML);
void     dr_modifyarcinst(ARCINST*,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG,INTBIG);
void     dr_newobject(INTBIG, INTBIG);
void     dr_killobject(INTBIG, INTBIG);
void     dr_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);
void     dr_readlibrary(LIBRARY*);
void     dr_eraselibrary(LIBRARY*);

/* intertool prototypes */
INTSML    dr_flatwrite(NODEPROTO*);
INTSML    dr_flatignore(char*);
INTSML    dr_flatunignore(char*);
INTSML    dr_rulesdialog(TECHNOLOGY *tech, DRCRULES *rules);
DRCRULES *dr_allocaterules(INTBIG layercount, char *techname);
void      dr_freerules(DRCRULES *rules);
INTBIG    drcb_check(NODEPROTO*);
INTSML    drcb_debug(void);
void      drcb_reset_dates(void);
INTSML    drcb_initincrementalcheck(NODEPROTO *facet);
INTSML    drcb_checkincremental(GEOM *geom, INTSML partial);
void      drcb_term(void);

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
}
#endif
