/*
 * Electric(tm) VLSI Design System
 *
 * File: simals.h
 * Header file for asynchronous logic simulator
 * From algorithms by: Brent Serbin and Peter J. Gallant
 * Last maintained by: Steven M. Rubin
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#define NOIRSIMTRANSISTOR ((IRSIMTRANSISTOR *)-1)

typedef struct Iirsimtransistor
{
	INTBIG transistortype;
	INTSML sourcefound, drainfound;
	INTBIG xpos, ypos;
	INTBIG length, width;
	INTBIG source, gate, drain;
	INTBIG sourcex, sourcey;
	INTBIG drainx, drainy;
	float sarea, darea;
	INTBIG sperimeter, dperimeter;
	struct Iirsimtransistor *nextirsimtransistor;
} IRSIMTRANSISTOR;

extern IRSIMTRANSISTOR *sim_firstirsimtransistor;
extern INTBIG           sim_irsimnetnumber;
extern char           **sim_irsimnetnames;
extern INTBIG          *sim_irsimnetsignals;

void     sim_irsimgeneratedeck(NODEPROTO *facet, FILE *f);
#if SIMTOOLIRSIM
INTSML   sim_irsimstartsimulation(NODEPROTO *np);
INTSML   sim_irsimcharhandlerschem(WINDOWPART *w, INTSML chr);
INTSML   sim_irsimcharhandlerwave(WINDOWPART *w, INTSML chr);
#endif
