/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.NodeUsage;
import com.sun.electric.database.network.NetCell;
import com.sun.electric.database.network.NetSchem;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.ErrorLogger;
import java.util.Collection;
import java.util.Iterator;

public class Network
extends Listener {
    public static final Network tool = new Network();
    static boolean debug = false;
    static boolean shortResistors;
    private static NetCell[] cells;
    static ErrorLogger errorLogger;
    static final int errorSortNetworks = 0;
    static final int errorSortNodes = 1;
    static final int errorSortPorts = 2;
    private static Pref cacheUnifyPowerAndGround;
    private static Pref cacheUnifyLikeNamedNets;
    private static Pref cacheIgnoreResistors;
    private static Pref cacheUnificationPrefix;
    private static Pref cacheBusBaseZero;
    private static Pref cacheBusAscending;

    private Network() {
        super("network");
        Network.reload();
    }

    public static void reload() {
        Cell c;
        Iterator cit;
        Library lib;
        int maxCell = 1;
        Iterator lit = Library.getLibraries();
        while (lit.hasNext()) {
            lib = (Library)lit.next();
            cit = lib.getCells();
            while (cit.hasNext()) {
                c = (Cell)cit.next();
                while (c.getCellIndex() >= maxCell) {
                    maxCell *= 2;
                }
            }
        }
        cells = new NetCell[maxCell];
        lit = Library.getLibraries();
        while (lit.hasNext()) {
            lib = (Library)lit.next();
            cit = lib.getCells();
            while (cit.hasNext()) {
                c = (Cell)cit.next();
                if (Network.getNetCell(c) != null) continue;
                if (c.isIcon() || c.isSchematicView()) {
                    new NetSchem(c);
                    continue;
                }
                new NetCell(c);
            }
        }
    }

    static void exportsChanged(Cell cell) {
        NetCell netCell = Network.getNetCell(cell);
        netCell.setInvalid(true);
        Iterator it = cell.getUsagesOf();
        while (it.hasNext()) {
            NodeUsage nu = (NodeUsage)it.next();
            if (nu.isIconOfParent()) continue;
            netCell = Network.getNetCell(nu.getParent());
            netCell.setInvalid(true);
        }
    }

    static void setCell(Cell cell, NetCell netCell) {
        int cellIndex = cell.getCellIndex();
        if (cellIndex >= cells.length) {
            int newLength;
            for (newLength = cells.length; cellIndex >= newLength; newLength *= 2) {
            }
            NetCell[] newCells = new NetCell[newLength];
            for (int i = 0; i < cells.length; ++i) {
                newCells[i] = cells[i];
            }
            cells = newCells;
        }
        Network.cells[cellIndex] = netCell;
    }

    static final NetCell getNetCell(Cell cell) {
        return cells[cell.getCellIndex()];
    }

    public static synchronized Netlist getUserNetlist(Cell cell) {
        return Network.getNetCell(cell).getUserNetlist();
    }

    public static synchronized Netlist getNetlist(Cell cell, boolean shortResistors) {
        if (Network.shortResistors != shortResistors) {
            for (int i = 0; i < cells.length; ++i) {
                NetCell netCell = cells[i];
                if (netCell == null) continue;
                netCell.setInvalid(true);
            }
            Network.shortResistors = shortResistors;
        }
        return Network.getNetCell(cell).getUserNetlist();
    }

    public void init() {
        this.setOn();
        if (!debug) {
            return;
        }
        System.out.println("Network.init()");
    }

    public void request(String cmd) {
        if (!debug) {
            return;
        }
        System.out.println("Network.request(" + cmd + ")");
    }

    public void examineCell(Cell cell) {
        if (!debug) {
            return;
        }
        System.out.println("Network.examineCell(" + cell + ")");
    }

    public void slice() {
        if (!debug) {
            return;
        }
        System.out.println("Network.slice()");
    }

    public void startBatch(Tool tool, boolean undoRedo) {
        if (!debug) {
            return;
        }
        System.out.println("Network.startBatch(" + tool + "," + undoRedo + ")");
    }

    public void endBatch() {
        if (!debug) {
            return;
        }
        System.out.println("Network.endBatch()");
    }

    public void modifyNodeInst(NodeInst ni, double oCX, double oCY, double oSX, double oSY, int oRot) {
        if (!debug) {
            return;
        }
        System.out.println("Network.modifyNodeInst(" + ni + "," + oCX + "," + oCY + "," + oSX + "," + oSY + "," + oRot + ")");
    }

    public void modifyNodeInsts(NodeInst[] nis, double[] oCX, double[] oCY, double[] oSX, double[] oSY, int[] oRot) {
        if (!debug) {
            return;
        }
        System.out.println("Network.modifyNodeInsts(" + nis.length + ")");
    }

    public void modifyArcInst(ArcInst ai, double oHX, double oHY, double oTX, double oTY, double oWid) {
        if (!debug) {
            return;
        }
        System.out.println("Network.modifyArcInst(" + ai + "," + "," + oHX + "," + oTX + "," + oTY + "," + oWid + ")");
    }

    public void modifyExport(Export pp, PortInst oldPi) {
        if (!debug) {
            return;
        }
        System.out.println("Network.modifyExport(" + pp + "," + oldPi + ")");
    }

    public void modifyCell(Cell cell, double oLX, double oHX, double oLY, double oHY) {
        if (!debug) {
            return;
        }
        System.out.println("Network.modifyCell(" + cell + "," + oLX + "," + oHX + "," + oLY + "," + oHY + ")");
    }

    public void modifyTextDescript(ElectricObject obj, TextDescriptor descript, int oldDescript0, int oldDescript1) {
        if (!debug) {
            return;
        }
        System.out.println("Network.modifyTextDescript(" + obj + ",...)");
    }

    public void newObject(ElectricObject obj) {
        Cell cell = obj.whichCell();
        if (obj instanceof Cell) {
            if (cell.isIcon() || cell.isSchematicView()) {
                new NetSchem(cell);
            } else {
                new NetCell(cell);
            }
        } else if (obj instanceof Export) {
            Network.exportsChanged(cell);
        } else if (cell != null) {
            Network.getNetCell(cell).setNetworksDirty();
        }
        if (!debug) {
            return;
        }
        System.out.println("Network.newObject(" + obj + ")");
    }

    public void killObject(ElectricObject obj) {
        Cell cell = obj.whichCell();
        if (obj instanceof Cell) {
            Network.setCell(cell, null);
            if (cell.isIcon() || cell.isSchematicView()) {
                NetSchem.updateCellGroup(cell.getCellGroup());
            }
        } else if (cell != null) {
            Network.getNetCell(cell).setNetworksDirty();
        }
        if (!debug) {
            return;
        }
        System.out.println("Network.killObject(" + obj + ")");
    }

    public void killExport(Export pp, Collection oldPortInsts) {
        Cell cell = (Cell)pp.getParent();
        Network.exportsChanged(cell);
        if (!debug) {
            return;
        }
        System.out.println("Network.killExport(" + pp + "," + oldPortInsts.size() + ")");
    }

    public void renameObject(ElectricObject obj, Name oldName) {
        Cell cell = obj.whichCell();
        if (obj instanceof Geometric && cell != null) {
            Network.getNetCell(cell).setNetworksDirty();
        }
        if (!debug) {
            return;
        }
        System.out.println("Network.reanameObject(" + obj + "," + oldName + ")");
    }

    public void newVariable(ElectricObject obj, Variable var) {
        if (!debug) {
            return;
        }
        System.out.println("Network.newVariable(" + obj + "," + var + ")");
    }

    public void killVariable(ElectricObject obj, Variable var) {
        if (!debug) {
            return;
        }
        System.out.println("Network.killVariable(" + obj + "," + var + ")");
    }

    public void modifyVariableFlags(ElectricObject obj, Variable var, int oldFlags) {
        if (!debug) {
            return;
        }
        System.out.println("Network.modifyVariableFlags(" + obj + "," + var + "." + oldFlags + ")");
    }

    public void modifyVariable(ElectricObject obj, Variable var, int index, Object oldValue) {
        if (!debug) {
            return;
        }
        System.out.println("Network.modifyVariable(" + obj + "," + var + "," + index + "," + oldValue + ")");
    }

    public void insertVariable(ElectricObject obj, Variable var, int index) {
        if (!debug) {
            return;
        }
        System.out.println("Network.insertVariable(" + obj + "," + var + "," + index + ")");
    }

    public void deleteVariable(ElectricObject obj, Variable var, int index, Object oldValue) {
        if (!debug) {
            return;
        }
        System.out.println("Network.deleteVariable(" + obj + "," + var + "," + index + "," + oldValue + ")");
    }

    public void readLibrary(Library lib) {
        if (!debug) {
            return;
        }
        System.out.println("Network.readLibrary(" + lib + ")");
    }

    public void eraseLibrary(Library lib) {
        if (!debug) {
            return;
        }
        System.out.println("Network.eraseLibrary(" + lib + ")");
    }

    public void writeLibrary(Library lib) {
        if (!debug) {
            return;
        }
        System.out.println("Network.writeLibrary(" + lib + ")");
    }

    public static boolean isUnifyPowerAndGround() {
        return cacheUnifyPowerAndGround.getBoolean();
    }

    public static void setUnifyPowerAndGround(boolean u) {
        cacheUnifyPowerAndGround.setBoolean(u);
    }

    public static boolean isUnifyLikeNamedNets() {
        return cacheUnifyLikeNamedNets.getBoolean();
    }

    public static void setUnifyLikeNamedNets(boolean u) {
        cacheUnifyLikeNamedNets.setBoolean(u);
    }

    public static boolean isIgnoreResistors() {
        return cacheIgnoreResistors.getBoolean();
    }

    public static void setIgnoreResistors(boolean i) {
        cacheIgnoreResistors.setBoolean(i);
    }

    public static String getUnificationPrefix() {
        return cacheUnificationPrefix.getString();
    }

    public static void setUnificationPrefix(String p) {
        cacheUnificationPrefix.setString(p);
    }

    public static boolean isBusBaseZero() {
        return cacheBusBaseZero.getBoolean();
    }

    public static void setBusBaseZero(boolean z) {
        cacheBusBaseZero.setBoolean(z);
    }

    public static boolean isBusAscending() {
        return cacheBusBaseZero.getBoolean();
    }

    public static void setBusAscending(boolean a) {
        cacheBusBaseZero.setBoolean(a);
    }

    static {
        errorLogger = ErrorLogger.newInstance("Network Errors", true);
        cacheUnifyPowerAndGround = Pref.makeBooleanPref("UnifyPowerAndGround", Network.tool.prefs, false);
        cacheUnifyPowerAndGround.attachToObject(tool, "Tools/Network tab", "Networks unify Power and Ground");
        cacheUnifyLikeNamedNets = Pref.makeBooleanPref("UnifyLikeNamedNets", Network.tool.prefs, false);
        cacheUnifyLikeNamedNets.attachToObject(tool, "Tools/Network tab", "Networks unify all like-named nets");
        cacheIgnoreResistors = Pref.makeBooleanPref("IgnoreResistors", Network.tool.prefs, false);
        cacheIgnoreResistors.attachToObject(tool, "Tools/Network tab", "Networks ignore Resistors");
        cacheUnificationPrefix = Pref.makeStringPref("UnificationPrefix", Network.tool.prefs, "");
        cacheUnificationPrefix.attachToObject(tool, "Tools/Network tab", "Network unification prefix");
        cacheBusBaseZero = Pref.makeBooleanPref("BusBaseZero", Network.tool.prefs, false);
        cacheBusBaseZero.attachToObject(tool, "Tools/Network tab", "Default busses starting index");
        cacheBusAscending = Pref.makeBooleanPref("BusAscending", Network.tool.prefs, false);
        cacheBusAscending.attachToObject(tool, "Tools/Network tab", "Default busses are ascending");
    }
}

