/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.TrackRouterH;

class Nand3_star_en_sy3 {
    private static final double DEF_SIZE = Double.POSITIVE_INFINITY;
    private static final double nmosTop = -9.0;
    private static final double pmosBot = 9.0;
    private static final double wellOverhangDiff = 6.0;
    private static final double incY = -4.0;
    private static final double inbY = 4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    Nand3_star_en_sy3() {
    }

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    static Cell makePart(double sz, String threshold, StdCellParams stdCell) {
        int i;
        int i2;
        int i3;
        sz = stdCell.roundSize(sz);
        Nand3_star_en_sy3.error(!threshold.equals("") && !threshold.equals("LT"), "Nand3en_sy3: threshold not \"\" or \"LT\": " + threshold);
        String nm = "nand3" + threshold + "en_sy3";
        double spaceAvail = stdCell.getCellTop() - 8.5 - 9.0;
        double lamPerSz = threshold.equals("LT") ? 2.0 : 6.0;
        double totWid = sz * lamPerSz * 2.0;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 2);
        Nand3_star_en_sy3.error(fwP == null, "can't make " + nm + " this small: " + sz);
        totWid = Math.max(5.0, sz * lamPerSz / 10.0);
        double weakBot = 11.5;
        spaceAvail = spaceAvail + 9.0 - weakBot;
        FoldsAndWidth fwW = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Nand3_star_en_sy3.error(fwW == null, "can't make " + nm + " weak PMOS should never have a problem");
        int nbStackedN = 3;
        spaceAvail = -9.0 - (stdCell.getCellBot() + 2.0 + 3.0 + 5.0 + 1.5);
        totWid = sz * 3.0 * (double)nbStackedN;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 3);
        Nand3_star_en_sy3.error(fwN == null, "can't make " + nm + " this small: " + sz);
        Cell nand = stdCell.findPart(nm, sz);
        if (nand != null) {
            return nand;
        }
        nand = stdCell.newPart(nm, sz);
        double inbX = 3.5;
        double incX = inbX + 2.0 + 3.0 + 2.0;
        double jogbX = incX + 2.0 + 3.0 + 2.0;
        double nmosX = jogbX + 2.0 + 3.0 + 2.0;
        FoldedNmos nmos = new FoldedNmos(nmosX, -9.0 - fwN.physWid / 2.0, fwN.nbFolds, nbStackedN, fwN.gateWid, nand);
        double pmosY = 9.0 + fwP.physWid / 2.0;
        FoldedMos[] pmoss = new FoldedMos[(int)Math.ceil((double)fwP.nbFolds / 12.0)];
        for (int i4 = 0; i4 < pmoss.length; ++i4) {
            double pmosPitch = 108.0;
            double pmosX = nmosX + 6.0 + (double)i4 * pmosPitch;
            int nbFolds = Math.min(12, fwP.nbFolds - i4 * 12);
            pmoss[i4] = new FoldedPmos(pmosX, pmosY, nbFolds, 1, fwP.gateWid, nand);
        }
        double weakX = StdCellParams.getRightDiffX(pmoss) + 12.0;
        double weakY = weakBot + fwW.physWid / 2.0;
        FoldedPmos weak = new FoldedPmos(weakX, weakY, fwW.nbFolds, 1, fwW.gateWid, nand);
        FoldedMos[] stroWeakPmoss = new FoldedMos[pmoss.length + 1];
        for (i3 = 0; i3 < pmoss.length; ++i3) {
            stroWeakPmoss[i3] = pmoss[i3];
        }
        stroWeakPmoss[pmoss.length] = weak;
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, nand);
        stdCell.wireVddGnd(stroWeakPmoss, StdCellParams.EVEN, nand);
        for (i3 = 6; i3 < nmos.nbInternalSrcDrns(); i3 += 6) {
            for (int j = 0; j < 6; ++j) {
                if (i3 / 6 % 2 == 0) {
                    LayoutLib.newArcInst(Tech.universalArc, 0.0, nmos.getInternalSrcDrn(j), nmos.getInternalSrcDrn(i3 + j));
                    continue;
                }
                LayoutLib.newArcInst(Tech.universalArc, 0.0, nmos.getInternalSrcDrn(j), nmos.getInternalSrcDrn(i3 + (5 - j)));
            }
        }
        double inbHiY = 11.0;
        LayoutLib.newExport(nand, "inb", PortProto.Characteristic.IN, Tech.m1, 4.0, inbX, inbHiY);
        TrackRouterH inbHi = new TrackRouterH(Tech.m2, 3.0, inbHiY, nand);
        inbHi.connect(nand.findExport("inb"));
        PortInst jogb = LayoutLib.newNodeInst(Tech.m1pin, jogbX, inbHiY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, nand).getOnlyPortInst();
        inbHi.connect(jogb);
        TrackRouterH inbLo = new TrackRouterH(Tech.m1, 3.0, 4.0, nand);
        inbLo.connect(jogb);
        block44: for (i2 = 0; i2 < fwN.nbFolds; ++i2) {
            switch (i2 % 6) {
                case 0: {
                    inbLo.connect(nmos.getGate(i2 * 3 + 0, 'T'), 1.5);
                    continue block44;
                }
                case 1: {
                    inbLo.connect(nmos.getGate(i2 * 3 + 1, 'T'), -1.0);
                    continue block44;
                }
                case 2: {
                    inbLo.connect(nmos.getGate(i2 * 3 + 2, 'T'));
                    continue block44;
                }
                case 3: {
                    inbLo.connect(nmos.getGate(i2 * 3 + 0, 'T'));
                    continue block44;
                }
                case 4: {
                    inbLo.connect(nmos.getGate(i2 * 3 + 1, 'T'), 1.0);
                    continue block44;
                }
                case 5: {
                    inbLo.connect(nmos.getGate(i2 * 3 + 2, 'T'), -1.5);
                }
            }
        }
        for (i2 = 0; i2 < pmoss.length; ++i2) {
            block46: for (int j = 0; j < pmoss[i2].nbGates(); ++j) {
                switch (j % 12) {
                    case 0: {
                        ((TrackRouter)inbLo).connect(pmoss[i2].getGate(j, 'B'), -4.5, 1.5);
                        continue block46;
                    }
                    case 2: {
                        inbLo.connect(pmoss[i2].getGate(j, 'B'));
                        continue block46;
                    }
                    case 5: {
                        inbLo.connect(pmoss[i2].getGate(j, 'B'));
                        continue block46;
                    }
                    case 6: {
                        inbLo.connect(pmoss[i2].getGate(j, 'B'));
                        continue block46;
                    }
                    case 9: {
                        inbLo.connect(pmoss[i2].getGate(j, 'B'));
                        continue block46;
                    }
                    case 11: {
                        ((TrackRouter)inbLo).connect(pmoss[i2].getGate(j, 'B'), 4.5, 1.5);
                    }
                }
            }
        }
        double inaX = StdCellParams.getRightDiffX(nmos) + 2.0 + 3.0 + 2.0;
        double gndBot = stdCell.getGndY() - stdCell.getGndWidth() / 2.0;
        double inaLoY = gndBot - 3.0 - 2.0;
        double nmosBot = -9.0 - fwN.physWid;
        inaLoY = Math.min(inaLoY, nmosBot - 2.0 - 3.0 - 2.5);
        double vddTop = stdCell.getVddY() + stdCell.getVddWidth() / 2.0;
        double weakTop = weakBot + fwW.physWid;
        double inaHiY = Math.max(vddTop, weakTop) + 3.0 + 2.0;
        LayoutLib.newExport(nand, "ina", PortProto.Characteristic.IN, Tech.m1, 4.0, inaX, inaHiY);
        TrackRouterH inaHi = new TrackRouterH(Tech.m1, 3.0, inaHiY, nand);
        inaHi.connect(nand.findExport("ina"));
        for (int i5 = 0; i5 < weak.nbGates(); ++i5) {
            inaHi.connect(weak.getGate(i5, 'T'));
        }
        TrackRouterH inaLo = new TrackRouterH(Tech.m1, 3.0, inaLoY, nand);
        inaLo.connect(nand.findExport("ina"));
        block48: for (int i6 = 0; i6 < fwN.nbFolds; ++i6) {
            switch (i6 % 6) {
                case 0: {
                    inaLo.connect(nmos.getGate(i6 * 3 + 1, 'B'));
                    continue block48;
                }
                case 1: {
                    inaLo.connect(nmos.getGate(i6 * 3 + 0, 'B'));
                    continue block48;
                }
                case 2: {
                    inaLo.connect(nmos.getGate(i6 * 3 + 0, 'B'));
                    continue block48;
                }
                case 3: {
                    inaLo.connect(nmos.getGate(i6 * 3 + 2, 'B'));
                    continue block48;
                }
                case 4: {
                    inaLo.connect(nmos.getGate(i6 * 3 + 2, 'B'));
                    continue block48;
                }
                case 5: {
                    inaLo.connect(nmos.getGate(i6 * 3 + 1, 'B'));
                }
            }
        }
        TrackRouterH inc = new TrackRouterH(Tech.m1, 3.0, -4.0, nand);
        block49: for (i = 0; i < fwN.nbFolds; ++i) {
            switch (i % 6) {
                case 0: {
                    inc.connect(nmos.getGate(i * 3 + 2, 'T'), 1.5);
                    continue block49;
                }
                case 1: {
                    inc.connect(nmos.getGate(i * 3 + 2, 'T'), 1.5);
                    continue block49;
                }
                case 2: {
                    ((TrackRouter)inc).connect(nmos.getGate(i * 3 + 1, 'T'), -11.5, 1.0);
                    continue block49;
                }
                case 3: {
                    ((TrackRouter)inc).connect(nmos.getGate(i * 3 + 1, 'T'), 11.5, 1.0);
                    continue block49;
                }
                case 4: {
                    inc.connect(nmos.getGate(i * 3 + 0, 'T'), -1.5);
                    continue block49;
                }
                case 5: {
                    inc.connect(nmos.getGate(i * 3 + 0, 'T'), -1.5);
                }
            }
        }
        for (i = 0; i < pmoss.length; ++i) {
            block51: for (int j = 0; j < pmoss[i].nbGates(); ++j) {
                switch (j % 12) {
                    case 1: {
                        ((TrackRouter)inc).connect(pmoss[i].getGate(j, 'B'), -2.5, 3.5);
                        continue block51;
                    }
                    case 3: {
                        inc.connect(pmoss[i].getGate(j, 'B'), -0.5);
                        continue block51;
                    }
                    case 4: {
                        ((TrackRouter)inc).connect(pmoss[i].getGate(j, 'B'), -8.5, 3.0);
                        continue block51;
                    }
                    case 7: {
                        ((TrackRouter)inc).connect(pmoss[i].getGate(j, 'B'), 8.5, 3.0);
                        continue block51;
                    }
                    case 8: {
                        inc.connect(pmoss[i].getGate(j, 'B'), 0.5);
                        continue block51;
                    }
                    case 10: {
                        ((TrackRouter)inc).connect(pmoss[i].getGate(j, 'B'), 2.5, 3.5);
                    }
                }
            }
        }
        LayoutLib.newExport(nand, "inc", PortProto.Characteristic.IN, Tech.m1, 4.0, incX, -4.0);
        inc.connect(nand.findExport("inc"));
        double outX = inaX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "out", PortProto.Characteristic.OUT, Tech.m1, 4.0, outX, 11.0);
        TrackRouterH outHi = new TrackRouterH(Tech.m2, 4.0, 11.0, nand);
        outHi.connect(nand.findExport("out"));
        for (int i7 = 0; i7 < stroWeakPmoss.length; ++i7) {
            for (int j = 1; j < stroWeakPmoss[i7].nbSrcDrns(); j += 2) {
                outHi.connect(stroWeakPmoss[i7].getSrcDrn(j));
            }
        }
        TrackRouterH outLo = new TrackRouterH(Tech.m2, 4.0, -11.0, nand);
        outLo.connect(nand.findExport("out"));
        for (int i8 = 1; i8 < nmos.nbSrcDrns(); i8 += 2) {
            outLo.connect(nmos.getSrcDrn(i8));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nand);
        stdCell.addPmosWell(wellMinX, wellMaxX, nand);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, nand);
        stdCell.doNCC(nand, nm + "{sch}");
        return nand;
    }
}

