/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.JNetwork;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.io.output.Topology;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.Exec;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ExecDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import java.awt.Frame;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Spice
extends Topology {
    public static final Variable.Key SPICE_TEMPLATE_KEY = ElectricObject.newKey("ATTR_SPICE_template");
    public static final Variable.Key SPICE_2_TEMPLATE_KEY = ElectricObject.newKey("ATTR_SPICE_template_spice2");
    public static final Variable.Key SPICE_3_TEMPLATE_KEY = ElectricObject.newKey("ATTR_SPICE_template_spice3");
    public static final Variable.Key SPICE_H_TEMPLATE_KEY = ElectricObject.newKey("ATTR_SPICE_template_hspice");
    public static final Variable.Key SPICE_P_TEMPLATE_KEY = ElectricObject.newKey("ATTR_SPICE_template_pspice");
    public static final Variable.Key SPICE_GC_TEMPLATE_KEY = ElectricObject.newKey("ATTR_SPICE_template_gnucap");
    public static final Variable.Key SPICE_SM_TEMPLATE_KEY = ElectricObject.newKey("ATTR_SPICE_template_smartspice");
    public static final Variable.Key SPICE_CARD_KEY = ElectricObject.newKey("SIM_spice_card");
    public static final Variable.Key SPICE_MODEL_KEY = ElectricObject.newKey("SIM_spice_model");
    public static final Variable.Key SPICE_MODEL_FILE_KEY = ElectricObject.newKey("SIM_spice_behave_file");
    public static final String SPICE_EXTENSION_PREFIX = "Extension ";
    private static final int SPICEMAXLENSUBCKTNAME = 70;
    private static final String SPICELEGALCHARS = "!#$%*+-/<>[]_";
    private static final String CDLNOBRACKETLEGALCHARS = "!#$%*+-/<>_";
    private Technology layoutTechnology;
    private double maskScale;
    private boolean useCDL;
    private String legalSpiceChars;
    private Variable.Key preferedEgnineTemplateKey;
    private int spiceEngine;

    public static void writeSpiceFile(Cell cell, VarContext context, String filePath, boolean cdl) {
        String runSpice;
        Spice out = new Spice();
        out.useCDL = cdl;
        if (out.openTextOutputStream(filePath)) {
            return;
        }
        if (out.writeCell(cell, context)) {
            return;
        }
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
        if (out.useCDL) {
            String templateFile;
            String deckFile = filePath;
            String deckPath = "";
            int lastDirSep = deckFile.lastIndexOf(File.separatorChar);
            if (lastDirSep > 0) {
                deckPath = deckFile.substring(0, lastDirSep);
                deckFile = deckFile.substring(lastDirSep + 1);
            }
            if (out.openTextOutputStream(templateFile = deckPath + File.separator + cell.getName() + ".cdltemplate")) {
                return;
            }
            String libName = Simulation.getCDLLibName();
            String libPath = Simulation.getCDLLibPath();
            out.printWriter.print("cdlInKeys = list(nil\n");
            out.printWriter.print("    'searchPath             \"" + deckFile + "");
            if (libPath.length() > 0) {
                out.printWriter.print("\n                             " + libPath);
            }
            out.printWriter.print("\"\n");
            out.printWriter.print("    'cdlFile                \"" + deckPath + "\"\n");
            out.printWriter.print("    'userSkillFile          \"\"\n");
            out.printWriter.print("    'opusLib                \"" + libName + "\"\n");
            out.printWriter.print("    'primaryCell            \"" + cell.getName() + "\"\n");
            out.printWriter.print("    'caseSensitivity        \"preserve\"\n");
            out.printWriter.print("    'hierarchy              \"flatten\"\n");
            out.printWriter.print("    'cellTable              \"\"\n");
            out.printWriter.print("    'viewName               \"netlist\"\n");
            out.printWriter.print("    'viewType               \"\"\n");
            out.printWriter.print("    'pr                     nil\n");
            out.printWriter.print("    'skipDevice             nil\n");
            out.printWriter.print("    'schemaLib              \"sample\"\n");
            out.printWriter.print("    'refLib                 \"\"\n");
            out.printWriter.print("    'globalNodeExpand       \"full\"\n");
            out.printWriter.print(")\n");
            if (out.closeTextOutputStream()) {
                return;
            }
            System.out.println(templateFile + " written");
        }
        if (!(runSpice = Simulation.getSpiceRunChoice()).equals("Don't Run")) {
            String workdir;
            String command = Simulation.getSpiceRunProgram() + " " + Simulation.getSpiceRunProgramArgs();
            String rundir = workdir = User.getWorkingDirectory();
            if (Simulation.getSpiceUseRunDir()) {
                rundir = Simulation.getSpiceRunDir();
            }
            File dir = new File(rundir);
            int start = filePath.lastIndexOf(File.separator);
            if (start == -1) {
                start = 0;
            } else if (++start > filePath.length()) {
                start = filePath.length();
            }
            int end = filePath.lastIndexOf(".");
            if (end == -1) {
                end = filePath.length();
            }
            String filename_noext = filePath.substring(start, end);
            String filename = filePath.substring(start, filePath.length());
            command = command.replaceAll("\\$\\{WORKING_DIR}", workdir);
            command = command.replaceAll("\\$\\{USE_DIR}", rundir);
            command = command.replaceAll("\\$\\{FILENAME}", filename);
            command = command.replaceAll("\\$\\{FILENAME_NO_EXT}", filename_noext);
            OpenFile.Type type = Simulate.getCurrentSpiceOutputType();
            String[] extensions = type.getExtensions();
            String outFile = rundir + File.separator + filename_noext + "." + extensions[0];
            SpiceFinishedListener l = new SpiceFinishedListener(cell, type, outFile);
            if (runSpice.equals("Run, Ingore Output")) {
                Exec e = new Exec(command, null, dir, null, null);
                if (Simulation.getSpiceRunProbe()) {
                    e.addFinishedListener(l);
                }
                e.start();
            }
            if (runSpice.equals("Run, Report Output")) {
                ExecDialog dialog = new ExecDialog((Frame)TopLevel.getCurrentJFrame(), false);
                if (Simulation.getSpiceRunProbe()) {
                    dialog.addFinishedListener(l);
                }
                dialog.startProcess(command, null, dir);
            }
            System.out.println("Running spice command: " + command);
        }
    }

    Spice() {
    }

    protected void start() {
        this.layoutTechnology = Schematics.getDefaultSchematicTechnology();
        this.spiceEngine = Simulation.getSpiceEngine();
        this.preferedEgnineTemplateKey = SPICE_TEMPLATE_KEY;
        switch (this.spiceEngine) {
            case 0: {
                this.preferedEgnineTemplateKey = SPICE_2_TEMPLATE_KEY;
                break;
            }
            case 1: {
                this.preferedEgnineTemplateKey = SPICE_3_TEMPLATE_KEY;
                break;
            }
            case 2: {
                this.preferedEgnineTemplateKey = SPICE_H_TEMPLATE_KEY;
                break;
            }
            case 3: {
                this.preferedEgnineTemplateKey = SPICE_P_TEMPLATE_KEY;
                break;
            }
            case 4: {
                this.preferedEgnineTemplateKey = SPICE_GC_TEMPLATE_KEY;
                break;
            }
            case 5: {
                this.preferedEgnineTemplateKey = SPICE_SM_TEMPLATE_KEY;
            }
        }
        this.maskScale = 1.0;
        this.legalSpiceChars = SPICELEGALCHARS;
        if (this.useCDL) {
            if (Simulation.isCDLConvertBrackets()) {
                this.legalSpiceChars = CDLNOBRACKETLEGALCHARS;
            }
            this.multiLinePrint(true, "* First line is ignored\n");
        } else {
            this.writeHeader(this.topCell);
        }
        Netlist netList = this.getNetlistForCell(this.topCell);
        Global.Set globals = netList.getGlobals();
        int globalSize = globals.size();
        if (!(Simulation.isSpiceUseNodeNames() && this.spiceEngine == 1 || globalSize <= 0)) {
            StringBuffer infstr = new StringBuffer();
            infstr.append("\n.global");
            for (int i = 0; i < globalSize; ++i) {
                Global global = globals.get(i);
                String name = global.getName();
                if (global == Global.power) {
                    name = this.getPowerName();
                }
                if (global == Global.ground) {
                    name = this.getGroundName();
                }
                infstr.append(" " + name);
            }
            infstr.append("\n");
            this.multiLinePrint(false, infstr.toString());
        }
    }

    protected void done() {
        if (!this.useCDL) {
            this.writeTrailer(this.topCell);
            this.multiLinePrint(false, ".END\n");
        }
    }

    private void writeMFactor(Nodable no, StringBuffer infstr) {
        Variable mVar = no.getVar("ATTR_M");
        if (mVar != null) {
            infstr.append(" M=" + mVar.getObject().toString());
        }
    }

    protected void writeCellTopology(Cell cell, Topology.CellNetInfo cni, VarContext context) {
        Iterator sIt;
        String message;
        Variable var = cell.getVar(SPICE_MODEL_FILE_KEY);
        if (var != null) {
            this.multiLinePrint(true, "* Cell " + cell.describe() + " is described in this file:\n");
            this.addIncludeFile(var.getObject().toString());
            return;
        }
        Netlist netList = cni.getNetList();
        if (cell == this.topCell && !Simulation.isSpiceForceGlobalPwrGnd()) {
            if (cni.getPowerNet() == null) {
                System.out.println("WARNING: cannot find power at top level of circuit");
            }
            if (cni.getGroundNet() == null) {
                System.out.println("WARNING: cannot find ground at top level of circuit");
            }
        }
        HashMap<JNetwork, SpiceNet> spiceNetMap = new HashMap<JNetwork, SpiceNet>();
        Iterator it = netList.getNetworks();
        while (it.hasNext()) {
            JNetwork net = (JNetwork)it.next();
            SpiceNet spNet = new SpiceNet();
            spNet.network = net;
            spNet.transistorCount = 0;
            spNet.diffArea = 0.0;
            spNet.diffPerim = 0.0;
            spNet.nonDiffCapacitance = 0.0f;
            spNet.merge = new PolyMerge();
            spiceNetMap.put(net, spNet);
        }
        int bipolarTrans = 0;
        int nmosTrans = 0;
        int pmosTrans = 0;
        Iterator aIt = cell.getNodes();
        while (aIt.hasNext()) {
            NodeInst ni = (NodeInst)aIt.next();
            this.addNodeInformation(netList, spiceNetMap, ni);
            NodeProto.Function fun = ni.getFunction();
            if (fun == NodeProto.Function.TRANPN || fun == NodeProto.Function.TRA4NPN || fun == NodeProto.Function.TRAPNP || fun == NodeProto.Function.TRA4PNP || fun == NodeProto.Function.TRANS) {
                ++bipolarTrans;
                continue;
            }
            if (fun == NodeProto.Function.TRAEMES || fun == NodeProto.Function.TRA4EMES || fun == NodeProto.Function.TRADMES || fun == NodeProto.Function.TRA4DMES || fun == NodeProto.Function.TRADMOS || fun == NodeProto.Function.TRA4DMOS || fun == NodeProto.Function.TRANMOS || fun == NodeProto.Function.TRA4NMOS) {
                ++nmosTrans;
                continue;
            }
            if (fun != NodeProto.Function.TRAPMOS && fun != NodeProto.Function.TRA4PMOS) continue;
            ++pmosTrans;
        }
        aIt = cell.getArcs();
        while (aIt.hasNext()) {
            JNetwork net;
            SpiceNet spNet;
            ArcInst ai = (ArcInst)aIt.next();
            if (ai.getProto().getFunction() == ArcProto.Function.NONELEC || (spNet = (SpiceNet)spiceNetMap.get(net = netList.getNetwork(ai, 0))) == null) continue;
            this.addArcInformation(spNet.merge, ai);
        }
        Iterator it2 = netList.getNetworks();
        while (it2.hasNext()) {
            JNetwork net = (JNetwork)it2.next();
            SpiceNet spNet = (SpiceNet)spiceNetMap.get(net);
            Iterator lIt = spNet.merge.getLayersUsed();
            while (lIt.hasNext()) {
                Layer layer = (Layer)lIt.next();
                List polyList = spNet.merge.getMergedPoints(layer);
                if (polyList == null) continue;
                Iterator pIt = polyList.iterator();
                while (pIt.hasNext()) {
                    Poly poly = (Poly)pIt.next();
                    Point2D[] pointList = poly.getPoints();
                    int count = pointList.length;
                    double perim = poly.getPerimeter();
                    double area = poly.getArea();
                    if (this.layerIsDiff(layer)) {
                        spNet.diffArea += area * this.maskScale * this.maskScale;
                        spNet.diffPerim += perim * this.maskScale;
                        continue;
                    }
                    spNet.nonDiffCapacitance = (float)((double)spNet.nonDiffCapacitance + layer.getCapacitance() * area * this.maskScale * this.maskScale);
                    spNet.nonDiffCapacitance = (float)((double)spNet.nonDiffCapacitance + layer.getEdgeCapacitance() * perim * this.maskScale);
                }
            }
        }
        JNetwork groundNet = cni.getGroundNet();
        JNetwork powerNet = cni.getPowerNet();
        if (pmosTrans != 0 && powerNet == null) {
            message = "WARNING: no power connection for P-transistor wells in cell " + cell.describe();
            this.dumpErrorMessage(message);
        }
        if (nmosTrans != 0 && groundNet == null) {
            message = "WARNING: no ground connection for N-transistor wells in cell " + cell.describe();
            this.dumpErrorMessage(message);
        }
        if (cell == this.topCell && !this.useCDL) {
            this.multiLinePrint(true, "\n*** TOP LEVEL CELL: " + cell.describe() + "\n");
        } else {
            String cellName = cni.getParameterizedName();
            this.multiLinePrint(false, "\n*** CELL: " + cell.describe() + "\n");
            StringBuffer infstr = new StringBuffer();
            infstr.append(".SUBCKT " + cellName);
            sIt = cni.getCellAggregateSignals();
            while (sIt.hasNext()) {
                int high;
                int low;
                Topology.CellAggregateSignal cas = (Topology.CellAggregateSignal)sIt.next();
                Export pp = cas.getExport();
                if (pp == null || cas.isGlobal()) continue;
                if (this.useCDL) {
                    // empty if block
                }
                if ((low = cas.getLowIndex()) > (high = cas.getHighIndex())) {
                    infstr.append(" " + cas.getName());
                    continue;
                }
                for (int j = low; j <= high; ++j) {
                    infstr.append(" " + cas.getName() + "[" + j + "]");
                }
            }
            Global.Set globals = netList.getGlobals();
            int globalSize = globals.size();
            if (!Simulation.isSpiceUseNodeNames() || this.spiceEngine == 1) {
                for (int i = 0; i < globalSize; ++i) {
                    Global global = globals.get(i);
                    int netIndex = netList.getNetIndex(global);
                    JNetwork net = netList.getNetwork(netIndex);
                    Topology.CellSignal cs = cni.getCellSignal(net);
                    infstr.append(" " + cs.getName());
                }
            }
            if (!this.useCDL && Simulation.isSpiceUseCellParameters()) {
                Iterator it3 = cell.getVariables();
                while (it3.hasNext()) {
                    Variable paramVar = (Variable)it3.next();
                    if (!paramVar.getTextDescriptor().isParam()) continue;
                    infstr.append(" " + paramVar.getTrueName() + "=" + paramVar.getPureValue(-1, -1));
                }
            }
            infstr.append("\n");
            this.multiLinePrint(false, infstr.toString());
            for (int i = 0; i < globalSize; ++i) {
                Global global = globals.get(i);
                int netIndex = netList.getNetIndex(global);
                JNetwork net = netList.getNetwork(netIndex);
                Topology.CellSignal cs = cni.getCellSignal(net);
                this.multiLinePrint(true, "** GLOBAL " + cs.getName() + "\n");
            }
            Iterator sIt2 = cni.getCellAggregateSignals();
            while (sIt2.hasNext()) {
                int high;
                Topology.CellAggregateSignal cas = (Topology.CellAggregateSignal)sIt2.next();
                Export pp = cas.getExport();
                if (pp == null || cas.isGlobal()) continue;
                int low = cas.getLowIndex();
                if (low > (high = cas.getHighIndex())) {
                    this.multiLinePrint(true, "** PORT " + cas.getName() + "\n");
                    continue;
                }
                this.multiLinePrint(true, "** PORT " + cas.getName() + "[" + low + ":" + high + "]\n");
            }
        }
        Iterator nIt = netList.getNodables();
        while (nIt.hasNext()) {
            Dimension2D size;
            Nodable no = (Nodable)nIt.next();
            NodeProto niProto = no.getProto();
            if (niProto instanceof Cell) {
                Variable varTemplate = niProto.getVar(this.preferedEgnineTemplateKey);
                if (varTemplate == null) {
                    varTemplate = niProto.getVar(SPICE_TEMPLATE_KEY);
                }
                if (varTemplate != null) {
                    String line = varTemplate.getObject().toString();
                    StringBuffer infstr = new StringBuffer();
                    for (int pt = 0; pt < line.length(); ++pt) {
                        int start;
                        char chr = line.charAt(pt);
                        if (chr != '$' || pt + 1 >= line.length() || line.charAt(pt + 1) != '(') {
                            infstr.append(chr);
                            continue;
                        }
                        for (pt = start = pt + 2; pt < line.length() && line.charAt(pt) != ')'; ++pt) {
                        }
                        String paramName = line.substring(start, pt);
                        PortProto pp = niProto.findPortProto(paramName);
                        if (pp != null) {
                            JNetwork net = netList.getNetwork(no, pp, 0);
                            Topology.CellSignal cs = cni.getCellSignal(net);
                            infstr.append(cs.getName());
                            continue;
                        }
                        if (paramName.equalsIgnoreCase("node_name")) {
                            infstr.append(this.getSafeNetName(no.getName()));
                            continue;
                        }
                        String varName = "ATTR_" + paramName;
                        Variable attrVar = no.getVar(varName);
                        if (attrVar == null) {
                            infstr.append("??");
                            continue;
                        }
                        if (attrVar.getCode() != Variable.Code.NONE) {
                            infstr.append(context.evalVar(attrVar));
                            continue;
                        }
                        infstr.append(attrVar.getPureValue(-1, -1));
                    }
                    this.writeMFactor(no, infstr);
                    infstr.append('\n');
                    this.multiLinePrint(false, infstr.toString());
                    continue;
                }
                Topology.CellNetInfo subCni = this.getCellNetInfo(this.parameterizedName(no, context));
                String modelChar = "X";
                if (no.getName() != null) {
                    modelChar = modelChar + this.getSafeNetName(no.getName());
                }
                StringBuffer infstr = new StringBuffer();
                infstr.append(modelChar);
                Iterator sIt3 = subCni.getCellAggregateSignals();
                while (sIt3.hasNext()) {
                    int high;
                    Topology.CellAggregateSignal cas = (Topology.CellAggregateSignal)sIt3.next();
                    Export pp = cas.getExport();
                    if (pp == null) continue;
                    int low = cas.getLowIndex();
                    if (low > (high = cas.getHighIndex())) {
                        JNetwork net = netList.getNetwork(no, pp, 0);
                        Topology.CellSignal cs = cni.getCellSignal(net);
                        infstr.append(" " + cs.getName());
                        continue;
                    }
                    for (int j = low; j <= high; ++j) {
                        JNetwork net = netList.getNetwork(no, cas.getExport(), j - low);
                        Topology.CellSignal cs = cni.getCellSignal(net);
                        infstr.append(" " + cs.getName());
                    }
                }
                if (!Simulation.isSpiceUseNodeNames() || this.spiceEngine == 1) {
                    Global.Set globals = subCni.getNetList().getGlobals();
                    int globalSize = globals.size();
                    for (int i = 0; i < globalSize; ++i) {
                        Global global = globals.get(i);
                        infstr.append(" " + global.getName());
                    }
                }
                infstr.append(" " + subCni.getParameterizedName());
                if (!this.useCDL && Simulation.isSpiceUseCellParameters()) {
                    Iterator it4 = niProto.getVariables();
                    while (it4.hasNext()) {
                        Variable paramVar = (Variable)it4.next();
                        if (!paramVar.getTextDescriptor().isParam()) continue;
                        Variable instVar = no.getVar(paramVar.getKey());
                        String paramStr = "??";
                        if (instVar != null) {
                            paramStr = instVar.describe(-1, -1);
                        }
                        infstr.append(" " + paramStr);
                    }
                }
                this.writeMFactor(no, infstr);
                infstr.append("\n");
                this.multiLinePrint(false, infstr.toString());
                continue;
            }
            NodeInst ni = (NodeInst)no;
            NodeProto.Function fun = ni.getFunction();
            if (fun == NodeProto.Function.RESIST || fun == NodeProto.Function.INDUCT || fun == NodeProto.Function.CAPAC || fun == NodeProto.Function.ECAPAC || fun == NodeProto.Function.DIODE || fun == NodeProto.Function.DIODEZ) {
                if (fun == NodeProto.Function.RESIST) {
                    Variable resistVar = ni.getVar(Schematics.SCHEM_RESISTANCE);
                    String extra = "";
                    if (resistVar != null && TextUtils.isANumber(extra = resistVar.describe(context, ni))) {
                        double pureValue = TextUtils.atof(extra);
                        extra = TextUtils.displayedUnits(pureValue, TextDescriptor.Unit.RESISTANCE, TextUtils.UnitScale.NONE);
                    }
                    this.writeTwoPort(ni, "R", extra, cni, netList);
                    continue;
                }
                if (fun == NodeProto.Function.CAPAC || fun == NodeProto.Function.ECAPAC) {
                    Variable capacVar = ni.getVar(Schematics.SCHEM_CAPACITANCE);
                    String extra = "";
                    if (capacVar != null && TextUtils.isANumber(extra = capacVar.describe(context, ni))) {
                        double pureValue = TextUtils.atof(extra);
                        extra = TextUtils.displayedUnits(pureValue, TextDescriptor.Unit.CAPACITANCE, TextUtils.UnitScale.NONE);
                    }
                    this.writeTwoPort(ni, "C", extra, cni, netList);
                    continue;
                }
                if (fun == NodeProto.Function.INDUCT) {
                    Variable inductVar = ni.getVar(Schematics.SCHEM_INDUCTANCE);
                    String extra = "";
                    if (inductVar != null && TextUtils.isANumber(extra = inductVar.describe(context, ni))) {
                        double pureValue = TextUtils.atof(extra);
                        extra = TextUtils.displayedUnits(pureValue, TextDescriptor.Unit.INDUCTANCE, TextUtils.UnitScale.NONE);
                    }
                    this.writeTwoPort(ni, "L", extra, cni, netList);
                    continue;
                }
                if (fun != NodeProto.Function.DIODE && fun != NodeProto.Function.DIODEZ) continue;
                Variable diodeVar = ni.getVar(Schematics.SCHEM_DIODE);
                String extra = "";
                if (diodeVar != null) {
                    extra = diodeVar.describe(context, ni);
                }
                if (extra.length() == 0) {
                    extra = "DIODE";
                }
                this.writeTwoPort(ni, "D", extra, cni, netList);
                continue;
            }
            if (niProto.getGroupFunction() != NodeProto.Function.TRANS) continue;
            JNetwork gateNet = netList.getNetwork(ni.getTransistorGatePort());
            Topology.CellSignal gateCs = cni.getCellSignal(gateNet);
            JNetwork sourceNet = netList.getNetwork(ni.getTransistorSourcePort());
            Topology.CellSignal sourceCs = cni.getCellSignal(sourceNet);
            JNetwork drainNet = netList.getNetwork(ni.getTransistorDrainPort());
            Topology.CellSignal drainCs = cni.getCellSignal(drainNet);
            Topology.CellSignal biasCs = null;
            PortInst biasPort = ni.getTransistorBiasPort();
            if (biasPort != null) {
                biasCs = cni.getCellSignal(netList.getNetwork(biasPort));
            }
            if (gateCs == null || sourceCs == null || drainCs == null) {
                String message2 = "WARNING: " + ni.describe() + " not fully connected in cell " + cell.describe();
                this.dumpErrorMessage(message2);
            }
            String modelName = null;
            Variable modelVar = ni.getVar(SPICE_MODEL_KEY);
            if (modelVar != null) {
                modelName = modelVar.getObject().toString();
            }
            String modelChar = "";
            if (fun == NodeProto.Function.TRANSREF) {
                modelChar = "X";
                biasCs = cni.getCellSignal(groundNet);
                modelName = niProto.getName();
            } else if (fun == NodeProto.Function.TRANMOS) {
                modelChar = "M";
                biasCs = cni.getCellSignal(groundNet);
                if (modelName == null) {
                    modelName = "N";
                }
            } else if (fun == NodeProto.Function.TRA4NMOS) {
                modelChar = "M";
                if (modelName == null) {
                    modelName = "N";
                }
            } else if (fun == NodeProto.Function.TRADMOS) {
                modelChar = "M";
                biasCs = cni.getCellSignal(groundNet);
                if (modelName == null) {
                    modelName = "D";
                }
            } else if (fun == NodeProto.Function.TRA4DMOS) {
                modelChar = "M";
                if (modelName == null) {
                    modelName = "D";
                }
            } else if (fun == NodeProto.Function.TRAPMOS) {
                modelChar = "M";
                biasCs = cni.getCellSignal(powerNet);
                if (modelName == null) {
                    modelName = "P";
                }
            } else if (fun == NodeProto.Function.TRA4PMOS) {
                modelChar = "M";
                if (modelName == null) {
                    modelName = "P";
                }
            } else if (fun == NodeProto.Function.TRANPN) {
                modelChar = "Q";
                if (modelName == null) {
                    modelName = "NBJT";
                }
            } else if (fun == NodeProto.Function.TRA4NPN) {
                modelChar = "Q";
                if (modelName == null) {
                    modelName = "NBJT";
                }
            } else if (fun == NodeProto.Function.TRAPNP) {
                modelChar = "Q";
                if (modelName == null) {
                    modelName = "PBJT";
                }
            } else if (fun == NodeProto.Function.TRA4PNP) {
                modelChar = "Q";
                if (modelName == null) {
                    modelName = "PBJT";
                }
            } else if (fun == NodeProto.Function.TRANJFET) {
                modelChar = "J";
                biasCs = null;
                if (modelName == null) {
                    modelName = "NJFET";
                }
            } else if (fun == NodeProto.Function.TRA4NJFET) {
                modelChar = "J";
                if (modelName == null) {
                    modelName = "NJFET";
                }
            } else if (fun == NodeProto.Function.TRAPJFET) {
                modelChar = "J";
                biasCs = null;
                if (modelName == null) {
                    modelName = "PJFET";
                }
            } else if (fun == NodeProto.Function.TRA4PJFET) {
                modelChar = "J";
                if (modelName == null) {
                    modelName = "PJFET";
                }
            } else if (fun == NodeProto.Function.TRADMES || fun == NodeProto.Function.TRA4DMES) {
                modelChar = "Z";
                biasCs = null;
                modelName = "DMES";
            } else if (fun == NodeProto.Function.TRAEMES || fun == NodeProto.Function.TRA4EMES) {
                modelChar = "Z";
                biasCs = null;
                modelName = "EMES";
            } else if (fun == NodeProto.Function.TRANS) {
                modelChar = "Q";
            }
            if (ni.getName() != null) {
                modelChar = modelChar + this.getSafeNetName(ni.getName());
            }
            StringBuffer infstr = new StringBuffer();
            infstr.append(modelChar + " " + drainCs.getName() + " " + gateCs.getName() + " " + sourceCs.getName());
            if (biasCs != null) {
                infstr.append(" " + biasCs.getName());
            }
            if (modelName != null) {
                infstr.append(" " + modelName);
            }
            if ((size = ni.getTransistorSize(context)).getWidth() > 0.0 || size.getHeight() > 0.0) {
                double w = this.maskScale * size.getWidth();
                double l = this.maskScale * size.getHeight();
                if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                    l *= this.layoutTechnology.getScale() / 1000.0;
                    w *= this.layoutTechnology.getScale() / 1000.0;
                }
                if (fun == NodeProto.Function.TRANMOS || fun == NodeProto.Function.TRA4NMOS || fun == NodeProto.Function.TRAPMOS || fun == NodeProto.Function.TRA4PMOS || fun == NodeProto.Function.TRADMOS || fun == NodeProto.Function.TRA4DMOS || (fun == NodeProto.Function.TRANJFET || fun == NodeProto.Function.TRAPJFET || fun == NodeProto.Function.TRADMES || fun == NodeProto.Function.TRAEMES) && this.spiceEngine == 2) {
                    infstr.append(" L=" + TextUtils.formatDouble(l, 2));
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        infstr.append("U");
                    }
                    infstr.append(" W=" + TextUtils.formatDouble(w, 2));
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        infstr.append("U");
                    }
                }
                if (fun != NodeProto.Function.TRANMOS && fun != NodeProto.Function.TRA4NMOS && fun != NodeProto.Function.TRAPMOS && fun != NodeProto.Function.TRA4PMOS && fun != NodeProto.Function.TRADMOS && fun != NodeProto.Function.TRA4DMOS) {
                    infstr.append(" AREA=" + TextUtils.formatDouble(l * w, 2));
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        infstr.append("P");
                    }
                }
            }
            SpiceNet spNetGate = (SpiceNet)spiceNetMap.get(gateNet);
            SpiceNet spNetSource = (SpiceNet)spiceNetMap.get(sourceNet);
            SpiceNet spNetDrain = (SpiceNet)spiceNetMap.get(drainNet);
            if (spNetGate == null || spNetSource == null || spNetDrain == null) continue;
            if (!(this.useCDL || fun != NodeProto.Function.TRANMOS && fun != NodeProto.Function.TRA4NMOS && fun != NodeProto.Function.TRAPMOS && fun != NodeProto.Function.TRA4PMOS && fun != NodeProto.Function.TRADMOS && fun != NodeProto.Function.TRA4DMOS)) {
                double as = 0.0;
                double ad = 0.0;
                double ps = 0.0;
                double pd = 0.0;
                if (spNetSource.transistorCount != 0) {
                    as = spNetSource.diffArea / (double)spNetSource.transistorCount;
                    ps = spNetSource.diffPerim / (double)spNetSource.transistorCount;
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        as *= this.layoutTechnology.getScale() * this.layoutTechnology.getScale() / 1000000.0;
                        ps *= this.layoutTechnology.getScale() / 1000.0;
                    }
                }
                if (spNetDrain.transistorCount != 0) {
                    ad = spNetDrain.diffArea / (double)spNetDrain.transistorCount;
                    pd = spNetDrain.diffPerim / (double)spNetDrain.transistorCount;
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        ad *= this.layoutTechnology.getScale() * this.layoutTechnology.getScale() / 1000000.0;
                        pd *= this.layoutTechnology.getScale() / 1000.0;
                    }
                }
                if (as > 0.0) {
                    infstr.append(" AS=" + TextUtils.formatDouble(as, 2));
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        infstr.append("P");
                    }
                }
                if (ad > 0.0) {
                    infstr.append(" AD=" + TextUtils.formatDouble(ad, 2));
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        infstr.append("P");
                    }
                }
                if (ps > 0.0) {
                    infstr.append(" PS=" + TextUtils.formatDouble(ps, 2));
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        infstr.append("U");
                    }
                }
                if (pd > 0.0) {
                    infstr.append(" PD=" + TextUtils.formatDouble(pd, 2));
                    if (!Simulation.isSpiceWriteTransSizeInLambda()) {
                        infstr.append("U");
                    }
                }
            }
            this.writeMFactor(ni, infstr);
            infstr.append("\n");
            this.multiLinePrint(false, infstr.toString());
        }
        if (!this.useCDL && Simulation.isSpiceUseParasitics()) {
            boolean first = true;
            int capacNum = 1;
            sIt = cni.getCellSignals();
            while (sIt.hasNext()) {
                Topology.CellSignal cs = (Topology.CellSignal)sIt.next();
                JNetwork net = cs.getNetwork();
                if (net == cni.getGroundNet()) continue;
                SpiceNet spNet = (SpiceNet)spiceNetMap.get(net);
                if (!((double)spNet.nonDiffCapacitance > this.layoutTechnology.getMinCapacitance())) continue;
                if (first) {
                    first = false;
                    this.multiLinePrint(true, "** Extracted Parasitic Elements:\n");
                }
                this.multiLinePrint(false, "C" + capacNum + " " + cs.getName() + " 0 " + TextUtils.formatDouble(spNet.nonDiffCapacitance, 2) + "F\n");
                ++capacNum;
            }
        }
        Iterator it5 = cell.getNodes();
        while (it5.hasNext()) {
            Object obj;
            Variable cardVar;
            NodeInst ni = (NodeInst)it5.next();
            if (ni.getProto() != Generic.tech.invisiblePinNode || (cardVar = ni.getVar(SPICE_CARD_KEY)) == null || !((obj = cardVar.getObject()) instanceof String) && !(obj instanceof String[]) || !cardVar.isDisplay()) continue;
            if (obj instanceof String) {
                this.multiLinePrint(false, (String)obj + "\n");
                continue;
            }
            String[] strings = (String[])obj;
            for (int i = 0; i < strings.length; ++i) {
                this.multiLinePrint(false, strings[i] + "\n");
            }
        }
        if (cell != this.topCell || this.useCDL) {
            this.multiLinePrint(false, ".ENDS " + cni.getParameterizedName() + "\n");
        }
    }

    protected String getSafeCellName(String name) {
        return this.getSafeNetName(name);
    }

    protected String getPowerName() {
        return "vdd";
    }

    protected String getGroundName() {
        return "gnd";
    }

    protected String getGlobalName(Global glob) {
        return glob.getName();
    }

    protected boolean isNetworksUseExportedNames() {
        return false;
    }

    protected String getSafeNetName(String name) {
        boolean allAlNum = true;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isLetterOrDigit(name.charAt(i))) continue;
            allAlNum = false;
            break;
        }
        if (allAlNum) {
            return name;
        }
        StringBuffer sb = new StringBuffer();
        for (int t = 0; t < name.length(); ++t) {
            char chr = name.charAt(t);
            boolean legalChar = Character.isLetterOrDigit(chr);
            if (!legalChar) {
                for (int j = 0; j < this.legalSpiceChars.length(); ++j) {
                    char legalChr = this.legalSpiceChars.charAt(j);
                    if (chr != legalChr) continue;
                    legalChar = true;
                    break;
                }
            }
            if (!legalChar) {
                chr = '_';
            }
            sb.append(chr);
        }
        return sb.toString();
    }

    protected Netlist getNetlistForCell(Cell cell) {
        boolean shortResistors = false;
        Netlist netList = cell.getNetlist(shortResistors);
        return netList;
    }

    protected boolean canParameterizeNames() {
        return !this.useCDL;
    }

    protected int maxNameLength() {
        return 70;
    }

    private void writeHeader(Cell cell) {
        String headerFile;
        this.multiLinePrint(true, "*** SPICE deck for cell " + cell.noLibDescribe() + " from library " + cell.getLibrary().getName() + "\n");
        this.emitCopyright("*** ", "");
        if (User.isIncludeDateAndVersionInOutput()) {
            this.multiLinePrint(true, "*** Created on " + TextUtils.formatDate(this.topCell.getCreationDate()) + "\n");
            this.multiLinePrint(true, "*** Last revised on " + TextUtils.formatDate(this.topCell.getRevisionDate()) + "\n");
            this.multiLinePrint(true, "*** Written on " + TextUtils.formatDate(new Date()) + " by Electric VLSI Design System, version " + Version.getVersion() + "\n");
        } else {
            this.multiLinePrint(true, "*** Written by Electric VLSI Design System\n");
        }
        this.multiLinePrint(true, "*** UC SPICE *** , MIN_RESIST " + this.layoutTechnology.getMinResistance() + ", MIN_CAPAC " + this.layoutTechnology.getMinCapacitance() + "FF\n");
        this.multiLinePrint(false, ".OPTIONS NOMOD NOPAGE\n");
        if (Simulation.isSpiceWriteTransSizeInLambda()) {
            double scale = this.layoutTechnology.getScale();
            this.multiLinePrint(false, "*** Lambda Conversion ***\n");
            this.multiLinePrint(false, ".opt scale=" + TextUtils.formatDouble(scale / 1000.0, 3) + "U\n\n");
        }
        if ((headerFile = Simulation.getSpiceHeaderCardInfo()).length() > 0) {
            if (headerFile.startsWith(SPICE_EXTENSION_PREFIX)) {
                String headerPath = TextUtils.getFilePath(cell.getLibrary().getLibFile());
                String ext = headerFile.substring(SPICE_EXTENSION_PREFIX.length());
                if (ext.startsWith(".")) {
                    ext = ext.substring(1);
                }
                String filePart = cell.getName() + "." + ext;
                String fileName = headerPath + filePart;
                File test = new File(fileName);
                if (test.exists()) {
                    this.multiLinePrint(true, "* Model cards are described in this file:\n");
                    this.addIncludeFile(filePart);
                    return;
                }
            } else {
                File test = new File(headerFile);
                if (!test.exists()) {
                    System.out.println("Warning: cannot find model file '" + headerFile + "'");
                }
                this.multiLinePrint(true, "* Model cards are described in this file:\n");
                this.addIncludeFile(headerFile);
                return;
            }
        }
        int level = TextUtils.atoi(Simulation.getSpiceLevel());
        String[] header = null;
        switch (level) {
            case 1: {
                header = this.layoutTechnology.getSpiceHeaderLevel1();
                break;
            }
            case 2: {
                header = this.layoutTechnology.getSpiceHeaderLevel2();
                break;
            }
            case 3: {
                header = this.layoutTechnology.getSpiceHeaderLevel3();
            }
        }
        if (header != null) {
            for (int i = 0; i < header.length; ++i) {
                this.multiLinePrint(false, header[i] + "\n");
            }
            return;
        }
        System.out.println("WARNING: no model cards for SPICE level " + level + " in " + this.layoutTechnology.getTechName() + " technology");
    }

    private void writeTrailer(Cell cell) {
        String trailerFile = Simulation.getSpiceTrailerCardInfo();
        if (trailerFile.length() > 0) {
            if (trailerFile.startsWith(SPICE_EXTENSION_PREFIX)) {
                String trailerpath = TextUtils.getFilePath(cell.getLibrary().getLibFile());
                String filePart = cell.getName() + "." + trailerFile.substring(SPICE_EXTENSION_PREFIX.length());
                String fileName = trailerpath + filePart;
                File test = new File(fileName);
                if (test.exists()) {
                    this.multiLinePrint(true, "* Trailer cards are described in this file:\n");
                    this.addIncludeFile(filePart);
                }
            } else {
                this.multiLinePrint(true, "* Trailer cards are described in this file:\n");
                this.addIncludeFile(trailerFile);
            }
        }
    }

    private void writeTwoPort(NodeInst ni, String partName, String extra, Topology.CellNetInfo cni, Netlist netList) {
        String message;
        PortInst port0 = ni.getPortInst(0);
        PortInst port1 = ni.getPortInst(1);
        JNetwork net0 = netList.getNetwork(port0);
        JNetwork net1 = netList.getNetwork(port1);
        Topology.CellSignal cs0 = cni.getCellSignal(net0);
        Topology.CellSignal cs1 = cni.getCellSignal(net1);
        if (cs0 == null || cs1 == null) {
            message = "WARNING: " + ni.describe() + " component not fully connected in cell " + ni.getParent().describe();
            this.dumpErrorMessage(message);
        }
        if (cs0 != null && cs1 != null && cs0 == cs1) {
            message = "WARNING: " + ni.describe() + " component appears to be shorted on net " + net0.toString() + " in cell " + ni.getParent().describe();
            this.dumpErrorMessage(message);
            return;
        }
        if (ni.getName() != null) {
            partName = partName + this.getSafeNetName(ni.getName());
        }
        this.multiLinePrint(false, partName + " " + cs1.getName() + " " + cs0.getName() + " " + extra + "\n");
    }

    private void addNodeInformation(Netlist netList, HashMap spiceNets, NodeInst ni) {
        NodeProto np = ni.getProto();
        if (np instanceof Cell) {
            return;
        }
        NodeProto.Function function = ni.getFunction();
        Technology tech = np.getTechnology();
        AffineTransform trans = ni.rotateOut();
        Poly[] polyList = tech.getShapeOfNode(ni, null, true, true);
        int tot = polyList.length;
        for (int i = 0; i < tot; ++i) {
            SpiceNet spNet;
            Poly poly = polyList[i];
            PortProto pp = poly.getPort();
            if (pp == null) continue;
            JNetwork net = netList.getNetwork(ni, pp, 0);
            Layer layer = poly.getLayer();
            if (!this.layerIsDiff(layer) && layer.getCapacitance() == 0.0 || layer.getTechnology() != Technology.getCurrent() || layer.getFunction() == Layer.Function.GATE || (spNet = (SpiceNet)spiceNets.get(net)) == null) continue;
            poly.transform(trans);
            spNet.merge.addPolygon(layer, poly);
            if (!this.layerIsDiff(layer) || !function.isTransistor()) continue;
            ++spNet.transistorCount;
        }
    }

    private void addArcInformation(PolyMerge merge, ArcInst ai) {
        boolean isDiffArc = this.arcIsDiff(ai);
        Technology tech = ai.getProto().getTechnology();
        Poly[] arcInstPolyList = tech.getShapeOfArc(ai);
        int tot = arcInstPolyList.length;
        for (int j = 0; j < tot; ++j) {
            Layer layer;
            Poly poly = arcInstPolyList[j];
            if (poly.getStyle().isText() || (layer = poly.getLayer()).getTechnology() != Technology.getCurrent() || (layer.getFunctionExtras() & 0x1000) != 0 || !this.layerIsDiff(layer) && (isDiffArc || !(layer.getCapacitance() > 0.0))) continue;
            merge.addPolygon(layer, poly);
        }
    }

    private void addIncludeFile(String fileName) {
        if (this.spiceEngine == 0 || this.spiceEngine == 1 || this.spiceEngine == 4 || this.spiceEngine == 5) {
            this.multiLinePrint(false, ".include " + fileName + "\n");
        } else if (this.spiceEngine == 2) {
            this.multiLinePrint(false, ".include '" + fileName + "'\n");
        } else if (this.spiceEngine == 3) {
            this.multiLinePrint(false, ".INC " + fileName + "\n");
        }
    }

    private boolean layerIsDiff(Layer layer) {
        int extras = layer.getFunctionExtras();
        return (extras & 0x1000) == 0 && layer.getFunction().isDiff();
    }

    private boolean arcIsDiff(ArcInst ai) {
        ArcProto.Function fun = ai.getProto().getFunction();
        if (fun == ArcProto.Function.DIFFP || fun == ArcProto.Function.DIFFN || fun == ArcProto.Function.DIFF) {
            return true;
        }
        return fun == ArcProto.Function.DIFFS || fun == ArcProto.Function.DIFFW;
    }

    private void dumpErrorMessage(String message) {
        this.multiLinePrint(true, "*** " + message + "\n");
        System.out.println(message);
    }

    private void multiLinePrint(boolean isComment, String str) {
        char contChar = '+';
        if (isComment) {
            contChar = '*';
        }
        int lastSpace = -1;
        int count = 0;
        boolean insideQuotes = false;
        int lineStart = 0;
        for (int pt = 0; pt < str.length(); ++pt) {
            char chr = str.charAt(pt);
            if (chr == '\n') {
                this.printWriter.print(str.substring(lineStart, pt + 1));
                count = 0;
                lastSpace = -1;
                lineStart = pt + 1;
                continue;
            }
            if (chr == ' ' && !insideQuotes) {
                lastSpace = pt;
            }
            if (chr == '\'') {
                boolean bl = insideQuotes = !insideQuotes;
            }
            if (++count < 78 || insideQuotes) continue;
            if (lastSpace < 0) {
                lastSpace = pt;
            }
            String partial = str.substring(lineStart, lastSpace + 1);
            this.printWriter.print(partial + "\n" + contChar);
            count = 1;
            lineStart = lastSpace + 1;
            lastSpace = -1;
        }
        if (lineStart < str.length()) {
            String partial = str.substring(lineStart);
            this.printWriter.print(partial);
        }
    }

    private static class SpiceFinishedListener
    implements Exec.FinishedListener {
        private Cell cell;
        private OpenFile.Type type;
        private String file;

        private SpiceFinishedListener(Cell cell, OpenFile.Type type, String file) {
            this.cell = cell;
            this.type = type;
            this.file = file;
        }

        public void processFinished(Exec.FinishedEvent e) {
            URL fileURL = TextUtils.makeURLToFile(this.file);
            WaveformWindow ww = WaveformWindow.findWaveformWindow(this.cell);
            Simulate.plotSimulationResults(this.type, this.cell, fileURL, ww);
        }
    }

    private static class SpiceNet {
        JNetwork network;
        PolyMerge merge;
        double diffArea;
        double diffPerim;
        float nonDiffCapacitance;
        int transistorCount;

        private SpiceNet() {
        }
    }
}

