/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CellUsage
extends HierarchyEnumerator.Visitor {
    private Set cellsInUse = new HashSet();
    private List cellsInRevTopoOrder = new ArrayList();
    private Map groupToAdditions = new HashMap();

    CellUsage() {
    }

    private void processCellGroupAdditions(Cell cell) {
        NccCellAnnotations ann = NccCellAnnotations.getAnnotations(cell);
        if (ann == null) {
            return;
        }
        Cell.CellGroup group = ann.getGroupToJoin();
        if (group == null) {
            return;
        }
        HashSet<Cell> additions = (HashSet<Cell>)this.groupToAdditions.get(group);
        if (additions == null) {
            additions = new HashSet<Cell>();
            this.groupToAdditions.put(group, additions);
        }
        additions.add(cell);
    }

    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        Cell cell = info.getCell();
        if (this.cellsInUse.contains(cell)) {
            return false;
        }
        this.cellsInUse.add(cell);
        this.processCellGroupAdditions(cell);
        return true;
    }

    public void exitCell(HierarchyEnumerator.CellInfo info) {
        this.cellsInRevTopoOrder.add(info.getCell());
    }

    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
        return true;
    }

    public boolean cellIsUsed(Cell cell) {
        return this.cellsInUse.contains(cell);
    }

    public Iterator cellsInReverseTopologicalOrder() {
        return this.cellsInRevTopoOrder.iterator();
    }

    public Set getGroupAdditions(Cell.CellGroup group) {
        Set additions = (Set)this.groupToAdditions.get(group);
        return additions != null ? additions : new HashSet();
    }
}

